/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver
implements XMLNamespaceResolver {
    private static final String BASE_PREFIX = "ns";
    private Properties namespaces = new Properties();
    int prefixCounter;
    private Node dom;

    public void setDOM(Node dom) {
        this.dom = dom;
    }

    public String resolveNamespacePrefix(String prefix) {
        if (null == prefix) {
            return null;
        }
        String uri = this.namespaces.getProperty(prefix);
        if (uri == null && prefix.equals("xml")) {
            uri = "http://www.w3.org/XML/1998/namespace";
        }
        return uri;
    }

    public String resolveNamespaceURI(String uri) {
        if (null == uri) {
            return null;
        }
        Enumeration<Object> keys = this.namespaces.keys();
        while (keys.hasMoreElements()) {
            String prefix = (String)keys.nextElement();
            if (!this.namespaces.getProperty(prefix).equals(uri)) continue;
            return prefix;
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.resolveNamespaceURI(this.dom, uri);
    }

    private String resolveNamespaceURI(Node node, String uri) {
        if (null == node) {
            return null;
        }
        if (uri.equals(node.getNamespaceURI())) {
            return node.getPrefix();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != namedNodeMap) {
            int namedNodeMapSize = namedNodeMap.getLength();
            for (int x = 0; x < namedNodeMapSize; ++x) {
                Node attr = namedNodeMap.item(x);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !uri.equals(attr.getNodeValue())) continue;
                return attr.getLocalName();
            }
        }
        return this.resolveNamespaceURI(node.getParentNode(), uri);
    }

    public void put(String prefix, String namespaceURI) {
        this.namespaces.setProperty(prefix, namespaceURI);
    }

    public Enumeration getPrefixes() {
        return this.namespaces.keys();
    }

    public Vector getNamespaces() {
        Vector<Namespace> names = new Vector<Namespace>(this.namespaces.size());
        Enumeration<Object> sources = this.namespaces.keys();
        while (sources.hasMoreElements()) {
            String prefix = (String)sources.nextElement();
            String URI2 = (String)this.namespaces.get(prefix);
            Namespace namespace = new Namespace(prefix, URI2);
            names.addElement(namespace);
        }
        return names;
    }

    public void setNamespaces(Vector names) {
        this.namespaces = new Properties();
        Enumeration sources = names.elements();
        while (sources.hasMoreElements()) {
            Namespace namespace = (Namespace)sources.nextElement();
            if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) continue;
            this.namespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    public String generatePrefix() {
        String generatedPrefix = this.getNextPrefix();
        return this.generatePrefix(generatedPrefix);
    }

    private String getNextPrefix() {
        return BASE_PREFIX + this.prefixCounter++;
    }

    public String generatePrefix(String defaultPrefix) {
        String lookup = this.resolveNamespacePrefix(defaultPrefix);
        while (lookup != null) {
            defaultPrefix = this.getNextPrefix();
            lookup = this.resolveNamespacePrefix(defaultPrefix);
        }
        return defaultPrefix;
    }

    public void removeNamespace(String prefix) {
        this.namespaces.remove(prefix);
    }
}

