/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;

public abstract class DatasourceLogin
implements Login,
Serializable,
Cloneable {
    private static final String versionStringTemplate = "{0} - {1} (Build {2})";
    public static String versionString = null;
    protected Properties properties;
    protected Platform platform;
    private boolean isEncryptedPasswordSet;
    private transient SecurableObjectHolder securableObjectHolder;
    protected Connector connector;
    protected boolean usesExternalConnectionPooling;
    protected boolean usesExternalTransactionController;
    protected int cacheTransactionIsolation = 5;
    public static final int CONCURRENT_READ_WRITE = 1;
    public static final int SYNCHRONIZED_WRITE = 2;
    public static final int SYNCHRONIZED_READ_ON_WRITE = 3;
    public static final int SYNCRONIZED_OBJECT_LEVEL_READ_WRITE = 4;
    public static final int SYNCRONIZED_OBJECT_LEVEL_READ_WRITE_DATABASE = 5;

    public DatasourceLogin() {
        this(new DatasourcePlatform());
    }

    public DatasourceLogin(Platform databasePlatform) {
        this.platform = databasePlatform;
        this.dontUseExternalConnectionPooling();
        this.dontUseExternalTransactionController();
        this.properties = new Properties();
        this.properties.put("user", "");
        this.properties.put("password", new char[0]);
        this.isEncryptedPasswordSet = false;
        this.securableObjectHolder = new SecurableObjectHolder();
    }

    protected SecurableObjectHolder getSecurableObjectHolder() {
        if (this.securableObjectHolder == null) {
            this.securableObjectHolder = new SecurableObjectHolder();
            this.securableObjectHolder.getSecurableObject();
        }
        return this.securableObjectHolder;
    }

    public Object clone() {
        DatasourceLogin clone = null;
        try {
            clone = (DatasourceLogin)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getConnector() != null) {
            clone.setConnector((Connector)this.getConnector().clone());
        }
        clone.setDatasourcePlatform((Platform)this.getDatasourcePlatform().clone());
        clone.setProperties((Properties)this.properties.clone());
        return clone;
    }

    public Object connectToDatasource(Accessor accessor, Session session) throws DatabaseException {
        return this.getConnector().connect(this.prepareProperties(this.properties), session);
    }

    public int getCacheTransactionIsolation() {
        return this.cacheTransactionIsolation;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public DatabasePlatform getPlatform() {
        try {
            return (DatabasePlatform)this.getDatasourcePlatform();
        }
        catch (ClassCastException wrongType) {
            throw ValidationException.notSupportedForDatasource();
        }
    }

    public Platform getDatasourcePlatform() {
        return this.platform;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public String getTableQualifier() {
        return this.getDatasourcePlatform().getTableQualifier();
    }

    public String getUserName() {
        return this.properties.getProperty("user");
    }

    public boolean isConnectionHealthValidatedOnError() {
        return false;
    }

    public static String getVersion() {
        if (versionString == null) {
            Object[] args = new Object[]{Version.getProduct(), Version.getVersion(), Version.getBuildNumber()};
            versionString = MessageFormat.format(versionStringTemplate, args);
        }
        return versionString;
    }

    private Properties prepareProperties(Properties properties) {
        Properties result = (Properties)properties.clone();
        Object passwordObject = result.get("password");
        if (passwordObject != null && (this.getSecurableObjectHolder().hasSecurableObject() || this.isEncryptedPasswordSet)) {
            String passwordString = null;
            if (passwordObject instanceof char[]) {
                passwordString = new String((char[])passwordObject);
            } else if (passwordObject instanceof String) {
                passwordString = (String)passwordObject;
            }
            result.put("password", this.getSecurableObjectHolder().getSecurableObject().decryptPassword(passwordString));
        }
        return result;
    }

    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
    }

    public void setCacheTransactionIsolation(int cacheTransactionIsolation) {
        this.cacheTransactionIsolation = cacheTransactionIsolation;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setDefaultNullValue(Class type, Object value) {
        this.getDatasourcePlatform().getConversionManager().setDefaultNullValue(type, value);
    }

    public void setPassword(String password) {
        if (password != null) {
            if (password == "") {
                this.setProperty("password", new char[0]);
            } else {
                String encryptedPassword = this.getSecurableObjectHolder().getSecurableObject().encryptPassword(password);
                this.setProperty("password", encryptedPassword.toCharArray());
            }
        } else {
            this.removeProperty("password");
        }
    }

    public String getPassword() {
        char[] passwordObject = (char[])this.properties.get("password");
        if (passwordObject != null) {
            return new String(passwordObject);
        }
        return null;
    }

    public void setEncryptedPassword(String password) {
        this.isEncryptedPasswordSet = true;
        if (password != null) {
            this.setProperty("password", password.toCharArray());
        } else {
            this.removeProperty("password");
        }
    }

    public void setEncryptionClassName(String encryptionClassName) {
        this.getSecurableObjectHolder().setEncryptionClassName(encryptionClassName);
    }

    public void setPlatform(Platform platform) {
        this.setDatasourcePlatform(platform);
    }

    public void setDatasourcePlatform(Platform platform) {
        this.platform = platform;
    }

    public String getPlatformClassName() {
        return this.getDatasourcePlatform().getClass().getName();
    }

    public void setPlatformClassName(String platformClassName) throws ValidationException {
        Class platformClass = null;
        try {
            platformClass = this.getClass().getClassLoader().loadClass(platformClassName);
            Platform platform = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    platform = (Platform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(platformClass));
                }
                catch (PrivilegedActionException exception) {
                    throw exception.getException();
                }
            } else {
                platform = (Platform)PrivilegedAccessHelper.newInstanceFromClass(platformClass);
            }
            this.usePlatform(platform);
        }
        catch (Exception cne) {
            try {
                platformClass = ConversionManager.loadClass(platformClassName);
                Platform platform = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        platform = (Platform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(platformClass));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.platformClassNotFound(exception.getException(), platformClassName);
                    }
                } else {
                    platform = (Platform)PrivilegedAccessHelper.newInstanceFromClass(platformClass);
                }
                this.usePlatform(platform);
            }
            catch (Exception cne2) {
                throw ValidationException.platformClassNotFound(cne2, platformClassName);
            }
        }
    }

    public void setPlatformClassName(String platformClassName, ClassLoader loader) throws ValidationException {
        boolean exceptionCaught = false;
        Class<?> platformClass = null;
        try {
            Platform platform = null;
            if (loader != null) {
                platformClass = loader.loadClass(platformClassName);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        platform = (Platform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(platformClass));
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.platformClassNotFound(exception.getException(), platformClassName);
                    }
                } else {
                    platform = (Platform)PrivilegedAccessHelper.newInstanceFromClass(platformClass);
                }
            }
            this.usePlatform(platform);
        }
        catch (Exception cne) {
            exceptionCaught = true;
        }
        if (exceptionCaught || loader == null) {
            this.setPlatformClassName(platformClassName);
        }
    }

    public void usePlatform(Platform platform) {
        if (this.getDatasourcePlatform() != null) {
            this.getDatasourcePlatform().copyInto(platform);
        }
        this.setPlatform(platform);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        this.properties.put(propertyName, propertyValue);
    }

    public void setTableQualifier(String qualifier) {
        this.getDatasourcePlatform().setTableQualifier(qualifier);
    }

    public void setTimestampQuery(ValueReadQuery timestampQuery) {
        this.getDatasourcePlatform().setTimestampQuery(timestampQuery);
    }

    public void setUserName(String name) {
        if (name != null) {
            this.setProperty("user", name);
        }
    }

    public void setUsesExternalConnectionPooling(boolean usesExternalConnectionPooling) {
        this.usesExternalConnectionPooling = usesExternalConnectionPooling;
    }

    public void setUsesExternalTransactionController(boolean usesExternalTransactionController) {
        this.usesExternalTransactionController = usesExternalTransactionController;
    }

    public void dontUseExternalConnectionPooling() {
        this.setUsesExternalConnectionPooling(false);
    }

    public void dontUseExternalTransactionController() {
        this.setUsesExternalTransactionController(false);
    }

    public boolean shouldAllowConcurrentReadWrite() {
        return this.getCacheTransactionIsolation() == 1;
    }

    public boolean shouldSynchronizedReadOnWrite() {
        return this.getCacheTransactionIsolation() == 3;
    }

    public boolean shouldSynchronizeWrites() {
        return this.getCacheTransactionIsolation() == 2;
    }

    public boolean shouldSynchronizeObjectLevelReadWrite() {
        return this.getCacheTransactionIsolation() == 4;
    }

    public boolean shouldSynchronizeObjectLevelReadWriteDatabase() {
        return this.getCacheTransactionIsolation() == 5;
    }

    public boolean shouldUseExternalConnectionPooling() {
        return this.usesExternalConnectionPooling;
    }

    public boolean shouldUseExternalTransactionController() {
        return this.usesExternalTransactionController;
    }

    public void useExternalConnectionPooling() {
        this.setUsesExternalConnectionPooling(true);
    }

    public void useExternalTransactionController() {
        this.setUsesExternalTransactionController(true);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.write(Helper.getShortClassName(this.getClass()));
        writer.println("(");
        writer.println("\t" + ToStringLocalization.buildMessage("platform", null) + "=> " + this.getDatasourcePlatform());
        if (!this.shouldUseExternalConnectionPooling()) {
            writer.println("\t" + ToStringLocalization.buildMessage("user_name", null) + "=> \"" + this.getUserName() + "\"");
        }
        writer.print("\t");
        this.getConnector().toString(writer);
        writer.write(")");
        return stringWriter.toString();
    }

    public Sequence getDefaultSequence() {
        return this.getDatasourcePlatform().getDefaultSequence();
    }

    public void setDefaultSequence(Sequence sequence) {
        this.getDatasourcePlatform().setDefaultSequence(sequence);
    }

    public void addSequence(Sequence sequence) {
        this.getDatasourcePlatform().addSequence(sequence);
    }

    public Sequence getSequence(String seqName) {
        return this.getDatasourcePlatform().getSequence(seqName);
    }

    public Map getSequences() {
        return this.getDatasourcePlatform().getSequences();
    }

    public Sequence removeSequence(String seqName) {
        return this.getDatasourcePlatform().removeSequence(seqName);
    }

    public void removeAllSequences() {
        this.getDatasourcePlatform().removeAllSequences();
    }

    public Sequence getDefaultSequenceToWrite() {
        return this.getDatasourcePlatform().getDefaultSequenceToWrite();
    }

    public Map getSequencesToWrite() {
        return this.getDatasourcePlatform().getSequencesToWrite();
    }

    public void setSequences(Map sequences) {
        this.getDatasourcePlatform().setSequences(sequences);
    }
}

