/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTreeNodeStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class UnBufferedTreeNodeStream
implements TreeNodeStream {
    public static final int INITIAL_LOOKAHEAD_BUFFER_SIZE = 5;
    protected boolean uniqueNavigationNodes = false;
    protected Object root;
    protected TokenStream tokens;
    TreeAdaptor adaptor;
    protected Stack nodeStack = new Stack();
    protected Stack indexStack = new Stack();
    protected Object currentNode;
    protected Object previousNode;
    protected int currentChildIndex;
    protected int absoluteNodeIndex;
    protected Object[] lookahead = new Object[5];
    protected int head;
    protected int tail;
    protected List markers;
    protected int markDepth = 0;
    protected int lastMarker;
    protected Object down;
    protected Object up;
    protected Object eof;

    public UnBufferedTreeNodeStream(Object tree) {
        this(new CommonTreeAdaptor(), tree);
    }

    public UnBufferedTreeNodeStream(TreeAdaptor adaptor, Object tree) {
        this.root = tree;
        this.adaptor = adaptor;
        this.reset();
        this.down = adaptor.create(2, "DOWN");
        this.up = adaptor.create(3, "UP");
        this.eof = adaptor.create(-1, "EOF");
    }

    public void reset() {
        this.currentNode = this.root;
        this.previousNode = null;
        this.currentChildIndex = -1;
        this.absoluteNodeIndex = -1;
        this.tail = 0;
        this.head = 0;
    }

    public Object get(int i) {
        throw new UnsupportedOperationException("stream is unbuffered");
    }

    public Object LT(int k) {
        if (k == -1) {
            return this.previousNode;
        }
        if (k < 0) {
            throw new IllegalArgumentException("tree node streams cannot look backwards more than 1 node");
        }
        if (k == 0) {
            return Tree.INVALID_NODE;
        }
        this.fill(k);
        return this.lookahead[(this.head + k - 1) % this.lookahead.length];
    }

    public Object getTreeSource() {
        return this.root;
    }

    public TokenStream getTokenStream() {
        return this.tokens;
    }

    public void setTokenStream(TokenStream tokens) {
        this.tokens = tokens;
    }

    protected void fill(int k) {
        int n = this.getLookaheadSize();
        for (int i = 1; i <= k - n; ++i) {
            this.next();
        }
    }

    protected void addLookahead(Object node) {
        this.lookahead[this.tail] = node;
        this.tail = (this.tail + 1) % this.lookahead.length;
        if (this.tail == this.head) {
            Object[] bigger = new Object[2 * this.lookahead.length];
            int remainderHeadToEnd = this.lookahead.length - this.head;
            System.arraycopy(this.lookahead, this.head, bigger, 0, remainderHeadToEnd);
            System.arraycopy(this.lookahead, 0, bigger, remainderHeadToEnd, this.tail);
            this.lookahead = bigger;
            this.head = 0;
            this.tail += remainderHeadToEnd;
        }
    }

    public void consume() {
        this.fill(1);
        ++this.absoluteNodeIndex;
        this.previousNode = this.lookahead[this.head];
        this.head = (this.head + 1) % this.lookahead.length;
    }

    public int LA(int i) {
        Object t = this.LT(i);
        if (t == null) {
            return 0;
        }
        return this.adaptor.getType(t);
    }

    public int mark() {
        if (this.markers == null) {
            this.markers = new ArrayList();
            this.markers.add(null);
        }
        ++this.markDepth;
        TreeWalkState state = null;
        if (this.markDepth >= this.markers.size()) {
            state = new TreeWalkState();
            this.markers.add(state);
        } else {
            state = (TreeWalkState)this.markers.get(this.markDepth);
        }
        state.absoluteNodeIndex = this.absoluteNodeIndex;
        state.currentChildIndex = this.currentChildIndex;
        state.currentNode = this.currentNode;
        state.previousNode = this.previousNode;
        state.nodeStackSize = this.nodeStack.size();
        state.indexStackSize = this.indexStack.size();
        int n = this.getLookaheadSize();
        int i = 0;
        state.lookahead = new Object[n];
        int k = 1;
        while (k <= n) {
            state.lookahead[i] = this.LT(k);
            ++k;
            ++i;
        }
        this.lastMarker = this.markDepth;
        return this.markDepth;
    }

    public void release(int marker) {
        this.markDepth = marker;
        --this.markDepth;
    }

    public void rewind(int marker) {
        if (this.markers == null) {
            return;
        }
        TreeWalkState state = (TreeWalkState)this.markers.get(marker);
        this.absoluteNodeIndex = state.absoluteNodeIndex;
        this.currentChildIndex = state.currentChildIndex;
        this.currentNode = state.currentNode;
        this.previousNode = state.previousNode;
        this.nodeStack.setSize(state.nodeStackSize);
        this.indexStack.setSize(state.indexStackSize);
        this.tail = 0;
        this.head = 0;
        while (this.tail < state.lookahead.length) {
            this.lookahead[this.tail] = state.lookahead[this.tail];
            ++this.tail;
        }
        this.release(marker);
    }

    public void rewind() {
        this.rewind(this.lastMarker);
    }

    public void seek(int index) {
        if (index < this.index()) {
            throw new IllegalArgumentException("can't seek backwards in node stream");
        }
        while (this.index() < index) {
            this.consume();
        }
    }

    public int index() {
        return this.absoluteNodeIndex + 1;
    }

    public int size() {
        CommonTreeNodeStream s = new CommonTreeNodeStream(this.root);
        return s.size();
    }

    public Object next() {
        if (this.currentNode == null) {
            this.addLookahead(this.eof);
            return null;
        }
        if (this.currentChildIndex == -1) {
            return this.handleRootNode();
        }
        if (this.currentChildIndex < this.adaptor.getChildCount(this.currentNode)) {
            return this.visitChild(this.currentChildIndex);
        }
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        if (this.currentNode != null) {
            return this.visitChild(this.currentChildIndex);
        }
        return null;
    }

    protected Object handleRootNode() {
        Object node = this.currentNode;
        this.currentChildIndex = 0;
        if (this.adaptor.isNil(node)) {
            node = this.visitChild(this.currentChildIndex);
        } else {
            this.addLookahead(node);
            if (this.adaptor.getChildCount(this.currentNode) == 0) {
                this.currentNode = null;
            }
        }
        return node;
    }

    protected Object visitChild(int child) {
        Object node = null;
        this.nodeStack.push(this.currentNode);
        this.indexStack.push(new Integer(child));
        if (child == 0 && !this.adaptor.isNil(this.currentNode)) {
            this.addNavigationNode(2);
        }
        this.currentNode = this.adaptor.getChild(this.currentNode, child);
        this.currentChildIndex = 0;
        node = this.currentNode;
        this.addLookahead(node);
        this.walkBackToMostRecentNodeWithUnvisitedChildren();
        return node;
    }

    protected void addNavigationNode(int ttype) {
        Object navNode = null;
        navNode = ttype == 2 ? (this.hasUniqueNavigationNodes() ? this.adaptor.create(2, "DOWN") : this.down) : (this.hasUniqueNavigationNodes() ? this.adaptor.create(3, "UP") : this.up);
        this.addLookahead(navNode);
    }

    protected void walkBackToMostRecentNodeWithUnvisitedChildren() {
        while (this.currentNode != null && this.currentChildIndex >= this.adaptor.getChildCount(this.currentNode)) {
            this.currentNode = this.nodeStack.pop();
            if (this.currentNode == null) {
                return;
            }
            this.currentChildIndex = (Integer)this.indexStack.pop();
            ++this.currentChildIndex;
            if (this.currentChildIndex < this.adaptor.getChildCount(this.currentNode)) continue;
            if (!this.adaptor.isNil(this.currentNode)) {
                this.addNavigationNode(3);
            }
            if (this.currentNode != this.root) continue;
            this.currentNode = null;
        }
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    public boolean hasUniqueNavigationNodes() {
        return this.uniqueNavigationNodes;
    }

    public void setUniqueNavigationNodes(boolean uniqueNavigationNodes) {
        this.uniqueNavigationNodes = uniqueNavigationNodes;
    }

    public String toString() {
        return this.toString(this.root, null);
    }

    protected int getLookaheadSize() {
        return this.tail < this.head ? this.lookahead.length - this.head + this.tail : this.tail - this.head;
    }

    public String toString(Object start, Object stop) {
        if (start == null) {
            return null;
        }
        if (this.tokens != null) {
            int beginTokenIndex = this.adaptor.getTokenStartIndex(start);
            int endTokenIndex = this.adaptor.getTokenStopIndex(stop);
            endTokenIndex = stop != null && this.adaptor.getType(stop) == 3 ? this.adaptor.getTokenStopIndex(start) : this.size() - 1;
            return this.tokens.toString(beginTokenIndex, endTokenIndex);
        }
        StringBuffer buf = new StringBuffer();
        this.toStringWork(start, stop, buf);
        return buf.toString();
    }

    protected void toStringWork(Object p, Object stop, StringBuffer buf) {
        if (!this.adaptor.isNil(p)) {
            String text = this.adaptor.getText(p);
            if (text == null) {
                text = " " + String.valueOf(this.adaptor.getType(p));
            }
            buf.append(text);
        }
        if (p == stop) {
            return;
        }
        int n = this.adaptor.getChildCount(p);
        if (n > 0 && !this.adaptor.isNil(p)) {
            buf.append(" ");
            buf.append(2);
        }
        for (int c = 0; c < n; ++c) {
            Object child = this.adaptor.getChild(p, c);
            this.toStringWork(child, stop, buf);
        }
        if (n > 0 && !this.adaptor.isNil(p)) {
            buf.append(" ");
            buf.append(3);
        }
    }

    protected class TreeWalkState {
        int currentChildIndex;
        int absoluteNodeIndex;
        Object currentNode;
        Object previousNode;
        int nodeStackSize;
        int indexStackSize;
        Object[] lookahead;

        protected TreeWalkState() {
        }
    }
}

