/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.BatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceAccessor;
import org.eclipse.persistence.internal.databaseaccess.DynamicSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.databaseaccess.ParameterizedSQLBatchWritingMechanism;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.LOBValueWriter;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.helper.ThreadCursoredList;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Login;

public class DatabaseAccessor
extends DatasourceAccessor {
    public static boolean shouldUseDynamicStatements = true;
    protected Hashtable statementCache = new Hashtable(50);
    protected DatabaseMetaData metaData;
    protected BatchWritingMechanism activeBatchWritingMechanism;
    protected DynamicSQLBatchWritingMechanism dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(this);
    protected ParameterizedSQLBatchWritingMechanism parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(this);
    protected LOBValueWriter lobWriter = null;
    protected boolean shouldUseThreadCursors = false;
    protected Statement dynamicStatement;
    protected boolean isDynamicStatementInUse = false;

    public DatabaseAccessor() {
        this.activeBatchWritingMechanism = this.parameterizedMechanism;
    }

    public void flushSelectCalls(AbstractSession session) {
        if (this.lobWriter != null) {
            this.lobWriter.buildAndExecuteSelectCalls(session);
        }
    }

    public LOBValueWriter getLOBWriter() {
        if (this.lobWriter == null) {
            this.lobWriter = new LOBValueWriter(this);
        }
        return this.lobWriter;
    }

    public synchronized Statement allocateDynamicStatement() throws SQLException {
        if (this.dynamicStatement == null) {
            this.dynamicStatement = this.getConnection().createStatement();
        }
        if (this.isDynamicStatementInUse()) {
            return this.getConnection().createStatement();
        }
        this.setIsDynamicStatementInUse(true);
        return this.dynamicStatement;
    }

    public boolean isDynamicStatementInUse() {
        return this.isDynamicStatementInUse;
    }

    public synchronized void setIsDynamicStatementInUse(boolean isDynamicStatementInUse) {
        this.isDynamicStatementInUse = isDynamicStatementInUse;
    }

    public void basicBeginTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().setAutoCommit(false);
            } else {
                this.getPlatform().beginTransaction(this);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    protected void buildConnectLog(AbstractSession session) {
        try {
            if (session.shouldLog(4, "connection")) {
                DatabaseMetaData metaData = this.getConnectionMetaData();
                Object[] args = new Object[]{metaData.getURL(), metaData.getUserName(), metaData.getDatabaseProductName(), metaData.getDatabaseProductVersion(), metaData.getDriverName(), metaData.getDriverVersion(), Helper.cr() + "\t"};
                session.log(4, "connection", "connected_user_database_driver", args, this);
            }
        }
        catch (Exception exception) {
            session.warning("JDBC_driver_does_not_support_meta_data", "connection");
        }
    }

    public AbstractRecord buildOutputRow(CallableStatement statement, DatabaseCall call, AbstractSession session) throws DatabaseException {
        try {
            return call.buildOutputRow(statement);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public Vector buildSortedFields(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        Vector<DatabaseField> sortedFields;
        try {
            Vector columnNames = this.getColumnNames(resultSet, session);
            if (fields == null) {
                sortedFields = new Vector<DatabaseField>(columnNames.size());
                Enumeration columnNamesEnum = columnNames.elements();
                while (columnNamesEnum.hasMoreElements()) {
                    sortedFields.addElement(new DatabaseField((String)columnNamesEnum.nextElement()));
                }
            } else {
                sortedFields = this.sortFields(fields, columnNames);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        return sortedFields;
    }

    protected void connectInternal(Login login, AbstractSession session) throws DatabaseException {
        super.connectInternal(login, session);
        this.checkTransactionIsolation(session);
    }

    protected void checkTransactionIsolation(AbstractSession session) throws DatabaseException {
        if (!this.isInTransaction && this.login != null && ((DatabaseLogin)this.login).getTransactionIsolation() != -1) {
            try {
                this.getConnection().setTransactionIsolation(((DatabaseLogin)this.login).getTransactionIsolation());
            }
            catch (SQLException sqlEx) {
                DatabaseException commException = this.processExceptionForCommError(session, sqlEx, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(sqlEx, this, session, false);
            }
        }
    }

    public void clearStatementCache(AbstractSession session) {
        if (this.hasStatementCache()) {
            Enumeration statements = this.getStatementCache().elements();
            while (statements.hasMoreElements()) {
                Statement statement = (Statement)statements.nextElement();
                try {
                    statement.close();
                }
                catch (SQLException exception) {}
            }
            this.setStatementCache(null);
        }
        if (this.dynamicStatement != null) {
            try {
                this.dynamicStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.dynamicStatement = null;
            this.setIsDynamicStatementInUse(false);
        }
    }

    public Object clone() {
        DatabaseAccessor accessor = (DatabaseAccessor)super.clone();
        accessor.dynamicSQLMechanism = new DynamicSQLBatchWritingMechanism(accessor);
        accessor.activeBatchWritingMechanism = accessor.dynamicSQLMechanism;
        accessor.parameterizedMechanism = new ParameterizedSQLBatchWritingMechanism(accessor);
        return accessor;
    }

    public void closeCursor(ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            resultSet.close();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement(Statement statement, AbstractSession session, DatabaseCall call) throws SQLException {
        if (statement == null) {
            this.decrementCallCount();
            return;
        }
        DatabaseQuery query = call == null ? null : call.getQuery();
        try {
            session.startOperationProfile("sql execute", query, Integer.MAX_VALUE);
            statement.close();
        }
        finally {
            session.endOperationProfile("sql execute", query, Integer.MAX_VALUE);
            this.decrementCallCount();
            if (statement == this.dynamicStatement) {
                this.dynamicStatement = null;
                this.setIsDynamicStatementInUse(false);
            }
        }
    }

    public void commitTransaction(AbstractSession session) throws DatabaseException {
        this.writesCompleted(session);
        super.commitTransaction(session);
    }

    public void basicCommitTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().commit();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().commitTransaction(this);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public AbstractRecord cursorRetrieveNextRow(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            if (resultSet.next()) {
                return this.fetchRow(fields, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public AbstractRecord cursorRetrievePreviousRow(Vector fields, ResultSet resultSet, AbstractSession session) throws DatabaseException {
        try {
            if (resultSet.previous()) {
                return this.fetchRow(fields, resultSet, resultSet.getMetaData(), session);
            }
            return null;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public void closeDatasourceConnection() throws DatabaseException {
        try {
            this.getConnection().close();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, null, false);
        }
    }

    public void disconnect(AbstractSession session) throws DatabaseException {
        this.clearStatementCache(session);
        super.disconnect(session);
    }

    public void closeConnection() {
        this.clearStatementCache(null);
        super.closeConnection();
    }

    protected void executeBatchedStatement(PreparedStatement statement, AbstractSession session) throws DatabaseException {
        try {
            this.executeDirectNoSelect(statement, null, session);
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session, null);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw exception;
        }
        try {
            this.closeStatement(statement, session, null);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        return this.basicExecuteCall(call, translationRow, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object basicExecuteCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        DatabaseCall dbCall;
        Vector<AbstractRecord> result;
        Statement statement;
        block40: {
            statement = null;
            result = null;
            dbCall = null;
            ResultSet resultSet = null;
            try {
                dbCall = (DatabaseCall)call;
            }
            catch (ClassCastException e) {
                throw QueryException.invalidDatabaseCall(call);
            }
            if (this.login == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.isInBatchWritingMode(session)) {
                if (!(!dbCall.isNothingReturned() || dbCall.hasOptimisticLock() && !this.getPlatform().usesNativeBatchWriting() || dbCall.shouldBuildOutputRow() || !this.getPlatform().usesJDBCBatchWriting() && dbCall.hasParameters() || dbCall.isLOBLocatorNeeded())) {
                    this.getActiveBatchWritingMechanism().appendCall(session, dbCall);
                    return new Integer(1);
                }
                this.getActiveBatchWritingMechanism().executeBatchedStatements(session);
            }
            try {
                this.incrementCallCount(session);
                if (session.shouldLog(3, "sql")) {
                    session.log(3, "sql", dbCall.getLogString(this), null, this, false);
                }
                session.startOperationProfile("sql prepare", dbCall.getQuery(), Integer.MAX_VALUE);
                try {
                    statement = dbCall.prepareStatement(this, translationRow, session);
                }
                finally {
                    session.endOperationProfile("sql prepare", dbCall.getQuery(), Integer.MAX_VALUE);
                }
                if (dbCall.isNothingReturned()) {
                    result = this.executeNoSelect(dbCall, statement, session);
                    if (!this.isInBatchWritingMode(session)) {
                        ++this.writeStatementsCount;
                    }
                    if (dbCall.isLOBLocatorNeeded()) {
                        this.getLOBWriter().addCall(dbCall);
                    }
                    break block40;
                }
                if (!dbCall.getReturnsResultSet() || dbCall.getReturnsResultSet() && dbCall.shouldBuildOutputRow()) {
                    result = session.getPlatform().executeStoredProcedure(dbCall, (PreparedStatement)statement, this, session);
                    if (!this.isInBatchWritingMode(session)) {
                        ++this.storedProcedureStatementsCount;
                    }
                    break block40;
                }
                resultSet = this.executeSelect(dbCall, statement, session);
                if (!this.isInBatchWritingMode(session)) {
                    ++this.readStatementsCount;
                }
                if (!dbCall.shouldIgnoreFirstRowMaxResultsSettings() && dbCall.getFirstResult() != 0) {
                    resultSet.absolute(dbCall.getFirstResult());
                }
                ResultSetMetaData metaData = resultSet.getMetaData();
                dbCall.matchFieldOrder(resultSet, this, session);
                if (dbCall.isCursorReturned()) {
                    dbCall.setStatement(statement);
                    dbCall.setResult(resultSet);
                    return dbCall;
                }
                session.startOperationProfile("row fetch", dbCall.getQuery(), Integer.MAX_VALUE);
                try {
                    block42: {
                        block41: {
                            if (!dbCall.isOneRowReturned()) break block41;
                            if (resultSet.next()) {
                                if (dbCall.isLOBLocatorNeeded()) {
                                    this.getLOBWriter().fetchLocatorAndWriteValue(dbCall, resultSet);
                                } else {
                                    result = this.fetchRow(dbCall.getFields(), resultSet, metaData, session);
                                }
                                if (resultSet.next()) {
                                    session.getEventManager().moreRowsDetected(dbCall);
                                }
                                break block42;
                            } else {
                                result = null;
                            }
                            break block42;
                        }
                        boolean hasNext = resultSet.next();
                        Vector<AbstractRecord> results = null;
                        if (hasNext) {
                            if (this.shouldUseThreadCursors()) {
                                Vector vector = this.buildThreadCursoredResult(dbCall, resultSet, statement, metaData, session);
                                return vector;
                            }
                            results = new Vector(20);
                            while (hasNext) {
                                results.addElement(this.fetchRow(dbCall.getFields(), resultSet, metaData, session));
                                hasNext = resultSet.next();
                            }
                        } else {
                            results = new Vector<AbstractRecord>(0);
                        }
                        result = results;
                    }
                    resultSet.close();
                }
                finally {
                    session.endOperationProfile("row fetch", dbCall.getQuery(), Integer.MAX_VALUE);
                }
            }
            catch (SQLException exception) {
                DatabaseException exceptionToThrow = this.processExceptionForCommError(session, exception, dbCall);
                try {
                    this.closeStatement(statement, session, dbCall);
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                if (exceptionToThrow != null) throw exceptionToThrow;
                throw DatabaseException.sqlException(exception, dbCall, this, session, false);
            }
            catch (RuntimeException exception) {
                try {
                    this.closeStatement(statement, session, dbCall);
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                if (!(exception instanceof DatabaseException)) throw exception;
                ((DatabaseException)exception).setCall(dbCall);
                throw exception;
            }
        }
        try {
            this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
            return result;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException == null) throw DatabaseException.sqlException(exception, this, session, false);
            throw commException;
        }
    }

    protected Vector buildThreadCursoredResult(final DatabaseCall dbCall, final ResultSet resultSet, final Statement statement, final ResultSetMetaData metaData, final AbstractSession session) {
        final ThreadCursoredList results = new ThreadCursoredList(20);
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                session.startOperationProfile("row fetch", dbCall.getQuery(), Integer.MAX_VALUE);
                try {
                    boolean hasNext = true;
                    while (hasNext) {
                        results.addElement(DatabaseAccessor.this.fetchRow(dbCall.getFields(), resultSet, metaData, session));
                        hasNext = resultSet.next();
                    }
                    resultSet.close();
                }
                catch (SQLException exception) {
                    DatabaseException exceptionToThrow = DatabaseAccessor.this.processExceptionForCommError(session, exception, dbCall);
                    try {
                        DatabaseAccessor.this.closeStatement(statement, session, dbCall);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (exceptionToThrow == null) {
                        results.throwException(DatabaseException.sqlException(exception, dbCall, DatabaseAccessor.this, session, false));
                    }
                    results.throwException(exceptionToThrow);
                }
                catch (RuntimeException exception) {
                    try {
                        DatabaseAccessor.this.closeStatement(statement, session, dbCall);
                    }
                    catch (Exception closeException) {
                        // empty catch block
                    }
                    if (exception instanceof DatabaseException) {
                        ((DatabaseException)exception).setCall(dbCall);
                    }
                    results.throwException(exception);
                }
                finally {
                    session.endOperationProfile("row fetch", dbCall.getQuery(), Integer.MAX_VALUE);
                }
                try {
                    DatabaseAccessor.this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
                }
                catch (SQLException exception) {
                    DatabaseException commException = DatabaseAccessor.this.processExceptionForCommError(session, exception, dbCall);
                    if (commException != null) {
                        results.throwException(commException);
                    }
                    results.throwException(DatabaseException.sqlException(exception, DatabaseAccessor.this, session, false));
                }
                results.setIsComplete(true);
            }
        };
        thread.start();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer executeDirectNoSelect(Statement statement, DatabaseCall call, AbstractSession session) throws DatabaseException {
        int rowCount = 0;
        try {
            if (call != null) {
                session.startOperationProfile("sql execute", call.getQuery(), Integer.MAX_VALUE);
            } else {
                session.startOperationProfile("sql execute", null, Integer.MAX_VALUE);
            }
            rowCount = call != null && call.isDynamicCall(session) ? statement.executeUpdate(call.getSQLString()) : ((PreparedStatement)statement).executeUpdate();
            if (!this.getPlatform().supportsAutoCommit() && !this.isInTransaction) {
                this.getPlatform().autoCommit(this);
            }
        }
        catch (SQLException exception) {
            if (!this.getPlatform().shouldIgnoreException(exception)) {
                DatabaseException commException = this.processExceptionForCommError(session, exception, call);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(exception, this, session, false);
            }
        }
        finally {
            if (call != null) {
                session.endOperationProfile("sql execute", call.getQuery(), Integer.MAX_VALUE);
            } else {
                session.endOperationProfile("sql execute", null, Integer.MAX_VALUE);
            }
        }
        return new Integer(rowCount);
    }

    protected int executeJDK12BatchStatement(Statement statement, DatabaseCall dbCall, AbstractSession session, boolean isStatementPrepared) throws DatabaseException {
        int returnValue = 0;
        try {
            returnValue = this.getPlatform().executeBatch(statement, isStatementPrepared);
        }
        catch (SQLException exception) {
            Object exceptionToThrow = null;
            DatabaseException commException = this.processExceptionForCommError(session, exception, dbCall);
            if (commException != null) {
                throw commException;
            }
            try {
                this.closeStatement(statement, session, dbCall);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            if (exceptionToThrow == null) {
                throw DatabaseException.sqlException(exception, this, session, false);
            }
            throw exceptionToThrow;
        }
        catch (RuntimeException exception) {
            try {
                this.closeStatement(statement, session, dbCall);
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            throw exception;
        }
        try {
            if (dbCall != null) {
                this.releaseStatement(statement, dbCall.getSQLString(), dbCall, session);
            } else {
                this.closeStatement(statement, session, dbCall);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, dbCall);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        return returnValue;
    }

    protected Integer executeNoSelect(DatabaseCall call, Statement statement, AbstractSession session) throws DatabaseException {
        Integer rowCount = this.executeDirectNoSelect(statement, call, session);
        if (call.shouldBuildOutputRow()) {
            AbstractRecord outputRow = this.buildOutputRow((CallableStatement)statement, call, session);
            call.getQuery().setProperty("output", outputRow);
            session.getEventManager().outputParametersDetected(outputRow, call);
        }
        return rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeSelect(DatabaseCall call, Statement statement, AbstractSession session) throws SQLException {
        ResultSet resultSet;
        session.startOperationProfile("sql execute", call.getQuery(), Integer.MAX_VALUE);
        try {
            resultSet = call.isDynamicCall(session) ? statement.executeQuery(call.getSQLString()) : ((PreparedStatement)statement).executeQuery();
        }
        finally {
            session.endOperationProfile("sql execute", call.getQuery(), Integer.MAX_VALUE);
        }
        if (call.shouldBuildOutputRow()) {
            AbstractRecord outputRow = this.buildOutputRow((CallableStatement)statement, call, session);
            call.getQuery().setProperty("output", outputRow);
            session.getEventManager().outputParametersDetected(outputRow, call);
        }
        return resultSet;
    }

    protected AbstractRecord fetchRow(Vector fields, ResultSet resultSet, ResultSetMetaData metaData, AbstractSession session) throws DatabaseException {
        int size = fields.size();
        NonSynchronizedVector values = NonSynchronizedVector.newInstance(size);
        DatabasePlatform platform = this.getPlatform();
        boolean optimizeData = platform.shouldOptimizeDataConversion();
        for (int index = 0; index < size; ++index) {
            DatabaseField field = (DatabaseField)fields.elementAt(index);
            if (field != null) {
                ((Vector)values).add(this.getObject(resultSet, field, metaData, index + 1, platform, optimizeData, session));
                continue;
            }
            ((Vector)values).add(null);
        }
        return new DatabaseRecord(fields, values);
    }

    public BatchWritingMechanism getActiveBatchWritingMechanism() {
        return this.activeBatchWritingMechanism;
    }

    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName, AbstractSession session) throws DatabaseException {
        if (session.shouldLog(1, "query")) {
            Object[] args = new Object[]{catalog, schema, tableName, columnName};
            session.log(1, "query", "query_column_meta_data_with_column", args, this);
        }
        Vector<AbstractRecord> result = new Vector<AbstractRecord>();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(session);
            resultSet = this.getConnectionMetaData().getColumns(catalog, schema, tableName, columnName);
            Vector fields = this.buildSortedFields(null, resultSet, session);
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                result.addElement(this.fetchRow(fields, resultSet, metaData, session));
            }
            resultSet.close();
        }
        catch (SQLException sqlException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            DatabaseException commException = this.processExceptionForCommError(session, sqlException, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(sqlException, this, session, false);
        }
        finally {
            this.decrementCallCount();
        }
        return result;
    }

    protected Vector getColumnNames(ResultSet resultSet, AbstractSession session) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        Vector<String> columnNames = new Vector<String>(metaData.getColumnCount());
        for (int index = 0; index < metaData.getColumnCount(); ++index) {
            String columnName = metaData.getColumnLabel(index + 1);
            if (columnName == null || columnName.equals("")) {
                columnName = "C" + (index + 1);
            }
            if (this.getPlatform().shouldForceFieldNamesToUpperCase()) {
                columnName = columnName.toUpperCase();
            }
            columnNames.addElement(columnName);
        }
        return columnNames;
    }

    public Connection getConnection() throws DatabaseException {
        return (Connection)this.datasourceConnection;
    }

    public DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.platform;
    }

    public DatabaseMetaData getConnectionMetaData() throws SQLException {
        return this.getConnection().getMetaData();
    }

    public Object getObject(ResultSet resultSet, DatabaseField field, ResultSetMetaData metaData, int columnNumber, DatabasePlatform platform, boolean optimizeData, AbstractSession session) throws DatabaseException {
        Object value = null;
        try {
            int type;
            block22: {
                type = field.sqlType;
                if (type == -1) {
                    type = metaData.getColumnType(columnNumber);
                    field.setSqlType(type);
                }
                if (optimizeData) {
                    try {
                        value = this.getObjectThroughOptimizedDataConversion(resultSet, field, type, columnNumber, platform, session);
                        if (value == null) {
                            return null;
                        }
                        if (value == this) {
                            value = null;
                        }
                    }
                    catch (SQLException exception) {
                        if (!session.shouldLog(6, "sql")) break block22;
                        session.logThrowable(6, "sql", exception);
                    }
                }
            }
            if (value == null) {
                if (type == -4 && platform.usesStreamsForBinding()) {
                    InputStream tempInputStream = resultSet.getBinaryStream(columnNumber);
                    if (tempInputStream != null) {
                        try {
                            ByteArrayOutputStream tempOutputStream = new ByteArrayOutputStream();
                            int tempInt = tempInputStream.read();
                            while (tempInt != -1) {
                                tempOutputStream.write(tempInt);
                                tempInt = tempInputStream.read();
                            }
                            value = tempOutputStream.toByteArray();
                        }
                        catch (IOException exception) {
                            throw DatabaseException.errorReadingBlobData();
                        }
                    } else {
                        value = null;
                    }
                } else {
                    value = platform.getObjectFromResultSet(resultSet, columnNumber, type, session);
                    if (this.isBlob(type)) {
                        value = platform.convertObject(value, ClassConstants.APBYTE);
                    }
                    if (this.isClob(type)) {
                        value = platform.convertObject(value, ClassConstants.STRING);
                    }
                    if (this.isArray(type)) {
                        value = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromArray(value);
                    }
                    if (this.isStruct(type, value)) {
                        value = ObjectRelationalDataTypeDescriptor.buildArrayObjectFromStruct(value);
                    }
                }
            }
            if (!optimizeData && resultSet.wasNull()) {
                value = null;
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
        return value;
    }

    protected Object getObjectThroughOptimizedDataConversion(ResultSet resultSet, DatabaseField field, int type, int columnNumber, DatabasePlatform platform, AbstractSession session) throws SQLException {
        Object value = this;
        Class fieldType = field.type;
        boolean isPrimitive = false;
        if (fieldType == ClassConstants.PLONG || fieldType == ClassConstants.LONG) {
            value = new Long(resultSet.getLong(columnNumber));
            isPrimitive = true;
        } else if (type == 12 || type == 1) {
            value = resultSet.getString(columnNumber);
            if (type == 1 && value != null && platform.shouldTrimStrings()) {
                value = Helper.rightTrimString((String)value);
            }
        } else if (fieldType == ClassConstants.INTEGER || fieldType == ClassConstants.PINT) {
            value = new Integer(resultSet.getInt(columnNumber));
            isPrimitive = true;
        } else if (fieldType == ClassConstants.FLOAT || fieldType == ClassConstants.PFLOAT) {
            value = new Float(resultSet.getFloat(columnNumber));
            isPrimitive = true;
        } else if (fieldType == ClassConstants.DOUBLE || fieldType == ClassConstants.PDOUBLE) {
            value = new Double(resultSet.getDouble(columnNumber));
            isPrimitive = true;
        } else if (fieldType == ClassConstants.SHORT || fieldType == ClassConstants.PSHORT) {
            value = new Short(resultSet.getShort(columnNumber));
            isPrimitive = true;
        } else if (Helper.shouldOptimizeDates() && fieldType != null && (type == 92 || type == 91 || type == 93)) {
            String dateString = resultSet.getString(columnNumber);
            value = platform.convertObject(dateString, fieldType);
        } else if (fieldType != null && (type == 92 || type == 91 || type == 93)) {
            if (fieldType == ClassConstants.SQLDATE) {
                value = resultSet.getDate(columnNumber);
            } else if (fieldType == ClassConstants.TIME) {
                value = resultSet.getTime(columnNumber);
            } else if (fieldType == ClassConstants.TIMESTAMP) {
                value = resultSet.getTimestamp(columnNumber);
            }
        }
        if (isPrimitive && resultSet.wasNull()) {
            value = null;
        }
        return value;
    }

    protected boolean hasStatementCache() {
        return this.statementCache != null && !this.statementCache.isEmpty();
    }

    protected synchronized Hashtable getStatementCache() {
        if (this.statementCache == null) {
            this.statementCache = new Hashtable(50);
        }
        return this.statementCache;
    }

    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types, AbstractSession session) throws DatabaseException {
        if (session.shouldLog(1, "query")) {
            Object[] args = new Object[]{catalog, schema, tableName};
            session.log(1, "query", "query_column_meta_data", args, this);
        }
        Vector<AbstractRecord> result = new Vector<AbstractRecord>();
        ResultSet resultSet = null;
        try {
            this.incrementCallCount(session);
            resultSet = this.getConnectionMetaData().getTables(catalog, schema, tableName, types);
            Vector fields = this.buildSortedFields(null, resultSet, session);
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                result.addElement(this.fetchRow(fields, resultSet, metaData, session));
            }
            resultSet.close();
        }
        catch (SQLException sqlException) {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException closeException) {
                // empty catch block
            }
            DatabaseException commException = this.processExceptionForCommError(session, sqlException, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(sqlException, this, session, false);
        }
        finally {
            this.decrementCallCount();
        }
        return result;
    }

    public boolean isDatasourceConnected() {
        try {
            return !this.getConnection().isClosed();
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, this, null, false);
        }
    }

    protected boolean isInBatchWritingMode(AbstractSession session) {
        return this.getPlatform().usesBatchWriting() && this.isInTransaction;
    }

    public boolean shouldUseThreadCursors() {
        return this.shouldUseThreadCursors;
    }

    public void setShouldUseThreadCursors(boolean shouldUseThreadCursors) {
        this.shouldUseThreadCursors = shouldUseThreadCursors;
    }

    public Statement prepareStatement(DatabaseCall call, AbstractSession session) throws SQLException {
        return this.prepareStatement(call, session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement prepareStatement(DatabaseCall call, AbstractSession session, boolean unwrapConnection) throws SQLException {
        Statement statement = null;
        if (call.usesBinding(session) && call.shouldCacheStatement(session)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                statement = (PreparedStatement)this.getStatementCache().get(call.getSQLString());
                if (statement != null) {
                    this.getStatementCache().remove(call.getSQLString());
                }
            }
        }
        if (statement == null) {
            if (call.isCallableStatementRequired()) {
                if (call.isResultSetScrollable()) {
                    statement = this.getConnection().prepareCall(call.getSQLString(), call.getResultSetType(), call.getResultSetConcurrency());
                    statement.setFetchSize(call.getResultSetFetchSize());
                } else {
                    statement = this.getConnection().prepareCall(call.getSQLString());
                }
            } else if (call.isResultSetScrollable()) {
                statement = this.getConnection().prepareStatement(call.getSQLString(), call.getResultSetType(), call.getResultSetConcurrency());
                statement.setFetchSize(call.getResultSetFetchSize());
            } else {
                statement = call.isDynamicCall(session) ? this.allocateDynamicStatement() : (unwrapConnection ? this.getPlatform().getConnection(session, this.getConnection()).prepareStatement(call.getSQLString()) : this.getConnection().prepareStatement(call.getSQLString()));
            }
        }
        return statement;
    }

    public DatabaseException processExceptionForCommError(AbstractSession session, SQLException exception, Call call) {
        if (session.getLogin().isConnectionHealthValidatedOnError() && (call == null || ((DatabaseCall)call).getQueryTimeout() == 0) && this.getConnection() != null && session.getServerPlatform().wasFailureCommunicationBased(exception, this, session)) {
            this.setIsValid(false);
            return DatabaseException.sqlException(exception, call, this, session, true);
        }
        return null;
    }

    protected void reconnect(AbstractSession session) {
        this.clearStatementCache(session);
        super.reconnect(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStatement(Statement statement, String sqlString, DatabaseCall call, AbstractSession session) throws SQLException {
        if (call.usesBinding(session) && call.shouldCacheStatement(session)) {
            Hashtable hashtable = this.getStatementCache();
            synchronized (hashtable) {
                PreparedStatement preparedStatement = (PreparedStatement)statement;
                if (!this.getStatementCache().containsKey(sqlString)) {
                    preparedStatement.clearParameters();
                    this.resetStatementFromCall(preparedStatement, call);
                    if (this.getStatementCache().size() > this.getPlatform().getStatementCacheSize()) {
                        PreparedStatement removedStatement = (PreparedStatement)this.getStatementCache().remove(this.getStatementCache().keys().nextElement());
                        this.closeStatement(removedStatement, session, call);
                    } else {
                        this.decrementCallCount();
                    }
                    this.getStatementCache().put(sqlString, preparedStatement);
                } else {
                    this.closeStatement(statement, session, call);
                }
            }
        } else if (statement == this.dynamicStatement) {
            this.resetStatementFromCall(statement, call);
            this.setIsDynamicStatementInUse(false);
            this.decrementCallCount();
        } else {
            this.closeStatement(statement, session, call);
        }
    }

    protected void resetStatementFromCall(Statement statement, DatabaseCall call) throws SQLException {
        if (call.getQueryTimeout() > 0) {
            statement.setQueryTimeout(0);
        }
        if (call.getMaxRows() > 0) {
            statement.setMaxRows(0);
        }
        if (call.getResultSetFetchSize() > 0) {
            statement.setFetchSize(0);
        }
    }

    public void rollbackTransaction(AbstractSession session) throws DatabaseException {
        this.getActiveBatchWritingMechanism().clear();
        super.rollbackTransaction(session);
    }

    public void basicRollbackTransaction(AbstractSession session) throws DatabaseException {
        try {
            if (this.getPlatform().supportsAutoCommit()) {
                this.getConnection().rollback();
                this.getConnection().setAutoCommit(true);
            } else {
                this.getPlatform().rollbackTransaction(this);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.processExceptionForCommError(session, exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this, session, false);
        }
    }

    public void setActiveBatchWritingMechanismToParameterizedSQL() {
        this.activeBatchWritingMechanism = this.parameterizedMechanism;
        if (((DatabaseLogin)this.login).getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE) {
            ((DatabaseLogin)this.login).setMaxBatchWritingSize(DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE);
        }
    }

    public void setActiveBatchWritingMechanismToDynamicSQL() {
        this.activeBatchWritingMechanism = this.dynamicSQLMechanism;
        if (((DatabaseLogin)this.login).getMaxBatchWritingSize() == DatabasePlatform.DEFAULT_PARAMETERIZED_MAX_BATCH_WRITING_SIZE) {
            ((DatabaseLogin)this.login).setMaxBatchWritingSize(DatabasePlatform.DEFAULT_MAX_BATCH_WRITING_SIZE);
        }
    }

    protected void setStatementCache(Hashtable statementCache) {
        this.statementCache = statementCache;
    }

    protected Vector sortFields(Vector fields, Vector columnNames) {
        Vector<DatabaseField> sortedFields = new Vector<DatabaseField>(columnNames.size());
        Vector eligableFields = (Vector)fields.clone();
        Enumeration columnNamesEnum = columnNames.elements();
        boolean valueFound = false;
        while (columnNamesEnum.hasMoreElements()) {
            String columnName = (String)columnNamesEnum.nextElement();
            DatabaseField field = null;
            Enumeration fieldEnum = eligableFields.elements();
            while (fieldEnum.hasMoreElements()) {
                field = (DatabaseField)fieldEnum.nextElement();
                if (field == null) continue;
                if (DatabasePlatform.shouldIgnoreCaseOnFieldComparisons()) {
                    if (!field.getName().equalsIgnoreCase(columnName)) continue;
                    valueFound = true;
                    sortedFields.addElement(field);
                    break;
                }
                if (!field.getName().equals(columnName)) continue;
                valueFound = true;
                sortedFields.addElement(field);
                break;
            }
            if (valueFound) {
                eligableFields.removeElement(field);
            } else {
                sortedFields.addElement(new DatabaseField());
            }
            valueFound = false;
        }
        return sortedFields;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("DatabaseAccessor(");
        if (this.isConnected()) {
            writer.write(ToStringLocalization.buildMessage("connected", null));
        } else {
            writer.write(ToStringLocalization.buildMessage("disconnected", null));
        }
        writer.write(")");
        return writer.toString();
    }

    private boolean isArray(int type) {
        return type == 2003;
    }

    private boolean isBlob(int type) {
        return type == 2004 || type == -4;
    }

    private boolean isClob(int type) {
        return type == 2005 || type == -1;
    }

    private boolean isStruct(int type, Object value) {
        return type == 2002 && value instanceof Struct;
    }

    public void writesCompleted(AbstractSession session) {
        if (this.isInBatchWritingMode(session)) {
            this.getActiveBatchWritingMechanism().executeBatchedStatements(session);
        }
    }
}

