/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.sql.Connection;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.sessions.Login;

public abstract class DatasourceAccessor
implements Accessor {
    protected Object datasourceConnection;
    protected Login login;
    protected int callCount = 0;
    public int storedProcedureStatementsCount;
    public int readStatementsCount;
    public int writeStatementsCount;
    public static final String READ_STATEMENTS_COUNT_PROPERTY = "Read_Statements_Count_Property";
    public static final String WRITE_STATEMENTS_COUNT_PROPERTY = "Write_Statements_Count_Property";
    public static final String STOREDPROCEDURE_STATEMENTS_COUNT_PROPERTY = "StoredProcedure_Statements_Count_Property";
    protected boolean isInTransaction = false;
    protected boolean isConnected = false;
    protected DatasourcePlatform platform;
    protected boolean isValid = true;
    protected transient SequencingCallback sequencingCallback;
    protected transient AbstractSession currentSession;
    protected boolean isBeginningTransaction;
    protected boolean isCompletingTransaction;
    protected boolean usesExternalConnectionPooling;
    public static boolean shouldCheckConnection = false;

    public Object clone() {
        try {
            DatasourceAccessor accessor = (DatasourceAccessor)super.clone();
            return accessor;
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError("clone not supported");
        }
    }

    public void closeJTSConnection() {
        if (this.usesExternalTransactionController()) {
            this.isInTransaction = false;
            if (this.usesExternalConnectionPooling) {
                this.closeConnection();
            }
        }
    }

    protected void setIsInTransaction(boolean value) {
        this.isInTransaction = value;
    }

    public void setIsValid(boolean isValid) {
        this.isValid = isValid;
    }

    public boolean isInTransaction() {
        return this.isInTransaction;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean usesExternalConnectionPooling() {
        return this.usesExternalConnectionPooling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (session.isExclusiveConnectionRequired() && !this.isInTransaction && this.usesExternalConnectionPooling) {
                this.closeConnection();
            }
            this.isInTransaction = true;
            return;
        }
        session.log(2, "transaction", "begin_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.isBeginningTransaction = true;
            this.incrementCallCount(session);
            this.basicBeginTransaction(session);
            this.isInTransaction = true;
        }
        finally {
            this.isBeginningTransaction = false;
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    protected abstract void basicBeginTransaction(AbstractSession var1);

    protected abstract void basicCommitTransaction(AbstractSession var1);

    protected abstract void basicRollbackTransaction(AbstractSession var1);

    public synchronized void decrementCallCount() {
        int count;
        if ((count = this.callCount--) <= 0) {
            return;
        }
        if (!(!this.usesExternalConnectionPooling || this.isInTransaction || this.currentSession != null && this.currentSession.isExclusiveConnectionRequired() || count != 1)) {
            try {
                this.closeConnection();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    public synchronized void incrementCallCount(AbstractSession session) {
        ++this.callCount;
        if (this.callCount == 1) {
            if (this.login == null) {
                throw DatabaseException.databaseAccessorNotConnected();
            }
            if (this.datasourceConnection != null) {
                if (shouldCheckConnection && !this.isConnected()) {
                    if (this.isInTransaction) {
                        throw DatabaseException.databaseAccessorNotConnected();
                    }
                    this.reconnect(session);
                }
            } else if (this.usesExternalConnectionPooling) {
                this.reconnect(session);
                if (this.isBeginningTransaction || this.isInTransaction || session.isExclusiveConnectionRequired()) {
                    session.postConnectExternalConnection(this);
                    this.currentSession = session;
                } else if (this.isCompletingTransaction) {
                    this.currentSession = session;
                }
            } else {
                throw DatabaseException.databaseAccessorNotConnected();
            }
        }
    }

    public void resetStatmentsCount() {
        this.readStatementsCount = 0;
        this.writeStatementsCount = 0;
        this.storedProcedureStatementsCount = 0;
    }

    protected void connectInternal(Login login, AbstractSession session) throws DatabaseException {
        this.datasourceConnection = login.connectToDatasource(this, session);
        this.isConnected = true;
    }

    protected void setIsConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    protected void setCallCount(int callCount) {
        this.callCount = callCount;
    }

    public int getCallCount() {
        return this.callCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (!session.isSynchronized()) {
                this.isInTransaction = false;
                if (this.usesExternalConnectionPooling) {
                    this.currentSession = session;
                    this.closeConnection();
                }
            }
            return;
        }
        session.log(2, "transaction", "commit_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.isCompletingTransaction = true;
            this.incrementCallCount(session);
            this.basicCommitTransaction(session);
            if (this.sequencingCallback != null) {
                this.sequencingCallback.afterCommit(this);
            }
            this.isInTransaction = false;
        }
        finally {
            this.isCompletingTransaction = false;
            this.sequencingCallback = null;
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Login login, AbstractSession session) throws DatabaseException {
        session.startOperationProfile("connect");
        session.incrementProfile("ConnectCalls");
        try {
            if (session.shouldLog(4, "connection")) {
                session.log(4, "connection", "connecting", new Object[]{login}, this);
            }
            this.setLogin(login);
            this.setDatasourcePlatform((DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform());
            try {
                this.connectInternal(login, session);
                this.isInTransaction = false;
            }
            catch (RuntimeException exception) {
                session.handleSevere(exception);
            }
            session.getEventManager().postConnect(this);
            this.incrementCallCount(session);
            try {
                this.buildConnectLog(session);
            }
            finally {
                this.decrementCallCount();
            }
        }
        finally {
            session.endOperationProfile("connect");
        }
    }

    protected abstract void closeDatasourceConnection();

    protected abstract Object basicExecuteCall(Call var1, AbstractRecord var2, AbstractSession var3);

    protected abstract void buildConnectLog(AbstractSession var1);

    public Login getLogin() {
        return this.login;
    }

    protected void setLogin(Login login) {
        this.login = login;
        this.usesExternalConnectionPooling = login.shouldUseExternalConnectionPooling();
    }

    public void disconnect(AbstractSession session) throws DatabaseException {
        session.log(4, "connection", "disconnect", (Object[])null, this);
        if (this.datasourceConnection == null) {
            return;
        }
        session.incrementProfile("DisconnectCalls");
        session.startOperationProfile("connect");
        this.closeDatasourceConnection();
        this.datasourceConnection = null;
        this.isInTransaction = true;
        session.endOperationProfile("connect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        try {
            if (this.datasourceConnection != null) {
                if (this.isDatasourceConnected()) {
                    if (this.currentSession != null) {
                        this.currentSession.preDisconnectExternalConnection(this);
                    }
                    this.closeDatasourceConnection();
                }
                this.datasourceConnection = null;
            }
        }
        catch (DatabaseException exception) {
            this.datasourceConnection = null;
        }
        finally {
            this.currentSession = null;
        }
    }

    public Object executeCall(Call call, AbstractRecord translationRow, AbstractSession session) throws DatabaseException {
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        if (session.shouldLog(3, "sql")) {
            session.log(3, "sql", call.getLogString(this), null, this, false);
        }
        Object result = this.basicExecuteCall(call, translationRow, session);
        return result;
    }

    public void reestablishConnection(AbstractSession session) throws DatabaseException {
        if (session.shouldLog(4, "connection")) {
            Object[] args = new Object[]{this.getLogin()};
            session.log(4, "connection", "reconnecting", args, this);
        }
        this.reconnect(session);
        this.isInTransaction = false;
        this.isValid = true;
        session.getEventManager().postConnect(this);
    }

    protected void reconnect(AbstractSession session) throws DatabaseException {
        session.log(1, "connection", "reconnecting_to_external_connection_pool");
        session.startOperationProfile("connect");
        this.connectInternal(this.login, session);
        session.endOperationProfile("connect");
    }

    public DatasourcePlatform getDatasourcePlatform() {
        return this.platform;
    }

    public void setDatasourcePlatform(DatasourcePlatform platform) {
        this.platform = platform;
    }

    public Object getDatasourceConnection() {
        return this.datasourceConnection;
    }

    public Connection getConnection() {
        return (Connection)this.datasourceConnection;
    }

    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName, AbstractSession session) throws DatabaseException {
        return new Vector();
    }

    public int getReadStatementsCount() {
        return this.readStatementsCount;
    }

    public int getWriteStatementsCount() {
        return this.writeStatementsCount;
    }

    public int getStoredProcedureStatementsCount() {
        return this.storedProcedureStatementsCount;
    }

    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types, AbstractSession session) throws DatabaseException {
        return new Vector();
    }

    protected void setDatasourceConnection(Object connection) {
        this.datasourceConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(AbstractSession session) throws DatabaseException {
        if (this.usesExternalTransactionController()) {
            if (!session.isSynchronized()) {
                this.isInTransaction = false;
                if (this.usesExternalConnectionPooling) {
                    this.currentSession = session;
                    this.closeConnection();
                }
            }
            return;
        }
        session.log(2, "transaction", "rollback_transaction", (Object[])null, this);
        try {
            session.startOperationProfile("transactions");
            this.isCompletingTransaction = true;
            this.incrementCallCount(session);
            this.basicRollbackTransaction(session);
        }
        finally {
            this.isInTransaction = false;
            this.isCompletingTransaction = false;
            this.sequencingCallback = null;
            this.decrementCallCount();
            session.endOperationProfile("transactions");
        }
    }

    public boolean usesExternalTransactionController() {
        if (this.login == null) {
            throw DatabaseException.databaseAccessorNotConnected();
        }
        return this.login.shouldUseExternalTransactionController();
    }

    public boolean isConnected() {
        if (this.datasourceConnection == null && this.login == null) {
            return false;
        }
        if (this.usesExternalConnectionPooling) {
            return true;
        }
        if (this.datasourceConnection == null) {
            return false;
        }
        return this.isDatasourceConnected();
    }

    protected abstract boolean isDatasourceConnected();

    public void flushSelectCalls(AbstractSession session) {
    }

    public void writesCompleted(AbstractSession session) {
    }

    public SequencingCallback getSequencingCallback(SequencingCallbackFactory sequencingCallbackFactory) {
        if (this.sequencingCallback == null) {
            this.sequencingCallback = sequencingCallbackFactory.createSequencingCallback();
        }
        return this.sequencingCallback;
    }
}

