/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree.analysis;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.Constants;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.ClassNode;
import org.eclipse.persistence.internal.libraries.asm.tree.IincInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.JumpInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LookupSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.MethodNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TableSwitchInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.TryCatchBlockNode;
import org.eclipse.persistence.internal.libraries.asm.tree.VarInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.AnalyzerException;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Frame;
import org.eclipse.persistence.internal.libraries.asm.tree.analysis.Interpreter;

public class Analyzer
implements Constants {
    private Interpreter interpreter;
    private int n;
    private IntMap indexes;
    private List[] handlers;
    private Frame[] frames;
    private Subroutine[] subroutines;
    private boolean[] queued;
    private int[] queue;
    private int top;
    private boolean jsr;

    public Analyzer(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Frame[] analyze(ClassNode c, MethodNode m) throws AnalyzerException {
        int i;
        this.n = m.instructions.size();
        this.indexes = new IntMap(2 * this.n);
        this.handlers = new List[this.n];
        this.frames = new Frame[this.n];
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (i = 0; i < this.n; ++i) {
            this.indexes.put(m.instructions.get(i), i);
        }
        for (i = 0; i < m.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tcb = (TryCatchBlockNode)m.tryCatchBlocks.get(i);
            int begin = this.indexes.get(tcb.start);
            int end = this.indexes.get(tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Frame current = this.newFrame(m.maxLocals, m.maxStack);
        Frame handler = this.newFrame(m.maxLocals, m.maxStack);
        Type[] args = Type.getArgumentTypes(m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getType("L" + c.name + ";");
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        for (int i2 = 0; i2 < args.length; ++i2) {
            current.setLocal(local++, this.interpreter.newValue(args[i2]));
            if (args[i2].getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.merge(0, current, null);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame f = this.frames[insn];
            Subroutine subroutine = this.subroutines[insn];
            this.queued[insn] = false;
            try {
                List insnHandlers;
                Object o = m.instructions.get(insn);
                this.jsr = false;
                if (o instanceof Label) {
                    this.merge(insn + 1, f, subroutine);
                } else {
                    Label label;
                    int j;
                    AbstractInsnNode insnNode = (AbstractInsnNode)o;
                    int insnOpcode = insnNode.getOpcode();
                    current.init(f).execute(insnNode, this.interpreter);
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current, subroutine);
                        }
                        if (insnOpcode == 168) {
                            this.jsr = true;
                            this.merge(this.indexes.get(j2.label), current, new Subroutine(j2.label, m.maxLocals, j2));
                        } else {
                            this.merge(this.indexes.get(j2.label), current, subroutine);
                        }
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        this.merge(this.indexes.get(lsi.dflt), current, subroutine);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            label = (Label)lsi.labels.get(j);
                            this.merge(this.indexes.get(label), current, subroutine);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        this.merge(this.indexes.get(tsi.dflt), current, subroutine);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            label = (Label)tsi.labels.get(j);
                            this.merge(this.indexes.get(label), current, subroutine);
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException("RET instruction outside of a sub routine");
                        }
                        for (int i3 = 0; i3 < subroutine.callers.size(); ++i3) {
                            int caller = this.indexes.get(subroutine.callers.get(i3));
                            this.merge(caller + 1, this.frames[caller], current, this.subroutines[caller], subroutine.access);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.access[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                            }
                        }
                        this.merge(insn + 1, current, subroutine);
                    }
                }
                if ((insnHandlers = this.handlers[insn]) == null) continue;
                for (int i4 = 0; i4 < insnHandlers.size(); ++i4) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)insnHandlers.get(i4);
                    Type type = tcb.type == null ? Type.getType("Ljava/lang/Throwable;") : Type.getType("L" + tcb.type + ";");
                    handler.init(f);
                    handler.clearStack();
                    handler.push(this.interpreter.newValue(type));
                    this.merge(this.indexes.get(tcb.handler), handler, subroutine);
                }
            }
            catch (Exception e) {
                throw new AnalyzerException("Error at instruction " + insn + ": " + e.getMessage());
            }
        }
        return this.frames;
    }

    public Frame[] getFrames() {
        return this.frames;
    }

    public int getIndex(Object insn) {
        return this.indexes.get(insn);
    }

    public List getHandlers(int insn) {
        return this.handlers[insn];
    }

    protected Frame newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected Frame newFrame(Frame src) {
        return new Frame(src);
    }

    protected void newControlFlowEdge(Frame frame, Frame successor) {
    }

    private void merge(int insn, Frame frame, Subroutine subroutine) throws AnalyzerException {
        if (insn > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes = false;
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(frame);
            changes = true;
        } else {
            changes |= oldFrame.merge(frame, this.interpreter);
        }
        this.newControlFlowEdge(frame, oldFrame);
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insn] = subroutine.copy();
                changes = true;
            }
        } else if (subroutine != null) {
            changes |= oldSubroutine.merge(subroutine, !this.jsr);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    private void merge(int insn, Frame beforeJSR, Frame afterRET, Subroutine subroutineBeforeJSR, boolean[] access) throws AnalyzerException {
        if (insn > this.n - 1) {
            throw new AnalyzerException("Execution can fall off end of the code");
        }
        Frame oldFrame = this.frames[insn];
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes = false;
        afterRET.merge(beforeJSR, access);
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(afterRET);
            changes = true;
        } else {
            changes |= oldFrame.merge(afterRET, access);
        }
        this.newControlFlowEdge(afterRET, oldFrame);
        if (oldSubroutine == null) {
            if (subroutineBeforeJSR != null) {
                this.subroutines[insn] = subroutineBeforeJSR.copy();
                changes = true;
            }
        } else if (subroutineBeforeJSR != null) {
            changes |= oldSubroutine.merge(subroutineBeforeJSR, !this.jsr);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    private static class Subroutine {
        Label start;
        boolean[] access;
        List callers;

        private Subroutine() {
        }

        public Subroutine(Label start, int maxLocals, JumpInsnNode caller) {
            this.start = start;
            this.access = new boolean[maxLocals];
            this.callers = new ArrayList();
            this.callers.add(caller);
        }

        public Subroutine copy() {
            Subroutine result = new Subroutine();
            result.start = this.start;
            result.access = new boolean[this.access.length];
            System.arraycopy(this.access, 0, result.access, 0, this.access.length);
            result.callers = new ArrayList(this.callers);
            return result;
        }

        public boolean merge(Subroutine subroutine, boolean checkOverlap) throws AnalyzerException {
            int i;
            if (checkOverlap && subroutine.start != this.start) {
                throw new AnalyzerException("Overlapping sub routines");
            }
            boolean changes = false;
            for (i = 0; i < this.access.length; ++i) {
                if (!subroutine.access[i] || this.access[i]) continue;
                this.access[i] = true;
                changes = true;
            }
            for (i = 0; i < subroutine.callers.size(); ++i) {
                Object caller = subroutine.callers.get(i);
                if (this.callers.contains(caller)) continue;
                this.callers.add(caller);
                changes = true;
            }
            return changes;
        }
    }

    private static class IntMap {
        private int size;
        private Object[] keys;
        private int[] values;

        private IntMap(int size) {
            this.size = size;
            this.keys = new Object[size];
            this.values = new int[size];
        }

        public int get(Object key) {
            int n = this.size;
            int i = (key.hashCode() & Integer.MAX_VALUE) % n;
            while (this.keys[i] != key) {
                i = (i + 1) % n;
            }
            return this.values[i];
        }

        public void put(Object key, int value) {
            int n = this.size;
            int i = (key.hashCode() & Integer.MAX_VALUE) % n;
            while (this.keys[i] != null) {
                i = (i + 1) % n;
            }
            this.keys[i] = key;
            this.values[i] = value;
        }
    }
}

