/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import java.io.StringWriter;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ClientSessionIdentityMapAccessor;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ClientSession
extends AbstractSession {
    protected ServerSession parent;
    protected ConnectionPolicy connectionPolicy;
    protected Accessor writeConnection;
    protected boolean isActive;
    protected Sequencing sequencing;

    public ClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        super(parent.getProject());
        if (connectionPolicy.isUserDefinedConnection()) {
            this.setProject((Project)this.getProject().clone());
            this.setLogin(connectionPolicy.getLogin());
        }
        this.isActive = true;
        this.externalTransactionController = parent.getExternalTransactionController();
        this.parent = parent;
        this.connectionPolicy = connectionPolicy;
        this.writeConnection = this.accessor;
        this.accessor = parent.getAccessor();
        this.name = parent.getName();
        this.profiler = parent.getProfiler();
        this.isInProfile = parent.isInProfile();
        this.commitManager = parent.getCommitManager();
        this.sessionLog = parent.getSessionLog();
        this.eventManager = parent.getEventManager().clone(this);
        this.exceptionHandler = parent.getExceptionHandler();
        this.getEventManager().postAcquireClientSession();
        this.incrementProfile("ClientSession");
    }

    protected ClientSession(Project project) {
        super(project);
    }

    public void releaseJTSConnection() {
        if (this.hasWriteConnection()) {
            this.getWriteConnection().closeJTSConnection();
            this.releaseWriteConnection();
        }
    }

    public void basicBeginTransaction() {
        if (!this.hasWriteConnection() && this.getConnectionPolicy().isLazy()) {
            this.getParent().acquireClientConnection(this);
        }
        super.basicBeginTransaction();
    }

    public void basicCommitTransaction() {
        super.basicCommitTransaction();
        if (this.hasExternalTransactionController()) {
            if (!this.isSynchronized()) {
                this.releaseJTSConnection();
            }
        } else {
            this.releaseWriteConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicRollbackTransaction() {
        try {
            if (this.hasWriteConnection()) {
                super.basicRollbackTransaction();
            }
        }
        finally {
            if (this.hasExternalTransactionController()) {
                if (!this.isSynchronized()) {
                    this.releaseJTSConnection();
                }
            } else {
                this.releaseWriteConnection();
            }
        }
    }

    public void connect() throws DatabaseException {
        this.getWriteConnection().connect(this.getDatasourceLogin(), this);
    }

    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (!containsQuery) {
            containsQuery = this.getParent().containsQuery(queryName);
        }
        return containsQuery;
    }

    public void disconnect() throws DatabaseException {
        this.getWriteConnection().disconnect(this);
    }

    public Accessor getAccessor() {
        if (this.isInTransaction()) {
            return this.getWriteConnection();
        }
        return super.getAccessor();
    }

    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    public Map getDescriptors() {
        return this.getParent().getDescriptors();
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery query, boolean canReturnSelf, boolean terminalOnly) {
        return this.getParent().getParentIdentityMapSession(query, canReturnSelf, terminalOnly);
    }

    public Object getProperty(String name) {
        Object propertyValue = super.getProperties().get(name);
        if (propertyValue == null) {
            propertyValue = this.getParent().getProperty(name);
        }
        return propertyValue;
    }

    public AbstractSession getExecutionSession(DatabaseQuery query) {
        if (this.isInTransaction()) {
            return this;
        }
        return this.getParent().getExecutionSession(query);
    }

    public ServerSession getParent() {
        return this.parent;
    }

    public DatabaseQuery getQuery(String name) {
        DatabaseQuery query = super.getQuery(name);
        if (query == null) {
            query = this.getParent().getQuery(name);
        }
        return query;
    }

    public DatabaseQuery getQuery(String name, Vector args) {
        DatabaseQuery query = super.getQuery(name, args);
        if (query == null) {
            query = this.getParent().getQuery(name, args);
        }
        return query;
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    public Sequencing getSequencing() {
        if (this.sequencing == null) {
            this.initializeSequencing();
        }
        return this.sequencing;
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public String getSessionTypeString() {
        return "ClientSession";
    }

    public Accessor getWriteConnection() {
        return this.writeConnection;
    }

    protected boolean hasWriteConnection() {
        if (this.getWriteConnection() == null) {
            return false;
        }
        return this.getWriteConnection().isConnected();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new ClientSessionIdentityMapAccessor(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isClientSession() {
        return true;
    }

    public boolean isConnected() {
        return this.getParent().isConnected();
    }

    public void release() throws DatabaseException {
        if (!this.isActive()) {
            return;
        }
        this.getEventManager().preReleaseClientSession();
        if (this.hasWriteConnection()) {
            this.getParent().releaseClientSession(this);
        }
        this.setIsActive(false);
        this.log(2, "connection", "client_released");
        this.getEventManager().postReleaseClientSession();
    }

    protected void releaseWriteConnection() {
        if (this.getConnectionPolicy().isLazy() && this.hasWriteConnection()) {
            this.getParent().releaseClientSession(this);
            this.setWriteConnection(null);
        }
    }

    public void setConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.connectionPolicy = connectionPolicy;
    }

    protected void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    protected void setParent(ServerSession parent) {
        this.parent = parent;
    }

    public void setWriteConnection(Accessor writeConnection) {
        this.writeConnection = writeConnection;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString());
        writer.write("(");
        writer.write(String.valueOf(this.getWriteConnection()));
        writer.write(")");
        return writer.toString();
    }

    public CommandManager getCommandManager() {
        return this.getParent().getCommandManager();
    }

    public boolean shouldPropagateChanges() {
        return this.getParent().shouldPropagateChanges();
    }

    public void releaseReadConnection(Accessor connection) {
        this.getParent().releaseReadConnection(connection);
    }

    public void postConnectExternalConnection(Accessor accessor) {
        if (this.getConnectionPolicy().isPooled()) {
            this.getEventManager().postAcquireConnection(accessor);
        }
        if (this.getConnectionPolicy().shouldUseExclusiveConnection()) {
            this.getEventManager().postAcquireExclusiveConnection(this, accessor);
        }
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        if (this.getConnectionPolicy().isPooled()) {
            this.getEventManager().preReleaseConnection(accessor);
        }
        if (this.getConnectionPolicy().shouldUseExclusiveConnection()) {
            this.getEventManager().preReleaseExclusiveConnection(this, accessor);
        }
    }

    public boolean isExclusiveConnectionRequired() {
        return this.getConnectionPolicy().shouldUseExclusiveConnection();
    }
}

