/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.config.PersistenceUnitProperties;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

public class PropertiesHandler {
    public static String getPropertyValue(String name, Map m) {
        return Prop.getPropertyValueToApply(name, m, null, true);
    }

    public static String getPropertyValueLogDebug(String name, Map m, AbstractSession session) {
        return Prop.getPropertyValueToApply(name, m, session, true);
    }

    public static String getPrefixedPropertyValue(String prefix, String suffix, Map m) {
        return (String)PropertiesHandler.getPrefixValues(prefix, m).get(suffix);
    }

    public static Map getPrefixValues(String prefix, Map m) {
        return Prop.getPrefixValuesToApply(prefix, m, null, true);
    }

    public static Map getPrefixValuesLogDebug(String prefix, Map m, AbstractSession session) {
        return Prop.getPrefixValuesToApply(prefix, m, session, true);
    }

    public static String getDefaultPropertyValue(String name) {
        return Prop.getDefaultPropertyValueToApply(name, null);
    }

    public static String getDefaultPropertyValueLogDebug(String name, AbstractSession session) {
        return Prop.getDefaultPropertyValueToApply(name, session);
    }

    public static String getSessionPropertyValue(String name, AbstractSession session) {
        String value = null;
        while (value == null && session != null) {
            AbstractSession parent = session.getParent();
            value = Prop.getPropertyValueToApply(name, session.getProperties(), null, parent == null);
            session = parent;
        }
        return value;
    }

    public static String getSessionPropertyValueLogDebug(String name, AbstractSession session) {
        String value = null;
        while (value == null && session != null) {
            AbstractSession parent = session.getParent();
            value = Prop.getPropertyValueToApply(name, session.getProperties(), session, parent == null);
            session = parent;
        }
        return value;
    }

    protected static boolean shouldUseDefault(String value) {
        return value != null && value.length() == 0;
    }

    protected static class JoinTransactionProp
    extends Prop {
        JoinTransactionProp() {
            super("eclipselink.transaction.join-existing", "false");
            this.valueArray = new Object[]{"true", "false"};
        }
    }

    protected static class FlushClearCacheProp
    extends Prop {
        FlushClearCacheProp() {
            super("eclipselink.flush-clear.cache", "DropInvalidate");
            this.valueArray = new Object[]{"Merge", "Drop", "DropInvalidate"};
        }
    }

    protected static class BatchWritingProp
    extends Prop {
        BatchWritingProp() {
            super("eclipselink.jdbc.batch-writing", "None");
            this.valueArray = new Object[]{"None", "JDBC", "Buffered", "Oracle-JDBC"};
        }
    }

    protected static class DescriptorCustomizerProp
    extends Prop {
        DescriptorCustomizerProp() {
            super("eclipselink.descriptor.customizer.");
        }
    }

    protected static class CacheSharedProp
    extends Prop {
        CacheSharedProp() {
            super("eclipselink.cache.shared.", "false");
            this.valueArray = new Object[]{"true", "false"};
        }
    }

    protected static class CacheTypeProp
    extends Prop {
        CacheTypeProp() {
            super("eclipselink.cache.type.", "SoftWeak");
            String pcg = "org.eclipse.persistence.internal.identitymaps.";
            this.valueArray = new Object[][]{{"Weak", pcg + "WeakIdentityMap"}, {"Soft", pcg + "SoftIdentityMap"}, {"SoftWeak", pcg + "SoftCacheWeakIdentityMap"}, {"HardWeak", pcg + "HardCacheWeakIdentityMap"}, {"Full", pcg + "FullIdentityMap"}, {"NONE", pcg + "NoIdentityMap"}};
        }
    }

    protected static class CacheSizeProp
    extends Prop {
        CacheSizeProp() {
            super("eclipselink.cache.size.", Integer.toString(1000));
        }
    }

    protected static class TargetServerProp
    extends Prop {
        TargetServerProp() {
            super("eclipselink.target-server", "None");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.platform.server.";
            this.valueArray = new Object[][]{{"None", pcg + "NoServerPlatform"}, {"OC4J", pcg + "oc4j.Oc4jPlatform"}, {"OC4J_10_1_3", pcg + "oc4j.Oc4j_10_1_3_Platform"}, {"OC4J_11_1_1", pcg + "oc4j.Oc4j_11_1_1_Platform"}, {"SunAS9", pcg + "sunas.SunAS9ServerPlatform"}, {"WebSphere", pcg + "was.WebSpherePlatform"}, {"WebSphere_6_1", pcg + "was.WebSphere_6_1_Platform"}, {"WebLogic", pcg + "wls.WebLogicPlatform"}, {"WebLogic_9", pcg + "wls.WebLogic_9_Platform"}, {"WebLogic_10", pcg + "wls.WebLogic_10_Platform"}, {"JBoss", pcg + "jboss.JBossPlatform"}};
        }
    }

    protected static class TargetDatabaseProp
    extends Prop {
        TargetDatabaseProp() {
            super("eclipselink.target-database", "Auto");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.platform.database.";
            this.valueArray = new Object[][]{{"Auto", pcg + "DatabasePlatform"}, {"Oracle", pcg + "oracle.OraclePlatform"}, {"Oracle8i", pcg + "oracle.Oracle8Platform"}, {"Oracle9i", pcg + "oracle.Oracle9Platform"}, {"Oracle10g", pcg + "oracle.Oracle10Platform"}, {"Oracle11", pcg + "oracle.Oracle11Platform"}, {"Attunity", pcg + "AttunityPlatform"}, {"Cloudscape", pcg + "CloudscapePlatform"}, {"Database", pcg + "DatabasePlatform"}, {"DB2Mainframe", pcg + "DB2MainframePlatform"}, {"DB2", pcg + "DB2Platform"}, {"DBase", pcg + "DBasePlatform"}, {"Derby", pcg + "DerbyPlatform"}, {"HSQL", pcg + "HSQLPlatform"}, {"Informix", pcg + "InformixPlatform"}, {"JavaDB", pcg + "JavaDBPlatform"}, {"MySQL4", pcg + "MySQL4Platform"}, {"PointBase", pcg + "PointBasePlatform"}, {"PostgreSQL", pcg + "PostgreSQLPlatform"}, {"SQLAnyWhere", pcg + "SQLAnyWherePlatform"}, {"SQLServer", pcg + "SQLServerPlatform"}, {"Sybase", pcg + "SybasePlatform"}, {"TimesTen", pcg + "TimesTenPlatform"}};
        }
    }

    protected static class DefaultReferenceModeProp
    extends Prop {
        DefaultReferenceModeProp() {
            super("eclipselink.persistence-context.reference-mode.default", ReferenceMode.WEAK.toString());
            this.valueArray = new Object[]{ReferenceMode.HARD.toString(), ReferenceMode.WEAK.toString(), ReferenceMode.FORCE_WEAK.toString()};
        }
    }

    protected static class ReferenceModeProp
    extends Prop {
        ReferenceModeProp() {
            super("eclipselink.persistence-context.reference-mode", ReferenceMode.WEAK.toString());
            this.valueArray = new Object[]{ReferenceMode.HARD.toString(), ReferenceMode.WEAK.toString(), ReferenceMode.FORCE_WEAK.toString()};
        }
    }

    protected static class CategoryLoggingLevelProp
    extends Prop {
        CategoryLoggingLevelProp() {
            super("eclipselink.logging.level.");
            this.valueArray = new Object[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.OFF.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()};
        }
    }

    protected static class LoggingLevelProp
    extends Prop {
        LoggingLevelProp() {
            super("eclipselink.logging.level", Level.INFO.getName());
            this.valueArray = new Object[]{Level.OFF.getName(), Level.SEVERE.getName(), Level.OFF.getName(), Level.WARNING.getName(), Level.INFO.getName(), Level.CONFIG.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName(), Level.ALL.getName()};
        }
    }

    protected static class LoggerTypeProp
    extends Prop {
        LoggerTypeProp() {
            super("eclipselink.logging.logger", "DefaultLogger");
            this.shouldReturnOriginalValueIfValueToApplyNotFound = true;
            String pcg = "org.eclipse.persistence.logging.";
            this.valueArray = new Object[][]{{"DefaultLogger", pcg + "DefaultSessionLog"}, {"JavaLogger", pcg + "JavaLog"}};
        }
    }

    protected static abstract class Prop {
        static HashMap mainMap = new HashMap();
        Object[] valueArray;
        HashMap valueMap;
        String name;
        String defaultValue;
        String defaultValueToApply;
        boolean valueToApplyMayBeNull;
        boolean shouldReturnOriginalValueIfValueToApplyNotFound;

        Prop(String name) {
            this.name = name;
        }

        Prop(String name, String defaultValue) {
            this(name);
            this.defaultValue = defaultValue;
        }

        static String getPropertyValueFromMap(String name, Map m, boolean useSystemAsDefault) {
            String value = (String)m.get(name);
            return value == null && useSystemAsDefault ? System.getProperty(name) : value;
        }

        static Map getPrefixValuesFromMap(String name, Map m, boolean useSystemAsDefault) {
            String entityName;
            String str;
            HashMap mapOut = new HashMap();
            if (useSystemAsDefault) {
                Iterator it = (Iterator)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperties().entrySet().iterator();
                    }
                });
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    str = (String)entry.getKey();
                    if (!str.startsWith(name)) continue;
                    entityName = str.substring(name.length(), str.length());
                    mapOut.put(entityName, entry.getValue());
                }
            }
            for (Map.Entry entry : m.entrySet()) {
                str = (String)entry.getKey();
                if (!str.startsWith(name)) continue;
                entityName = str.substring(name.length(), str.length());
                mapOut.put(entityName, entry.getValue());
            }
            return mapOut;
        }

        static String getPropertyValue(String name, boolean shouldUseDefault, Map m, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                return null;
            }
            String value = Prop.getPropertyValueFromMap(name, m, useSystemAsDefault);
            if (value == null) {
                return null;
            }
            return prop.getValueToApply(value, shouldUseDefault, session);
        }

        static String getPropertyValueToApply(String name, Map m, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                return null;
            }
            String value = Prop.getPropertyValueFromMap(name, m, useSystemAsDefault);
            if (value == null) {
                return null;
            }
            return prop.getValueToApply(value, PropertiesHandler.shouldUseDefault(value), session);
        }

        static Map getPrefixValuesToApply(String prefix, Map m, AbstractSession session, boolean useSystemAsDefault) {
            Prop prop = (Prop)mainMap.get(prefix);
            if (prop == null) {
                return new HashMap(0);
            }
            Map mapIn = Prop.getPrefixValuesFromMap(prefix, m, useSystemAsDefault);
            if (mapIn.isEmpty()) {
                return mapIn;
            }
            HashMap<String, String> mapOut = new HashMap<String, String>(mapIn.size());
            for (Map.Entry entry : mapIn.entrySet()) {
                String suffix = (String)entry.getKey();
                String value = (String)entry.getValue();
                mapOut.put(suffix, prop.getValueToApply(value, PropertiesHandler.shouldUseDefault(value), suffix, session));
            }
            return mapOut;
        }

        static String getDefaultPropertyValueToApply(String name, AbstractSession session) {
            Prop prop = (Prop)mainMap.get(name);
            if (prop == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-default-for-unknown-property", new Object[]{name}));
            }
            prop.logDefault(session);
            return prop.defaultValueToApply;
        }

        String getValueToApply(String value, boolean shouldUseDefault, AbstractSession session) {
            return this.getValueToApply(value, shouldUseDefault, null, session);
        }

        String getValueToApply(String value, boolean shouldUseDefault, String suffix, AbstractSession session) {
            String logValue;
            String key;
            if (shouldUseDefault) {
                this.logDefault(session, suffix);
                return this.defaultValueToApply;
            }
            String valueToApply = value;
            if (this.valueMap != null && (valueToApply = (String)this.valueMap.get(key = Prop.getUpperCaseString(value))) == null) {
                boolean notFound = true;
                if (this.valueToApplyMayBeNull) {
                    boolean bl = notFound = !this.valueMap.containsKey(key);
                }
                if (notFound) {
                    if (this.shouldReturnOriginalValueIfValueToApplyNotFound) {
                        valueToApply = value;
                    } else {
                        String propertyName = this.name;
                        if (suffix != null) {
                            propertyName = propertyName + suffix;
                        }
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-illegal-property-value", new Object[]{propertyName, Prop.getPrintValue(value)}));
                    }
                }
            }
            if ((logValue = PersistenceUnitProperties.getOverriddenLogStringForProperty(this.name)) != null) {
                this.log(session, logValue, logValue, suffix);
            } else {
                this.log(session, value, valueToApply, suffix);
            }
            return valueToApply;
        }

        static String getUpperCaseString(String value) {
            if (value != null) {
                return value.toUpperCase();
            }
            return null;
        }

        static String getPrintValue(String value) {
            if (value != null) {
                return value;
            }
            return "null";
        }

        void initialize() {
            if (this.valueArray != null) {
                this.valueMap = new HashMap(this.valueArray.length);
                if (this.valueArray instanceof Object[][]) {
                    Object[][] valueArray2 = (Object[][])this.valueArray;
                    for (int i = 0; i < valueArray2.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)valueArray2[i][0]), valueArray2[i][1]);
                        if (valueArray2[i][1] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                } else {
                    for (int i = 0; i < this.valueArray.length; ++i) {
                        this.valueMap.put(Prop.getUpperCaseString((String)this.valueArray[i]), this.valueArray[i]);
                        if (this.valueArray[i] != null) continue;
                        this.valueToApplyMayBeNull = true;
                    }
                }
                this.defaultValueToApply = (String)this.valueMap.get(Prop.getUpperCaseString(this.defaultValue));
            } else {
                this.defaultValueToApply = this.defaultValue;
            }
        }

        void logDefault(AbstractSession session) {
            this.logDefault(session, null);
        }

        void logDefault(AbstractSession session, String suffix) {
            if (session != null) {
                String propertyName = this.name;
                if (suffix != null) {
                    propertyName = propertyName + suffix;
                }
                if (this.defaultValue != this.defaultValueToApply) {
                    session.log(1, "properties", "handler_property_value_default", new Object[]{propertyName, this.defaultValue, this.defaultValueToApply});
                } else {
                    session.log(1, "properties", "property_value_default", new Object[]{propertyName, this.defaultValue});
                }
            }
        }

        void log(AbstractSession session, String value, String valueToApply, String suffix) {
            if (session != null) {
                String propertyName = this.name;
                if (suffix != null) {
                    propertyName = propertyName + suffix;
                }
                if (value != valueToApply) {
                    session.log(1, "properties", "handler_property_value_specified", new Object[]{propertyName, value, valueToApply});
                } else {
                    session.log(1, "properties", "property_value_specified", new Object[]{propertyName, value});
                }
            }
        }

        static void addProp(Prop prop) {
            prop.initialize();
            mainMap.put(prop.name, prop);
        }

        static {
            Prop.addProp(new LoggerTypeProp());
            Prop.addProp(new LoggingLevelProp());
            Prop.addProp(new CategoryLoggingLevelProp());
            Prop.addProp(new TargetDatabaseProp());
            Prop.addProp(new TargetServerProp());
            Prop.addProp(new CacheSizeProp());
            Prop.addProp(new CacheTypeProp());
            Prop.addProp(new CacheSharedProp());
            Prop.addProp(new DescriptorCustomizerProp());
            Prop.addProp(new BatchWritingProp());
            Prop.addProp(new FlushClearCacheProp());
        }
    }
}

