/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.expressions.SpatialExpressionOperators;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPHelper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTypes;
import org.eclipse.persistence.internal.platform.database.oracle.XMLTypeFactory;
import org.eclipse.persistence.internal.platform.database.oracle.XMLTypePlaceholder;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.NCharacter;
import org.eclipse.persistence.platform.database.oracle.NClob;
import org.eclipse.persistence.platform.database.oracle.NString;
import org.eclipse.persistence.platform.database.oracle.Oracle8Platform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.w3c.dom.Document;

public class Oracle9Platform
extends Oracle8Platform {
    public static final Class NCHAR = NCharacter.class;
    public static final Class NSTRING = NString.class;
    public static final Class NCLOB = NClob.class;
    public static final Class XMLTYPE = XMLTypePlaceholder.class;
    private XMLTypeFactory xmlTypeFactory;

    public Object getObjectFromResultSet(ResultSet resultSet, int columnNumber, int type, AbstractSession session) throws SQLException {
        if (type == 93 || type == 91) {
            return resultSet.getTimestamp(columnNumber);
        }
        if (type == -101) {
            TIMESTAMPTZ tsTZ = (TIMESTAMPTZ)resultSet.getObject(columnNumber);
            if (tsTZ != null && tsTZ.getLength() != 0L) {
                tsTZ.timestampValue(this.getConnection(session, resultSet.getStatement().getConnection()));
                return new TIMESTAMPTZWrapper(tsTZ);
            }
            return null;
        }
        if (type == -102) {
            TIMESTAMPLTZ tsLTZ = (TIMESTAMPLTZ)resultSet.getObject(columnNumber);
            if (tsLTZ != null && tsLTZ.getLength() != 0L) {
                Timestamp ts = TIMESTAMPLTZ.toTimestamp((Connection)this.getConnection(session, resultSet.getStatement().getConnection()), (byte[])tsLTZ.toBytes());
                return new TIMESTAMPLTZWrapper(ts, ((oracle.jdbc.OracleConnection)this.getConnection(session, resultSet.getStatement().getConnection())).getSessionTimeZone());
            }
            return null;
        }
        if (type == 2007) {
            try {
                Object result = resultSet.getObject(columnNumber);
                if (!(result instanceof OPAQUE)) {
                    return result;
                }
                return this.getXMLTypeFactory().getDOM((OPAQUE)result);
            }
            catch (SQLException ex) {
                throw DatabaseException.sqlException((SQLException)ex, null, (AbstractSession)session);
            }
        }
        return super.getObjectFromResultSet(resultSet, columnNumber, type, session);
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        Class type = field.getType();
        if (type != null && this.isOracle9Specific(type)) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(field);
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.extract());
        this.addOperator(ExpressionOperator.extractValue());
        this.addOperator(ExpressionOperator.existsNode());
        this.addOperator(ExpressionOperator.isFragment());
        this.addOperator(ExpressionOperator.getStringVal());
        this.addOperator(ExpressionOperator.getNumberVal());
        this.addOperator(SpatialExpressionOperators.withinDistance());
        this.addOperator(SpatialExpressionOperators.relate());
        this.addOperator(SpatialExpressionOperators.filter());
        this.addOperator(SpatialExpressionOperators.nearestNeighbor());
    }

    protected Hashtable buildFieldTypes() {
        Hashtable fieldTypes = super.buildFieldTypes();
        fieldTypes.put(Document.class, new FieldTypeDefinition("sys.XMLType"));
        fieldTypes.put(Time.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypes.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypes.put(TIMESTAMP.class, new FieldTypeDefinition("TIMESTAMP", false));
        fieldTypes.put(TIMESTAMPTZ.class, new FieldTypeDefinition("TIMESTAMP WITH TIME ZONE", false));
        fieldTypes.put(TIMESTAMPLTZ.class, new FieldTypeDefinition("TIMESTAMP WITH LOCAL TIME ZONE", false));
        return fieldTypes;
    }

    protected Hashtable buildClassTypes() {
        Hashtable classTypeMapping = super.buildClassTypes();
        classTypeMapping.put("TIMESTAMP", TIMESTAMP.class);
        classTypeMapping.put("TIMESTAMP WITH TIME ZONE", TIMESTAMPTZ.class);
        classTypeMapping.put("TIMESTAMP WITH LOCAL TIME ZONE", TIMESTAMPLTZ.class);
        return classTypeMapping;
    }

    public Object convertObject(Object sourceObject, Class javaClass) throws ConversionException, DatabaseException {
        if (javaClass == null || sourceObject != null && sourceObject.getClass() == javaClass) {
            return sourceObject;
        }
        Object valueToConvert = sourceObject;
        if (javaClass == TIMESTAMPTypes.TIMESTAMP_CLASS || javaClass == TIMESTAMPTypes.TIMESTAMPTZ_CLASS || javaClass == TIMESTAMPTypes.TIMESTAMPLTZ_CLASS) {
            return sourceObject;
        }
        if (javaClass == XMLTYPE) {
            return sourceObject;
        }
        if (sourceObject instanceof TIMESTAMP) {
            try {
                valueToConvert = ((TIMESTAMP)sourceObject).timestampValue();
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException((SQLException)exception);
            }
        } else if (sourceObject instanceof TIMESTAMPTZWrapper) {
            if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
                try {
                    return TIMESTAMPHelper.buildCalendar((TIMESTAMPTZWrapper)sourceObject);
                }
                catch (SQLException exception) {
                    throw DatabaseException.sqlException((SQLException)exception);
                }
            }
            valueToConvert = ((TIMESTAMPTZWrapper)sourceObject).getTimestamp();
        } else if (sourceObject instanceof TIMESTAMPLTZWrapper) {
            if (javaClass == ClassConstants.CALENDAR || javaClass == ClassConstants.GREGORIAN_CALENDAR) {
                try {
                    return TIMESTAMPHelper.buildCalendar((TIMESTAMPLTZWrapper)sourceObject);
                }
                catch (SQLException exception) {
                    throw DatabaseException.sqlException((SQLException)exception);
                }
            }
            valueToConvert = ((TIMESTAMPLTZWrapper)sourceObject).getTimestamp();
        }
        return super.convertObject(valueToConvert, javaClass);
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp('");
            writer.write(Helper.printTimestamp((Timestamp)timestamp));
            writer.write("','yyyy-mm-dd HH24:MI:SS.FF')");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("to_timestamp_tz('");
            writer.write(TIMESTAMPHelper.printCalendar(calendar));
            writer.write("','yyyy-mm-dd HH24:MI:SS.FF TZR')");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    public Connection getConnection(AbstractSession session, Connection connection) {
        if (session.getServerPlatform() != null && session.getLogin().shouldUseExternalConnectionPooling()) {
            return session.getServerPlatform().unwrapConnection(connection);
        }
        return connection;
    }

    public void setParameterValueInDatabaseCall(Object parameter, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
        if (parameter instanceof Calendar) {
            Calendar calendar = (Calendar)parameter;
            TIMESTAMPTZ tsTZ = TIMESTAMPHelper.buildTIMESTAMPTZ(calendar, this.getConnection(session, statement.getConnection()));
            statement.setObject(index, tsTZ);
        } else {
            super.setParameterValueInDatabaseCall(parameter, statement, index, session);
        }
    }

    public Timestamp getTimestampFromServer(AbstractSession session, String sessionName) {
        if (this.getTimestampQuery() != null) {
            this.getTimestampQuery().setSessionName(sessionName);
            Object ob = session.executeQuery((DatabaseQuery)this.getTimestampQuery());
            return ((TIMESTAMPTZWrapper)ob).getTimestamp();
        }
        return super.getTimestampFromServer(session, sessionName);
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSTIMESTAMP FROM DUAL");
        }
        return this.timestampQuery;
    }

    public String serverTimestampString() {
        return "SYSTIMESTAMP";
    }

    protected Vector buildToTIMESTAMPVec() {
        Vector<Class<Time>> vec = new Vector<Class<Time>>();
        vec.addElement(java.util.Date.class);
        vec.addElement(Timestamp.class);
        vec.addElement(Calendar.class);
        vec.addElement(String.class);
        vec.addElement(Long.class);
        vec.addElement(Date.class);
        vec.addElement(Time.class);
        return vec;
    }

    protected Vector buildToNStringCharVec() {
        Vector<Class> vec = new Vector<Class>();
        vec.addElement(String.class);
        vec.addElement(Character.class);
        return vec;
    }

    protected Vector buildToNClobVec() {
        Vector<Class<char[]>> vec = new Vector<Class<char[]>>();
        vec.addElement(String.class);
        vec.addElement(Character[].class);
        vec.addElement(char[].class);
        return vec;
    }

    public void setShouldUseLocatorForLOBWrite(boolean usesLocatorForLOBWrite) {
        this.usesLocatorForLOBWrite = usesLocatorForLOBWrite;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int lobValueLimits) {
        this.lobValueLimits = lobValueLimits;
    }

    protected boolean isOracle9Specific(Class type) {
        return type == NCHAR || type == NSTRING || type == NCLOB || type == XMLTYPE;
    }

    protected boolean isClob(Class type) {
        return NCLOB.equals(type) || super.isClob(type);
    }

    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        Class type = field.getType();
        if (type != null && this.isOracle9Specific(type)) {
            if (value == null) {
                return null;
            }
            if (NCHAR.equals(type) || NSTRING.equals(type)) {
                return new NTypeBindCallCustomParameter(value);
            }
            if (NCLOB.equals(type)) {
                value = this.convertToDatabaseType(value);
                if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(value)) {
                    ((DatabaseCall)call).addContext(field, value);
                    value = new String(" ");
                }
                return new NTypeBindCallCustomParameter(value);
            }
            if (XMLTYPE.equals(type)) {
                return this.getXMLTypeFactory().createXMLTypeBindCallCustomParameter(value);
            }
        }
        return super.getCustomModifyValueForCall(call, value, field, shouldBind);
    }

    protected Vector buildFromStringCharVec(Class javaClass) {
        Vector vec = this.getConversionManager().getDataTypesConvertedFrom(javaClass);
        vec.addElement(NCHAR);
        vec.addElement(NSTRING);
        if (javaClass == String.class) {
            vec.addElement(NCLOB);
        }
        return vec;
    }

    public Vector getDataTypesConvertedFrom(Class javaClass) {
        Vector dataTypes;
        if (this.dataTypesConvertedFromAClass == null) {
            this.dataTypesConvertedFromAClass = new Hashtable(5);
        }
        if ((dataTypes = (Vector)this.dataTypesConvertedFromAClass.get(javaClass)) != null) {
            return dataTypes;
        }
        dataTypes = super.getDataTypesConvertedFrom(javaClass);
        if (javaClass == String.class || javaClass == Character.class) {
            dataTypes.addElement(NCHAR);
            dataTypes.addElement(NSTRING);
            if (javaClass == String.class) {
                dataTypes.addElement(NCLOB);
            }
        }
        if (javaClass == char[].class || javaClass == Character[].class) {
            dataTypes.addElement(NCLOB);
        }
        this.dataTypesConvertedFromAClass.put(javaClass, dataTypes);
        return dataTypes;
    }

    public Vector getDataTypesConvertedTo(Class javaClass) {
        Vector dataTypes;
        if (this.dataTypesConvertedToAClass == null) {
            this.dataTypesConvertedToAClass = new Hashtable(5);
        }
        if ((dataTypes = (Vector)this.dataTypesConvertedToAClass.get(javaClass)) != null) {
            return dataTypes;
        }
        dataTypes = javaClass == NCHAR || javaClass == NSTRING ? this.buildToNStringCharVec() : (javaClass == NCLOB ? this.buildToNClobVec() : super.getDataTypesConvertedTo(javaClass));
        this.dataTypesConvertedToAClass.put(javaClass, dataTypes);
        return dataTypes;
    }

    public int getJDBCType(DatabaseField field) {
        int type = super.getJDBCType(field);
        if (type == 2007) {
            return 12;
        }
        return type;
    }

    public int getJDBCType(Class javaType) {
        if (javaType == XMLTYPE) {
            return 12;
        }
        return super.getJDBCType(javaType);
    }

    public int executeBatch(Statement statement, boolean isStatementPrepared) throws SQLException {
        if (this.usesNativeBatchWriting() && isStatementPrepared) {
            return ((OraclePreparedStatement)statement).sendBatch();
        }
        return super.executeBatch(statement, isStatementPrepared);
    }

    public int addBatch(PreparedStatement statement) throws SQLException {
        if (this.usesNativeBatchWriting()) {
            return statement.executeUpdate();
        }
        return super.addBatch(statement);
    }

    public Statement prepareBatchStatement(Statement statement) throws SQLException {
        if (this.usesNativeBatchWriting()) {
            ((OraclePreparedStatement)statement).setExecuteBatch(this.getMaxBatchWritingSize());
        }
        return statement;
    }

    protected XMLTypeFactory getXMLTypeFactory() {
        if (this.xmlTypeFactory == null) {
            String className = "org.eclipse.persistence.internal.platform.database.oracle.xdb.XMLTypeFactoryImpl";
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    Class xmlTypeFactoryClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, ((Object)((Object)this)).getClass().getClassLoader()));
                    Constructor xmlTypeFactoryConstructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(xmlTypeFactoryClass, new Class[0], true));
                    this.xmlTypeFactory = (XMLTypeFactory)AccessController.doPrivileged(new PrivilegedInvokeConstructor(xmlTypeFactoryConstructor, new Object[0]));
                } else {
                    Class xmlTypeFactoryClass = PrivilegedAccessHelper.getClassForName((String)className, (boolean)true, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    Constructor xmlTypeFactoryConstructor = PrivilegedAccessHelper.getConstructorFor((Class)xmlTypeFactoryClass, (Class[])new Class[0], (boolean)true);
                    this.xmlTypeFactory = (XMLTypeFactory)PrivilegedAccessHelper.invokeConstructor((Constructor)xmlTypeFactoryConstructor, (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                throw QueryException.reflectiveCallOnTopLinkClassFailed((String)className, (Exception)e);
            }
        }
        return this.xmlTypeFactory;
    }

    public boolean isXDBDocument(Object obj) {
        return this.getXMLTypeFactory().isXDBDocument(obj);
    }

    public boolean canUnwrapOracleConnection() {
        return true;
    }

    public Connection unwrapOracleConnection(Connection connection) {
        if (connection instanceof OracleConnection) {
            return ((OracleConnection)connection).getPhysicalConnection();
        }
        return super.unwrapOracleConnection(connection);
    }

    protected static class NTypeBindCallCustomParameter
    extends BindCallCustomParameter {
        public NTypeBindCallCustomParameter(Object obj) {
            super(obj);
        }

        public boolean shouldUseUnwrappedConnection() {
            return true;
        }

        public void set(DatabasePlatform platform, PreparedStatement statement, int index, AbstractSession session) throws SQLException {
            ((OraclePreparedStatement)statement).setFormOfUse(index, (short)2);
            super.set(platform, statement, index, session);
        }
    }
}

