/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import javax.persistence.OneToOne;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class OneToOneAccessor
extends ObjectAccessor {
    public OneToOneAccessor() {
    }

    public OneToOneAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object oneToOne = this.getAnnotation(OneToOne.class);
        if (oneToOne != null) {
            this.setTargetEntity((Class)MetadataHelper.invokeMethod("targetEntity", oneToOne));
            this.setCascadeTypes((Enum[])MetadataHelper.invokeMethod("cascade", oneToOne));
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", oneToOne));
            this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", oneToOne));
            this.setMappedBy((String)MetadataHelper.invokeMethod("mappedBy", oneToOne));
        } else {
            this.setTargetEntity(Void.TYPE);
            this.setCascadeTypes(new Enum[0]);
            this.setFetch(this.getDefaultFetchType());
            this.setOptional(true);
            this.setMappedBy("");
        }
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_one_reference_class";
    }

    public boolean isOneToOne() {
        return true;
    }

    public void process() {
        OneToOneMapping mapping = this.initOneToOneMapping();
        if (this.getMappedBy().equals("")) {
            this.processOwningMappingKeys(mapping);
        } else {
            OneToOneMapping ownerMapping = null;
            if (!this.getOwningMapping().isOneToOneMapping()) {
                throw ValidationException.invalidMapping((Class)this.getJavaClass(), (Class)this.getReferenceClass());
            }
            ownerMapping = (OneToOneMapping)this.getOwningMapping();
            mapping.setSourceToTargetKeyFields(ownerMapping.getTargetToSourceKeyFields());
            mapping.setTargetToSourceKeyFields(ownerMapping.getSourceToTargetKeyFields());
        }
        this.processProperties((DatabaseMapping)mapping);
        this.getDescriptor().addMapping((DatabaseMapping)mapping);
    }
}

