/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.IdClass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.annotations.Cache;
import org.eclipse.persistence.annotations.NamedStoredProcedureQueries;
import org.eclipse.persistence.annotations.NamedStoredProcedureQuery;
import org.eclipse.persistence.annotations.OptimisticLocking;
import org.eclipse.persistence.annotations.ReadOnly;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.cache.CacheMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.locking.OptimisticLockingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedSuperclassAccessor
extends ClassAccessor {
    private boolean m_excludeDefaultListeners;
    private boolean m_excludeSuperclassListeners;
    private Boolean m_readOnly;
    private CacheMetadata m_cache;
    private List<EntityListenerMetadata> m_entityListeners;
    private OptimisticLockingMetadata m_optimisticLocking;
    private String m_idClassName;
    private String m_prePersist;
    private String m_postPersist;
    private String m_preRemove;
    private String m_postRemove;
    private String m_preUpdate;
    private String m_postUpdate;
    private String m_postLoad;

    public MappedSuperclassAccessor() {
    }

    protected MappedSuperclassAccessor(Class cls, MetadataProject project) {
        super(cls, project);
    }

    public MappedSuperclassAccessor(Class cls, MetadataDescriptor descriptor, MetadataProject project) {
        super(cls, descriptor, project);
    }

    public boolean excludeDefaultListeners() {
        return this.m_excludeDefaultListeners;
    }

    public boolean excludeSuperclassListeners() {
        return this.m_excludeSuperclassListeners;
    }

    public CacheMetadata getCache() {
        return this.m_cache;
    }

    public List<EntityListenerMetadata> getEntityListeners() {
        return this.m_entityListeners;
    }

    public String getExcludeDefaultListeners() {
        return null;
    }

    public String getExcludeSuperclassListeners() {
        return null;
    }

    public String getIdClassName() {
        return this.m_idClassName;
    }

    public OptimisticLockingMetadata getOptimisticLocking() {
        return this.m_optimisticLocking;
    }

    public String getPostLoad() {
        return this.m_postLoad;
    }

    public String getPostPersist() {
        return this.m_postPersist;
    }

    public String getPostRemove() {
        return this.m_postRemove;
    }

    public String getPostUpdate() {
        return this.m_postUpdate;
    }

    public String getPrePersist() {
        return this.m_prePersist;
    }

    public String getPreRemove() {
        return this.m_preRemove;
    }

    public String getPreUpdate() {
        return this.m_preUpdate;
    }

    public Boolean getReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void process() {
        this.processClassMetadata();
        this.processAccessors();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride) {
        if (this.getDescriptor().hasAssociationOverrideFor(associationOverride.getName())) {
            AssociationOverrideMetadata otherAssociationOverride = this.getDescriptor().getAssociationOverrideFor(associationOverride.getName());
            if (otherAssociationOverride.getJavaClassName().equals(associationOverride.getJavaClassName())) {
                if (!otherAssociationOverride.loadedFromXML()) throw ValidationException.multipleAssociationOverrideWithSameNameFound((String)associationOverride.getName(), (String)associationOverride.getJavaClassName(), (String)associationOverride.getLocation());
                if (associationOverride.loadedFromXML()) {
                    throw ValidationException.multipleAssociationOverrideWithSameNameFound((String)associationOverride.getName(), (String)associationOverride.getJavaClassName(), (String)associationOverride.getLocation());
                }
                this.getLogger().logWarningMessage("annotation_warning_ignore_association_override", associationOverride.getName(), associationOverride.getJavaClassName(), associationOverride.getLocation());
                return;
            } else {
                this.getLogger().logWarningMessage("annotation_warning_ignore_association_override_on_mapped_superclass", associationOverride.getName(), associationOverride.getJavaClassName(), this.getDescriptor().getJavaClassName());
            }
            return;
        } else {
            this.getDescriptor().addAssociationOverride(associationOverride);
        }
    }

    protected void processAssociationOverrides() {
        Object associationOverride;
        Object associationOverrides = this.getAnnotation(AssociationOverrides.class);
        if (associationOverrides != null) {
            for (Annotation associationOverride2 : (Annotation[])MetadataHelper.invokeMethod("value", associationOverrides)) {
                this.processAssociationOverride(new AssociationOverrideMetadata(associationOverride2, this.getJavaClassName()));
            }
        }
        if ((associationOverride = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(new AssociationOverrideMetadata((Annotation)associationOverride, this.getJavaClassName()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAttributeOverride(AttributeOverrideMetadata attributeOverride) {
        if (this.getDescriptor().hasAttributeOverrideFor(attributeOverride.getName())) {
            AttributeOverrideMetadata otherAttributeOverride = this.getDescriptor().getAttributeOverrideFor(attributeOverride.getName());
            if (otherAttributeOverride.getJavaClassName().equals(attributeOverride.getJavaClassName())) {
                if (!otherAttributeOverride.loadedFromXML()) throw ValidationException.multipleAttributeOverrideWithSameNameFound((String)attributeOverride.getName(), (String)attributeOverride.getJavaClassName(), (String)attributeOverride.getLocation());
                if (attributeOverride.loadedFromXML()) {
                    throw ValidationException.multipleAttributeOverrideWithSameNameFound((String)attributeOverride.getName(), (String)attributeOverride.getJavaClassName(), (String)attributeOverride.getLocation());
                }
                this.getLogger().logWarningMessage("annotation_warning_ignore_attribute_override", attributeOverride.getName(), attributeOverride.getJavaClassName(), attributeOverride.getLocation());
                return;
            } else {
                this.getLogger().logWarningMessage("annotation_warning_ignore_attribute_override_on_mapped_superclass", attributeOverride.getName(), attributeOverride.getJavaClassName(), this.getDescriptor().getJavaClassName());
            }
            return;
        } else {
            this.getDescriptor().addAttributeOverride(attributeOverride);
        }
    }

    protected void processAttributeOverrides() {
        Object attributeOverride;
        Object attributeOverrides = this.getAnnotation(AttributeOverrides.class);
        if (attributeOverrides != null) {
            for (Annotation attributeOverride2 : (Annotation[])MetadataHelper.invokeMethod("value", attributeOverrides)) {
                this.processAttributeOverride(new AttributeOverrideMetadata(attributeOverride2, this.getJavaClassName()));
            }
        }
        if ((attributeOverride = this.getAnnotation(AttributeOverride.class)) != null) {
            this.processAttributeOverride(new AttributeOverrideMetadata((Annotation)attributeOverride, this.getJavaClassName()));
        }
    }

    protected void processCache() {
        if (this.m_cache != null || this.isAnnotationPresent(Cache.class)) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_subclass_cache", this.getJavaClass());
            } else if (this.getDescriptor().hasCache()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_cache", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_cache == null) {
                new CacheMetadata((Annotation)this.getAnnotation(Cache.class)).process(this.getDescriptor(), this.getJavaClass());
            } else {
                this.m_cache.process(this.getDescriptor(), this.getJavaClass());
            }
        }
    }

    protected Method processCallbackMethodName(EntityListenerMetadata listener, String methodName, Method[] methods) {
        Method method = MetadataHelper.getMethodForName(methods, methodName);
        if (method == null) {
            throw ValidationException.invalidCallbackMethod((Class)listener.getListenerClass(), (String)methodName);
        }
        return method;
    }

    protected void processCallbackMethodNames(Method[] methods, EntityListenerMetadata listener) {
        if (listener.getPrePersist() != null) {
            this.setPrePersist(this.processCallbackMethodName(listener, listener.getPrePersist(), methods), listener);
        }
        if (listener.getPostPersist() != null) {
            this.setPostPersist(this.processCallbackMethodName(listener, listener.getPostPersist(), methods), listener);
        }
        if (listener.getPreRemove() != null) {
            this.setPreRemove(this.processCallbackMethodName(listener, listener.getPreRemove(), methods), listener);
        }
        if (listener.getPostRemove() != null) {
            this.setPostRemove(this.processCallbackMethodName(listener, listener.getPostRemove(), methods), listener);
        }
        if (listener.getPreUpdate() != null) {
            this.setPreUpdate(this.processCallbackMethodName(listener, listener.getPreUpdate(), methods), listener);
        }
        if (listener.getPostUpdate() != null) {
            this.setPostUpdate(this.processCallbackMethodName(listener, listener.getPostUpdate(), methods), listener);
        }
        if (listener.getPostLoad() != null) {
            this.setPostLoad(this.processCallbackMethodName(listener, listener.getPostLoad(), methods), listener);
        }
    }

    protected void processCallbackMethods(Method[] candidateMethods, EntityListenerMetadata listener) {
        for (Method method : candidateMethods) {
            if (this.isAnnotationPresent(PostLoad.class, method)) {
                this.setPostLoad(method, listener);
            }
            if (this.isAnnotationPresent(PostPersist.class, method)) {
                this.setPostPersist(method, listener);
            }
            if (this.isAnnotationPresent(PostRemove.class, method)) {
                this.setPostRemove(method, listener);
            }
            if (this.isAnnotationPresent(PostUpdate.class, method)) {
                this.setPostUpdate(method, listener);
            }
            if (this.isAnnotationPresent(PrePersist.class, method)) {
                this.setPrePersist(method, listener);
            }
            if (this.isAnnotationPresent(PreRemove.class, method)) {
                this.setPreRemove(method, listener);
            }
            if (!this.isAnnotationPresent(PreUpdate.class, method)) continue;
            this.setPreUpdate(method, listener);
        }
    }

    protected void processClassMetadata() {
        this.processAttributeOverrides();
        this.processAssociationOverrides();
        this.processNamedQueries();
        this.processNamedNativeQueries();
        this.processNamedStoredProcedureQueries();
        this.processSqlResultSetMappings();
        this.processTableGenerator();
        this.processSequenceGenerator();
        this.processIdClass();
        this.processExcludeDefaultListeners();
        this.processExcludeSuperclassListeners();
        this.processConverters();
        this.processOptimisticLocking();
        this.processCache();
        this.processChangeTracking();
        this.processReadOnly();
        this.processCustomizer();
    }

    public void processEntityListeners(Class entityClass) {
        block3: {
            block2: {
                if (this.m_entityListeners != null && !this.m_entityListeners.isEmpty()) break block2;
                Object entityListeners = this.getAnnotation(EntityListeners.class);
                if (entityListeners == null) break block3;
                for (Class entityListener : (Class[])MetadataHelper.invokeMethod("value", entityListeners)) {
                    EntityListenerMetadata listener = new EntityListenerMetadata(entityListener, entityClass);
                    this.processCallbackMethods(MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener), listener);
                    this.getDescriptor().addEntityListenerEventListener(listener);
                }
                break block3;
            }
            for (EntityListenerMetadata listener : this.m_entityListeners) {
                listener.setEntityClass(entityClass);
                listener.initializeListenerClass(this.getEntityMappings().getClassForName(listener.getClassName()));
                Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener);
                this.processCallbackMethodNames(candidateMethods, listener);
                this.processCallbackMethods(candidateMethods, listener);
                this.getDescriptor().addEntityListenerEventListener(listener);
            }
        }
    }

    protected void processExcludeDefaultListeners() {
        if (this.excludeDefaultListeners()) {
            this.getDescriptor().setExcludeDefaultListeners(true);
        } else if (this.isAnnotationPresent(ExcludeDefaultListeners.class)) {
            this.getDescriptor().setExcludeDefaultListeners(true);
        }
    }

    protected void processExcludeSuperclassListeners() {
        if (this.excludeSuperclassListeners()) {
            this.getDescriptor().setExcludeSuperclassListeners(true);
        } else if (this.isAnnotationPresent(ExcludeSuperclassListeners.class)) {
            this.getDescriptor().setExcludeSuperclassListeners(true);
        }
    }

    protected void processIdClass() {
        Class pkClass;
        if (this.m_idClassName == null) {
            Object idClass = this.getAnnotation(IdClass.class);
            if (idClass == null) {
                return;
            }
            pkClass = (Class)MetadataHelper.invokeMethod("value", idClass);
        } else {
            if (this.isAnnotationPresent(IdClass.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_id_class", this.getDescriptor());
            }
            pkClass = this.getEntityMappings().getClassForName(this.m_idClassName);
        }
        this.getDescriptor().setPKClass(pkClass);
        if (this.getDescriptor().usesPropertyAccess()) {
            for (AccessibleObject accessibleObject : MetadataHelper.getDeclaredMethods(pkClass)) {
                MetadataMethod metadataMethod;
                if (!this.isValidPersistenceElement(accessibleObject, ((Method)accessibleObject).getModifiers()) || !(metadataMethod = new MetadataMethod((Method)accessibleObject)).isValidPersistenceMethodName()) continue;
                this.getDescriptor().addPKClassId(metadataMethod.getAttributeName(), metadataMethod.getRelationType());
            }
        } else {
            for (AccessibleObject accessibleObject : MetadataHelper.getFields(pkClass)) {
                if (!this.isValidPersistenceElement(accessibleObject, ((Field)accessibleObject).getModifiers())) continue;
                this.getDescriptor().addPKClassId(((Field)accessibleObject).getName(), ((Field)accessibleObject).getGenericType());
            }
        }
    }

    public void processEntityEventListener(EntityListenerMetadata listener, Class entityClass, ClassLoader classLoader) {
        Method[] candidateMethods = MetadataHelper.getCandidateCallbackMethodsForMappedSuperclass(this.getJavaClass(), entityClass);
        this.processCallbackMethodNames(candidateMethods, listener);
        this.processCallbackMethods(candidateMethods, listener);
    }

    protected void processNamedNativeQueries() {
        Object namedNativeQuery;
        Object namedNativeQueries = this.getAnnotation(NamedNativeQueries.class);
        if (namedNativeQueries != null) {
            for (Annotation namedNativeQuery2 : (Annotation[])MetadataHelper.invokeMethod("value", namedNativeQueries)) {
                this.getProject().addNamedNativeQuery(new NamedNativeQueryMetadata(namedNativeQuery2, this.getJavaClassName()));
            }
        }
        if ((namedNativeQuery = this.getAnnotation(NamedNativeQuery.class)) != null) {
            this.getProject().addNamedNativeQuery(new NamedNativeQueryMetadata((Annotation)namedNativeQuery, this.getJavaClassName()));
        }
    }

    protected void processNamedQueries() {
        Object namedQuery;
        Object namedQueries = this.getAnnotation(NamedQueries.class);
        if (namedQueries != null) {
            for (Annotation namedQuery2 : (Annotation[])MetadataHelper.invokeMethod("value", namedQueries)) {
                this.getProject().addNamedQuery(new NamedQueryMetadata(namedQuery2, this.getJavaClassName()));
            }
        }
        if ((namedQuery = this.getAnnotation(NamedQuery.class)) != null) {
            this.getProject().addNamedQuery(new NamedQueryMetadata((Annotation)namedQuery, this.getJavaClassName()));
        }
    }

    protected void processNamedStoredProcedureQueries() {
        Object namedStoredProcedureQuery;
        Object namedStoredProcedureQueries = this.getAnnotation(NamedStoredProcedureQueries.class);
        if (namedStoredProcedureQueries != null) {
            for (Annotation namedStoredProcedureQuery2 : (Annotation[])MetadataHelper.invokeMethod("value", namedStoredProcedureQueries)) {
                this.getProject().addNamedStoredProcedureQuery(new NamedStoredProcedureQueryMetadata(namedStoredProcedureQuery2, this.getJavaClassName()));
            }
        }
        if ((namedStoredProcedureQuery = this.getAnnotation(NamedStoredProcedureQuery.class)) != null) {
            this.getProject().addNamedStoredProcedureQuery(new NamedStoredProcedureQueryMetadata((Annotation)namedStoredProcedureQuery, this.getJavaClassName()));
        }
    }

    protected void processOptimisticLocking() {
        if (this.getDescriptor().usesOptimisticLocking()) {
            if (this.m_optimisticLocking != null || this.isAnnotationPresent(OptimisticLocking.class)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_optimistic_locking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            }
        } else if (this.m_optimisticLocking == null) {
            Object optimisticLocking = this.getAnnotation(OptimisticLocking.class);
            if (optimisticLocking != null) {
                new OptimisticLockingMetadata(optimisticLocking).process(this.getDescriptor());
            }
        } else {
            if (this.isAnnotationPresent(OptimisticLocking.class)) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_optimistic_locking", this.getJavaClass(), this.getMappingFile());
            }
            this.m_optimisticLocking.process(this.getDescriptor());
        }
    }

    protected void processReadOnly() {
        if (this.m_readOnly != null || this.isAnnotationPresent(ReadOnly.class)) {
            if (this.getDescriptor().isInheritanceSubclass()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_inheritance_read_only", this.getJavaClass());
            } else if (this.getDescriptor().hasReadOnly()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_read_only", this.getJavaClass());
            } else if (this.m_readOnly == null) {
                this.getDescriptor().setReadOnly(true);
            } else {
                if (this.isAnnotationPresent(ReadOnly.class)) {
                    this.getLogger().logWarningMessage("annotation_warning_ignore_read_only", this.getJavaClass());
                }
                this.getDescriptor().setReadOnly(this.m_readOnly);
            }
        }
    }

    protected void processSequenceGenerator() {
        if (this.isAnnotationPresent(SequenceGenerator.class)) {
            this.getProject().addSequenceGenerator(new SequenceGeneratorMetadata((Annotation)this.getAnnotation(SequenceGenerator.class), this.getJavaClassName()));
        }
    }

    protected void processSqlResultSetMappings() {
        Object sqlResultSetMappings = this.getAnnotation(SqlResultSetMappings.class);
        if (sqlResultSetMappings != null) {
            for (Annotation sqlResultSetMapping : (Annotation[])MetadataHelper.invokeMethod("value", sqlResultSetMappings)) {
                new SQLResultSetMappingMetadata(sqlResultSetMapping).process(this.getProject());
            }
        } else {
            Object sqlResultSetMapping = this.getAnnotation(SqlResultSetMapping.class);
            if (sqlResultSetMapping != null) {
                new SQLResultSetMappingMetadata((Annotation)sqlResultSetMapping).process(this.getProject());
            }
        }
    }

    protected void processTableGenerator() {
        if (this.isAnnotationPresent(TableGenerator.class)) {
            this.getProject().addTableGenerator(new TableGeneratorMetadata((Annotation)this.getAnnotation(TableGenerator.class), this.getJavaClassName()), this.getDescriptor().getXMLCatalog(), this.getDescriptor().getXMLSchema());
        }
    }

    public void setCache(CacheMetadata cache) {
        this.m_cache = cache;
    }

    public void setEntityListeners(List<EntityListenerMetadata> entityListeners) {
        this.m_entityListeners = entityListeners;
    }

    public void setExcludeDefaultListeners(String ignore) {
        this.m_excludeDefaultListeners = true;
    }

    public void setExcludeSuperclassListeners(String ignore) {
        this.m_excludeSuperclassListeners = true;
    }

    public void setIdClassName(String idClassName) {
        this.m_idClassName = idClassName;
    }

    public void setOptimisticLocking(OptimisticLockingMetadata optimisticLocking) {
        this.m_optimisticLocking = optimisticLocking;
    }

    protected void setPostLoad(Method method, EntityListenerMetadata listener) {
        listener.setPostBuildMethod(method);
        listener.setPostCloneMethod(method);
        listener.setPostRefreshMethod(method);
    }

    public void setPostLoad(String postLoad) {
        this.m_postLoad = postLoad;
    }

    protected void setPostPersist(Method method, EntityListenerMetadata listener) {
        listener.setPostInsertMethod(method);
    }

    public void setPostPersist(String postPersist) {
        this.m_postPersist = postPersist;
    }

    protected void setPostRemove(Method method, EntityListenerMetadata listener) {
        listener.setPostDeleteMethod(method);
    }

    public void setPostRemove(String postRemove) {
        this.m_postRemove = postRemove;
    }

    protected void setPostUpdate(Method method, EntityListenerMetadata listener) {
        listener.setPostUpdateMethod(method);
    }

    public void setPostUpdate(String postUpdate) {
        this.m_postUpdate = postUpdate;
    }

    protected void setPrePersist(Method method, EntityListenerMetadata listener) {
        listener.setPrePersistMethod(method);
    }

    public void setPrePersist(String prePersist) {
        this.m_prePersist = prePersist;
    }

    protected void setPreRemove(Method method, EntityListenerMetadata listener) {
        listener.setPreRemoveMethod(method);
    }

    public void setPreRemove(String preRemove) {
        this.m_preRemove = preRemove;
    }

    protected void setPreUpdate(Method method, EntityListenerMetadata listener) {
        listener.setPreUpdateWithChangesMethod(method);
    }

    public void setPreUpdate(String preUpdate) {
        this.m_preUpdate = preUpdate;
    }

    public void setReadOnly(Boolean readOnly) {
        this.m_readOnly = readOnly;
    }
}

