/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.GenerationType;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitDefaults;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProject {
    private static final String DEFAULT_AUTO_GENERATOR = "SEQ_GEN";
    private static final String DEFAULT_TABLE_GENERATOR = "SEQ_GEN_TABLE";
    private static final String DEFAULT_SEQUENCE_GENERATOR = "SEQ_GEN_SEQUENCE";
    private static final String DEFAULT_IDENTITY_GENERATOR = "SEQ_GEN_IDENTITY";
    private PersistenceUnitInfo m_persistenceUnitInfo;
    private List<XMLEntityMappings> m_entityMappings;
    private AbstractSession m_session;
    private MetadataLogger m_logger;
    private boolean m_weavingEnabled;
    private boolean m_weaveEager;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;
    private HashMap<String, MappedSuperclassAccessor> m_mappedSuperclasses;
    private HashMap<String, ClassAccessor> m_allAccessors;
    private HashMap<String, EntityAccessor> m_entityAccessors;
    private HashMap<String, EmbeddableAccessor> m_embeddableAccessors;
    private HashMap<String, InterfaceAccessor> m_interfaceAccessors;
    private HashSet<ClassAccessor> m_accessorsWithRelationships;
    private HashSet<ClassAccessor> m_accessorsWithCustomizer;
    private HashMap<String, NamedQueryMetadata> m_namedQueries;
    private HashMap<String, NamedNativeQueryMetadata> m_namedNativeQueries;
    private HashMap<String, NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private HashMap<Class, GeneratedValueMetadata> m_generatedValues;
    private HashMap<String, TableGeneratorMetadata> m_tableGenerators;
    private HashMap<String, SequenceGeneratorMetadata> m_sequenceGenerators;
    private Set<EntityListenerMetadata> m_defaultListeners;
    private HashMap<String, AbstractConverterMetadata> m_converters;
    private HashSet<DirectAccessor> m_convertAccessors;
    private HashMap<String, StructConverterMetadata> m_structConverters;

    public MetadataProject(PersistenceUnitInfo puInfo, AbstractSession session, boolean weavingEnabled, boolean weaveEager) {
        this.m_persistenceUnitInfo = puInfo;
        this.m_session = session;
        this.m_logger = new MetadataLogger(session);
        this.m_weavingEnabled = weavingEnabled;
        this.m_weaveEager = weaveEager;
        this.m_entityMappings = new ArrayList<XMLEntityMappings>();
        this.m_defaultListeners = new LinkedHashSet<EntityListenerMetadata>();
        this.m_namedQueries = new HashMap();
        this.m_namedNativeQueries = new HashMap();
        this.m_namedStoredProcedureQueries = new HashMap();
        this.m_mappedSuperclasses = new HashMap();
        this.m_allAccessors = new HashMap();
        this.m_entityAccessors = new HashMap();
        this.m_embeddableAccessors = new HashMap();
        this.m_interfaceAccessors = new HashMap();
        this.m_accessorsWithCustomizer = new HashSet();
        this.m_accessorsWithRelationships = new HashSet();
        this.m_generatedValues = new HashMap();
        this.m_tableGenerators = new HashMap();
        this.m_sequenceGenerators = new HashMap();
        this.m_converters = new HashMap();
        this.m_convertAccessors = new HashSet();
        this.m_structConverters = new HashMap();
    }

    protected void addAccessor(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (this.m_persistenceUnitMetadata != null) {
            descriptor.setIgnoreAnnotations(this.m_persistenceUnitMetadata.isXMLMappingMetadataComplete());
            XMLPersistenceUnitDefaults persistenceUnitDefaults = this.m_persistenceUnitMetadata.getPersistenceUnitDefaults();
            if (persistenceUnitDefaults != null) {
                descriptor.setXMLAccess(persistenceUnitDefaults.getAccess());
                descriptor.setXMLSchema(persistenceUnitDefaults.getSchema());
                descriptor.setXMLCatalog(persistenceUnitDefaults.getCatalog());
                descriptor.setIsCascadePersist(persistenceUnitDefaults.isCascadePersist());
            }
        }
        this.getSession().getProject().addDescriptor(descriptor.getClassDescriptor());
        this.m_allAccessors.put(accessor.getJavaClassName(), accessor);
    }

    public void addAccessorWithCustomizer(ClassAccessor accessor) {
        this.m_accessorsWithCustomizer.add(accessor);
    }

    public void addAccessorWithRelationships(ClassAccessor accessor) {
        this.m_accessorsWithRelationships.add(accessor);
    }

    public void addConvertAccessor(DirectAccessor accessor) {
        this.m_convertAccessors.add(accessor);
    }

    public void addConverter(AbstractConverterMetadata converter) {
        StructConverterMetadata existingStructConverter = this.m_structConverters.get(converter.getName());
        if (existingStructConverter != null) {
            throw ValidationException.multipleConvertersOfTheSameName((String)converter.getName(), (String)existingStructConverter.getLocation(), (String)converter.getLocation());
        }
        AbstractConverterMetadata existingConverter = this.m_converters.get(converter.getName());
        if (existingConverter == null || existingConverter.loadedFromAnnotation() && converter.loadedFromXML()) {
            if (existingConverter != null) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_converter", existingConverter.getName(), existingConverter.getLocation(), converter.getLocation());
            }
            this.m_converters.put(converter.getName(), converter);
        } else if (!existingConverter.equals(converter)) {
            throw ValidationException.multipleConvertersOfTheSameName((String)converter.getName(), (String)existingConverter.getLocation(), (String)converter.getLocation());
        }
    }

    public void addDefaultListener(EntityListenerMetadata defaultListener) {
        this.m_defaultListeners.add(defaultListener);
    }

    public void addEmbeddableAccessor(EmbeddableAccessor accessor) {
        this.m_embeddableAccessors.put(accessor.getJavaClassName(), accessor);
        this.addAccessor(accessor);
        accessor.getDescriptor().setIsEmbeddable();
    }

    public void addEntityAccessor(EntityAccessor accessor) {
        this.m_entityAccessors.put(accessor.getJavaClassName(), accessor);
        this.addAccessor(accessor);
    }

    public void addInterfaceAccessor(InterfaceAccessor accessor) {
        this.m_interfaceAccessors.put(accessor.getJavaClassName(), accessor);
        this.getSession().getProject().addDescriptor(accessor.getDescriptor().getClassDescriptor());
    }

    public void addEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings.add(entityMappings);
    }

    public void addGeneratedValue(GeneratedValueMetadata generatedvalue, Class entityClass) {
        this.m_generatedValues.put(entityClass, generatedvalue);
    }

    public void addMappedSuperclass(String className, MappedSuperclassAccessor mappedSuperclass) {
        this.m_mappedSuperclasses.put(className, mappedSuperclass);
    }

    public void addNamedNativeQuery(NamedNativeQueryMetadata namedNativeQuery) {
        NamedNativeQueryMetadata existingNamedNativeQuery = this.m_namedNativeQueries.get(namedNativeQuery.getName());
        if (existingNamedNativeQuery == null || existingNamedNativeQuery.loadedFromAnnotation() && namedNativeQuery.loadedFromXML()) {
            if (existingNamedNativeQuery != null) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_named_native_query", existingNamedNativeQuery.getName(), existingNamedNativeQuery.getLocation(), namedNativeQuery.getLocation());
            }
            this.m_namedNativeQueries.put(namedNativeQuery.getName(), namedNativeQuery);
        } else if (!existingNamedNativeQuery.equals(namedNativeQuery)) {
            throw ValidationException.multipleNamedNativeQueriesWithSameName((String)namedNativeQuery.getName(), (String)namedNativeQuery.getLocation(), (String)existingNamedNativeQuery.getLocation());
        }
    }

    public void addNamedQuery(NamedQueryMetadata namedQuery) {
        NamedQueryMetadata existingNamedQuery = this.m_namedQueries.get(namedQuery.getName());
        if (existingNamedQuery == null || existingNamedQuery.loadedFromAnnotation() && namedQuery.loadedFromXML()) {
            if (existingNamedQuery != null) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_named_query", existingNamedQuery.getName(), existingNamedQuery.getLocation(), namedQuery.getLocation());
            }
            this.m_namedQueries.put(namedQuery.getName(), namedQuery);
        } else if (!existingNamedQuery.equals(namedQuery)) {
            throw ValidationException.multipleNamedQueriesWithSameName((String)namedQuery.getName(), (String)namedQuery.getLocation(), (String)existingNamedQuery.getLocation());
        }
    }

    public void addNamedStoredProcedureQuery(NamedStoredProcedureQueryMetadata namedStoredProcedureQuery) {
        NamedStoredProcedureQueryMetadata existingNamedStoredProcedureQuery = this.m_namedStoredProcedureQueries.get(namedStoredProcedureQuery.getName());
        if (existingNamedStoredProcedureQuery == null || existingNamedStoredProcedureQuery.loadedFromAnnotation() && namedStoredProcedureQuery.loadedFromXML()) {
            if (existingNamedStoredProcedureQuery != null) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_named_stored_procedure_query", existingNamedStoredProcedureQuery.getName(), existingNamedStoredProcedureQuery.getLocation(), namedStoredProcedureQuery.getLocation());
            }
        } else {
            throw ValidationException.multipleNamedStoredProcedureQueriesWithSameName((String)namedStoredProcedureQuery.getName(), (String)namedStoredProcedureQuery.getLocation(), (String)existingNamedStoredProcedureQuery.getLocation());
        }
        this.m_namedStoredProcedureQueries.put(namedStoredProcedureQuery.getName(), namedStoredProcedureQuery);
    }

    public void addSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        TableGeneratorMetadata tableGenerator;
        String name = sequenceGenerator.getName();
        if (name.equals(DEFAULT_TABLE_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_TABLE_GENERATOR, (String)sequenceGenerator.getLocation());
        }
        if (name.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.sequenceGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (String)sequenceGenerator.getLocation());
        }
        SequenceGeneratorMetadata otherSequenceGenerator = this.m_sequenceGenerators.get(name);
        if (otherSequenceGenerator != null) {
            if (sequenceGenerator.loadedFromAnnotations() && otherSequenceGenerator.loadedFromXML()) {
                return;
            }
            if (!otherSequenceGenerator.equals(sequenceGenerator)) {
                throw ValidationException.conflictingSequenceGeneratorsSpecified((String)name, (String)sequenceGenerator.getLocation(), (String)otherSequenceGenerator.getLocation());
            }
        }
        if ((tableGenerator = this.m_tableGenerators.get(name)) != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)name, (String)sequenceGenerator.getLocation(), (String)tableGenerator.getLocation());
        }
        for (TableGeneratorMetadata otherTableGenerator : this.m_tableGenerators.values()) {
            if (!otherTableGenerator.getPkColumnValue().equals(sequenceGenerator.getSequenceName()) || otherTableGenerator.getPkColumnValue().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGenerator.getSequenceName(), (String)sequenceGenerator.getLocation(), (String)otherTableGenerator.getLocation());
        }
        this.m_sequenceGenerators.put(sequenceGenerator.getName(), sequenceGenerator);
    }

    public void addStructConverter(StructConverterMetadata structConverter) {
        AbstractConverterMetadata existingConverter = this.m_converters.get(structConverter.getName());
        if (existingConverter != null) {
            throw ValidationException.multipleConvertersOfTheSameName((String)structConverter.getName(), (String)existingConverter.getLocation(), (String)structConverter.getLocation());
        }
        StructConverterMetadata existingStructConverter = this.m_structConverters.get(structConverter.getName());
        if (existingStructConverter == null || existingStructConverter.loadedFromAnnotation() && structConverter.loadedFromXML()) {
            if (existingConverter != null) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_struct_converter", existingConverter.getName(), existingConverter.getLocation(), structConverter.getLocation());
            }
            this.m_structConverters.put(structConverter.getName(), structConverter);
        } else if (!existingStructConverter.equals(structConverter)) {
            throw ValidationException.multipleConvertersOfTheSameName((String)structConverter.getName(), (String)existingStructConverter.getLocation(), (String)structConverter.getLocation());
        }
    }

    public void addTableGenerator(TableGeneratorMetadata tableGenerator, String defaultCatalog, String defaultSchema) {
        this.processTable(tableGenerator, "SEQUENCE", defaultCatalog, defaultSchema);
        String generatorName = tableGenerator.getGeneratorName();
        if (generatorName.equals(DEFAULT_SEQUENCE_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_SEQUENCE_GENERATOR, (String)tableGenerator.getLocation());
        }
        if (generatorName.equals(DEFAULT_IDENTITY_GENERATOR)) {
            throw ValidationException.tableGeneratorUsingAReservedName((String)DEFAULT_IDENTITY_GENERATOR, (String)tableGenerator.getLocation());
        }
        TableGeneratorMetadata otherTableGenerator = this.m_tableGenerators.get(generatorName);
        if (otherTableGenerator != null && !otherTableGenerator.equals(tableGenerator)) {
            if (tableGenerator.loadedFromAnnotations() && otherTableGenerator.loadedFromXML()) {
                return;
            }
            throw ValidationException.conflictingTableGeneratorsSpecified((String)generatorName, (String)tableGenerator.getLocation(), (String)otherTableGenerator.getLocation());
        }
        SequenceGeneratorMetadata otherSequenceGenerator = this.m_sequenceGenerators.get(generatorName);
        if (otherSequenceGenerator != null) {
            throw ValidationException.conflictingSequenceAndTableGeneratorsSpecified((String)generatorName, (String)otherSequenceGenerator.getLocation(), (String)tableGenerator.getLocation());
        }
        for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
            if (!sequenceGenerator.getSequenceName().equals(tableGenerator.getPkColumnValue()) || sequenceGenerator.getSequenceName().length() <= 0) continue;
            throw ValidationException.conflictingSequenceNameAndTablePkColumnValueSpecified((String)sequenceGenerator.getSequenceName(), (String)sequenceGenerator.getLocation(), (String)tableGenerator.getLocation());
        }
        this.m_tableGenerators.put(tableGenerator.getGeneratorName(), tableGenerator);
    }

    public boolean isWeavingEnabled() {
        return this.m_weavingEnabled;
    }

    public boolean weaveEager() {
        return this.m_weaveEager;
    }

    public void setWeavingEnabled(boolean weavingEnabled) {
        this.m_weavingEnabled = weavingEnabled;
    }

    public ClassAccessor getAccessor(String className) {
        return this.m_allAccessors.get(className);
    }

    public Set<ClassAccessor> getAccessorsWithCustomizer() {
        return this.m_accessorsWithCustomizer;
    }

    public Set<ClassAccessor> getAccessorsWithRelationships() {
        return this.m_accessorsWithRelationships;
    }

    public Collection<ClassAccessor> getAllAccessors() {
        return this.m_allAccessors.values();
    }

    public Collection<EntityAccessor> getEntityAccessors() {
        return this.m_entityAccessors.values();
    }

    public AbstractConverterMetadata getConverter(String name) {
        return this.m_converters.get(name);
    }

    public Set<EntityListenerMetadata> getDefaultListeners() {
        return this.m_defaultListeners;
    }

    public EmbeddableAccessor getEmbeddableAccessor(String className) {
        return this.m_embeddableAccessors.get(className);
    }

    public EntityAccessor getEntityAccessor(String className) {
        return this.m_entityAccessors.get(className);
    }

    public List<XMLEntityMappings> getEntityMappings() {
        return this.m_entityMappings;
    }

    public InterfaceAccessor getInterfaceAccessor(String className) {
        return this.m_interfaceAccessors.get(className);
    }

    public MetadataLogger getLogger() {
        return this.m_logger;
    }

    public MappedSuperclassAccessor getMappedSuperclass(Class cls) {
        return this.m_mappedSuperclasses.get(cls.getName());
    }

    public PersistenceUnitInfo getPersistenceUnitInfo() {
        return this.m_persistenceUnitInfo;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public AbstractSession getSession() {
        return this.m_session;
    }

    public StructConverterMetadata getStructConverter(String name) {
        return this.m_structConverters.get(name);
    }

    public HashMap<String, StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public Collection<String> getWeavableClassNames() {
        return Collections.unmodifiableCollection(this.m_allAccessors.keySet());
    }

    public boolean hasConverter(String name) {
        return this.m_converters.containsKey(name);
    }

    public boolean hasEmbeddable(Class cls) {
        return this.m_embeddableAccessors.containsKey(cls.getName());
    }

    public boolean hasEntity(Class cls) {
        return this.m_entityAccessors.containsKey(cls.getName());
    }

    public boolean hasInterface(Class cls) {
        return this.m_interfaceAccessors.containsKey(cls.getName());
    }

    public boolean hasMappedSuperclass(Class cls) {
        return this.m_mappedSuperclasses.containsKey(cls.getName());
    }

    public boolean hasStructConverter(String name) {
        return this.m_structConverters.containsKey(name);
    }

    public void process() {
        this.processConvertAccessors();
        this.processSequencing();
        this.processAccessorsWithRelationships();
        this.processInterfaceAccessors();
    }

    protected void processAccessorsWithRelationships() {
        for (ClassAccessor classAccessor : this.getAccessorsWithRelationships()) {
            for (RelationshipAccessor accessor : classAccessor.getDescriptor().getRelationshipAccessors()) {
                accessor.processRelationship();
            }
        }
    }

    protected void processConvertAccessors() {
        for (DirectAccessor accessor : this.m_convertAccessors) {
            accessor.processConvert();
        }
    }

    public void processNamedNativeQueries(ClassLoader loader) {
        for (NamedNativeQueryMetadata namedNativeQuery : this.m_namedNativeQueries.values()) {
            namedNativeQuery.process(this.m_session, loader);
        }
    }

    public void processNamedQueries() {
        for (NamedQueryMetadata namedQuery : this.m_namedQueries.values()) {
            namedQuery.process(this.m_session);
        }
    }

    public void processNamedStoredProcedureQueries(ClassLoader loader) {
        for (NamedStoredProcedureQueryMetadata query : this.m_namedStoredProcedureQueries.values()) {
            query.process(this.m_session, loader);
        }
    }

    protected void processSequencing() {
        if (!this.m_generatedValues.isEmpty()) {
            TableSequence sequence;
            Integer allocationSize;
            String seqName;
            DatabaseLogin login = this.m_session.getProject().getLogin();
            NativeSequence defaultAutoSequence = null;
            TableSequence defaultTableSequence = new TableSequence(DEFAULT_TABLE_GENERATOR);
            NativeSequence defaultObjectNativeSequence = new NativeSequence(DEFAULT_SEQUENCE_GENERATOR, false);
            NativeSequence defaultIdentityNativeSequence = new NativeSequence(DEFAULT_IDENTITY_GENERATOR, 1, true);
            Hashtable<String, Object> sequences = new Hashtable<String, Object>();
            for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators.values()) {
                String sequenceGeneratorName = sequenceGenerator.getName();
                seqName = sequenceGenerator.getSequenceName() != null && !sequenceGenerator.getSequenceName().equals("") ? sequenceGenerator.getSequenceName() : sequenceGeneratorName;
                allocationSize = sequenceGenerator.getAllocationSize();
                if (allocationSize == null) {
                    allocationSize = new Integer(50);
                }
                NativeSequence sequence2 = new NativeSequence(seqName, allocationSize.intValue(), false);
                sequences.put(sequenceGeneratorName, sequence2);
                if (sequenceGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                    defaultAutoSequence = sequence2;
                    continue;
                }
                if (!sequenceGeneratorName.equals(DEFAULT_SEQUENCE_GENERATOR)) continue;
                defaultObjectNativeSequence = sequence2;
            }
            for (TableGeneratorMetadata tableGenerator : this.m_tableGenerators.values()) {
                Integer initialValue;
                String tableGeneratorName = tableGenerator.getGeneratorName();
                seqName = tableGenerator.getPkColumnValue() != null && !tableGenerator.getPkColumnValue().equals("") ? tableGenerator.getPkColumnValue() : tableGeneratorName;
                allocationSize = tableGenerator.getAllocationSize();
                if (allocationSize == null) {
                    allocationSize = new Integer(50);
                }
                if ((initialValue = tableGenerator.getInitialValue()) == null) {
                    initialValue = new Integer(0);
                }
                sequence = new TableSequence(seqName, allocationSize.intValue(), initialValue.intValue());
                sequences.put(tableGeneratorName, sequence);
                sequence.setTable(tableGenerator.getDatabaseTable());
                if (tableGenerator.getPkColumnName() != null && !tableGenerator.getPkColumnName().equals("")) {
                    sequence.setNameFieldName(tableGenerator.getPkColumnName());
                }
                if (tableGenerator.getValueColumnName() != null && !tableGenerator.getValueColumnName().equals("")) {
                    sequence.setCounterFieldName(tableGenerator.getValueColumnName());
                }
                if (tableGeneratorName.equals(DEFAULT_AUTO_GENERATOR)) {
                    defaultAutoSequence = sequence;
                    continue;
                }
                if (!tableGeneratorName.equals(DEFAULT_TABLE_GENERATOR)) continue;
                defaultTableSequence = sequence;
            }
            boolean usesAuto = false;
            for (Class entityClass : this.m_generatedValues.keySet()) {
                MetadataDescriptor descriptor = this.m_allAccessors.get(entityClass.getName()).getDescriptor();
                GeneratedValueMetadata generatedValue = this.m_generatedValues.get(entityClass);
                String generatorName = generatedValue.getGenerator();
                if (generatorName == null) {
                    generatorName = "";
                }
                sequence = null;
                if (!generatorName.equals("")) {
                    sequence = (Sequence)sequences.get(generatorName);
                }
                if (sequence == null) {
                    Enum strategy = generatedValue.getStrategy();
                    if (strategy == null || strategy.equals(GenerationType.AUTO)) {
                        usesAuto = true;
                    } else if (strategy.equals(GenerationType.TABLE)) {
                        if (generatorName.equals("")) {
                            sequence = defaultTableSequence;
                        } else {
                            sequence = (Sequence)defaultTableSequence.clone();
                            sequence.setName(generatorName);
                        }
                    } else if (strategy.equals(GenerationType.SEQUENCE)) {
                        if (generatorName.equals("")) {
                            sequence = defaultObjectNativeSequence;
                        } else {
                            sequence = (Sequence)defaultObjectNativeSequence.clone();
                            sequence.setName(generatorName);
                        }
                    } else if (strategy.equals(GenerationType.IDENTITY)) {
                        if (generatorName.equals("")) {
                            sequence = defaultIdentityNativeSequence;
                        } else {
                            sequence = (Sequence)defaultIdentityNativeSequence.clone();
                            sequence.setName(generatorName);
                        }
                    }
                }
                if (sequence != null) {
                    descriptor.setSequenceNumberName(sequence.getName());
                    login.addSequence((Sequence)sequence);
                    continue;
                }
                String seqName2 = generatorName.equals("") ? (defaultAutoSequence != null ? defaultAutoSequence.getName() : DEFAULT_AUTO_GENERATOR) : generatorName;
                descriptor.setSequenceNumberName(seqName2);
            }
            if (usesAuto && defaultAutoSequence != null) {
                login.setDefaultSequence(defaultAutoSequence);
            }
        }
    }

    public void processTable(TableMetadata table, String defaultName, String defaultCatalog, String defaultSchema) {
        String name = MetadataHelper.getName(table.getName(), defaultName, table.getNameContext(), this.m_logger, table.getLocation());
        String catalog = MetadataHelper.getName(table.getCatalog(), defaultCatalog, table.getCatalogContext(), this.m_logger, table.getLocation());
        String schema = MetadataHelper.getName(table.getSchema(), defaultSchema, table.getSchemaContext(), this.m_logger, table.getLocation());
        String tableName = new String(name);
        if (!schema.equals("")) {
            tableName = schema + "." + tableName;
        }
        if (!catalog.equals("")) {
            tableName = catalog + "." + tableName;
        }
        table.setFullyQualifiedTableName(tableName);
        table.processUniqueConstraints();
    }

    protected void processInterfaceAccessors() {
        for (EntityAccessor accessor : this.getEntityAccessors()) {
            for (Class<?> interfaceClass : accessor.getJavaClass().getInterfaces()) {
                if (!this.m_interfaceAccessors.containsKey(interfaceClass.getName())) continue;
                this.m_interfaceAccessors.get(interfaceClass.getName()).addEntityAccessor(accessor);
            }
        }
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        if (this.m_persistenceUnitMetadata == null) {
            this.m_persistenceUnitMetadata = persistenceUnitMetadata;
        } else if (!this.m_persistenceUnitMetadata.equals(persistenceUnitMetadata)) {
            throw ValidationException.persistenceUnitMetadataConflict((String)this.m_persistenceUnitMetadata.getConflict());
        }
    }
}

