/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import javax.persistence.GeneratedValue;
import javax.persistence.SequenceGenerator;
import javax.persistence.TableGenerator;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.GeneratedValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;

public class IdAccessor
extends BasicAccessor {
    private GeneratedValueMetadata m_generatedValue;
    private SequenceGeneratorMetadata m_sequenceGenerator;
    private TableGeneratorMetadata m_tableGenerator;

    public IdAccessor() {
    }

    public IdAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        if (this.isAnnotationPresent(GeneratedValue.class)) {
            this.m_generatedValue = new GeneratedValueMetadata((Annotation)this.getAnnotation(GeneratedValue.class));
        }
        if (this.isAnnotationPresent(SequenceGenerator.class)) {
            this.m_sequenceGenerator = new SequenceGeneratorMetadata((Annotation)this.getAnnotation(SequenceGenerator.class), this.getJavaClassName());
        }
        if (this.isAnnotationPresent(TableGenerator.class)) {
            this.m_tableGenerator = new TableGeneratorMetadata((Annotation)this.getAnnotation(TableGenerator.class), this.getJavaClassName());
        }
    }

    public GeneratedValueMetadata getGeneratedValue() {
        return this.m_generatedValue;
    }

    public SequenceGeneratorMetadata getSequenceGenerator() {
        return this.m_sequenceGenerator;
    }

    public TableGeneratorMetadata getTableGenerator() {
        return this.m_tableGenerator;
    }

    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.m_sequenceGenerator != null) {
            this.m_sequenceGenerator.setLocation(this.getJavaClassName());
        }
        if (this.m_tableGenerator != null) {
            this.m_tableGenerator.setLocation(this.getJavaClassName());
        }
    }

    public void process() {
        super.process();
        String attributeName = this.getAttributeName();
        if (this.getOwningDescriptor().hasEmbeddedIdAttribute()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound((Class)this.getJavaClass(), (String)this.getOwningDescriptor().getEmbeddedIdAttributeName(), (String)attributeName);
        }
        this.getOwningDescriptor().validatePKClassId(attributeName, this.getReferenceClass());
        this.getOwningDescriptor().addIdAttributeName(attributeName);
        this.getOwningDescriptor().addPrimaryKeyField(this.getField());
        this.processGeneratedValue();
        if (this.m_tableGenerator != null) {
            this.getProject().addTableGenerator(this.m_tableGenerator, this.getDescriptor().getXMLCatalog(), this.getDescriptor().getXMLSchema());
        }
        if (this.m_sequenceGenerator != null) {
            this.getProject().addSequenceGenerator(this.m_sequenceGenerator);
        }
    }

    protected void processGeneratedValue() {
        if (this.m_generatedValue != null) {
            DatabaseField existingSequenceNumberField = this.getOwningDescriptor().getSequenceNumberField();
            if (existingSequenceNumberField == null) {
                this.getOwningDescriptor().setSequenceNumberField(this.getField());
                this.getProject().addGeneratedValue(this.m_generatedValue, this.getOwningDescriptor().getJavaClass());
            } else {
                throw ValidationException.onlyOneGeneratedValueIsAllowed((Class)this.getOwningDescriptor().getJavaClass(), (String)existingSequenceNumberField.getQualifiedName(), (String)this.getField().getQualifiedName());
            }
        }
    }

    public void setGeneratedValue(GeneratedValueMetadata value) {
        this.m_generatedValue = value;
    }

    public void setSequenceGenerator(SequenceGeneratorMetadata sequenceGenerator) {
        this.m_sequenceGenerator = sequenceGenerator;
    }

    public void setTableGenerator(TableGeneratorMetadata tableGenerator) {
        this.m_tableGenerator = tableGenerator;
    }
}

