/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CascadeTypes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MetadataAccessor {
    private boolean m_privateOwned;
    private CascadeTypes m_cascadeTypes;
    protected Class m_referenceClass;
    private Class m_targetEntity;
    private Enum m_fetch;
    private Enum m_joinFetch;
    private List<JoinColumnMetadata> m_joinColumns;
    private String m_mappedBy;
    private String m_targetEntityName;

    protected RelationshipAccessor() {
    }

    protected RelationshipAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object joinColumn;
        Object joinFetch = this.getAnnotation(JoinFetch.class);
        if (joinFetch != null) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", joinFetch);
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        Object joinColumns = this.getAnnotation(JoinColumns.class);
        if (joinColumns != null) {
            for (Annotation jColumn : (Annotation[])MetadataHelper.invokeMethod("value", joinColumns)) {
                this.m_joinColumns.add(new JoinColumnMetadata(jColumn));
            }
        }
        if ((joinColumn = this.getAnnotation(JoinColumn.class)) != null) {
            this.m_joinColumns.add(new JoinColumnMetadata((Annotation)joinColumn));
        }
    }

    public CascadeTypes getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    @Override
    public abstract Enum getDefaultFetchType();

    public Enum getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    protected abstract String getLoggingContext();

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    protected DatabaseMapping getOwningMapping() {
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = ownerDescriptor.getMappingForAttributeName(this.getMappedBy(), this);
        if (mapping == null) {
            throw ValidationException.noMappedByAttributeFound((Class)ownerDescriptor.getJavaClass(), (String)this.getMappedBy(), (Class)this.getJavaClass(), (String)this.getAttributeName());
        }
        return mapping;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor descriptor;
        try {
            descriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            descriptor = null;
        }
        if (descriptor == null || descriptor.isEmbeddable() || descriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship((Class)this.getJavaClass(), (Class)this.getReferenceClass(), (AnnotatedElement)this.getAnnotatedElement());
        }
        return descriptor;
    }

    public Class getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    @Override
    public boolean hasPrimaryKeyJoinColumns() {
        if (this.getPrimaryKeyJoinColumns() != null && !this.getPrimaryKeyJoinColumns().isEmpty()) {
            return true;
        }
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class) || this.isAnnotationPresent(PrimaryKeyJoinColumn.class);
    }

    @Override
    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        super.init(accessibleObject, accessor);
        if (this.getTargetEntityName() != null) {
            this.setTargetEntity(this.getEntityMappings().getClassForName(this.getTargetEntityName()));
        } else {
            this.setTargetEntity(Void.TYPE);
        }
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && this.hasPrimaryKeyJoinColumns();
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        if (this.m_cascadeTypes != null) {
            for (Enum cascadeType : this.m_cascadeTypes.getTypes()) {
                this.setCascadeType(cascadeType, mapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType((Enum)CascadeType.PERSIST, mapping);
        }
    }

    protected List<JoinColumnMetadata> processJoinColumns() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(this.m_joinColumns, this.getReferenceDescriptor());
    }

    protected List<JoinColumnMetadata> processJoinColumns(List<JoinColumnMetadata> joinColumns, MetadataDescriptor descriptor) {
        if (joinColumns.isEmpty()) {
            if (descriptor.hasCompositePrimaryKey()) {
                for (String primaryKeyField : descriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumn = new JoinColumnMetadata();
                    joinColumn.setReferencedColumnName(primaryKeyField);
                    joinColumn.setName(primaryKeyField);
                    joinColumns.add(joinColumn);
                }
            } else {
                joinColumns.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumn : joinColumns) {
                joinColumn.setReferencedColumnName(descriptor.getPrimaryKeyJoinColumnAssociation(joinColumn.getReferencedColumnName()));
            }
        }
        if (descriptor.hasCompositePrimaryKey()) {
            if (joinColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Class)this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumn : joinColumns) {
                if (!joinColumn.isPrimaryKeyFieldNotSpecified() && !joinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Class)this.getJavaClass());
            }
        } else if (joinColumns.size() > 1) {
            throw ValidationException.excessiveJoinColumnsSpecified((Object)this.getAnnotatedElement(), (Class)this.getJavaClass());
        }
        return joinColumns;
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.hasColumn()) {
                throw ValidationException.invalidColumnAnnotationOnRelationship((Class)this.getJavaClass(), (String)this.getAttributeName());
            }
            if (this.hasConvert()) {
                throw ValidationException.invalidMappingForConverter((Class)this.getJavaClass(), (Object)this.getAttributeName());
            }
            if (!(this.getTargetEntity() == ValueHolderInterface.class || this.getTargetEntity() == Void.TYPE && this.getReferenceClass().getName().equalsIgnoreCase(ValueHolderInterface.class.getName()))) {
                this.process();
            }
            this.setIsProcessed();
        }
    }

    protected void setCascadeType(Enum type, ForeignReferenceMapping mapping) {
        if (type.equals(CascadeType.ALL)) {
            mapping.setCascadeAll(true);
        } else if (type.equals(CascadeType.MERGE)) {
            mapping.setCascadeMerge(true);
        } else if (type.equals(CascadeType.PERSIST)) {
            mapping.setCascadePersist(true);
        } else if (type.equals(CascadeType.REFRESH)) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals(CascadeType.REMOVE)) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(Enum[] cascadeTypes) {
        this.m_cascadeTypes = new CascadeTypes(cascadeTypes);
    }

    public void setCascadeTypes(CascadeTypes cascadeTypes) {
        this.m_cascadeTypes = cascadeTypes;
    }

    public void setFetch(Enum fetch) {
        this.m_fetch = fetch;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinFetch(Enum joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setPrivateOwned(String ignore) {
        this.m_privateOwned = true;
    }

    public void setTargetEntity(Class targetEntity) {
        this.m_targetEntity = targetEntity;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.m_targetEntityName = targetEntityName;
    }

    public boolean isLazy() {
        Enum fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY);
    }

    public boolean usesIndirection() {
        if (this.getProject().weaveEager()) {
            return true;
        }
        return this.isLazy();
    }
}

