/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.sql.Timestamp;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;

public class VersionAccessor
extends BasicAccessor {
    public VersionAccessor() {
    }

    public VersionAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    protected boolean isValidTimestampVersionLockingType(Class cls) {
        return cls.equals(Timestamp.class);
    }

    protected boolean isValidVersionLockingType(Class cls) {
        return cls.equals(Integer.TYPE) || cls.equals(Integer.class) || cls.equals(Short.TYPE) || cls.equals(Short.class) || cls.equals(Long.TYPE) || cls.equals(Long.class);
    }

    public void process() {
        super.process();
        if (this.getDescriptor().usesOptimisticLocking()) {
            this.getLogger().logWarningMessage("metadata_warning_ignore_version_locking", this);
        } else {
            Class lockType = this.getRawClass();
            this.getField().setType(lockType);
            if (this.isValidVersionLockingType(lockType) || this.isValidTimestampVersionLockingType(lockType)) {
                VersionLockingPolicy policy = this.isValidVersionLockingType(lockType) ? new VersionLockingPolicy(this.getField()) : new TimestampLockingPolicy(this.getField());
                policy.storeInObject();
                policy.setIsCascaded(this.getDescriptor().usesCascadedOptimisticLocking());
                this.getOwningDescriptor().setOptimisticLockingPolicy((OptimisticLockingPolicy)policy);
            } else {
                throw ValidationException.invalidTypeForVersionAttribute((String)this.getAttributeName(), (Class)lockType, (Class)this.getJavaClass());
            }
        }
    }
}

