/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class MetadataMethod
extends MetadataAccessibleObject {
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    private static final String SET_PROPERTY_METHOD_PREFIX = "set";
    private static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    private static final int POSITION_AFTER_IS_PREFIX = "is".length();
    private static final int POSITION_AFTER_GET_PREFIX = "get".length();
    protected Method m_getMethod;
    protected Method m_setMethod;

    public MetadataMethod(Method getMethod) {
        super(getMethod);
        this.m_getMethod = getMethod;
        this.m_setMethod = MetadataMethod.getSetMethod(getMethod, getMethod.getDeclaringClass());
        this.setName(getMethod.getName());
        this.setAttributeName(MetadataMethod.getAttributeNameFromMethodName(getMethod.getName()));
        this.setRelationType(getMethod.getGenericReturnType());
    }

    public static String getAttributeNameFromMethodName(String methodName) {
        String leadingChar = "";
        String restOfName = methodName;
        if (methodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else if (methodName.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return leadingChar.toLowerCase().concat(restOfName);
    }

    public static Method getSetMethod(Method method, Class cls) {
        String getMethodName = method.getName();
        Class[] params = new Class[]{method.getReturnType()};
        if (getMethodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return MetadataMethod.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(3), cls, params);
        }
        Method setMethod = MetadataMethod.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        if (setMethod == null) {
            return MetadataMethod.getMethod(SET_IS_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        }
        return setMethod;
    }

    public String getSetMethodName() {
        return this.m_setMethod.getName();
    }

    static Method getMethod(String methodName, Class cls, Class[] params) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Method)AccessController.doPrivileged(new PrivilegedGetMethod(cls, methodName, params, true));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod((Class)cls, (String)methodName, (Class[])params, (boolean)true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    public boolean hasParameters() {
        return this.m_getMethod.getParameterTypes().length > 0;
    }

    public boolean hasSetMethod() {
        return this.m_setMethod != null;
    }

    public boolean isValidPersistenceMethodName() {
        return this.getName().startsWith(GET_PROPERTY_METHOD_PREFIX) || this.getName().startsWith(IS_PROPERTY_METHOD_PREFIX);
    }
}

