/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class ColumnMetadata {
    private Boolean m_unique;
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;
    private DatabaseField m_databaseField;
    private Integer m_scale;
    private Integer m_length;
    private Integer m_precision;
    private String m_attributeName;
    private String m_name;
    private String m_table;
    private String m_columnDefinition;

    public ColumnMetadata() {
    }

    public ColumnMetadata(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public ColumnMetadata(Annotation column) {
        this(column, "");
    }

    public ColumnMetadata(Annotation column, String attributeName) {
        this(attributeName);
        if (column != null) {
            this.setUnique((Boolean)MetadataHelper.invokeMethod("unique", column));
            this.setNullable((Boolean)MetadataHelper.invokeMethod("nullable", column));
            this.setUpdatable((Boolean)MetadataHelper.invokeMethod("updatable", column));
            this.setInsertable((Boolean)MetadataHelper.invokeMethod("insertable", column));
            this.setScale((Integer)MetadataHelper.invokeMethod("scale", column));
            this.setLength((Integer)MetadataHelper.invokeMethod("length", column));
            this.setPrecision((Integer)MetadataHelper.invokeMethod("precision", column));
            this.setName((String)MetadataHelper.invokeMethod("name", column));
            this.setTable((String)MetadataHelper.invokeMethod("table", column));
            this.setColumnDefinition((String)MetadataHelper.invokeMethod("columnDefinition", column));
        }
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public DatabaseField getDatabaseField() {
        if (this.m_databaseField == null) {
            this.m_databaseField = new DatabaseField();
            this.m_databaseField.setUnique(this.m_unique == null ? false : this.m_unique);
            this.m_databaseField.setNullable(this.m_nullable == null ? true : this.m_nullable);
            this.m_databaseField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
            this.m_databaseField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
            this.m_databaseField.setScale(this.m_scale == null ? 0 : this.m_scale);
            this.m_databaseField.setLength(this.m_length == null ? 255 : this.m_length);
            this.m_databaseField.setPrecision(this.m_precision == null ? 0 : this.m_precision);
            this.m_databaseField.setName(this.m_name == null ? "" : this.m_name);
            this.m_databaseField.setTableName(this.m_table == null ? "" : this.m_table);
            this.m_databaseField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        }
        return this.m_databaseField;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public Integer getLength() {
        return this.m_length;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public Integer getPrecision() {
        return this.m_precision;
    }

    public Integer getScale() {
        return this.m_scale;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public String getUpperCaseAttributeName() {
        return this.m_attributeName.toUpperCase();
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setDatabaseField(DatabaseField databaseField) {
        this.m_databaseField = databaseField;
    }

    public void setInsertable(Boolean insertable) {
        this.m_insertable = insertable;
    }

    public void setLength(Integer length) {
        this.m_length = length;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNullable(Boolean nullable) {
        this.m_nullable = nullable;
    }

    public void setPrecision(Integer precision) {
        this.m_precision = precision;
    }

    public void setScale(Integer scale) {
        this.m_scale = scale;
    }

    public void setTable(String table) {
        this.m_table = table;
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }

    public void setUpdatable(Boolean updatable) {
        this.m_updatable = updatable;
    }
}

