/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public class JoinColumnMetadata {
    private Boolean m_unique;
    private Boolean m_nullable;
    private Boolean m_updatable;
    private Boolean m_insertable;
    private String m_name;
    private String m_table;
    private String m_columnDefinition;
    private String m_referencedColumnName;

    public JoinColumnMetadata() {
    }

    public JoinColumnMetadata(Annotation joinColumn) {
        if (joinColumn != null) {
            this.setReferencedColumnName((String)MetadataHelper.invokeMethod("referencedColumnName", joinColumn));
            this.setName((String)MetadataHelper.invokeMethod("name", joinColumn));
            this.setTable((String)MetadataHelper.invokeMethod("table", joinColumn));
            this.setUnique((Boolean)MetadataHelper.invokeMethod("unique", joinColumn));
            this.setNullable((Boolean)MetadataHelper.invokeMethod("nullable", joinColumn));
            this.setUpdatable((Boolean)MetadataHelper.invokeMethod("updatable", joinColumn));
            this.setInsertable((Boolean)MetadataHelper.invokeMethod("insertable", joinColumn));
            this.setColumnDefinition((String)MetadataHelper.invokeMethod("columnDefinition", joinColumn));
        }
    }

    public DatabaseField getForeignKeyField() {
        DatabaseField fkField = new DatabaseField();
        fkField.setUnique(this.m_unique == null ? false : this.m_unique);
        fkField.setNullable(this.m_nullable == null ? true : this.m_nullable);
        fkField.setUpdatable(this.m_updatable == null ? true : this.m_updatable);
        fkField.setInsertable(this.m_insertable == null ? true : this.m_insertable);
        fkField.setName(this.m_name == null ? "" : this.m_name);
        fkField.setTableName(this.m_table == null ? "" : this.m_table);
        fkField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        return fkField;
    }

    public DatabaseField getPrimaryKeyField() {
        DatabaseField pkField = new DatabaseField();
        pkField.setName(this.m_referencedColumnName == null ? "" : this.m_referencedColumnName);
        return pkField;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public Boolean getInsertable() {
        return this.m_insertable;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getNullable() {
        return this.m_nullable;
    }

    public String getReferencedColumnName() {
        return this.m_referencedColumnName;
    }

    public String getTable() {
        return this.m_table;
    }

    public Boolean getUnique() {
        return this.m_unique;
    }

    public Boolean getUpdatable() {
        return this.m_updatable;
    }

    public boolean isForeignKeyFieldNotSpecified() {
        return this.m_name == null || this.m_name.equals("");
    }

    public boolean isPrimaryKeyFieldNotSpecified() {
        return this.m_referencedColumnName == null || this.m_referencedColumnName.equals("");
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setInsertable(Boolean insertable) {
        this.m_insertable = insertable;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNullable(Boolean nullable) {
        this.m_nullable = nullable;
    }

    public void setReferencedColumnName(String referencedColumnName) {
        this.m_referencedColumnName = referencedColumnName;
    }

    public void setTable(String table) {
        this.m_table = table;
    }

    public void setUnique(Boolean unique) {
        this.m_unique = unique;
    }

    public void setUpdatable(Boolean updatable) {
        this.m_updatable = updatable;
    }
}

