/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.copypolicy;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.MetadataHelper;

public class CustomCopyPolicyMetadata
extends CopyPolicyMetadata {
    private String copyPolicyClassName;
    private Class copyPolicyClass;

    public CustomCopyPolicyMetadata() {
    }

    public CustomCopyPolicyMetadata(Annotation copyPolicy) {
        this.copyPolicyClass = (Class)MetadataHelper.invokeMethod("value", copyPolicy);
        this.copyPolicyClassName = this.copyPolicyClass.getName();
    }

    public CopyPolicy getCopyPolicy() {
        assert (false);
        return null;
    }

    public String getCopyPolicyClassName() {
        return this.copyPolicyClassName;
    }

    public void process(MetadataDescriptor descriptor, Class javaClass) {
        descriptor.setHasCopyPolicy();
        this.javaClassName = javaClass.getName();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        if (this.copyPolicyClass == null) {
            classDescriptor.setCopyPolicyClassName(descriptor.getClassAccessor().getEntityMappings().getFullyQualifiedClassName(this.copyPolicyClassName));
        } else {
            classDescriptor.setCopyPolicyClassName(this.copyPolicyClassName);
        }
    }

    public void setCopyPolicyClassName(String className) {
        this.copyPolicyClassName = className;
    }
}

