/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.locking;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.OptimisticLockingType;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.locking.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticLockingMetadata {
    private Boolean m_cascade;
    private List<ColumnMetadata> m_selectedColumns;
    private Enum m_type;

    public OptimisticLockingMetadata() {
    }

    public OptimisticLockingMetadata(Object optimisticLocking) {
        this.setType((Enum)MetadataHelper.invokeMethod("type", optimisticLocking));
        this.setCascade((Boolean)MetadataHelper.invokeMethod("cascade", optimisticLocking));
        this.setSelectedColumns((Annotation[])MetadataHelper.invokeMethod("selectedColumns", optimisticLocking));
    }

    public List<ColumnMetadata> getSelectedColumns() {
        return this.m_selectedColumns;
    }

    public Enum getType() {
        return this.m_type;
    }

    public boolean hasSelectedColumns() {
        return !this.m_selectedColumns.isEmpty();
    }

    public Boolean getCascade() {
        return this.m_cascade;
    }

    public void process(MetadataDescriptor descriptor) {
        if (this.m_type == null || this.m_type.equals(OptimisticLockingType.VERSION_COLUMN)) {
            descriptor.setUsesCascadedOptimisticLocking(this.m_cascade != null && this.m_cascade != false);
        } else if (this.m_type.equals(OptimisticLockingType.ALL_COLUMNS)) {
            descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)new AllFieldsLockingPolicy());
        } else if (this.m_type.equals(OptimisticLockingType.CHANGED_COLUMNS)) {
            descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)new ChangedFieldsLockingPolicy());
        } else if (this.m_type.equals(OptimisticLockingType.SELECTED_COLUMNS)) {
            if (this.m_selectedColumns.isEmpty()) {
                throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified((Class)descriptor.getJavaClass());
            }
            SelectedFieldsLockingPolicy policy = new SelectedFieldsLockingPolicy();
            for (ColumnMetadata selectedColumn : this.m_selectedColumns) {
                if (selectedColumn.getName().equals("")) {
                    throw ValidationException.optimisticLockingSelectedColumnNamesNotSpecified((Class)descriptor.getJavaClass());
                }
                policy.addLockFieldName(selectedColumn.getName());
            }
            descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)policy);
        }
    }

    public void setCascade(Boolean cascade) {
        this.m_cascade = cascade;
    }

    protected void setSelectedColumns(Annotation[] selectedColumns) {
        this.m_selectedColumns = new ArrayList<ColumnMetadata>();
        for (Annotation selectedColumn : selectedColumns) {
            this.m_selectedColumns.add(new ColumnMetadata(selectedColumn));
        }
    }

    public void setSelectedColumns(List<ColumnMetadata> selectedColumns) {
        this.m_selectedColumns = selectedColumns;
    }

    public void setType(Enum type) {
        this.m_type = type;
    }
}

