/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.queries.EntityResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.FieldResultMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.queries.ColumnResult;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.FieldResult;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLResultSetMappingMetadata {
    private List<String> m_columnResults;
    private List<EntityResultMetadata> m_entityResults;
    private String m_name;

    public SQLResultSetMappingMetadata() {
    }

    public SQLResultSetMappingMetadata(Annotation sqlResultSetMapping) {
        this.setName((String)MetadataHelper.invokeMethod("name", sqlResultSetMapping));
        this.setEntityResults((Annotation[])MetadataHelper.invokeMethod("entities", sqlResultSetMapping));
        this.setColumnResults((Annotation[])MetadataHelper.invokeMethod("columns", sqlResultSetMapping));
    }

    public List<String> getColumnResults() {
        return this.m_columnResults;
    }

    public List<EntityResultMetadata> getEntityResults() {
        return this.m_entityResults;
    }

    public String getName() {
        return this.m_name;
    }

    public void process(MetadataProject project) {
        SQLResultSetMapping mapping = new SQLResultSetMapping(this.getName());
        for (EntityResultMetadata eResult : this.m_entityResults) {
            EntityResult entityResult = new EntityResult(eResult.getEntityClass().getName());
            if (eResult.hasFieldResults()) {
                for (FieldResultMetadata fResult : eResult.getFieldResults()) {
                    entityResult.addFieldResult(new FieldResult(fResult.getName(), fResult.getColumn()));
                }
            }
            entityResult.setDiscriminatorColumn(eResult.getDiscriminatorColumn());
            mapping.addResult((SQLResult)entityResult);
        }
        for (String columnResult : this.m_columnResults) {
            mapping.addResult((SQLResult)new ColumnResult(columnResult));
        }
        project.getSession().getProject().addSQLResultSetMapping(mapping);
    }

    protected void setColumnResults(Object[] columnResults) {
        this.m_columnResults = new ArrayList<String>();
        for (Object columnResult : columnResults) {
            this.m_columnResults.add((String)MetadataHelper.invokeMethod("name", columnResult));
        }
    }

    protected void setColumnResults(List<String> columnResults) {
        this.m_columnResults = columnResults;
    }

    public void setEntityResults(Annotation[] entityResults) {
        this.m_entityResults = new ArrayList<EntityResultMetadata>();
        for (Annotation entityResult : entityResults) {
            this.m_entityResults.add(new EntityResultMetadata(entityResult));
        }
    }

    public void setEntityResults(List<EntityResultMetadata> entityResults) {
        this.m_entityResults = entityResults;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

