/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.tables.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.tables.UniqueConstraintMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetadata {
    private DatabaseTable m_databaseTable = new DatabaseTable();
    private List<UniqueConstraintMetadata> m_uniqueConstraints;
    private String m_location;
    private String m_name;
    private String m_schema;
    private String m_catalog;

    public TableMetadata() {
    }

    public TableMetadata(String entityClassName) {
        this();
        this.m_location = entityClassName;
    }

    public TableMetadata(Annotation table, String entityClassName) {
        this(entityClassName);
        if (table != null) {
            this.m_name = (String)this.invokeMethod("name", table);
            this.m_schema = (String)this.invokeMethod("schema", table);
            this.m_catalog = (String)this.invokeMethod("catalog", table);
            this.setUniqueConstraints((Annotation[])this.invokeMethod("uniqueConstraints", table));
        }
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String getCatalogContext() {
        return "metadata_default_table_catalog";
    }

    public DatabaseTable getDatabaseTable() {
        return this.m_databaseTable;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameContext() {
        return "metadata_default_table_name";
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getSchemaContext() {
        return "metadata_default_table_schema";
    }

    public List<UniqueConstraintMetadata> getUniqueConstraints() {
        return this.m_uniqueConstraints;
    }

    protected Object invokeMethod(String methodName, Annotation annotation) {
        return MetadataHelper.invokeMethod(methodName, annotation);
    }

    public void processUniqueConstraints() {
        if (this.m_uniqueConstraints != null) {
            for (UniqueConstraintMetadata uniqueConstraint : this.m_uniqueConstraints) {
                this.m_databaseTable.addUniqueConstraints(uniqueConstraint.getColumnNames());
            }
        }
    }

    public void setFullyQualifiedTableName(String fullyQualifiedTableName) {
        this.m_databaseTable.setPossiblyQualifiedName(fullyQualifiedTableName);
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setDatabaseTable(DatabaseTable databaseTable) {
        this.m_databaseTable = databaseTable;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    protected void setUniqueConstraints(Annotation[] uniqueConstraints) {
        this.m_uniqueConstraints = new ArrayList<UniqueConstraintMetadata>();
        for (Annotation uniqueConstraint : uniqueConstraints) {
            this.m_uniqueConstraints.add(new UniqueConstraintMetadata(uniqueConstraint));
        }
    }

    public void setUniqueConstraints(List<UniqueConstraintMetadata> uniqueConstraints) {
        this.m_uniqueConstraints = uniqueConstraints;
    }
}

