/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();

    public EmbeddedIdAccessor() {
    }

    public EmbeddedIdAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    public void process() {
        if (this.getDescriptor().hasEmbeddedIdAttribute()) {
            throw ValidationException.multipleEmbeddedIdAnnotationsFound((Class)this.getJavaClass(), (String)this.getAttributeName(), (String)this.getDescriptor().getEmbeddedIdAttributeName());
        }
        if (this.getDescriptor().hasPrimaryKeyFields()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound((Class)this.getJavaClass(), (String)this.getAttributeName(), (String)this.getDescriptor().getIdAttributeName());
        }
        this.getDescriptor().setPKClass(this.getReferenceClass());
        this.getDescriptor().setEmbeddedIdAttributeName(this.getAttributeName());
        super.process();
        for (DatabaseField field : this.m_idFields.values()) {
            this.getDescriptor().addPrimaryKeyField(field);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping mapping, AttributeOverrideMetadata attributeOverride) {
        super.processAttributeOverride(mapping, attributeOverride);
        DatabaseField field = attributeOverride.getColumn().getDatabaseField();
        field.setTable(this.getDescriptor().getPrimaryTable());
        this.m_idFields.put(attributeOverride.getName(), field);
    }

    protected MetadataDescriptor processEmbeddableClass() {
        MetadataDescriptor embeddableDescriptor = super.processEmbeddableClass();
        if (embeddableDescriptor.getMappings().isEmpty()) {
            String accessType = embeddableDescriptor.usesPropertyAccess() ? EmbeddedAccessor.AccessType.PROPERTY.name() : EmbeddedAccessor.AccessType.FIELD.name();
            throw ValidationException.embeddedIdHasNoAttributes((Class)this.getDescriptor().getJavaClass(), (Class)embeddableDescriptor.getJavaClass(), (String)accessType);
        }
        for (DatabaseMapping mapping : embeddableDescriptor.getMappings()) {
            DatabaseField field = (DatabaseField)mapping.getField().clone();
            field.setTable(this.getDescriptor().getPrimaryTable());
            this.m_idFields.put(mapping.getAttributeName(), field);
        }
        return embeddableDescriptor;
    }
}

