/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.eclipse.persistence.annotations.ChangeTracking;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.TransformationAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VariableOneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VersionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.ChangeTrackingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLAttributes;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassAccessor
extends MetadataAccessor {
    private Boolean m_metadataComplete;
    private ChangeTrackingMetadata m_changeTracking;
    private Class m_customizerClass;
    private String m_access;
    private String m_className;
    private String m_customizerClassName;
    private String m_description;
    private String m_mappingFile;
    private XMLAttributes m_attributes;

    public ClassAccessor() {
    }

    public ClassAccessor(Class cls, MetadataProject project) {
        super(new MetadataClass(cls), new MetadataDescriptor(cls), project);
        this.getDescriptor().setClassAccessor(this);
    }

    protected ClassAccessor(Class cls, MetadataDescriptor descriptor, MetadataProject project) {
        super(new MetadataClass(cls), descriptor, project);
    }

    protected MetadataAccessor buildAccessor(MetadataAccessibleObject accessibleObject) {
        MetadataAccessor accessor = this.getDescriptor().getAccessorFor(accessibleObject.getAttributeName());
        if (accessor == null) {
            if (accessibleObject.isBasicCollection(this.getDescriptor())) {
                return new BasicCollectionAccessor(accessibleObject, this);
            }
            if (accessibleObject.isBasicMap(this.getDescriptor())) {
                return new BasicMapAccessor(accessibleObject, this);
            }
            if (accessibleObject.isId(this.getDescriptor())) {
                return new IdAccessor(accessibleObject, this);
            }
            if (accessibleObject.isVersion(this.getDescriptor())) {
                return new VersionAccessor(accessibleObject, this);
            }
            if (accessibleObject.isBasic(this.getDescriptor())) {
                return new BasicAccessor(accessibleObject, this);
            }
            if (accessibleObject.isEmbedded(this.getDescriptor())) {
                return new EmbeddedAccessor(accessibleObject, this);
            }
            if (accessibleObject.isEmbeddedId(this.getDescriptor())) {
                return new EmbeddedIdAccessor(accessibleObject, this);
            }
            if (accessibleObject.isTransformation(this.getDescriptor())) {
                return new TransformationAccessor(accessibleObject, this);
            }
            if (accessibleObject.isManyToMany(this.getDescriptor())) {
                return new ManyToManyAccessor(accessibleObject, this);
            }
            if (accessibleObject.isManyToOne(this.getDescriptor())) {
                return new ManyToOneAccessor(accessibleObject, this);
            }
            if (accessibleObject.isVariableOneToOne(this.getDescriptor())) {
                return new VariableOneToOneAccessor(accessibleObject, this);
            }
            if (accessibleObject.isOneToMany(this.getDescriptor())) {
                return new OneToManyAccessor(accessibleObject, this);
            }
            if (accessibleObject.isOneToOne(this.getDescriptor())) {
                return new OneToOneAccessor(accessibleObject, this);
            }
            return new BasicAccessor(accessibleObject, this);
        }
        return accessor;
    }

    public String getAccess() {
        return this.m_access;
    }

    public XMLAttributes getAttributes() {
        return this.m_attributes;
    }

    public ChangeTrackingMetadata getChangeTracking() {
        return this.m_changeTracking;
    }

    public String getClassName() {
        return this.m_className;
    }

    public Class getCustomizerClass() {
        return this.m_customizerClass;
    }

    public String getCustomizerClassName() {
        return this.m_customizerClassName;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected Field getFieldForName(String fieldName, Class javaClass) {
        Field field;
        block5: {
            field = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        field = (Field)AccessController.doPrivileged(new PrivilegedGetField(javaClass, fieldName, false));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        return null;
                    }
                }
                field = PrivilegedAccessHelper.getField((Class)javaClass, (String)fieldName, (boolean)false);
            }
            catch (NoSuchFieldException nsfex) {
                return null;
            }
        }
        return field;
    }

    @Override
    public Class getJavaClass() {
        return (Class)this.getAnnotatedElement();
    }

    @Override
    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        ArrayList<MappedSuperclassAccessor> mappedSuperclasses = new ArrayList<MappedSuperclassAccessor>();
        for (Class parent = this.getJavaClass().getSuperclass(); !(parent == Object.class || this.getDescriptor().isInheritanceSubclass() && this.getProject().hasEntity(parent)); parent = parent.getSuperclass()) {
            MappedSuperclassAccessor accessor = this.getProject().getMappedSuperclass(parent);
            if (accessor == null) {
                if (!this.isAnnotationPresent(MappedSuperclass.class, parent)) continue;
                mappedSuperclasses.add(new MappedSuperclassAccessor(parent, this.getDescriptor(), this.getProject()));
                continue;
            }
            mappedSuperclasses.add(accessor.getEntityMappings().reloadMappedSuperclass(accessor, this.getDescriptor()));
        }
        return mappedSuperclasses;
    }

    public String getMappingFile() {
        return this.m_mappingFile;
    }

    public Boolean getMetadataComplete() {
        return this.m_metadataComplete;
    }

    protected MetadataMethod getMetadataMethod(Method method, boolean userSpecified) {
        MetadataMethod metadataMethod = new MetadataMethod(method);
        if (metadataMethod.isValidPersistenceMethodName()) {
            if (metadataMethod.hasParameters()) {
                if (userSpecified) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments((Object)method, (Class)this.getJavaClass());
                }
            } else {
                if (metadataMethod.hasSetMethod()) {
                    return metadataMethod;
                }
                if (userSpecified) {
                    throw ValidationException.noCorrespondingSetterMethodDefined((Class)this.getJavaClass(), (Method)method);
                }
            }
        }
        return null;
    }

    public Method getMethodForPropertyName(String propertyName, Class cls) {
        String leadingChar = String.valueOf(propertyName.charAt(0)).toUpperCase();
        String restOfName = propertyName.substring(1);
        Method method = MetadataHelper.getMethod("get".concat(leadingChar).concat(restOfName), cls, new Class[0]);
        if (method == null) {
            method = MetadataHelper.getMethod("is".concat(leadingChar).concat(restOfName), cls, new Class[0]);
        }
        return method;
    }

    public boolean isMetadataComplete() {
        return this.m_metadataComplete != null && this.m_metadataComplete != false;
    }

    protected boolean isValidPersistenceElement(AnnotatedElement annotatedElement, int modifiers) {
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    @Override
    public abstract void process();

    protected void processAccessor(MetadataAccessor accessor) {
        if (!accessor.isProcessed()) {
            this.getDescriptor().addAccessor(accessor);
            accessor.processConverters();
            if (accessor.isBasicCollection()) {
                this.getDescriptor().addBasicCollectionAccessor(accessor);
            } else if (accessor.isRelationship()) {
                this.getDescriptor().addRelationshipAccessor(accessor);
            } else {
                accessor.process();
                accessor.setIsProcessed();
            }
        }
    }

    protected void processAccessorFields() {
        for (Field field : MetadataHelper.getFields(this.getJavaClass())) {
            if (this.isAnnotationPresent(Transient.class, field)) {
                if (MetadataHelper.getDeclaredAnnotationsCount(field, this.getDescriptor()) <= 1) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute((Object)field);
            }
            if (this.isValidPersistenceElement(field, field.getModifiers())) {
                this.processAccessor(this.buildAccessor(new MetadataField(field)));
                continue;
            }
            if (MetadataHelper.getDeclaredAnnotationsCount(field, this.getDescriptor()) <= 0) continue;
            throw ValidationException.mappingMetadataAppliedToInvalidAttribute((Object)field, (Class)this.getJavaClass());
        }
    }

    protected void processAccessorMethods() {
        for (Method method : MetadataHelper.getDeclaredMethods(this.getJavaClass())) {
            if (this.isAnnotationPresent(Transient.class, method)) {
                if (MetadataHelper.getDeclaredAnnotationsCount(method, this.getDescriptor()) <= 1) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute((Object)method);
            }
            if (this.isValidPersistenceElement(method, method.getModifiers())) {
                MetadataMethod metadataMethod = this.getMetadataMethod(method, MetadataHelper.getDeclaredAnnotationsCount(method, this.getDescriptor()) > 0);
                if (metadataMethod == null) continue;
                this.processAccessor(this.buildAccessor(metadataMethod));
                continue;
            }
            if (MetadataHelper.getDeclaredAnnotationsCount(method, this.getDescriptor()) <= 0) continue;
            throw ValidationException.mappingMetadataAppliedToInvalidAttribute((Object)method, (Class)this.getJavaClass());
        }
    }

    protected void processAccessors() {
        if (this.m_attributes != null) {
            for (MetadataAccessor accessor : this.m_attributes.getAccessors()) {
                MetadataAccessibleObject accessibleObject;
                if (this.getDescriptor().usesPropertyAccess()) {
                    Method method = this.getMethodForPropertyName(accessor.getName(), this.getJavaClass());
                    if (method == null) {
                        throw ValidationException.invalidPropertyForClass((String)accessor.getName(), (Class)this.getJavaClass());
                    }
                    if (!this.isValidPersistenceElement(method, method.getModifiers())) {
                        throw ValidationException.mappingMetadataAppliedToInvalidAttribute((Object)method, (Class)this.getJavaClass());
                    }
                    accessibleObject = this.getMetadataMethod(method, true);
                } else {
                    Field field = this.getFieldForName(accessor.getName(), this.getJavaClass());
                    if (field == null) {
                        throw ValidationException.invalidFieldForClass((String)accessor.getName(), (Class)this.getJavaClass());
                    }
                    if (!this.isValidPersistenceElement(field, field.getModifiers())) {
                        throw ValidationException.mappingMetadataAppliedToInvalidAttribute((Object)field, (Class)this.getJavaClass());
                    }
                    accessibleObject = new MetadataField(field);
                }
                accessor.init(accessibleObject, this);
                this.processAccessor(accessor);
            }
        }
        if (this.getDescriptor().usesPropertyAccess()) {
            this.processAccessorMethods();
        } else {
            this.processAccessorFields();
        }
    }

    protected void processBasicCollectionAccessors() {
        for (BasicCollectionAccessor accessor : this.getDescriptor().getBasicCollectionAccessors()) {
            accessor.process();
            accessor.setIsProcessed();
        }
    }

    protected void processChangeTracking() {
        if (this.m_changeTracking != null || this.isAnnotationPresent(ChangeTracking.class)) {
            if (this.getDescriptor().hasChangeTracking()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_change_tracking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_changeTracking == null) {
                new ChangeTrackingMetadata((Annotation)this.getAnnotation(ChangeTracking.class)).process(this.getDescriptor());
            } else {
                if (this.isAnnotationPresent(ChangeTracking.class)) {
                    this.getLogger().logWarningMessage("annotation_warning_ignore_change_tracking", this.getDescriptor().getJavaClass(), this.getJavaClass());
                }
                this.m_changeTracking.process(this.getDescriptor());
            }
        }
    }

    protected void processCustomizer() {
        if (this.m_customizerClassName != null || this.isAnnotationPresent(Customizer.class)) {
            if (this.getDescriptor().hasCustomizer()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_customizer", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_customizerClassName == null) {
                Object customizer = this.getAnnotation(Customizer.class);
                if (customizer != null) {
                    this.m_customizerClass = (Class)MetadataHelper.invokeMethod("value", customizer);
                    this.getProject().addAccessorWithCustomizer(this);
                }
            } else {
                if (this.isAnnotationPresent(Customizer.class)) {
                    this.getLogger().logWarningMessage("annotation_warning_ignore_customizer", this.getDescriptor().getJavaClass(), this.getJavaClass());
                }
                this.m_customizerClass = this.getEntityMappings().getClassForName(this.m_customizerClassName);
                this.getProject().addAccessorWithCustomizer(this);
            }
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setAttributes(XMLAttributes attributes) {
        this.m_attributes = attributes;
    }

    public void setChangeTracking(ChangeTrackingMetadata changeTracking) {
        this.m_changeTracking = changeTracking;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public void setCustomizerClassName(String customizerClassName) {
        this.m_customizerClassName = customizerClassName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setJavaClass(Class cls) {
        this.setAnnotatedElement(cls);
        this.getDescriptor().setJavaClass(cls);
    }

    public void setMappingFile(String mappingFile) {
        this.m_mappingFile = mappingFile;
    }

    public void setMetadataComplete(Boolean metadataComplete) {
        this.m_metadataComplete = metadataComplete;
    }
}

