/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class NamedNativeQueryMetadata
extends QueryMetadata {
    private Class m_resultClass;
    private String m_resultClassName;
    private String m_resultSetMapping;

    public NamedNativeQueryMetadata() {
        this.setLoadedFromXML();
    }

    public NamedNativeQueryMetadata(Annotation namedNativeQuery, String javaClassName) {
        this.setLoadedFromAnnotation();
        this.setLocation(javaClassName);
        this.setName((String)this.invokeMethod("name", namedNativeQuery));
        this.setQuery((String)this.invokeMethod("query", namedNativeQuery));
        this.setHints((Annotation[])this.invokeMethod("hints", namedNativeQuery));
        this.m_resultClass = (Class)this.invokeMethod("resultClass", namedNativeQuery);
        this.m_resultSetMapping = (String)this.invokeMethod("resultSetMapping", namedNativeQuery);
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedNativeQueryMetadata) {
            NamedNativeQueryMetadata namedNativeQuery = (NamedNativeQueryMetadata)objectToCompare;
            if (!MetadataHelper.valuesMatch(this.getName(), namedNativeQuery.getName())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.getQuery(), namedNativeQuery.getQuery())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.getResultClass(), namedNativeQuery.getResultClass())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.getResultSetMapping(), namedNativeQuery.getResultSetMapping())) {
                return false;
            }
            if (this.getHints().size() != namedNativeQuery.getHints().size()) {
                return false;
            }
            for (QueryHintMetadata hint : this.getHints()) {
                if (namedNativeQuery.hasHint(hint)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Class getResultClass() {
        return this.m_resultClass;
    }

    public String getResultClassName() {
        return this.m_resultClassName;
    }

    public String getResultSetMapping() {
        return this.m_resultSetMapping;
    }

    public void process(AbstractSession session, ClassLoader loader) {
        HashMap<String, String> hints = this.processQueryHints(session);
        if (this.m_resultClass == Void.TYPE) {
            if (this.m_resultSetMapping.equals("")) {
                session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.getQuery(), hints));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(this.m_resultSetMapping, this.getQuery(), hints));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildSQLDatabaseQuery(org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper.getClassForName(this.m_resultClass.getName(), loader), this.getQuery(), hints));
        }
    }

    public void setResultClass(Class resultClass) {
        this.m_resultClass = resultClass;
    }

    public void setResultClassName(String resultClassName) {
        this.m_resultClassName = resultClassName;
    }

    protected void setResultSetMapping(String resultSetMapping) {
        this.m_resultSetMapping = resultSetMapping;
    }
}

