/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import javax.persistence.ManyToOne;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class ManyToOneAccessor
extends ObjectAccessor {
    public ManyToOneAccessor() {
    }

    public ManyToOneAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object manyToOne = this.getAnnotation(ManyToOne.class);
        this.setTargetEntity((Class)MetadataHelper.invokeMethod("targetEntity", manyToOne));
        this.setCascadeTypes((Enum[])MetadataHelper.invokeMethod("cascade", manyToOne));
        this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", manyToOne));
        this.setOptional((Boolean)MetadataHelper.invokeMethod("optional", manyToOne));
    }

    protected String getLoggingContext() {
        return "metadata_default_many_to_one_reference_class";
    }

    public String getMappedBy() {
        throw new RuntimeException("Development exception. A mapped by value is not supported on a many to one.");
    }

    public boolean isManyToOne() {
        return true;
    }

    public boolean isPrivateOwned() {
        if (super.isPrivateOwned()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
        }
        return false;
    }

    public void process() {
        OneToOneMapping mapping = this.initOneToOneMapping();
        this.processOwningMappingKeys(mapping);
        this.getDescriptor().addMapping((DatabaseMapping)mapping);
    }
}

