/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToMany;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
    }

    public OneToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        Object oneToMany = this.getAnnotation(OneToMany.class);
        if (oneToMany != null) {
            this.setTargetEntity((Class)MetadataHelper.invokeMethod("targetEntity", oneToMany));
            this.setCascadeTypes((Enum[])MetadataHelper.invokeMethod("cascade", oneToMany));
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", oneToMany));
            this.setMappedBy((String)MetadataHelper.invokeMethod("mappedBy", oneToMany));
        } else {
            this.setTargetEntity(Void.TYPE);
            this.setCascadeTypes(new Enum[0]);
            this.setFetch(this.getDefaultFetchType());
            this.setMappedBy("");
        }
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    public boolean isOneToMany() {
        return true;
    }

    public void process() {
        super.process();
        String mappedBy = this.getMappedBy();
        if (mappedBy.equals("")) {
            if (this.isAnnotationPresent(JoinColumn.class) || this.isAnnotationPresent(JoinColumns.class)) {
                throw ValidationException.uniDirectionalOneToManyHasJoinColumnAnnotations((String)this.getAttributeName(), (Class)this.getJavaClass());
            }
            ManyToManyMapping mapping = new ManyToManyMapping();
            this.process((CollectionMapping)mapping);
            if (mapping.isPrivateOwned()) {
                this.getLogger().logWarningMessage("annotation_warning_ignore_private_owned", this);
                mapping.setIsPrivateOwned(false);
            }
            this.processJoinTable(mapping);
            this.getDescriptor().addMapping((DatabaseMapping)mapping);
        } else {
            OneToManyMapping mapping = new OneToManyMapping();
            this.process((CollectionMapping)mapping);
            OneToOneMapping ownerMapping = null;
            if (!this.getOwningMapping().isOneToOneMapping()) {
                throw ValidationException.invalidMapping((Class)this.getJavaClass(), (Class)this.getReferenceClass());
            }
            ownerMapping = (OneToOneMapping)this.getOwningMapping();
            Map keys = ownerMapping.getSourceToTargetKeyFields();
            for (DatabaseField fkField : keys.keySet()) {
                mapping.addTargetForeignKeyField(fkField, (DatabaseField)keys.get(fkField));
            }
            this.getDescriptor().addMapping((DatabaseMapping)mapping);
        }
    }
}

