/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.copypolicy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

final class MetadataHelper {
    MetadataHelper() {
    }

    static Object invokeMethod(String methodName, Object target) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(target.getClass(), (String)methodName);
        }
        catch (NoSuchMethodException e) {
            EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)target, (Exception)e);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, target));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)target);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)target, (Exception)throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod((Method)method, (Object)target);
            }
            catch (IllegalAccessException ex1) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject((Method)method, (Object)target);
            }
            catch (InvocationTargetException ex2) {
                throw EntityManagerSetupException.methodInvocationFailed((Method)method, (Object)target, (Exception)ex2);
            }
        }
        return null;
    }

    static Object initializeClass(Class clazz) {
        Object initializedClass;
        block6: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        initializedClass = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                        break block6;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.errorInstantiatingClass((Class)clazz, (Exception)exception.getException());
                    }
                }
                initializedClass = PrivilegedAccessHelper.newInstanceFromClass((Class)clazz);
            }
            catch (IllegalAccessException exception) {
                throw ValidationException.errorInstantiatingClass((Class)clazz, (Exception)exception);
            }
            catch (InstantiationException exception) {
                throw ValidationException.errorInstantiatingClass((Class)clazz, (Exception)exception);
            }
        }
        return initializedClass;
    }
}

