/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.factories.SessionFactory;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class JpaHelper {
    public static boolean isEclipseLink(EntityManager em) {
        return JpaHelper.getEntityManager(em) != null;
    }

    public static boolean isEclipseLink(EntityManagerFactory emf) {
        try {
            JpaHelper.getEntityManagerFactory(emf);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static boolean isEclipseLink(Query query) {
        try {
            JpaHelper.getReadAllQuery(query);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static boolean isReportQuery(Query query) {
        try {
            JpaHelper.getReportQuery(query);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    public static ReportQuery getReportQuery(Query query) {
        if (EJBQueryImpl.class.isAssignableFrom(query.getClass())) {
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            if (dbQuery.isReportQuery()) {
                return (ReportQuery)dbQuery;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_report_query" + query.getClass())));
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_query" + query.getClass())));
    }

    public static ReadAllQuery getReadAllQuery(Query query) {
        if (EJBQueryImpl.class.isAssignableFrom(query.getClass())) {
            DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
            if (dbQuery.isReadAllQuery()) {
                return (ReadAllQuery)dbQuery;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_read_all_query" + query.getClass())));
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_query" + query.getClass())));
    }

    public static Query createQuery(ReadAllQuery query, EntityManager em) {
        EntityManagerImpl emImpl = (EntityManagerImpl)JpaHelper.getEntityManager(em);
        return new EJBQueryImpl((DatabaseQuery)query, emImpl);
    }

    public static JpaEntityManager getEntityManager(EntityManager entityManager) {
        if (JpaEntityManager.class.isAssignableFrom(entityManager.getClass())) {
            return (JpaEntityManager)entityManager;
        }
        if (entityManager.getDelegate() != null) {
            return JpaHelper.getEntityManager((JpaEntityManager)entityManager.getDelegate());
        }
        return null;
    }

    public static EntityManagerFactoryImpl getEntityManagerFactory(EntityManagerFactory emf) {
        if (EntityManagerFactoryImpl.class.isAssignableFrom(emf.getClass())) {
            return (EntityManagerFactoryImpl)emf;
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)("jpa_helper_invalid_entity_manager_factory" + emf.getClass())));
    }

    public static Server getServerSession(EntityManagerFactory emf) {
        return JpaHelper.getEntityManagerFactory(emf).getServerSession();
    }

    public static EntityManagerFactory createEntityManagerFactory(Server session) {
        return new EntityManagerFactoryImpl((ServerSession)session);
    }

    public static EntityManagerFactoryImpl createEntityManagerFactory(String sessionName) {
        SessionFactory sf = new SessionFactory(sessionName);
        return new EntityManagerFactoryImpl((ServerSession)sf.getSharedSession());
    }
}

