/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.EJBQLPlaceHolderQuery;

public class NamedQueryMetadata
extends QueryMetadata {
    public NamedQueryMetadata() {
        this.setLoadedFromXML();
    }

    public NamedQueryMetadata(Annotation namedQuery, String javaClassName) {
        this.setLoadedFromAnnotation();
        this.setLocation(javaClassName);
        this.setName((String)this.invokeMethod("name", namedQuery));
        this.setQuery((String)this.invokeMethod("query", namedQuery));
        this.setHints((Annotation[])this.invokeMethod("hints", namedQuery));
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof NamedQueryMetadata) {
            NamedQueryMetadata namedQuery = (NamedQueryMetadata)objectToCompare;
            if (!MetadataHelper.valuesMatch(this.getName(), namedQuery.getName())) {
                return false;
            }
            if (!MetadataHelper.valuesMatch(this.getQuery(), namedQuery.getQuery())) {
                return false;
            }
            if (this.getHints().size() != namedQuery.getHints().size()) {
                return false;
            }
            for (QueryHintMetadata hint : this.getHints()) {
                if (namedQuery.hasHint(hint)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void process(AbstractSession session) {
        try {
            HashMap<String, String> hints = this.processQueryHints(session);
            session.addEjbqlPlaceHolderQuery((DatabaseQuery)new EJBQLPlaceHolderQuery(this.getName(), this.getQuery(), hints));
        }
        catch (Exception exception) {
            throw ValidationException.errorProcessingNamedQuery(this.getClass(), (String)this.getName(), (Exception)exception);
        }
    }
}

