/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.Converter;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.ObjectTypeConverter;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.annotations.StructConverter;
import org.eclipse.persistence.annotations.TypeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataAccessor {
    private boolean m_isProcessed;
    private Boolean m_isRelationship;
    private List<ConverterMetadata> m_converters;
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns;
    private List<StructConverterMetadata> m_structConverters;
    private List<TypeConverterMetadata> m_typeConverters;
    private MetadataAccessibleObject m_accessibleObject;
    private MetadataDescriptor m_descriptor;
    private MetadataDescriptor m_owningDescriptor;
    private MetadataProject m_project;
    private String m_name;
    private XMLEntityMappings m_entityMappings;
    private List<PropertyMetadata> m_properties;

    public MetadataAccessor() {
    }

    public MetadataAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        this.init(accessibleObject, classAccessor.getDescriptor(), classAccessor.getProject(), null);
    }

    public MetadataAccessor(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project) {
        this.init(accessibleObject, descriptor, project, null);
    }

    protected void checkForPropertiesConflictsInXml() {
        this.checkForPropertiesConflicts(true, 0);
    }

    protected void checkForPropertiesConflictsInAnnotations(int startIndex) {
        this.checkForPropertiesConflicts(false, startIndex);
    }

    protected void checkForPropertiesConflicts(boolean isXml, int startIndex) {
        int size = this.m_properties.size() - startIndex;
        if (size <= 1) {
            return;
        }
        HashMap<String, PropertyMetadata> map = new HashMap<String, PropertyMetadata>(size);
        for (int i = 0; i < size; ++i) {
            PropertyMetadata property = this.m_properties.get(startIndex + i);
            PropertyMetadata existingProperty = (PropertyMetadata)map.get(property.getName());
            if (existingProperty == null) {
                map.put(property.getName(), property);
                continue;
            }
            if (existingProperty.getValue().equals(property.getValue())) continue;
            if (this.getAttributeName() == null) {
                if (isXml) {
                    throw ValidationException.classPropertyConflictInXml((String)this.getJavaClassName(), (String)property.getName(), (String)existingProperty.getValue(), (String)property.getValue());
                }
                throw ValidationException.classPropertyConflictInAnnotations((String)this.getJavaClassName(), (String)property.getName(), (String)existingProperty.getValue(), (String)property.getValue());
            }
            if (isXml) {
                throw ValidationException.attributePropertyConflictInXml((String)this.getAttributeName(), (String)this.getJavaClassName(), (String)property.getName(), (String)existingProperty.getValue(), (String)property.getValue());
            }
            throw ValidationException.attributePropertyConflictInAnnotations((String)this.getAttributeName(), (String)this.getJavaClassName(), (String)property.getName(), (String)existingProperty.getValue(), (String)property.getValue());
        }
    }

    public MetadataAccessibleObject getAccessibleObject() {
        return this.m_accessibleObject;
    }

    public String getAccessibleObjectName() {
        return this.m_accessibleObject.getName();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_accessibleObject.getAnnotatedElement();
    }

    public String getAnnotatedElementName() {
        return this.getAnnotatedElement().toString();
    }

    protected <T extends Annotation> T getAnnotation(Class annotation) {
        return this.m_accessibleObject.getAnnotation(annotation, this.m_descriptor);
    }

    public String getAttributeName() {
        return this.m_accessibleObject.getAttributeName();
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    public MetadataDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public XMLEntityMappings getEntityMappings() {
        return this.m_entityMappings;
    }

    public Class getJavaClass() {
        return this.m_descriptor.getJavaClass();
    }

    protected String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    protected Class getMapKeyClass() {
        return this.m_accessibleObject.getMapKeyClass();
    }

    protected int getMappingJoinFetchType(Enum joinFetchType) {
        if (joinFetchType == null) {
            return 0;
        }
        if (joinFetchType.equals(JoinFetchType.INNER)) {
            return 1;
        }
        return 2;
    }

    public String getName() {
        return this.m_name;
    }

    protected String getName(DatabaseField field, String defaultName, String context) {
        return this.getName(field.getName(), defaultName, context);
    }

    protected String getName(String name, String defaultName, String context) {
        return MetadataHelper.getName(name, defaultName, context, this.getLogger(), this.getAnnotatedElement().toString());
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public MetadataDescriptor getOwningDescriptor() {
        if (this.m_owningDescriptor == null) {
            return this.getDescriptor();
        }
        return this.m_owningDescriptor;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<PropertyMetadata> getProperties() {
        return this.m_properties;
    }

    public Class getRawClass() {
        return this.m_accessibleObject.getRawClass();
    }

    public Class getReferenceClass() {
        return this.m_accessibleObject.getRawClass();
    }

    public Class getReferenceClassFromGeneric() {
        return this.m_accessibleObject.getReferenceClassFromGeneric();
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor accessor = this.m_project.getAccessor(this.getReferenceClassName());
        if (accessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit((String)this.getReferenceClassName());
        }
        return accessor.getDescriptor();
    }

    protected Type getRelationType() {
        return this.m_accessibleObject.getRelationType();
    }

    protected String getSetMethodName() {
        return ((MetadataMethod)this.m_accessibleObject).getSetMethodName();
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    protected String getUpperCaseAttributeName() {
        return this.getAttributeName().toUpperCase();
    }

    protected String getUpperCaseShortJavaClassName() {
        return Helper.getShortClassName((String)this.getJavaClassName()).toUpperCase();
    }

    protected Integer getValue(Integer value, Integer defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected String getValue(String value, String defaultValue) {
        return MetadataHelper.getValue(value, defaultValue);
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert() {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasPrimaryKeyJoinColumns() {
        return this.isAnnotationPresent(PrimaryKeyJoinColumns.class);
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public void init(MetadataAccessibleObject accessibleObject, ClassAccessor accessor) {
        this.init(accessibleObject, accessor.getDescriptor(), accessor.getProject(), accessor.getEntityMappings());
    }

    public void init(MetadataAccessibleObject accessibleObject, MetadataDescriptor descriptor, MetadataProject project, XMLEntityMappings entityMappings) {
        this.m_isProcessed = false;
        this.m_project = project;
        this.m_descriptor = descriptor;
        this.m_entityMappings = entityMappings;
        this.m_accessibleObject = accessibleObject;
        this.initProperties();
    }

    protected void initProperties() {
        boolean shouldProcessPropertyAnnotations;
        if (this.m_entityMappings != null) {
            if (this.m_properties != null) {
                for (PropertyMetadata property : this.m_properties) {
                    if (property.getValueTypeName() == null || property.getValueTypeName().length() <= 0) continue;
                    property.setValueType(this.m_entityMappings.getClassForName(property.getValueTypeName()));
                }
                this.checkForPropertiesConflictsInXml();
            }
            shouldProcessPropertyAnnotations = this.isClassAccessor();
        } else {
            shouldProcessPropertyAnnotations = true;
        }
        if (shouldProcessPropertyAnnotations) {
            Properties properties;
            PropertyMetadata property;
            int startIndex = this.m_properties != null ? this.m_properties.size() : 0;
            property = (Property)this.getAnnotation(Property.class);
            if (property != null) {
                this.addProperty((Property)property);
            }
            if ((properties = (Properties)this.getAnnotation(Properties.class)) != null) {
                Property[] propertyArray = properties.value();
                for (int i = 0; i < propertyArray.length; ++i) {
                    this.addProperty(propertyArray[i]);
                }
            }
            if (this.m_properties != null) {
                this.checkForPropertiesConflictsInAnnotations(startIndex);
            }
        }
    }

    protected void addProperty(Property property) {
        PropertyMetadata propertyMetadata = new PropertyMetadata();
        propertyMetadata.setName((String)org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper.invokeMethod("name", property));
        propertyMetadata.setValue((String)org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper.invokeMethod("value", property));
        propertyMetadata.setValueType((Class)org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper.invokeMethod("valueType", property));
        if (this.m_properties == null) {
            this.m_properties = new ArrayList<PropertyMetadata>();
        }
        this.m_properties.add(propertyMetadata);
    }

    protected boolean isAnnotationNotPresent(Class<? extends Annotation> annotation, AnnotatedElement annotatedElement) {
        return this.m_accessibleObject.isAnnotationNotPresent(annotation, annotatedElement);
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        return this.m_accessibleObject.isAnnotationPresent(annotation, this.getAnnotatedElement(), this.m_descriptor);
    }

    protected boolean isAnnotationPresent(Class<? extends Annotation> annotation, AnnotatedElement annotatedElement) {
        return this.m_accessibleObject.isAnnotationPresent(annotation, annotatedElement, this.m_descriptor);
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isClassAccessor() {
        return false;
    }

    public boolean isDirect() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isMappingAccessor() {
        return this.isDirect() || this.isRelationship() || this.isEmbedded();
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    public boolean isProcessed() {
        return this.m_isProcessed;
    }

    public boolean isRelationship() {
        if (this.m_isRelationship == null) {
            this.m_isRelationship = new Boolean(this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne());
        }
        return this.m_isRelationship;
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    public abstract void process();

    public void processConverters() {
        this.processCustomConverters();
        this.processObjectTypeConverters();
        this.processTypeConverters();
        this.processStructConverter();
    }

    protected void processCustomConverters() {
        Object converter;
        if (this.m_converters != null) {
            this.getEntityMappings().processConverters(this.m_converters);
        }
        if ((converter = this.getAnnotation(Converter.class)) != null) {
            this.m_project.addConverter(new ConverterMetadata((Annotation)converter, this.getAnnotatedElement()));
        }
    }

    protected void processObjectTypeConverters() {
        Object converter;
        if (this.m_objectTypeConverters != null) {
            this.getEntityMappings().processObjectTypeConverters(this.m_objectTypeConverters);
        }
        if ((converter = this.getAnnotation(ObjectTypeConverter.class)) != null) {
            this.m_project.addConverter(new ObjectTypeConverterMetadata((Annotation)converter, this.getAnnotatedElement()));
        }
    }

    protected List<PrimaryKeyJoinColumnMetadata> processPrimaryKeyJoinColumns(PrimaryKeyJoinColumnsMetadata primaryKeyJoinColumns) {
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = primaryKeyJoinColumns.values(this.m_descriptor);
        if (this.m_descriptor.hasCompositePrimaryKey()) {
            if (pkJoinColumns.size() != this.m_descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
            for (PrimaryKeyJoinColumnMetadata pkJoinColumn : pkJoinColumns) {
                if (!pkJoinColumn.isPrimaryKeyFieldNotSpecified() && !pkJoinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompletePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
            }
        } else if (pkJoinColumns.size() > 1) {
            throw ValidationException.excessivePrimaryKeyJoinColumnsSpecified((Object)this.getAnnotatedElement());
        }
        return pkJoinColumns;
    }

    protected void processProperties(DatabaseMapping mapping) {
        if (this.m_properties != null && !this.m_properties.isEmpty()) {
            this.processProperties(mapping.getProperties(), mapping.getAttributeName());
        }
    }

    protected void processProperties() {
        if (this.m_properties != null && !this.m_properties.isEmpty()) {
            this.processProperties(this.m_descriptor.getClassDescriptor().getProperties(), null);
        }
    }

    protected void processProperties(Map map, String attributeName) {
        for (PropertyMetadata property : this.m_properties) {
            Object overridingConvertedValue = map.get(property.getName());
            if (overridingConvertedValue == null) {
                map.put(property.getName(), property.getConvertedValue());
                continue;
            }
            if (attributeName == null) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_property_for_class", this.getDescriptor().getJavaClass(), property.getName(), property.getConvertedValue(), overridingConvertedValue);
                continue;
            }
            this.getLogger().logWarningMessage("metadata_warning_ignore_property_for_attribute", attributeName, this.getDescriptor().getJavaClass(), property.getName(), property.getConvertedValue(), overridingConvertedValue);
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    protected void processStructConverter() {
        Object converter;
        if (this.m_structConverters != null) {
            this.getEntityMappings().processStructConverters(this.m_structConverters);
        }
        if ((converter = this.getAnnotation(StructConverter.class)) != null) {
            this.m_project.addStructConverter(new StructConverterMetadata((Annotation)converter, this.getAnnotatedElement()));
        }
    }

    protected void processTable(TableMetadata table, String defaultName) {
        this.getProject().processTable(table, defaultName, this.m_descriptor.getXMLCatalog(), this.m_descriptor.getXMLSchema());
    }

    protected void processTypeConverters() {
        Object converter;
        if (this.m_typeConverters != null) {
            this.getEntityMappings().processTypeConverters(this.m_typeConverters);
        }
        if ((converter = this.getAnnotation(TypeConverter.class)) != null) {
            this.m_project.addConverter(new TypeConverterMetadata((Annotation)converter, this.getAnnotatedElement()));
        }
    }

    public void setAccessibleObject(MetadataAccessibleObject accessibleObject) {
        this.m_accessibleObject = accessibleObject;
    }

    protected void setAccessorMethods(DatabaseMapping mapping) {
        if (this.m_descriptor.usesPropertyAccess()) {
            mapping.setGetMethodName(this.getAccessibleObjectName());
            mapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_accessibleObject.setAnnotatedElement(annotatedElement);
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescriptor(MetadataDescriptor descriptor) {
        this.m_descriptor = descriptor;
    }

    public void setEntityMappings(XMLEntityMappings entityMappings) {
        this.m_entityMappings = entityMappings;
    }

    public void setIndirectionPolicy(CollectionMapping mapping, String mapKey, boolean usesIndirection) {
        Class rawClass = this.getRawClass();
        if (usesIndirection) {
            if (rawClass == Map.class) {
                mapping.useTransparentMap(mapKey);
            } else if (rawClass == List.class) {
                mapping.useTransparentList();
            } else if (rawClass == Collection.class) {
                mapping.useTransparentCollection();
                mapping.setContainerPolicy((ContainerPolicy)new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (rawClass == Set.class) {
                mapping.useTransparentSet();
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass == Map.class) {
                mapping.useMapClass(Hashtable.class, mapKey);
            } else if (rawClass == Set.class) {
                mapping.useCollectionClass(HashSet.class);
            } else {
                mapping.useCollectionClass(Vector.class);
            }
        }
    }

    public void setIsProcessed() {
        this.m_isProcessed = true;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setOwningDescriptor(MetadataDescriptor owningDescriptor) {
        this.m_owningDescriptor = owningDescriptor;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }

    public void setProperties(List<PropertyMetadata> properties) {
        this.m_properties = properties;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }
}

