/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.XMLParseException;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.PersistenceContentHandler;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLException;
import org.eclipse.persistence.internal.jpa.deployment.xml.parser.XMLExceptionHandler;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitProcessor {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String PERSISTENCE_SCHEMA_NAME = "xsd/persistence_1_0.xsd";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public static String buildClassNameFromEntryString(String classEntryString) {
        String classNameForLoader = classEntryString;
        if (classEntryString.endsWith(".class")) {
            classNameForLoader = classNameForLoader.substring(0, classNameForLoader.length() - 6);
            classNameForLoader = classNameForLoader.replace("/", ".");
        }
        return classNameForLoader;
    }

    public static Set<String> buildClassSet(PersistenceUnitInfo persistenceUnitInfo, ClassLoader loader) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(persistenceUnitInfo.getManagedClassNames());
        Iterator i = persistenceUnitInfo.getJarFileUrls().iterator();
        while (i.hasNext()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL((URL)i.next()));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            set.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl()));
        }
        set.addAll(PersistenceUnitProcessor.buildPersistentClassSetFromXMLDocuments(persistenceUnitInfo, loader));
        return set;
    }

    public static Collection<Class> buildEntityList(MetadataProject project, ClassLoader loader) {
        ArrayList<Class> entityList = new ArrayList<Class>();
        for (String className : project.getWeavableClassNames()) {
            try {
                Class<?> entityClass = loader.loadClass(className);
                entityList.add(entityClass);
            }
            catch (ClassNotFoundException exc) {
                AbstractSessionLog.getLog().log(4, "exception_loading_entity_class", (Object)className, (Object)exc);
            }
        }
        return entityList;
    }

    private static Set<String> buildPersistentClassSetFromXMLDocuments(PersistenceUnitInfo info, ClassLoader loader) {
        MetadataProcessor processor = new MetadataProcessor(info, null, loader, false);
        processor.readMappingFiles(false);
        return processor.getPersistenceUnitClassSetFromMappingFiles();
    }

    public static URL computePURootURL(URL pxmlURL) throws IOException {
        String protocol = pxmlURL.getProtocol();
        if ("file".equals(protocol)) {
            assert (new File(pxmlURL.getFile()).isFile());
            return new URL(pxmlURL, "..");
        }
        if ("jar".equals(protocol)) {
            JarURLConnection conn = (JarURLConnection)JarURLConnection.class.cast(pxmlURL.openConnection());
            assert (conn.getJarEntry().getName().equals("META-INF/persistence.xml"));
            return conn.getJarFileURL();
        }
        return new URL(pxmlURL, "../");
    }

    public static Set<Archive> findPersistenceArchives() {
        ClassLoader threadLoader = Thread.currentThread().getContextClassLoader();
        return PersistenceUnitProcessor.findPersistenceArchives(threadLoader);
    }

    public static Set<Archive> findPersistenceArchives(ClassLoader loader) {
        HashSet<Archive> pars = new HashSet<Archive>();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/persistence.xml");
            while (resources.hasMoreElements()) {
                URL pxmlURL = resources.nextElement();
                URL puRootURL = PersistenceUnitProcessor.computePURootURL(pxmlURL);
                Archive archive = new ArchiveFactoryImpl().createArchive(puRootURL);
                pars.add(archive);
            }
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources((ClassLoader)loader, (Exception)exc);
        }
        catch (URISyntaxException exc) {
            throw PersistenceUnitLoadingException.exceptionSearchingForPersistenceResources((ClassLoader)loader, (Exception)exc);
        }
        return pars;
    }

    public static Set<String> getClassNamesFromURL(URL url) {
        HashSet<String> classNames = new HashSet<String>();
        Archive archive = null;
        try {
            archive = new ArchiveFactoryImpl().createArchive(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("url = [" + url + "]", e);
        }
        catch (IOException e) {
            throw new RuntimeException("url = [" + url + "]", e);
        }
        Iterator entries = archive.getEntries();
        while (entries.hasNext()) {
            String entry = (String)entries.next();
            if (!entry.endsWith(".class")) continue;
            classNames.add(PersistenceUnitProcessor.buildClassNameFromEntryString(entry));
        }
        return classNames;
    }

    public static List<SEPersistenceUnitInfo> getPersistenceUnits(Archive archive, ClassLoader loader) {
        return PersistenceUnitProcessor.processPersistenceArchive(archive, loader);
    }

    public static boolean isEmbeddable(Class candidateClass) {
        return MetadataHelper.isAnnotationPresent(Embeddable.class, candidateClass);
    }

    public static boolean isEntity(Class candidateClass) {
        return MetadataHelper.isAnnotationPresent(Entity.class, candidateClass);
    }

    public static Class loadClass(String className, ClassLoader loader, boolean throwExceptionIfNotFound, MetadataProject project) {
        Class<?> candidateClass = null;
        try {
            candidateClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException exc) {
            if (throwExceptionIfNotFound) {
                throw PersistenceUnitLoadingException.exceptionLoadingClassWhileLookingForAnnotations((String)className, (Exception)exc);
            }
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", (Object)exc.getClass().getName(), (Object)exc.getLocalizedMessage(), (Object)className);
        }
        catch (NullPointerException npe) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class_weaving_disabled", (Object)loader, (Object)project.getPersistenceUnitInfo().getPersistenceUnitName(), (Object)className);
            project.setWeavingEnabled(false);
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(6, "persistence_unit_processor_error_loading_class", (Object)exception.getClass().getName(), (Object)exception.getLocalizedMessage(), (Object)className);
        }
        return candidateClass;
    }

    public static void processORMetadata(MetadataProcessor processor, boolean throwExceptionOnFail) {
        processor.readMappingFiles(throwExceptionOnFail);
        processor.processEntityMappings();
        processor.processAnnotations();
    }

    public static List<SEPersistenceUnitInfo> processPersistenceArchive(Archive archive, ClassLoader loader) {
        URL puRootURL = archive.getRootURL();
        try {
            InputStream pxmlStream = archive.getEntry("META-INF/persistence.xml");
            return PersistenceUnitProcessor.processPersistenceXML(puRootURL, pxmlStream, loader);
        }
        catch (IOException e) {
            throw PersistenceUnitLoadingException.exceptionLoadingFromUrl((String)puRootURL.toString(), (Exception)e);
        }
    }

    private static List<SEPersistenceUnitInfo> processPersistenceXML(URL baseURL, InputStream input, ClassLoader loader) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(true);
        XMLReader xmlReader = null;
        SAXParser sp = null;
        XMLExceptionHandler xmlErrorHandler = new XMLExceptionHandler();
        try {
            sp = spf.newSAXParser();
            sp.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
        }
        catch (ParserConfigurationException exc) {
            throw XMLParseException.exceptionCreatingSAXParser((URL)baseURL, (Exception)exc);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingSAXParser((URL)baseURL, (Exception)exc);
        }
        try {
            xmlReader = sp.getXMLReader();
            xmlReader.setErrorHandler(xmlErrorHandler);
        }
        catch (SAXException exc) {
            throw XMLParseException.exceptionCreatingXMLReader((URL)baseURL, (Exception)exc);
        }
        URL schemaURL = loader.getResource(PERSISTENCE_SCHEMA_NAME);
        if (schemaURL != null) {
            try {
                sp.setProperty(JAXP_SCHEMA_SOURCE, schemaURL.toString());
            }
            catch (SAXException exc) {
                throw XMLParseException.exceptionSettingSchemaSource((URL)baseURL, (URL)schemaURL, (Exception)exc);
            }
        }
        PersistenceContentHandler myContentHandler = new PersistenceContentHandler();
        xmlReader.setContentHandler(myContentHandler);
        InputSource inputSource = new InputSource(input);
        try {
            xmlReader.parse(inputSource);
        }
        catch (IOException exc) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML((URL)baseURL, (Exception)exc);
        }
        catch (SAXException exc) {
            // empty catch block
        }
        XMLException xmlError = xmlErrorHandler.getXMLException();
        if (xmlError != null) {
            throw PersistenceUnitLoadingException.exceptionProcessingPersistenceXML((URL)baseURL, (Exception)xmlError);
        }
        for (SEPersistenceUnitInfo info : myContentHandler.getPersistenceUnits()) {
            info.setPersistenceUnitRootUrl(baseURL);
        }
        return myContentHandler.getPersistenceUnits();
    }

    public static String buildPersistenceUnitName(URL url, String puName) {
        String fullPuName = null;
        try {
            fullPuName = URLDecoder.decode(url.toString(), "UTF8") + puName;
        }
        catch (UnsupportedEncodingException e) {
            throw PersistenceUnitLoadingException.couldNotBuildPersistenceUntiName((Exception)e, (String)url.toString(), (String)puName);
        }
        return fullPuName;
    }
}

