/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.spi.PersistenceUnitInfo;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.factories.DescriptorCustomizer;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.platform.database.converters.StructConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProcessor {
    protected ClassLoader m_loader;
    protected MetadataProject m_project;
    protected AbstractSession m_session;

    public MetadataProcessor(PersistenceUnitInfo puInfo, AbstractSession session, ClassLoader loader, boolean enableLazyForOneToOne) {
        this.m_loader = loader;
        this.m_session = session;
        this.m_project = new MetadataProject(puInfo, session, enableLazyForOneToOne);
    }

    public void addEntityListeners() {
        for (EntityAccessor accessor : this.m_project.getEntityAccessors()) {
            accessor.setJavaClass(accessor.getDescriptor().getClassDescriptor().getJavaClass());
            accessor.processListeners(this.m_loader);
        }
    }

    public void addNamedQueries() {
        this.m_project.processNamedQueries();
        this.m_project.processNamedNativeQueries(this.m_loader);
        this.m_project.processNamedStoredProcedureQueries(this.m_loader);
    }

    public Set<String> getPersistenceUnitClassSetFromMappingFiles() {
        HashSet<String> classSet = new HashSet<String>();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            for (EntityAccessor entity : entityMappings.getEntities()) {
                classSet.add(entityMappings.getFullyQualifiedClassName(entity.getClassName()));
            }
            for (EmbeddableAccessor embeddable : entityMappings.getEmbeddables()) {
                classSet.add(entityMappings.getFullyQualifiedClassName(embeddable.getClassName()));
            }
            for (MappedSuperclassAccessor mappedSuperclass : entityMappings.getMappedSuperclasses()) {
                classSet.add(entityMappings.getFullyQualifiedClassName(mappedSuperclass.getClassName()));
            }
        }
        return classSet;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public List<StructConverter> getStructConverters() {
        ArrayList<StructConverter> structConverters = new ArrayList<StructConverter>();
        for (StructConverterMetadata converter : this.m_project.getStructConverters().values()) {
            StructConverter structConverter = (StructConverter)MetadataHelper.getClassInstance(converter.getConverterClassName(), this.m_loader);
            structConverters.add(structConverter);
        }
        return structConverters;
    }

    protected void handleORMException(RuntimeException e, String mappingFile, boolean throwException) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(4, "error_loading_xml_file", new Object[]{mappingFile, e});
        } else if (!throwException) {
            this.m_session.log(4, "ejb_or_metadata", "error_loading_xml_file", new Object[]{mappingFile, e});
        } else {
            this.m_session.handleException(e);
        }
    }

    protected void initPersistenceUnitClasses() {
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.initPersistenceUnitClasses();
        }
        PersistenceUnitInfo persistenceUnitInfo = this.m_project.getPersistenceUnitInfo();
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.addAll(persistenceUnitInfo.getManagedClassNames());
        for (URL url : persistenceUnitInfo.getJarFileUrls()) {
            classNames.addAll(PersistenceUnitProcessor.getClassNamesFromURL(url));
        }
        if (!persistenceUnitInfo.excludeUnlistedClasses()) {
            classNames.addAll(PersistenceUnitProcessor.getClassNamesFromURL(persistenceUnitInfo.getPersistenceUnitRootUrl()));
        }
        for (String className : classNames) {
            Class candidateClass = PersistenceUnitProcessor.loadClass(className, this.m_loader, true, this.getProject());
            if (null == candidateClass) continue;
            if (PersistenceUnitProcessor.isEntity(candidateClass) && !this.m_project.hasEntity(candidateClass)) {
                this.m_project.addEntityAccessor(new EntityAccessor(candidateClass, this.m_project));
                continue;
            }
            if (!PersistenceUnitProcessor.isEmbeddable(candidateClass) || this.m_project.hasEmbeddable(candidateClass)) continue;
            this.m_project.addEmbeddableAccessor(new EmbeddableAccessor(candidateClass, this.m_project));
        }
    }

    protected void logMessage(String message) {
        if (this.m_session == null) {
            AbstractSessionLog.getLog().log(2, message);
        } else {
            this.m_session.logMessage(message);
        }
    }

    public void processAnnotations() {
        for (EntityAccessor accessor : this.m_project.getEntityAccessors()) {
            if (accessor.isProcessed()) continue;
            accessor.process();
            accessor.setIsProcessed();
        }
        this.m_project.process();
    }

    public void processCustomizers() {
        for (ClassAccessor classAccessor : this.m_project.getAccessorsWithCustomizer()) {
            DescriptorCustomizer customizer = (DescriptorCustomizer)MetadataHelper.getClassInstance(classAccessor.getCustomizerClass().getName(), this.m_loader);
            try {
                customizer.customize(classAccessor.getDescriptor().getClassDescriptor());
            }
            catch (Exception e) {}
        }
    }

    public void processEntityMappings() {
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.setLoader(this.m_loader);
            entityMappings.setProject(this.m_project);
            entityMappings.processPersistenceUnitMetadata();
        }
        this.initPersistenceUnitClasses();
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.process();
        }
    }

    public void readMappingFiles(boolean throwExceptionOnFail) {
        this.readStandardMappingFiles();
        this.readSpecifiedMappingFiles(throwExceptionOnFail);
    }

    protected void readSpecifiedMappingFiles(boolean throwExceptionOnFail) {
        PersistenceUnitInfo puInfo = this.m_project.getPersistenceUnitInfo();
        for (String mappingFileName : puInfo.getMappingFileNames()) {
            try {
                Enumeration<URL> mappingFileURLs = this.m_loader.getResources(mappingFileName);
                if (mappingFileURLs.hasMoreElements()) {
                    URL nextURL = mappingFileURLs.nextElement();
                    if (mappingFileURLs.hasMoreElements()) {
                        this.handleORMException((RuntimeException)((Object)ValidationException.nonUniqueMappingFileName((String)puInfo.getPersistenceUnitName(), (String)mappingFileName)), mappingFileName, throwExceptionOnFail);
                    }
                    this.m_project.addEntityMappings(XMLEntityMappingsReader.read(nextURL, this.m_loader));
                    continue;
                }
                this.handleORMException((RuntimeException)((Object)ValidationException.mappingFileNotFound((String)puInfo.getPersistenceUnitName(), (String)mappingFileName)), mappingFileName, throwExceptionOnFail);
            }
            catch (IOException e) {
                this.handleORMException((RuntimeException)PersistenceUnitLoadingException.exceptionLoadingORMXML((String)mappingFileName, (Exception)e), mappingFileName, throwExceptionOnFail);
            }
        }
    }

    protected void readStandardMappingFiles() {
        PersistenceUnitInfo puInfo = this.m_project.getPersistenceUnitInfo();
        HashSet<URL> rootUrls = new HashSet<URL>(puInfo.getJarFileUrls());
        rootUrls.add(puInfo.getPersistenceUnitRootUrl());
        String ormXMLFile = "META-INF/orm.xml";
        for (URL rootURL : rootUrls) {
            this.logMessage("Searching for default mapping file in " + rootURL);
            URL ormURL = null;
            try {
                Archive m_par = null;
                m_par = new ArchiveFactoryImpl().createArchive(rootURL);
                ormURL = m_par.getEntryAsURL(ormXMLFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (ormURL == null) continue;
            this.logMessage("Found a default mapping file at " + ormURL + " for root URL " + rootURL);
            try {
                this.m_project.addEntityMappings(XMLEntityMappingsReader.read(ormURL, this.m_loader));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_loader = loader;
        for (XMLEntityMappings entityMappings : this.m_project.getEntityMappings()) {
            entityMappings.setLoader(this.m_loader);
        }
    }
}

