/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.copypolicy;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.MetadataHelper;

public class CloneCopyPolicyMetadata
extends CopyPolicyMetadata {
    private String methodName;
    private String workingCopyMethodName;

    public CloneCopyPolicyMetadata() {
    }

    public CloneCopyPolicyMetadata(Annotation copyPolicy) {
        this.methodName = (String)MetadataHelper.invokeMethod("method", copyPolicy);
        this.workingCopyMethodName = (String)MetadataHelper.invokeMethod("workingCopyMethod", copyPolicy);
    }

    public CopyPolicy getCopyPolicy() {
        if (this.methodName == null && this.workingCopyMethodName == null) {
            throw ValidationException.copyPolicyMustSpecifyEitherMethodOrWorkingCopyMethod((String)this.javaClassName);
        }
        CloneCopyPolicy copyPolicy = new CloneCopyPolicy();
        copyPolicy.setMethodName(this.methodName);
        copyPolicy.setWorkingCopyMethodName(this.workingCopyMethodName);
        return copyPolicy;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getWorkingCopyMethodName() {
        return this.workingCopyMethodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setWorkingCopyMethodName(String workingCopyMethodName) {
        this.workingCopyMethodName = workingCopyMethodName;
    }
}

