/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;

public class WriteTransformerMetadata
extends ReadTransformerMetadata {
    private ColumnMetadata m_column;

    protected void applyClass(TransformationMapping mapping) {
        if (!FieldTransformer.class.isAssignableFrom(this.getTransformerClass())) {
            throw ValidationException.writeTransformerClassDoesntImplementFieldTransformer((String)mapping.getAttributeName(), (String)mapping.getDescriptor().getJavaClassName(), (String)this.m_column.getName());
        }
        mapping.addFieldTransformerClassName(this.m_column.getDatabaseField(), this.getTransformerClass().getName());
    }

    protected void applyMethod(TransformationMapping mapping) {
        mapping.addFieldTransformation(this.m_column.getDatabaseField(), this.getMethod());
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    public boolean hasFieldName() {
        return this.m_column != null && this.m_column.getName() != null && this.m_column.getName().length() > 0;
    }

    public void process(TransformationMapping mapping) {
        if (!this.hasFieldName()) {
            throw ValidationException.writeTransformerHasNoColumnName((String)mapping.getAttributeName(), (String)mapping.getDescriptor().getJavaClassName());
        }
        super.process(mapping);
    }

    public void setColumn(ColumnMetadata column) {
        this.m_column = column;
    }

    public void setFieldName(String fieldName) {
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata();
        }
        this.m_column.setName(fieldName);
    }

    protected void throwBothClassAndMethodSpecifiedException(TransformationMapping mapping) {
        throw ValidationException.writeTransformerHasBothClassAndMethod((String)mapping.getAttributeName(), (String)mapping.getDescriptor().getJavaClassName(), (String)this.m_column.getName());
    }

    protected void throwNeitherClassNorMethodSpecifiedException(TransformationMapping mapping) {
        throw ValidationException.writeTransformerHasNeitherClassNorMethod((String)mapping.getAttributeName(), (String)mapping.getDescriptor().getJavaClassName(), (String)this.m_column.getName());
    }
}

