/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.QueryHintMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryMetadata {
    private boolean m_loadedFromXML;
    private List<QueryHintMetadata> m_hints;
    private String m_location;
    private String m_name;
    private String m_query;

    public List<QueryHintMetadata> getHints() {
        return this.m_hints;
    }

    public String getLocation() {
        return this.m_location;
    }

    public String getName() {
        return this.m_name;
    }

    public String getQuery() {
        return this.m_query;
    }

    protected boolean hasHint(QueryHintMetadata hint) {
        for (QueryHintMetadata myHint : this.getHints()) {
            if (!org.eclipse.persistence.internal.jpa.metadata.MetadataHelper.valuesMatch(myHint.getName(), hint.getName()) || !org.eclipse.persistence.internal.jpa.metadata.MetadataHelper.valuesMatch(myHint.getValue(), hint.getValue())) continue;
            return true;
        }
        return false;
    }

    protected Object invokeMethod(String methodName, Annotation annotation) {
        return MetadataHelper.invokeMethod(methodName, annotation);
    }

    public boolean loadedFromAnnotation() {
        return !this.loadedFromXML();
    }

    public boolean loadedFromXML() {
        return this.m_loadedFromXML;
    }

    protected HashMap<String, String> processQueryHints(AbstractSession session) {
        HashMap<String, String> hints = new HashMap<String, String>();
        for (QueryHintMetadata hint : this.m_hints) {
            QueryHintsHandler.verify(hint.getName(), hint.getValue(), this.m_name, session);
            hints.put(hint.getName(), hint.getValue());
        }
        return hints;
    }

    public void setHints(List<QueryHintMetadata> hints) {
        this.m_hints = hints;
    }

    protected void setHints(Annotation[] hints) {
        this.m_hints = new ArrayList<QueryHintMetadata>();
        for (Annotation hint : hints) {
            this.m_hints.add(new QueryHintMetadata((String)this.invokeMethod("name", hint), (String)this.invokeMethod("value", hint)));
        }
    }

    public void setLoadedFromAnnotation() {
        this.m_loadedFromXML = false;
    }

    public void setLoadedFromXML() {
        this.m_loadedFromXML = true;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setQuery(String query) {
        this.m_query = query;
    }
}

