/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.util.Iterator;
import javax.xml.bind.Binder;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.eclipse.persistence.jaxb.JAXBBinder;
import org.eclipse.persistence.jaxb.JAXBIntrospector;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.JAXBValidator;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.oxm.XMLContext;

public class JAXBContext
extends javax.xml.bind.JAXBContext {
    private XMLContext xmlContext;
    private Generator generator;

    public JAXBContext(XMLContext context) {
        this.xmlContext = context;
    }

    public JAXBContext(XMLContext context, Generator generator) {
        this.xmlContext = context;
        this.generator = generator;
    }

    public void generateSchema(SchemaOutputResolver outputResolver) {
        if (this.generator == null) {
            return;
        }
        this.generator.generateSchemaFiles(outputResolver, null);
    }

    public Marshaller createMarshaller() {
        JAXBMarshaller marshaller = new JAXBMarshaller(this.xmlContext.createMarshaller(), new JAXBIntrospector(this.xmlContext));
        if (this.generator != null && this.generator.hasMarshalCallbacks()) {
            Iterator callIt = this.generator.getMarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                MarshalCallback cb = (MarshalCallback)this.generator.getMarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            marshaller.setMarshalCallbacks(this.generator.getMarshalCallbacks());
        }
        return marshaller;
    }

    public Unmarshaller createUnmarshaller() {
        JAXBUnmarshaller unmarshaller = new JAXBUnmarshaller(this.xmlContext.createUnmarshaller());
        if (this.generator != null && this.generator.hasUnmarshalCallbacks()) {
            Iterator callIt = this.generator.getUnmarshalCallbacks().keySet().iterator();
            while (callIt.hasNext()) {
                UnmarshalCallback cb = (UnmarshalCallback)this.generator.getUnmarshalCallbacks().get(callIt.next());
                cb.initialize(this.generator.getClass().getClassLoader());
            }
            unmarshaller.setUnmarshalCallbacks(this.generator.getUnmarshalCallbacks());
        }
        return unmarshaller;
    }

    public Validator createValidator() {
        return new JAXBValidator(this.xmlContext.createValidator());
    }

    public Binder createBinder() {
        return new JAXBBinder(this.xmlContext);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return new JAXBIntrospector(this.xmlContext);
    }
}

