/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private HashMap<String, Schema> schemaForNamespace;
    private Schema schema;
    private int schemaCount;
    private Helper helper;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, SchemaTypeInfo> schemaTypeInfo;
    private HashMap<String, QName> userDefinedSchemaTypes;

    public SchemaGenerator(Helper helper) {
        this.helper = helper;
    }

    public Schema generateSchema(ArrayList<JavaClass> typeInfoClasses, HashMap<String, TypeInfo> typeInfo, HashMap<String, QName> userDefinedSchemaTypes, HashMap<String, NamespaceInfo> packageToNamespaceMappings, HashMap<QName, String> additionalGlobalElements) {
        this.typeInfo = typeInfo;
        this.userDefinedSchemaTypes = userDefinedSchemaTypes;
        this.packageToNamespaceMappings = packageToNamespaceMappings;
        this.schemaCount = 0;
        this.schemaTypeInfo = new HashMap(typeInfo.size());
        for (JavaClass javaClass : typeInfoClasses) {
            this.addSchemaComponents(javaClass);
        }
        this.populateSchemaTypes();
        if (additionalGlobalElements != null) {
            this.addGlobalElements(additionalGlobalElements);
        }
        return this.schema;
    }

    public void addSchemaComponents(JavaClass myClass) {
        SimpleType type;
        String myClassName = myClass.getQualifiedName();
        Element rootElement = null;
        TypeInfo info = this.typeInfo.get(myClassName);
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        this.schemaTypeInfo.put(myClass.getQualifiedName(), schemaTypeInfo);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(myClass.getPackage().getQualifiedName());
        Schema schema = this.getSchemaForNamespace(info.getClassNamespace());
        info.setSchema(schema);
        String typeName = info.getSchemaTypeName();
        String[] propOrder = info.getPropOrder();
        String pfx = "";
        Property valueField = null;
        if (this.helper.isAnnotationPresent(myClass, XmlRootElement.class)) {
            int idx;
            char ch;
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(myClass, XmlRootElement.class);
            rootElement = new Element();
            String elementName = rootElemAnnotation.name();
            if ((elementName.equals("##default") || elementName.equals("")) && (elementName = myClassName.indexOf("$") != -1 ? Introspector.decapitalize(myClassName.substring(myClassName.lastIndexOf(36) + 1)) : Introspector.decapitalize(myClassName.substring(myClassName.lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(ch = elementName.charAt((idx = elementName.length() - 1) - 1))) {
                char lastCh = Character.toUpperCase(elementName.charAt(idx));
                elementName = elementName.substring(0, idx) + lastCh;
            }
            rootElement.setName(elementName);
            String rootNamespace = rootElemAnnotation.namespace();
            if (rootNamespace.equals("##default")) {
                this.getSchemaForNamespace(namespaceInfo.getNamespace()).addTopLevelElement(rootElement);
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), rootNamespace));
                rootNamespace = namespaceInfo.getNamespace();
            } else {
                this.getSchemaForNamespace(rootNamespace).addTopLevelElement(rootElement);
                schemaTypeInfo.getGlobalElementDeclarations().add(new QName(rootNamespace, elementName));
            }
            Schema rootSchema = this.getSchemaForNamespace(rootNamespace);
            if (schema != rootSchema) {
                Import schemaImport = new Import();
                schemaImport.setNamespace(schema.getTargetNamespace());
                schemaImport.setSchemaLocation(schema.getName());
                rootSchema.getImports().add(schemaImport);
            }
            if (!info.getClassNamespace().equals("")) {
                pfx = this.getPrefixForNamespace(info.getClassNamespace(), rootSchema.getNamespaceResolver());
                if (pfx == null) {
                    pfx = rootSchema.getNamespaceResolver().generatePrefix();
                    rootSchema.getNamespaceResolver().put(pfx, info.getClassNamespace());
                }
                pfx = pfx + ":";
            }
        }
        ArrayList<String> propertyNames = info.getPropertyNames();
        if (info.isEnumerationType() || propertyNames.size() == 1 && this.helper.isAnnotationPresent(info.getProperties().get(propertyNames.get(0)).getElement(), XmlValue.class)) {
            type = new SimpleType();
            if (typeName.equals("")) {
                if (rootElement != null) {
                    rootElement.setSimpleType(type);
                }
            } else {
                type.setName(typeName);
                schema.addTopLevelSimpleTypes(type);
                if (rootElement != null) {
                    rootElement.setType(pfx + type.getName());
                }
            }
            QName restrictionType = null;
            Restriction restriction = new Restriction();
            if (info.isEnumerationType()) {
                restrictionType = ((EnumTypeInfo)info).getRestrictionBase();
                restriction.setEnumerationFacets(this.getEnumerationFacetsFor((EnumTypeInfo)info));
                restriction.setBaseType("xsd:" + restrictionType.getLocalPart());
                type.setRestriction(restriction);
            } else {
                valueField = info.getProperties().get(propertyNames.get(0));
                QName baseType = this.getSchemaTypeFor(valueField.getType());
                if (this.helper.isAnnotationPresent(valueField.getElement(), XmlList.class)) {
                    List list = new List();
                    list.setItemType("xsd:" + baseType.getLocalPart());
                    type.setList(list);
                } else {
                    if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                        XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                        baseType = new QName("http://www.w3.org/2001/XMLSchema-instance", schemaType.name());
                    }
                    restriction.setBaseType("xsd:" + baseType.getLocalPart());
                    type.setRestriction(restriction);
                }
            }
            info.setSimpleType(type);
        } else {
            valueField = this.getXmlValueFieldForSimpleContent(info.getPropertyList());
            if (valueField != null) {
                type = new ComplexType();
                SimpleContent content = new SimpleContent();
                if (typeName.equals("")) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                } else {
                    type.setName(typeName);
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    if (rootElement != null) {
                        rootElement.setType(pfx + type.getName());
                    }
                }
                QName extensionType = this.getSchemaTypeFor(valueField.getType());
                if (this.helper.isAnnotationPresent(valueField.getElement(), XmlSchemaType.class)) {
                    XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(valueField.getElement(), XmlSchemaType.class);
                    extensionType = new QName("http://www.w3.org/2001/XMLSchema-instance", schemaType.name());
                }
                Extension extension = new Extension();
                extension.setBaseType("xsd:" + extensionType.getLocalPart());
                content.setExtension(extension);
                type.setSimpleContent(content);
                info.setComplexType((ComplexType)type);
                info.setPropOrder(propOrder);
            } else {
                type = new ComplexType();
                JavaClass superClass = myClass.getSuperclass();
                TypeInfo parentTypeInfo = this.typeInfo.get(superClass.getQualifiedName());
                Extension extension = null;
                if (parentTypeInfo != null) {
                    extension = new Extension();
                    String parentPrefix = this.getPrefixForNamespace(parentTypeInfo.getClassNamespace(), namespaceInfo.getNamespaceResolver());
                    if (parentPrefix != null) {
                        extension.setBaseType(parentPrefix + ":" + parentTypeInfo.getSchemaTypeName());
                    } else {
                        extension.setBaseType(parentTypeInfo.getSchemaTypeName());
                    }
                    ComplexContent content = new ComplexContent();
                    content.setExtension(extension);
                    type.setComplexContent(content);
                }
                Sequence compositor = null;
                if (propOrder.length == 0) {
                    if (extension != null) {
                        compositor = new All();
                        extension.setAll((All)compositor);
                    } else {
                        compositor = new All();
                        type.setAll((All)compositor);
                    }
                } else {
                    compositor = new Sequence();
                    if (extension != null) {
                        extension.setSequence(compositor);
                    } else {
                        type.setSequence(compositor);
                    }
                }
                if (typeName.equals("")) {
                    if (rootElement != null) {
                        rootElement.setComplexType((ComplexType)type);
                    }
                    info.setComplexType((ComplexType)type);
                    info.setCompositor((TypeDefParticle)compositor);
                } else {
                    type.setName(typeName);
                    if (rootElement != null) {
                        rootElement.setType(pfx + type.getName());
                    }
                    schema.addTopLevelComplexTypes((ComplexType)type);
                    info.setComplexType((ComplexType)type);
                    info.setCompositor((TypeDefParticle)compositor);
                }
                info.setPropOrder(propOrder);
            }
        }
    }

    public void addToSchemaType(ArrayList<Property> properties, TypeDefParticle compositor, ComplexType type, Schema schema) {
        for (Property next : properties) {
            JavaClass gType;
            String prefix;
            TypeInfo info;
            JavaClass javaType;
            if (next == null) continue;
            TypeDefParticle parentCompositor = compositor;
            boolean isChoice = parentCompositor instanceof Choice;
            ComplexType parentType = type;
            if (this.helper.isAnnotationPresent(next.getElement(), XmlTransient.class)) continue;
            if (!isChoice && this.helper.isAnnotationPresent(next.getElement(), XmlElementWrapper.class)) {
                XmlElementWrapper wrapper = (XmlElementWrapper)this.helper.getAnnotation(next.getElement(), XmlElementWrapper.class);
                Element wrapperElement = new Element();
                wrapperElement.setName(wrapper.name());
                wrapperElement.setMinOccurs("0");
                compositor.addElement(wrapperElement);
                ComplexType wrapperType = new ComplexType();
                Sequence wrapperSequence = new Sequence();
                wrapperType.setSequence(wrapperSequence);
                wrapperElement.setComplexType(wrapperType);
                parentType = wrapperType;
                parentCompositor = wrapperSequence;
            }
            if (this.helper.isAnnotationPresent(next.getElement(), XmlAttribute.class)) {
                Attribute attribute = new Attribute();
                QName attributeName = next.getSchemaName();
                attribute.setName(attributeName.getLocalPart());
                javaType = next.getType();
                if (next.getGenericType() != null) {
                    javaType = next.getGenericType();
                }
                String typeName = null;
                info = this.typeInfo.get(next.getType().getQualifiedName());
                if (info != null) {
                    if (!info.isComplexType()) {
                        typeName = info.getSimpleType().getName();
                    }
                } else if (this.helper.isAnnotationPresent(next.getElement(), XmlID.class)) {
                    typeName = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(next.getElement(), XmlIDREF.class)) {
                    typeName = "xsd:IDREF";
                } else {
                    QName schemaType = next.getSchemaType();
                    if (schemaType == null) {
                        schemaType = this.getSchemaTypeFor(javaType);
                    }
                    typeName = schemaType != null ? "xsd:" + schemaType.getLocalPart() : "xsd:anySimpleType";
                }
                if (this.isCollectionType(next)) {
                    SimpleType localType = new SimpleType();
                    List list = new List();
                    list.setItemType(typeName);
                    localType.setList(list);
                    attribute.setSimpleType(localType);
                } else {
                    String prefix2;
                    if (typeName != null && !typeName.contains(":") && info.getSchema() == schema && (prefix2 = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                        typeName = prefix2 + ":" + typeName;
                    }
                    attribute.setType(typeName);
                }
                if (!attributeName.getNamespaceURI().equals("")) {
                    Schema attributeSchema = this.getSchemaForNamespace(attributeName.getNamespaceURI());
                    if (attributeSchema.getTopLevelAttributes().get(attribute.getName()) == null) {
                        attributeSchema.getTopLevelAttributes().put(attribute.getName(), attribute);
                    }
                    if (!this.importExists(schema, attributeSchema.getName())) {
                        Import schemaImport = new Import();
                        schemaImport.setNamespace(attributeSchema.getTargetNamespace());
                        schemaImport.setSchemaLocation(attributeSchema.getName());
                        schema.getImports().add(schemaImport);
                        schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), attributeSchema.getTargetNamespace());
                    }
                    Attribute reference = new Attribute();
                    prefix = this.getPrefixForNamespace(attributeSchema.getTargetNamespace(), schema.getNamespaceResolver());
                    if (prefix == null) {
                        reference.setRef(attribute.getName());
                    } else {
                        reference.setRef(prefix + ":" + attribute.getName());
                    }
                    if (parentType.getSimpleContent() != null) {
                        parentType.getSimpleContent().getExtension().getOrderedAttributes().add(reference);
                        continue;
                    }
                    parentType.getOrderedAttributes().add(reference);
                    continue;
                }
                if (parentType.getSimpleContent() != null) {
                    parentType.getSimpleContent().getExtension().getOrderedAttributes().add(attribute);
                    continue;
                }
                parentType.getOrderedAttributes().add(attribute);
                continue;
            }
            if (this.helper.isAnnotationPresent(next.getElement(), XmlAnyAttribute.class)) {
                AnyAttribute anyAttribute = new AnyAttribute();
                anyAttribute.setProcessContents("lax");
                if (type.getSimpleContent() != null) {
                    SimpleContent content = type.getSimpleContent();
                    content.getRestriction().setAnyAttribute(anyAttribute);
                    continue;
                }
                type.setAnyAttribute(anyAttribute);
                continue;
            }
            if (next.isChoice()) {
                Choice choice = new Choice();
                ArrayList choiceProperties = (ArrayList)((ChoiceProperty)next).getChoiceProperties();
                this.addToSchemaType(choiceProperties, (TypeDefParticle)choice, parentType, schema);
                if (parentCompositor instanceof Sequence) {
                    ((Sequence)parentCompositor).addChoice(choice);
                    continue;
                }
                if (!(parentCompositor instanceof Choice)) continue;
                ((Choice)parentCompositor).addChoice(choice);
                continue;
            }
            if (next.isAny()) {
                Any any = new Any();
                AnyProperty anyProp = (AnyProperty)next;
                if (anyProp.isLax()) {
                    any.setProcessContents("lax");
                }
                if (parentCompositor instanceof Sequence) {
                    ((Sequence)parentCompositor).addAny(any);
                    continue;
                }
                if (!(parentCompositor instanceof Choice)) continue;
                ((Choice)parentCompositor).addAny(any);
                continue;
            }
            if (this.helper.isAnnotationPresent(next.getElement(), XmlValue.class)) continue;
            Element element = new Element();
            element.setMinOccurs(next.isRequired() ? "1" : "0");
            QName elementName = next.getSchemaName();
            javaType = next.getType();
            boolean isCollectionType = this.isCollectionType(next);
            if (isCollectionType && (gType = next.getGenericType()) != null && gType.hasActualTypeArguments()) {
                Object[] params = gType.getActualTypeArguments().toArray();
                javaType = (JavaClass)params[0];
            }
            element.setName(elementName.getLocalPart());
            info = this.typeInfo.get(javaType.getQualifiedName());
            String typeName = null;
            boolean isComplexType = false;
            if (info != null) {
                if (this.helper.isAnnotationPresent(next.getElement(), XmlID.class)) {
                    typeName = "xsd:ID";
                } else if (this.helper.isAnnotationPresent(next.getElement(), XmlIDREF.class)) {
                    typeName = "xsd:IDREF";
                } else {
                    isComplexType = info.isComplexType();
                    typeName = info.isComplexType() ? info.getComplexType().getName() : info.getSimpleType().getName();
                }
                if (typeName == null && !info.hasRootElement()) {
                    if (info.isComplexType()) {
                        element.setComplexType(info.getComplexType());
                    } else {
                        element.setSimpleType(info.getSimpleType());
                    }
                }
                if (info.getSchema() != schema && !this.importExists(schema, info.getSchema().getName())) {
                    String prefix3;
                    Import schemaImport = new Import();
                    schemaImport.setSchemaLocation(info.getSchema().getName());
                    schemaImport.setNamespace(info.getSchema().getTargetNamespace());
                    schema.getImports().add(schemaImport);
                    if (schemaImport.getNamespace() != null) {
                        schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), schemaImport.getNamespace());
                    }
                    if ((prefix3 = this.getPrefixForNamespace(info.getSchema().getTargetNamespace(), schema.getNamespaceResolver())) != null && !typeName.equals("")) {
                        typeName = prefix3 + ":" + typeName;
                    }
                }
            } else {
                QName schemaType = next.getSchemaType();
                if (schemaType == null) {
                    schemaType = this.getSchemaTypeFor(javaType);
                }
                if (schemaType != null) {
                    typeName = "xsd:" + schemaType.getLocalPart();
                }
            }
            if (typeName != null && !typeName.contains(":") && info.getSchema() == schema && (prefix = this.getPrefixForNamespace(schema.getTargetNamespace(), schema.getNamespaceResolver())) != null) {
                typeName = prefix + ":" + typeName;
            }
            if (isCollectionType) {
                if (this.helper.isAnnotationPresent(next.getElement(), XmlList.class)) {
                    if (isComplexType) {
                        // empty if block
                    }
                    SimpleType localSimpleType = new SimpleType();
                    List list = new List();
                    list.setItemType(typeName);
                    localSimpleType.setList(list);
                    element.setSimpleType(localSimpleType);
                } else {
                    element.setMaxOccurs("unbounded");
                    element.setType(typeName);
                }
            } else {
                element.setType(typeName);
            }
            if (!elementName.getNamespaceURI().equals("")) {
                String prefix4;
                Element reference = new Element();
                reference.setMinOccurs(element.getMinOccurs());
                reference.setMaxOccurs(element.getMaxOccurs());
                Schema attributeSchema = this.getSchemaForNamespace(elementName.getNamespaceURI());
                if (attributeSchema.getTopLevelElements().get(element.getName()) == null) {
                    element.setMinOccurs(null);
                    element.setMaxOccurs(null);
                    attributeSchema.getTopLevelElements().put(element.getName(), element);
                }
                if (attributeSchema != schema && !this.importExists(schema, attributeSchema.getName())) {
                    Import schemaImport = new Import();
                    schemaImport.setNamespace(attributeSchema.getTargetNamespace());
                    schemaImport.setSchemaLocation(attributeSchema.getName());
                    schema.getImports().add(schemaImport);
                    schema.getNamespaceResolver().put(schema.getNamespaceResolver().generatePrefix(), attributeSchema.getTargetNamespace());
                }
                if ((prefix4 = this.getPrefixForNamespace(attributeSchema.getTargetNamespace(), schema.getNamespaceResolver())) == null) {
                    reference.setRef(element.getName());
                } else {
                    reference.setRef(prefix4 + ":" + element.getName());
                }
                parentCompositor.addElement(reference);
                continue;
            }
            parentCompositor.addElement(element);
        }
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (schemaType == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public void populateSchemaTypes() {
        for (String javaClassName : this.typeInfo.keySet()) {
            TypeInfo info = this.typeInfo.get(javaClassName);
            if (!info.isComplexType()) continue;
            ComplexType type = info.getComplexType();
            TypeDefParticle compositor = info.getCompositor();
            String[] propOrder = info.getPropOrder();
            if (propOrder.length == 0 || propOrder[0].equals("")) {
                propOrder = info.getPropertyNames().toArray(new String[info.getPropertyNames().size()]);
            }
            ArrayList<Property> properties = new ArrayList<Property>(propOrder.length);
            for (int i = 0; i < propOrder.length; ++i) {
                Property next = info.getProperties().get(propOrder[i]);
                properties.add(next);
            }
            this.addToSchemaType(properties, compositor, type, info.getSchema());
        }
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = Introspector.decapitalize(className.substring(className.lastIndexOf(46) + 1));
        return typeName;
    }

    public ArrayList getEnumerationFacetsFor(EnumTypeInfo info) {
        Collection<String> valuesCollection = info.getObjectValuesToFieldValues().values();
        return new ArrayList<String>(valuesCollection);
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> properties) {
        boolean foundValue = false;
        boolean foundNonAttribute = false;
        Property valueField = null;
        for (Property prop : properties) {
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlValue.class)) {
                foundValue = true;
                valueField = prop;
                continue;
            }
            if (this.helper.isAnnotationPresent(prop.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(prop.getElement(), XmlAnyAttribute.class)) continue;
            foundNonAttribute = true;
        }
        if (foundValue && !foundNonAttribute) {
            return valueField;
        }
        return null;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(java.util.List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    private Schema getSchemaForNamespace(String namespace) {
        Schema schema;
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        if ((schema = this.schemaForNamespace.get(namespace)) == null) {
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForNamespace(namespace);
            schema = new Schema();
            schema.setName("schema" + this.schemaCount + ".xsd");
            ++this.schemaCount;
            if (!namespace.equals("")) {
                schema.setTargetNamespace(namespace);
                String prefix = null;
                if (namespaceInfo != null) {
                    prefix = namespaceInfo.getNamespaceResolver().resolveNamespaceURI(namespace);
                }
                if (prefix == null) {
                    prefix = schema.getNamespaceResolver().generatePrefix();
                }
                schema.getNamespaceResolver().put(prefix, namespace);
            }
            if (namespaceInfo != null) {
                schema.setAttributeFormDefault(namespaceInfo.isAttributeFormQualified());
                schema.setElementFormDefault(namespaceInfo.isElementFormQualified());
            }
            this.schemaForNamespace.put(namespace, schema);
        }
        return schema;
    }

    public Collection<Schema> getAllSchemas() {
        if (this.schemaForNamespace == null) {
            this.schemaForNamespace = new HashMap();
        }
        return this.schemaForNamespace.values();
    }

    public NamespaceInfo getNamespaceInfoForNamespace(String namespace) {
        Collection<NamespaceInfo> namespaceInfo = this.packageToNamespaceMappings.values();
        for (NamespaceInfo info : namespaceInfo) {
            if (!info.getNamespace().equals(namespace)) continue;
            return info;
        }
        return null;
    }

    public String getPrefixForNamespace(String URI2, NamespaceResolver namespaceResolver) {
        Enumeration keys = namespaceResolver.getPrefixes();
        while (keys.hasMoreElements()) {
            String next = (String)keys.nextElement();
            String nextUri = namespaceResolver.resolveNamespacePrefix(next);
            if (!nextUri.equals(URI2)) continue;
            return next;
        }
        return null;
    }

    public void addGlobalElements(HashMap<QName, String> additionalElements) {
        for (QName next : additionalElements.keySet()) {
            String namespaceURI = next.getNamespaceURI();
            Schema targetSchema = this.getSchemaForNamespace(namespaceURI);
            Element element = new Element();
            element.setName(next.getLocalPart());
            JavaClass javaClass = this.helper.getJavaClass(additionalElements.get(next));
            QName schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
            if (schemaType != null) {
                element.setType("xsd:" + schemaType.getLocalPart());
            } else {
                TypeInfo type = this.typeInfo.get(javaClass.getQualifiedName());
                if (type != null) {
                    String typeName = null;
                    typeName = type.isComplexType() ? type.getComplexType().getName() : type.getSimpleType().getName();
                    if (type.getClassNamespace().equals(namespaceURI)) {
                        element.setType(schemaType.getLocalPart());
                    } else {
                        Schema complexTypeSchema = this.getSchemaForNamespace(type.getClassNamespace());
                        String complexTypeSchemaNS = complexTypeSchema.getTargetNamespace();
                        if (complexTypeSchemaNS == null) {
                            complexTypeSchemaNS = "";
                        }
                        if (!this.importExists(targetSchema, complexTypeSchema.getName())) {
                            Import schemaImport = new Import();
                            schemaImport.setNamespace(complexTypeSchema.getTargetNamespace());
                            schemaImport.setSchemaLocation(complexTypeSchema.getName());
                            targetSchema.getImports().add(schemaImport);
                            if (!complexTypeSchemaNS.equals("")) {
                                targetSchema.getNamespaceResolver().put(targetSchema.getNamespaceResolver().generatePrefix(), complexTypeSchemaNS);
                            }
                        }
                        String prefix = targetSchema.getNamespaceResolver().resolveNamespaceURI(complexTypeSchema.getTargetNamespace());
                        element.setType(prefix + ":" + typeName);
                    }
                }
            }
            targetSchema.addTopLevelElement(element);
            SchemaTypeInfo info = this.schemaTypeInfo.get(javaClass.getQualifiedName());
            if (info == null) {
                info = new SchemaTypeInfo();
                info.setSchemaTypeName(schemaType);
                this.schemaTypeInfo.put(javaClass.getQualifiedName(), info);
            }
            info.getGlobalElementDeclarations().add(next);
        }
    }

    public HashMap<String, SchemaTypeInfo> getSchemaTypeInfo() {
        return this.schemaTypeInfo;
    }

    private boolean importExists(Schema schema, String schemaName) {
        java.util.List imports = schema.getImports();
        for (int i = 0; i < imports.size(); ++i) {
            Import nextImport = (Import)imports.get(i);
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }
}

