/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsProcessor {
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private NamespaceResolver namespaceResolver;
    private Helper helper;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
    }

    public void processClassesAndProperties(JavaClass[] classes) {
        this.typeInfoClasses = new ArrayList();
        this.typeInfo = new HashMap();
        this.userDefinedSchemaTypes = new HashMap();
        this.packageToNamespaceMappings = new HashMap();
        this.namespaceResolver = new NamespaceResolver();
        for (JavaClass javaClass : classes) {
            if (javaClass == null) continue;
            this.createTypeInfoFor(javaClass);
            for (JavaClass innerClass : javaClass.getDeclaredClasses()) {
                if (!this.shouldGenerateTypeInfo(innerClass)) continue;
                this.createTypeInfoFor(innerClass);
            }
            JavaClass superClass = javaClass.getSuperclass();
            if (!this.shouldGenerateTypeInfo(superClass)) continue;
            this.createTypeInfoFor(superClass);
        }
        this.checkForCallbackMethods();
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToNamespaceMappings = new HashMap();
            this.namespaceResolver = new NamespaceResolver();
        }
        TypeInfo info = this.createTypeInfoFor(javaClass);
        JavaPackage pack = javaClass.getPackage();
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(pack.getQualifiedName());
        SchemaTypeInfo schemaInfo = new SchemaTypeInfo();
        schemaInfo.setSchemaTypeName(new QName(info.getClassNamespace(), info.getSchemaTypeName()));
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            String rootNamespace;
            XmlRootElement rootElemAnnotation = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            String elementName = rootElemAnnotation.name();
            if (elementName.equals("##default") || elementName.equals("")) {
                elementName = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1));
            }
            if ((rootNamespace = rootElemAnnotation.namespace()).equals("##default")) {
                schemaInfo.getGlobalElementDeclarations().add(new QName(namespaceInfo.getNamespace(), rootNamespace));
            } else {
                schemaInfo.getGlobalElementDeclarations().add(new QName(elementName, rootNamespace));
            }
        }
        return schemaInfo;
    }

    public TypeInfo createTypeInfoFor(JavaClass javaClass) {
        JavaClass superClass;
        NamespaceInfo packageNamespace;
        JavaClass boundType;
        JavaClass adapterClass;
        XmlJavaTypeAdapter[] adapterArray;
        XmlJavaTypeAdapters adapters;
        if (javaClass == null) {
            return null;
        }
        if (this.typeInfo.containsKey(javaClass.getQualifiedName())) {
            return this.typeInfo.get(javaClass.getQualifiedName());
        }
        TypeInfo info = null;
        info = javaClass.isEnum() ? new EnumTypeInfo(this.helper) : new TypeInfo(this.helper);
        JavaPackage pack = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(pack, XmlJavaTypeAdapters.class)) {
            adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(pack, XmlJavaTypeAdapters.class);
            for (XmlJavaTypeAdapter next : adapterArray = adapters.value()) {
                adapterClass = this.helper.getJavaClass(next.value());
                boundType = this.helper.getJavaClass(next.type());
                if (boundType == null) continue;
                info.addAdapterClass(adapterClass, boundType);
            }
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlJavaTypeAdapters.class)) {
            adapters = (XmlJavaTypeAdapters)this.helper.getAnnotation(javaClass, XmlJavaTypeAdapters.class);
            for (XmlJavaTypeAdapter next : adapterArray = adapters.value()) {
                adapterClass = this.helper.getJavaClass(next.value());
                boundType = this.helper.getJavaClass(next.type());
                if (boundType == null) continue;
                info.addAdapterClass(adapterClass, boundType);
            }
        }
        if ((packageNamespace = this.packageToNamespaceMappings.get(pack.getQualifiedName())) == null) {
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(pack, XmlSchema.class);
            packageNamespace = this.processNamespaceInformation(xmlSchema);
            if (packageNamespace.getNamespace() == null) {
                packageNamespace.setNamespace("");
            }
            if (this.helper.isAnnotationPresent(pack, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(pack, XmlAccessorType.class);
                packageNamespace.setAccessType(xmlAccessorType.value());
            }
            this.packageToNamespaceMappings.put(pack.getQualifiedName(), packageNamespace);
            if (this.helper.isAnnotationPresent(pack, XmlSchemaTypes.class)) {
                XmlSchemaType[] typeArray;
                XmlSchemaTypes types = (XmlSchemaTypes)this.helper.getAnnotation(pack, XmlSchemaTypes.class);
                for (XmlSchemaType next : typeArray = types.value()) {
                    this.processSchemaType(next);
                }
            } else if (this.helper.isAnnotationPresent(pack, XmlSchemaType.class)) {
                this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(pack, XmlSchemaType.class));
            }
        }
        String[] propOrder = new String[]{};
        String typeName = "";
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            typeName = typeAnnotation.name();
            if (typeName.equals("##default")) {
                typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
            propOrder = typeAnnotation.propOrder();
            if (!typeAnnotation.namespace().equals("##default")) {
                info.setClassNamespace(typeAnnotation.namespace());
            } else {
                info.setClassNamespace(packageNamespace.getNamespace());
            }
        } else {
            typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            info.setClassNamespace(packageNamespace.getNamespace());
        }
        info.setPropOrder(propOrder);
        info.setSchemaTypeName(typeName);
        if (info.isEnumerationType()) {
            this.addEnumTypeInfo(javaClass, (EnumTypeInfo)info);
            return info;
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), info);
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorType.class)) {
            XmlAccessorType accessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            info.setAccessType(accessorType.value());
        } else {
            info.setAccessType(packageNamespace.getAccessType());
        }
        info.setProperties(this.getPropertiesForClass(javaClass, info));
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            XmlAccessorOrder order = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
            info.orderProperties(order.value());
        }
        if (this.shouldGenerateTypeInfo(superClass = javaClass.getSuperclass())) {
            this.createTypeInfoFor(superClass);
        }
        ArrayList<Property> properties = info.getPropertyList();
        for (Property property : properties) {
            XmlElement element;
            JavaClass propertyType = property.getType();
            if (this.isCollectionType(property)) {
                JavaClass gType = property.getGenericType();
                if (gType != null) {
                    if (gType.hasActualTypeArguments()) {
                        propertyType = this.helper.getJavaClass(gType.getRawName());
                    } else if (gType instanceof JavaClass) {
                        propertyType = gType;
                    }
                }
            } else if (propertyType.isArray()) {
                propertyType = propertyType.getComponentType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class) && (element = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).type() != XmlElement.DEFAULT.class) {
                propertyType = this.helper.getJavaClass(element.type());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                if (!this.areEquals(property.getType(), String.class)) {
                    // empty if block
                }
                if (info.isIDSet()) {
                    // empty if block
                }
                info.setIDProperty(property);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                property.setAdapterClass(((XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class)).value());
            }
            if (!this.shouldGenerateTypeInfo(propertyType)) continue;
            this.createTypeInfoFor(propertyType);
        }
        return info;
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || javaClass.isInterface() || javaClass.isArray()) {
            return false;
        }
        if (javaClass.getPackageName().startsWith("java.") || javaClass.getPackageName().startsWith("javax.")) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        return !this.helper.isBuiltInJavaType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass cls, TypeInfo info) {
        if (info.getAccessType() == XmlAccessType.FIELD) {
            return this.getFieldPropertiesForClass(cls, info, false);
        }
        if (info.getAccessType() == XmlAccessType.PROPERTY) {
            return this.getPropertyPropertiesForClass(cls, info, false);
        }
        if (info.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            return this.getPublicMemberPropertiesForClass(cls, info);
        }
        return this.getNoAccessTypePropertiesForClass(cls, info);
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        for (JavaField nextField : cls.getDeclaredFields()) {
            if (this.helper.isAnnotationPresent(nextField, XmlTransient.class) || (!Modifier.isPublic(nextField.getModifiers()) || !onlyPublic) && onlyPublic) continue;
            Property property = null;
            if (this.helper.isAnnotationPresent(nextField, XmlElements.class)) {
                property = new ChoiceProperty(this.helper);
                property.setElement(nextField);
                XmlElements xmlElements = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                XmlElement[] elements = xmlElements.value();
                ArrayList<Property> choiceProperties = new ArrayList<Property>(elements.length);
                for (int i = 0; i < elements.length; ++i) {
                    XmlElement next = elements[i];
                    Property choiceProp = new Property();
                    String name = next.name();
                    String namespace = next.namespace();
                    QName qName = null;
                    qName = !namespace.equals("##default") ? new QName(namespace, name) : new QName(name);
                    choiceProp.setPropertyName(property.getPropertyName());
                    choiceProp.setType(this.helper.getJavaClass(next.type()));
                    choiceProp.setSchemaName(qName);
                    choiceProp.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(next.type())));
                    choiceProp.setElement(property.getElement());
                    choiceProperties.add(choiceProp);
                }
                ((ChoiceProperty)property).setChoiceProperties(choiceProperties);
            } else if (this.helper.isAnnotationPresent(nextField, XmlAnyElement.class)) {
                property = new AnyProperty(this.helper);
                property.setElement(nextField);
                XmlAnyElement anyElement = (XmlAnyElement)this.helper.getAnnotation(nextField, XmlAnyElement.class);
                ((AnyProperty)property).setLax(anyElement.lax());
            } else {
                property = new Property(this.helper);
                property.setElement(nextField);
            }
            JavaClass ptype = nextField.getResolvedType();
            property.setType(ptype);
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                XmlJavaTypeAdapter adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(adapter.value());
            } else if (info.getAdaptersByClass().get(ptype) != null) {
                property.setAdapterClass(info.getAdapterClass(ptype));
            }
            if (property.hasAdapterClass()) {
                ptype = property.getValueType();
            }
            property.setGenericType(this.helper.getGenericType(nextField));
            property.setPropertyName(nextField.getName());
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER)) {
                property.setIsSwaAttachmentRef(true);
                property.setSchemaType(XMLConstants.SWA_REF_QNAME);
            } else if (this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                property.setIsMtomAttachment(true);
                property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                QName schemaTypeQname = new QName("http://www.w3.org/2001/XMLSchema-instance", schemaType.name());
                property.setSchemaType(schemaTypeQname);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                property.setIsAttribute(true);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) {
                property.setIsRequired(((XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).required());
            }
            property.setSchemaName(this.getQNameForProperty(Introspector.decapitalize(nextField.getName()), nextField));
            properties.add(property);
        }
        return properties;
    }

    protected boolean areEquals(JavaClass src, Class tgt) {
        if (src == null || tgt == null) {
            return false;
        }
        return src.getRawName().equals(tgt.getCanonicalName());
    }

    protected boolean areEquals(JavaClass src, String tgtCanonicalName) {
        if (src == null || tgtCanonicalName == null) {
            return false;
        }
        return src.getRawName().equals(tgtCanonicalName);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass cls, TypeInfo info, boolean onlyPublic) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (cls == null) {
            return properties;
        }
        ArrayList<JavaMethod> getMethods = new ArrayList<JavaMethod>();
        for (JavaMethod next : new ArrayList(cls.getDeclaredMethods())) {
            if (!next.getName().startsWith("get") && (!this.areEquals(next.getReturnType(), Boolean.class) && !this.areEquals(next.getReturnType(), Boolean.TYPE) || !next.getName().startsWith("is")) || (!onlyPublic || !Modifier.isPublic(next.getModifiers())) && onlyPublic) continue;
            getMethods.add(next);
        }
        for (int i = 0; i < getMethods.size(); ++i) {
            XmlJavaTypeAdapter adapter;
            JavaMethod getMethod = (JavaMethod)getMethods.get(i);
            String propertyName = "";
            if (getMethod.getName().startsWith("get")) {
                propertyName = getMethod.getName().substring(3);
            } else if (getMethod.getName().startsWith("is")) {
                propertyName = getMethod.getName().substring(2);
            }
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            String setMethodName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
            JavaClass[] paramTypes = new JavaClass[]{getMethod.getReturnType()};
            JavaMethod setMethod = cls.getMethod(setMethodName, paramTypes);
            JavaMethod propertyMethod = null;
            if (setMethod != null && !setMethod.getAnnotations().isEmpty()) {
                if (!this.helper.isAnnotationPresent(setMethod, XmlTransient.class)) {
                    propertyMethod = setMethod;
                }
            } else if (!this.helper.isAnnotationPresent(getMethod, XmlTransient.class)) {
                propertyMethod = getMethod;
            }
            Property property = null;
            property = this.helper.isAnnotationPresent(propertyMethod, XmlElements.class) ? new ChoiceProperty(this.helper) : (this.helper.isAnnotationPresent(propertyMethod, XmlAnyElement.class) ? new AnyProperty(this.helper) : new Property(this.helper));
            property.setElement(propertyMethod);
            property.setSchemaName(this.getQNameForProperty(propertyName, propertyMethod));
            property.setPropertyName(propertyName);
            property.setType(getMethod.getReturnType());
            property.setGenericType(this.helper.getGenericReturnType(getMethod));
            property.setGetMethodName(getMethod.getName());
            property.setSetMethodName(setMethodName);
            property.setMethodProperty(true);
            JavaClass ptype = property.getType();
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(adapter.value());
            } else if (info.getAdaptersByClass().get(ptype) != null) {
                property.setAdapterClass(info.getAdaptersByClass().get(ptype));
            }
            if (property.hasAdapterClass()) {
                ptype = property.getValueType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                XmlSchemaType schemaType = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                QName schemaTypeQname = new QName("http://www.w3.org/2001/XMLSchema-instance", schemaType.name());
                property.setSchemaType(schemaTypeQname);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER)) {
                property.setIsSwaAttachmentRef(true);
                property.setSchemaType(XMLConstants.SWA_REF_QNAME);
            } else if (this.areEquals(ptype, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(ptype, byte[].class) || this.areEquals(ptype, Byte[].class) || this.areEquals(ptype, Image.class) || this.areEquals(ptype, Source.class) || this.areEquals(ptype, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                property.setIsMtomAttachment(true);
                property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                adapter = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(adapter.value());
            } else if (info.getAdaptersByClass().get(ptype) != null) {
                property.setAdapterClass(info.getAdaptersByClass().get(ptype));
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                property.setIsAttribute(true);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElements.class)) {
                XmlElements xmlElements = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                XmlElement[] elements = xmlElements.value();
                ArrayList<Property> choiceProperties = new ArrayList<Property>(elements.length);
                for (int j = 0; j < elements.length; ++j) {
                    XmlElement next = elements[j];
                    Property choiceProp = new Property();
                    String name = next.name();
                    String namespace = next.namespace();
                    QName qName = null;
                    qName = !namespace.equals("##default") ? new QName(namespace, name) : new QName(name);
                    choiceProp.setPropertyName(property.getPropertyName());
                    choiceProp.setType(this.helper.getJavaClass(next.type()));
                    choiceProp.setSchemaName(qName);
                    choiceProp.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(next.type())));
                    choiceProp.setElement(property.getElement());
                    choiceProperties.add(choiceProp);
                }
                ((ChoiceProperty)property).setChoiceProperties(choiceProperties);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyElement.class)) {
                XmlAnyElement anyElement = (XmlAnyElement)this.helper.getAnnotation(property.getElement(), XmlAnyElement.class);
                ((AnyProperty)property).setLax(anyElement.lax());
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) {
                properties.add(property);
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) continue;
            property.setIsRequired(((XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).required());
        }
        return properties;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass cls, TypeInfo info) {
        ArrayList<Property> publicFieldProperties = this.getFieldPropertiesForClass(cls, info, true);
        ArrayList<Property> publicMethodProperties = this.getPropertyPropertiesForClass(cls, info, true);
        if (publicFieldProperties.size() >= 0 && publicMethodProperties.size() == 0) {
            return publicFieldProperties;
        }
        if (publicMethodProperties.size() > 0 && publicFieldProperties.size() == 0) {
            return publicMethodProperties;
        }
        HashMap fieldPropertyMap = this.getPropertyMapFromArrayList(publicFieldProperties);
        for (int i = 0; i < publicMethodProperties.size(); ++i) {
            Property next = publicMethodProperties.get(i);
            if (fieldPropertyMap.get(next.getPropertyName()) != null) continue;
            publicFieldProperties.add(next);
        }
        return publicFieldProperties;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> props) {
        HashMap<String, Property> propMap = new HashMap<String, Property>(props.size());
        for (Property next : props) {
            propMap.put(next.getPropertyName(), next);
        }
        return propMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass cls, TypeInfo info) {
        JavaHasAnnotations elem;
        Property next;
        int i;
        ArrayList<Property> list = new ArrayList<Property>();
        if (cls == null) {
            return list;
        }
        ArrayList<Property> fieldProperties = this.getFieldPropertiesForClass(cls, info, false);
        ArrayList<Property> methodProperties = this.getPropertyPropertiesForClass(cls, info, false);
        for (i = 0; i < fieldProperties.size(); ++i) {
            next = fieldProperties.get(i);
            elem = next.getElement();
            if (!this.helper.isAnnotationPresent(elem, XmlElement.class) && !this.helper.isAnnotationPresent(elem, XmlAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlAnyElement.class) && !this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlValue.class) && !this.helper.isAnnotationPresent(elem, XmlElements.class)) continue;
            list.add(next);
        }
        for (i = 0; i < methodProperties.size(); ++i) {
            next = methodProperties.get(i);
            elem = next.getElement();
            if (!this.helper.isAnnotationPresent(elem, XmlElement.class) && !this.helper.isAnnotationPresent(elem, XmlAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlAnyElement.class) && !this.helper.isAnnotationPresent(elem, XmlAnyAttribute.class) && !this.helper.isAnnotationPresent(elem, XmlValue.class) && !this.helper.isAnnotationPresent(elem, XmlElements.class)) continue;
            list.add(next);
        }
        return list;
    }

    public void processSchemaType(XmlSchemaType type) {
        String schemaTypeName = type.name();
        Class javaType = type.type();
        if (javaType == null) {
            return;
        }
        JavaClass jClass = this.helper.getJavaClass(javaType);
        if (jClass == null) {
            return;
        }
        QName typeQName = new QName("http://www.w3.org/2001/XMLSchema-instance", schemaTypeName);
        this.userDefinedSchemaTypes.put(jClass.getQualifiedName(), typeQName);
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo info) {
        if (javaClass == null) {
            return;
        }
        info.setClassName(javaClass.getQualifiedName());
        Class restrictionClass = String.class;
        if (this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) {
            XmlEnum xmlEnum = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
            restrictionClass = xmlEnum.value();
        }
        QName restrictionBase = this.getSchemaTypeFor(this.helper.getJavaClass(restrictionClass));
        info.setRestrictionBase(restrictionBase);
        for (JavaField field : javaClass.getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            String fieldValue = field.getName();
            if (this.helper.isAnnotationPresent(field, XmlEnumValue.class)) {
                XmlEnumValue xmlEnumValue = (XmlEnumValue)this.helper.getAnnotation(field, XmlEnumValue.class);
                fieldValue = xmlEnumValue.value();
            }
            info.getObjectValuesToFieldValues().put(field.getName(), fieldValue);
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), info);
    }

    public ArrayList getEnumerationFacetsFor(EnumTypeInfo info) {
        Collection<String> valuesCollection = info.getObjectValuesToFieldValues().values();
        return new ArrayList<String>(valuesCollection);
    }

    public String getSchemaTypeNameForClassName(String className) {
        String typeName = "";
        typeName = className.indexOf(36) != -1 ? className.substring(className.lastIndexOf(36) + 1).toLowerCase() : className.substring(className.lastIndexOf(46) + 1).toLowerCase();
        return typeName;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName schemaType = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (schemaType == null) {
            schemaType = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (schemaType == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return schemaType;
    }

    public boolean isCollectionType(Property field) {
        JavaClass type = field.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo info = new NamespaceInfo();
        info.setNamespaceResolver(new NamespaceResolver());
        String packageNamespace = null;
        if (xmlSchema != null) {
            String namespaceMapping = xmlSchema.namespace();
            if (!namespaceMapping.equals("") && !namespaceMapping.equals("##default")) {
                packageNamespace = namespaceMapping;
            }
            info.setNamespace(packageNamespace);
            XmlNs[] xmlns = xmlSchema.xmlns();
            for (int i = 0; i < xmlns.length; ++i) {
                XmlNs next = xmlns[i];
                info.getNamespaceResolver().put(next.prefix(), next.namespaceURI());
            }
            info.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            info.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
        }
        return info;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public String getSchemaTypeNameFor(JavaClass javaClass, XmlType xmlType) {
        String typeName = "";
        if (javaClass == null) {
            return typeName;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType typeAnnotation = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            typeName = typeAnnotation.name();
            if (typeName.equals("#default")) {
                typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
        } else {
            typeName = this.getSchemaTypeNameForClassName(javaClass.getName());
        }
        return typeName;
    }

    public QName getQNameForProperty(String defaultName, JavaHasAnnotations element) {
        String name = "##default";
        String namespace = "##default";
        if (this.helper.isAnnotationPresent(element, XmlAttribute.class)) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.helper.getAnnotation(element, XmlAttribute.class);
            name = xmlAttribute.name();
            namespace = xmlAttribute.namespace();
        } else if (this.helper.isAnnotationPresent(element, XmlElement.class)) {
            XmlElement xmlElement = (XmlElement)this.helper.getAnnotation(element, XmlElement.class);
            name = xmlElement.name();
            namespace = xmlElement.namespace();
        }
        if (name.equals("##default")) {
            name = defaultName;
        }
        QName qName = null;
        qName = !namespace.equals("##default") ? new QName(namespace, name) : new QName(name);
        return qName;
    }

    public HashMap<String, NamespaceInfo> getPackageToNamespaceMappings() {
        return this.packageToNamespaceMappings;
    }

    private void checkForCallbackMethods() {
        for (JavaClass next : this.typeInfoClasses) {
            if (next == null) continue;
            JavaClass unmarshallerCls = this.helper.getJavaClass(Unmarshaller.class);
            JavaClass marshallerCls = this.helper.getJavaClass(Marshaller.class);
            JavaClass objectCls = this.helper.getJavaClass(Object.class);
            JavaClass[] unmarshalParams = new JavaClass[]{unmarshallerCls, objectCls};
            JavaClass[] marshalParams = new JavaClass[]{marshallerCls};
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (next.getMethod("beforeUnmarshal", unmarshalParams) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(next.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (next.getMethod("afterUnmarshal", unmarshalParams) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(next.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(next.getQualifiedName(), unmarshalCallback);
            }
            if (next.getMethod("beforeMarshal", marshalParams) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(next.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (next.getMethod("afterMarshal", marshalParams) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(next.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(next.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }
}

