/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.jaxb.JAXBUnmarshalListener;
import org.eclipse.persistence.jaxb.JAXBUnmarshallerHandler;
import org.eclipse.persistence.jaxb.attachment.AttachmentUnmarshallerAdapter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class JAXBUnmarshaller
implements Unmarshaller {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLUnmarshaller xmlUnmarshaller;
    private Schema schema;
    public static final String XML_JAVATYPE_ADAPTERS = "xml-javatype-adapters";
    public static final String STAX_SOURCE_CLASS_NAME = "javax.xml.transform.stax.StAXSource";

    public JAXBUnmarshaller(XMLUnmarshaller newXMLUnmarshaller) {
        this.xmlUnmarshaller = newXMLUnmarshaller;
        this.xmlUnmarshaller.setValidationMode(0);
        this.xmlUnmarshaller.setUnmarshalListener((XMLUnmarshalListener)new JAXBUnmarshalListener(this));
    }

    public Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(file);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(inputStream);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(URL url) throws JAXBException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(url);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(inputSource);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(reader);
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(node);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    private JAXBElement buildJAXBElementFromObject(Object obj) {
        if (obj instanceof XMLRoot) {
            XMLRoot xmlRoot = (XMLRoot)obj;
            QName qname = new QName(xmlRoot.getNamespaceURI(), xmlRoot.getLocalName());
            return new JAXBElement(qname, xmlRoot.getObject().getClass(), xmlRoot.getObject());
        }
        AbstractSession sess = this.xmlUnmarshaller.getXMLContext().getSession(obj);
        XMLDescriptor desc = (XMLDescriptor)sess.getClassDescriptor(obj);
        String rootName = desc.getDefaultRootElement();
        if (rootName == null) {
            return new JAXBElement(new QName(""), obj.getClass(), obj);
        }
        String rootNamespaceUri = null;
        int idx = rootName.indexOf(":");
        if (idx != -1) {
            rootNamespaceUri = desc.getNamespaceResolver().resolveNamespacePrefix(rootName.substring(0, idx));
            rootName = rootName.substring(idx + 1);
        }
        QName qname = rootNamespaceUri == null ? new QName(rootName) : new QName(rootNamespaceUri, rootName);
        return new JAXBElement(qname, obj.getClass(), obj);
    }

    public JAXBElement unmarshal(Node node, Class javaClass) throws JAXBException {
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(node, javaClass));
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlUnmarshaller.unmarshal(source);
        }
        catch (Exception e) {
            throw new UnmarshalException((Throwable)e);
        }
    }

    public JAXBElement unmarshal(Source source, Class javaClass) throws JAXBException {
        return this.buildJAXBElementFromObject(this.xmlUnmarshaller.unmarshal(source, javaClass));
    }

    public JAXBElement unmarshal(XMLStreamReader streamReader, Class javaClass) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)staxResult, (Class[])new Class[]{XMLStreamReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)cons, (Object[])new Object[]{streamReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source, javaClass);
    }

    public Object unmarshal(XMLStreamReader streamReader) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)staxResult, (Class[])new Class[]{XMLStreamReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)cons, (Object[])new Object[]{streamReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source);
    }

    public JAXBElement unmarshal(XMLEventReader eventReader, Class javaClass) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)staxResult, (Class[])new Class[]{XMLEventReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)cons, (Object[])new Object[]{eventReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source, javaClass);
    }

    public Object unmarshal(XMLEventReader eventReader) throws JAXBException {
        Source source = null;
        try {
            Class staxResult = PrivilegedAccessHelper.getClassForName((String)STAX_SOURCE_CLASS_NAME);
            Constructor cons = PrivilegedAccessHelper.getDeclaredConstructorFor((Class)staxResult, (Class[])new Class[]{XMLEventReader.class}, (boolean)false);
            source = (Source)PrivilegedAccessHelper.invokeConstructor((Constructor)cons, (Object[])new Object[]{eventReader});
        }
        catch (Exception ex) {
            throw new MarshalException((Throwable)ex);
        }
        return this.unmarshal(source);
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new JAXBUnmarshallerHandler(this.xmlUnmarshaller);
    }

    public void setValidating(boolean validate) throws JAXBException {
        if (validate) {
            this.xmlUnmarshaller.setValidationMode(3);
        } else {
            this.xmlUnmarshaller.setValidationMode(0);
        }
    }

    public boolean isValidating() throws JAXBException {
        return this.xmlUnmarshaller.getValidationMode() != 0;
    }

    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = null == newValidationEventHandler ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlUnmarshaller.setErrorHandler((ErrorHandler)new JAXBErrorHandler(this.validationEventHandler));
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setProperty(String key, Object value) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException(key, value);
    }

    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException("Unsupported Property");
    }

    public Unmarshaller.Listener getListener() {
        return ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).getListener();
    }

    public void setListener(Unmarshaller.Listener listener) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setListener(listener);
    }

    public XmlAdapter getAdapter(Class javaClass) {
        HashMap result = (HashMap)this.xmlUnmarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            return null;
        }
        return (XmlAdapter)result.get(javaClass);
    }

    public void setAdapter(Class javaClass, XmlAdapter adapter) {
        HashMap<Class, XmlAdapter> result = (HashMap<Class, XmlAdapter>)this.xmlUnmarshaller.getProperty((Object)XML_JAVATYPE_ADAPTERS);
        if (result == null) {
            result = new HashMap<Class, XmlAdapter>();
            this.xmlUnmarshaller.getProperties().put(XML_JAVATYPE_ADAPTERS, result);
        }
        result.put(javaClass, adapter);
    }

    public void setAdapter(XmlAdapter adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return ((AttachmentUnmarshallerAdapter)this.xmlUnmarshaller.getAttachmentUnmarshaller()).getAttachmentUnmarshaller();
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller unmarshaller) {
        this.xmlUnmarshaller.setAttachmentUnmarshaller((XMLAttachmentUnmarshaller)new AttachmentUnmarshallerAdapter(unmarshaller));
    }

    public void setUnmarshalCallbacks(HashMap callbacks) {
        ((JAXBUnmarshalListener)this.xmlUnmarshaller.getUnmarshalListener()).setClassBasedUnmarshalEvents(callbacks);
    }
}

