/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.Method;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.DomHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.sessions.Session;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomHandlerConverter
implements XMLConverter {
    private DomHandler domHandler;
    private XMLTransformer xmlTransformer;
    private Class<? extends DomHandler> domHandlerClass;
    private Class elementClass;
    private Class resultType;

    public DomHandlerConverter(Class<? extends DomHandler> domHandlerClass) {
        this.domHandlerClass = domHandlerClass;
    }

    public void initialize(DatabaseMapping mapping, Session session) {
        try {
            this.domHandler = this.domHandlerClass.newInstance();
            Method createUnmarshallerMethod = this.domHandlerClass.getDeclaredMethod("createUnmarshaller", ValidationEventHandler.class);
            this.resultType = createUnmarshallerMethod.getReturnType();
            Method getElementMethod = this.domHandlerClass.getDeclaredMethod("getElement", this.resultType);
            this.elementClass = getElementMethod.getReturnType();
            this.xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
            this.xmlTransformer.setFormattedOutput(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        if (dataValue instanceof Element) {
            ErrorHandler handler = unmarshaller.getErrorHandler();
            Result result = null;
            result = handler != null && handler instanceof JAXBErrorHandler ? this.domHandler.createUnmarshaller(((JAXBErrorHandler)handler).getValidationEventHandler()) : this.domHandler.createUnmarshaller(null);
            this.xmlTransformer.transform((Node)((Element)dataValue), result);
            Object value = this.domHandler.getElement(result);
            return value;
        }
        return dataValue;
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        if (this.elementClass.isAssignableFrom(objectValue.getClass())) {
            Source source = this.domHandler.marshal(objectValue, null);
            DOMResult result = new DOMResult();
            this.xmlTransformer.transform(source, (Result)result);
            return result.getNode();
        }
        return objectValue;
    }

    public boolean isMutable() {
        return true;
    }

    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return null;
    }

    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return null;
    }
}

