/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.MappingsGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private AnnotationsProcessor annotationsProcessor;
    private SchemaGenerator schemaGenerator;
    private MappingsGenerator mappingsGenerator;
    private Helper helper;

    public Generator(JavaModelInput jModelInput) {
        this.helper = new Helper(jModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.annotationsProcessor.processClassesAndProperties(jModelInput.getJavaClasses());
    }

    public boolean hasMarshalCallbacks() {
        return this.getMarshalCallbacks() != null && this.getMarshalCallbacks().size() > 0;
    }

    public boolean hasUnmarshalCallbacks() {
        return this.getUnmarshalCallbacks() != null && this.getUnmarshalCallbacks().size() > 0;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        return this.annotationsProcessor.addClass(javaClass);
    }

    public Project generateProject() throws Exception {
        return this.mappingsGenerator.generateProject(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
    }

    public Collection<Schema> generateSchema() {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
        return this.schemaGenerator.getAllSchemas();
    }

    public HashMap<String, SchemaTypeInfo> generateSchemaFiles(String schemaPath, HashMap<QName, String> additionalElements) throws FileNotFoundException {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), additionalElements);
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext((Project)proj);
        XMLMarshaller marshaller = context.createMarshaller();
        XMLDescriptor schemaDescriptor = (XMLDescriptor)proj.getDescriptor(Schema.class);
        Collection<Schema> schemas = this.schemaGenerator.getAllSchemas();
        int schemaCount = 0;
        for (Schema schema : schemas) {
            File file = new File(schemaPath + "/" + schema.getName());
            NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
            schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
            schemaDescriptor.setNamespaceResolver(schemaNamespaces);
            marshaller.marshal((Object)schema, (OutputStream)new FileOutputStream(file));
            ++schemaCount;
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    public HashMap<String, SchemaTypeInfo> generateSchemaFiles(SchemaOutputResolver outputResolver, HashMap<QName, String> additonalGlobalElements) {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), additonalGlobalElements);
        SchemaModelProject proj = new SchemaModelProject();
        XMLContext context = new XMLContext((Project)proj);
        XMLMarshaller marshaller = context.createMarshaller();
        XMLDescriptor schemaDescriptor = (XMLDescriptor)proj.getDescriptor(Schema.class);
        Collection<Schema> schemas = this.schemaGenerator.getAllSchemas();
        int schemaCount = 0;
        for (Schema schema : schemas) {
            try {
                NamespaceResolver schemaNamespaces = schema.getNamespaceResolver();
                schemaNamespaces.put("xsd", "http://www.w3.org/2001/XMLSchema");
                schemaDescriptor.setNamespaceResolver(schemaNamespaces);
                Result target = outputResolver.createOutput(schema.getTargetNamespace(), schema.getName());
                marshaller.marshal((Object)schema, target);
                ++schemaCount;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    public HashMap getUnmarshalCallbacks() {
        return this.annotationsProcessor.getUnmarshalCallbacks();
    }

    public HashMap getMarshalCallbacks() {
        return this.annotationsProcessor.getMarshalCallbacks();
    }

    public MappingsGenerator getMappingsGenerator() {
        return this.mappingsGenerator;
    }
}

