/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;

public class SDOCopyHelper
implements CopyHelper {
    private HelperContext aHelperContext;

    public SDOCopyHelper() {
    }

    public SDOCopyHelper(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public DataObject copyShallow(DataObject dataObject) {
        if (null == dataObject) {
            return null;
        }
        SDODataObject copy = (SDODataObject)this.getHelperContext().getDataFactory().create(dataObject.getType().getURI(), dataObject.getType().getName());
        List ocListOriginal = ((SDODataObject)dataObject)._getOpenContentProperties();
        Iterator anOCIterator = ocListOriginal.iterator();
        while (anOCIterator.hasNext()) {
            copy.addOpenContentProperty((Property)anOCIterator.next());
        }
        List ocAttrsListOriginal = ((SDODataObject)dataObject)._getOpenContentPropertiesAttributes();
        Iterator anOCAttrIterator = ocAttrsListOriginal.iterator();
        while (anOCAttrIterator.hasNext()) {
            copy.addOpenContentProperty((Property)anOCAttrIterator.next());
        }
        List allProperties = copy.getInstanceProperties();
        for (Property eachProperty : allProperties) {
            if (!dataObject.isSet(eachProperty)) continue;
            Object o = this.getValue((SDODataObject)dataObject, eachProperty, null);
            if (!eachProperty.getType().isDataType() || eachProperty.getType() == SDOConstants.SDO_CHANGESUMMARY) continue;
            copy.setInternal(eachProperty, o, false);
        }
        if (dataObject.getType().isSequenced()) {
            List<Setting> settings = ((SDOSequence)dataObject.getSequence()).getSettings();
            int size = dataObject.getSequence().size();
            for (int index = 0; index < size; ++index) {
                Setting nextSetting = settings.get(index);
                Property prop = dataObject.getSequence().getProperty(index);
                if (prop != null && !prop.getType().isDataType()) continue;
                Setting copySetting = nextSetting.copy((Object)copy);
                ((SDOSequence)copy.getSequence()).getSettings().add(copySetting);
                ((SDOSequence)copy.getSequence()).addValueToSettings(copySetting);
            }
        }
        if (copy != null && copy.getChangeSummary() != null && ((SDOType)copy.getType()).getChangeSummaryProperty() != null && ((SDODataObject)dataObject).getChangeSummary().isLogging()) {
            ((SDOChangeSummary)copy.getChangeSummary()).setLogging(true);
        }
        return copy;
    }

    public DataObject copy(DataObject dataObject) throws IllegalArgumentException {
        return this.copy(dataObject, null);
    }

    public DataObject copy(DataObject dataObject, SDOChangeSummary cs) throws IllegalArgumentException {
        if (null == dataObject) {
            return null;
        }
        HashMap doMap = new HashMap();
        HashMap ncPropMap = new HashMap();
        DataObject aCopy = this.copyPrivate((SDODataObject)dataObject, doMap, ncPropMap, cs);
        this.processNonContainmentNodesPrivate(doMap, ncPropMap);
        this.processContainmentSequencesPrivate(doMap, cs);
        if (aCopy != null && aCopy.getChangeSummary() != null && ((SDOType)aCopy.getType()).getChangeSummaryProperty() != null) {
            if (((SDODataObject)dataObject).getChangeSummary().isLogging()) {
                ((SDOChangeSummary)aCopy.getChangeSummary()).resumeLogging();
            }
            this.copyChangeSummary(((SDODataObject)dataObject).getChangeSummary(), aCopy.getChangeSummary(), doMap);
        }
        return aCopy;
    }

    private void processNonContainmentNodesPrivate(HashMap doMap, HashMap ncPropMap) {
        for (DataObject sourceDO : ncPropMap.keySet()) {
            ArrayList aList = (ArrayList)ncPropMap.get(sourceDO);
            for (Property aProperty : aList) {
                Object targetDO = sourceDO.get(aProperty);
                boolean isPropertyInsideCopyTreeScope = false;
                DataObject sourceDOCopy = null;
                ArrayList targetDOCopy = null;
                if (aProperty.isMany()) {
                    ListWrapper targetList = (ListWrapper)targetDO;
                    sourceDOCopy = (DataObject)doMap.get(sourceDO);
                    targetDOCopy = new ArrayList();
                    int size = targetList.size();
                    for (int i = 0; i < size; ++i) {
                        DataObject sourceDOCopyKey = (DataObject)targetList.get(i);
                        DataObject sourceDOCopyValue = (DataObject)doMap.get(sourceDOCopyKey);
                        if (sourceDOCopyValue == null) continue;
                        ((List)targetDOCopy).add(sourceDOCopyValue);
                    }
                    isPropertyInsideCopyTreeScope = ((List)targetDOCopy).size() > 0;
                } else {
                    targetDOCopy = (ArrayList)doMap.get(targetDO);
                    sourceDOCopy = (DataObject)doMap.get(sourceDO);
                    boolean bl = isPropertyInsideCopyTreeScope = targetDOCopy != null;
                }
                if (isPropertyInsideCopyTreeScope) {
                    ((SDODataObject)sourceDOCopy).set(aProperty, targetDOCopy, false);
                    continue;
                }
                if (null != aProperty.getOpposite()) continue;
                ((SDODataObject)sourceDOCopy).set(aProperty, targetDO, false);
            }
        }
    }

    private void replicateAndRereferenceSequenceCopyPrivate(SDOSequence origSequence, SDOSequence copySequence, DataObject dataObject, DataObject copy, Map doMap, SDOChangeSummary cs) {
        if (cs != null && cs.isDeleted(dataObject)) {
            origSequence = (SDOSequence)cs.getOldSequence(dataObject);
        }
        Property seqProperty = null;
        try {
            List<Setting> settings = origSequence.getSettings();
            int size = origSequence.size();
            for (int index = 0; index < size; ++index) {
                Object orig;
                Setting nextSetting = settings.get(index);
                seqProperty = origSequence.getProperty(nextSetting);
                if (null == seqProperty || seqProperty.getType().isDataType()) {
                    Setting copySetting = nextSetting.copy((Object)copy);
                    copySequence.getSettings().add(copySetting);
                    copySequence.addValueToSettings(copySetting);
                    continue;
                }
                Object copySeqValue = null;
                Object origSeqValue = origSequence.getValue(index);
                if (cs != null && (orig = cs.getReverseDeletedMap().get(origSeqValue)) != null) {
                    origSeqValue = orig;
                }
                if (origSeqValue instanceof XMLRoot) {
                    origSeqValue = ((XMLRoot)origSeqValue).getObject();
                }
                copySeqValue = null != origSeqValue ? doMap.get(origSeqValue) : null;
                Setting copySetting = nextSetting.copy((Object)copy, copySeqValue);
                copySequence.getSettings().add(copySetting);
                copySequence.addValueToSettings(copySetting);
            }
        }
        catch (ClassCastException cce) {
            throw SDOException.foundSimpleValueForNonDataTypeProperty((String)seqProperty.getName());
        }
    }

    private void processContainmentSequencesPrivate(Map doMap, SDOChangeSummary cs) {
        for (DataObject cObject : doMap.keySet()) {
            DataObject copyDO = (DataObject)doMap.get(cObject);
            if (!cObject.getType().isSequenced()) continue;
            SDOSequence origSequence = (SDOSequence)cObject.getSequence();
            this.replicateAndRereferenceSequenceCopyPrivate(origSequence, (SDOSequence)copyDO.getSequence(), cObject, copyDO, doMap, cs);
        }
    }

    private ValueStore createValueStore() {
        Class aValueStore;
        block9: {
            try {
                String pluggableClassName = System.getProperty("valuestore.impl.class", "org.eclipse.persistence.sdo.DefaultValueStore");
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        aValueStore = (Class)AccessController.doPrivileged(new PrivilegedClassForName(pluggableClassName));
                        break block9;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                aValueStore = PrivilegedAccessHelper.getClassForName((String)pluggableClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException(cnfe.getMessage());
            }
        }
        try {
            return (ValueStore)aValueStore.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(ie.getMessage());
        }
    }

    private void copyChangeSummary(ChangeSummary anOriginalCS, ChangeSummary aCopyCS, Map origDOCS1toCopyDOCS2Map) {
        SDOChangeSummary originalCS = (SDOChangeSummary)anOriginalCS;
        SDOChangeSummary copyCS = (SDOChangeSummary)aCopyCS;
        HashMap<List, ListWrapper> copyListWrapperCS2toCopyOfListCS2Map = new HashMap<List, ListWrapper>();
        HashMap<Object, Property> propertyToOriginalListMap = new HashMap<Object, Property>();
        DataObject anOriginalObject2 = null;
        DataObject aCopyOfOriginalObject = null;
        for (DataObject anOriginalObject2 : originalCS.getDeleted()) {
            aCopyOfOriginalObject = this.copy(anOriginalObject2, null);
            copyCS.getDeleted().add(aCopyOfOriginalObject);
            if (null != origDOCS1toCopyDOCS2Map.get(anOriginalObject2)) continue;
            origDOCS1toCopyDOCS2Map.put(anOriginalObject2, aCopyOfOriginalObject);
        }
        Iterator aIterator = originalCS.getCreated().iterator();
        while (aIterator.hasNext()) {
            copyCS.getCreated().add(origDOCS1toCopyDOCS2Map.get(aIterator.next()));
        }
        Iterator anIterator = originalCS.getModified().iterator();
        while (anIterator.hasNext()) {
            copyCS.getModified().add(origDOCS1toCopyDOCS2Map.get(anIterator.next()));
        }
        ValueStore aVSCopy = null;
        ValueStore aVSOriginal = null;
        for (DataObject anOriginalObject2 : originalCS.getOriginalValueStores().keySet()) {
            aCopyOfOriginalObject = (DataObject)origDOCS1toCopyDOCS2Map.get(anOriginalObject2);
            aVSCopy = this.createValueStore();
            aVSOriginal = (ValueStore)originalCS.getOriginalValueStores().get(anOriginalObject2);
            aVSCopy.initialize(aCopyOfOriginalObject);
            Object aVSPropertyItem = null;
            int size = anOriginalObject2.getType().getDeclaredProperties().size();
            for (int i = 0; i < size; ++i) {
                aVSPropertyItem = aVSOriginal.getDeclaredProperty(i);
                if (!aVSOriginal.isSetDeclaredProperty(i)) continue;
                Property currentProperty = (Property)anOriginalObject2.getType().getDeclaredProperties().get(i);
                if (currentProperty.isMany()) {
                    propertyToOriginalListMap.put(aVSPropertyItem, currentProperty);
                    SDODataObject copyContainer = (SDODataObject)origDOCS1toCopyDOCS2Map.get(anOriginalObject2);
                    ListWrapper aCopyOfListCopy = (ListWrapper)copyContainer.getList(currentProperty);
                    copyListWrapperCS2toCopyOfListCS2Map.put(anOriginalObject2.getList(currentProperty), aCopyOfListCopy);
                    aVSCopy.setDeclaredProperty(i, aCopyOfListCopy);
                    continue;
                }
                if (!currentProperty.getType().isDataType()) {
                    aVSCopy.setDeclaredProperty(i, origDOCS1toCopyDOCS2Map.get(aVSPropertyItem));
                    continue;
                }
                if (currentProperty.getType() == SDOConstants.SDO_CHANGESUMMARY) continue;
                aVSCopy.setDeclaredProperty(i, aVSPropertyItem);
            }
            ArrayList ocPropertiesList = new ArrayList();
            ocPropertiesList.addAll(originalCS.getUnsetOCProperties(anOriginalObject2));
            ocPropertiesList.addAll(((SDODataObject)anOriginalObject2)._getOpenContentProperties());
            ocPropertiesList.addAll(((SDODataObject)anOriginalObject2)._getOpenContentPropertiesAttributes());
            for (Property ocProperty : ocPropertiesList) {
                if (!aVSOriginal.isSetOpenContentProperty(ocProperty)) continue;
                Object anOCPropertyItem = aVSOriginal.getOpenContentProperty(ocProperty);
                if (ocProperty.isMany()) {
                    SDODataObject copyContainer = (SDODataObject)origDOCS1toCopyDOCS2Map.get(anOriginalObject2);
                    ListWrapper aCopyOfListCopy = (ListWrapper)copyContainer.getList(ocProperty);
                    copyListWrapperCS2toCopyOfListCS2Map.put(anOriginalObject2.getList(ocProperty), aCopyOfListCopy);
                    aVSCopy.setOpenContentProperty(ocProperty, aCopyOfListCopy);
                    continue;
                }
                if (!ocProperty.getType().isDataType()) {
                    aVSCopy.setOpenContentProperty(ocProperty, origDOCS1toCopyDOCS2Map.get(aVSPropertyItem));
                    continue;
                }
                aVSCopy.setOpenContentProperty(ocProperty, anOCPropertyItem);
            }
            copyCS.getOriginalValueStores().put(aCopyOfOriginalObject, aVSCopy);
        }
        ListWrapper anOriginalListKey2 = null;
        ListWrapper aCopyListWrapper = null;
        ArrayList<Object> aCopyList = null;
        for (ListWrapper anOriginalListKey2 : originalCS.getOriginalElements().keySet()) {
            Property aProperty = (Property)propertyToOriginalListMap.get(anOriginalListKey2);
            aCopyListWrapper = (ListWrapper)copyListWrapperCS2toCopyOfListCS2Map.get(anOriginalListKey2);
            aCopyList = new ArrayList<Object>();
            Object aListItem2 = null;
            Object aListItemCopy = null;
            for (Object aListItem2 : anOriginalListKey2) {
                aListItemCopy = !aProperty.getType().isDataType() ? (Object)origDOCS1toCopyDOCS2Map.get(aListItem2) : aListItem2;
                aCopyList.add(aListItemCopy);
            }
            aCopyListWrapper.setCurrentElements(aCopyList);
            ArrayList<Object> listValueCopy = new ArrayList<Object>();
            List listValue = (List)originalCS.getOriginalElements().get(anOriginalListKey2);
            aListItem2 = null;
            aListItemCopy = null;
            for (Object aListItem2 : listValue) {
                if (!aProperty.getType().isDataType()) {
                    aListItemCopy = origDOCS1toCopyDOCS2Map.get(aListItem2);
                    if (null == aListItemCopy) {
                        // empty if block
                    }
                } else {
                    aListItemCopy = aListItem2;
                }
                if (aListItemCopy == null) continue;
                listValueCopy.add(aListItemCopy);
            }
            copyCS.getOriginalElements().put(aCopyListWrapper, listValueCopy);
        }
        Map oldContainersMap = originalCS.getOldContainers();
        Map copyContainersMap = copyCS.getOldContainers();
        DataObject oldContainerKey2 = null;
        SDODataObject copyContainerKey = null;
        for (DataObject oldContainerKey2 : oldContainersMap.keySet()) {
            copyContainerKey = (SDODataObject)origDOCS1toCopyDOCS2Map.get(oldContainerKey2);
            DataObject oldContainerValue = null;
            if (null != copyContainersMap.get(copyContainerKey)) continue;
            oldContainerValue = (DataObject)oldContainersMap.get(oldContainerKey2);
            copyContainersMap.put(copyContainerKey, origDOCS1toCopyDOCS2Map.get(oldContainerValue));
        }
        Map oldContainmentPropertyMap = originalCS.getOldContainmentProperty();
        Map copyContainmentPropertyMap = copyCS.getOldContainmentProperty();
        DataObject oldContainmentPropertyKey2 = null;
        SDODataObject copyContainmentPropertyKey = null;
        for (DataObject oldContainmentPropertyKey2 : oldContainmentPropertyMap.keySet()) {
            copyContainmentPropertyKey = (SDODataObject)origDOCS1toCopyDOCS2Map.get(oldContainmentPropertyKey2);
            if (null != copyContainmentPropertyMap.get(copyContainmentPropertyKey)) continue;
            copyContainmentPropertyMap.put(copyContainmentPropertyKey, oldContainmentPropertyMap.get(oldContainmentPropertyKey2));
        }
        Map oldUnsetOCPropertyMap = originalCS.getUnsetOCPropertiesMap();
        SDODataObject oldOCPropertyContainer2 = null;
        for (SDODataObject oldOCPropertyContainer2 : oldUnsetOCPropertyMap.keySet()) {
            Iterator iterUnset = ((List)oldUnsetOCPropertyMap.get(oldOCPropertyContainer2)).iterator();
            while (iterUnset.hasNext()) {
                copyCS.setUnsetOCProperty((SDODataObject)origDOCS1toCopyDOCS2Map.get(oldOCPropertyContainer2), (Property)iterUnset.next());
            }
        }
        for (SDODataObject sequenceDataObjectKey : originalCS.getOriginalSequences().keySet()) {
            SDOSequence originalSequence = (SDOSequence)originalCS.getOriginalSequences().get(sequenceDataObjectKey);
            SDODataObject copyOriginalSequenceDataObject = (SDODataObject)origDOCS1toCopyDOCS2Map.get(originalSequence.getDataObject());
            SDOSequence copySequence = new SDOSequence(copyOriginalSequenceDataObject);
            this.replicateAndRereferenceSequenceCopyPrivate(originalSequence, copySequence, originalSequence.getDataObject(), copyOriginalSequenceDataObject, origDOCS1toCopyDOCS2Map, originalCS);
            copyCS.getOriginalSequences().put(copyOriginalSequenceDataObject, copySequence);
        }
    }

    private DataObject copyPrivate(SDODataObject dataObject, HashMap doMap, HashMap ncPropMap, SDOChangeSummary cs) throws IllegalArgumentException {
        if (null == dataObject) {
            return null;
        }
        SDODataObject copy = (SDODataObject)this.getHelperContext().getDataFactory().create(dataObject.getType().getURI(), dataObject.getType().getName());
        doMap.put(dataObject, copy);
        List ocListOriginal = dataObject._getOpenContentProperties();
        Iterator anOCIterator = ocListOriginal.iterator();
        while (anOCIterator.hasNext()) {
            copy.addOpenContentProperty((Property)anOCIterator.next());
        }
        List ocAttrsListOriginal = dataObject._getOpenContentPropertiesAttributes();
        Iterator anOCAttrIterator = ocAttrsListOriginal.iterator();
        while (anOCAttrIterator.hasNext()) {
            copy.addOpenContentProperty((Property)anOCAttrIterator.next());
        }
        for (Property eachProperty : copy.getInstanceProperties()) {
            boolean isSet = this.isSet(dataObject, eachProperty, cs);
            if (!isSet) continue;
            Object o = this.getValue(dataObject, eachProperty, cs);
            if (eachProperty.getType().isDataType()) {
                if (eachProperty.getType() == SDOConstants.SDO_CHANGESUMMARY) continue;
                copy.setInternal(eachProperty, o, false);
                continue;
            }
            if (eachProperty.isContainment()) {
                this.copyContainmentPropertyValue(copy, eachProperty, o, doMap, ncPropMap, cs);
                continue;
            }
            ArrayList<Property> anArray = (ArrayList<Property>)ncPropMap.get(dataObject);
            if (anArray == null) {
                anArray = new ArrayList<Property>();
                anArray.add(eachProperty);
                ncPropMap.put(dataObject, anArray);
                continue;
            }
            anArray.add(eachProperty);
        }
        return copy;
    }

    private void copyContainmentPropertyValue(SDODataObject copy, Property property, Object value, HashMap doMap, HashMap ncPropMap, SDOChangeSummary cs) {
        if (property.isMany()) {
            ArrayList copyValue = new ArrayList();
            copy.setInternal(property, copyValue, false);
            for (SDODataObject o : (List)value) {
                DataObject copyO = this.copyPrivate(o, doMap, ncPropMap, cs);
                ((ListWrapper)copy.getList(property)).add(copyO, false);
                if (copyO == null || copyO.getChangeSummary() == null || ((SDOType)copyO.getType()).getChangeSummaryProperty() == null) continue;
                if (o.getChangeSummary().isLogging()) {
                    ((SDOChangeSummary)copyO.getChangeSummary()).setLogging(true);
                }
                this.copyChangeSummary(o.getChangeSummary(), copyO.getChangeSummary(), doMap);
            }
        } else {
            DataObject copyO = this.copyPrivate((SDODataObject)value, doMap, ncPropMap, cs);
            copy.setInternal(property, copyO, false);
            if (copyO != null && copyO.getChangeSummary() != null && ((SDOType)copyO.getType()).getChangeSummaryProperty() != null) {
                if (((SDODataObject)value).getChangeSummary().isLogging()) {
                    ((SDOChangeSummary)copyO.getChangeSummary()).setLogging(true);
                }
                this.copyChangeSummary(((SDODataObject)value).getChangeSummary(), copyO.getChangeSummary(), doMap);
            }
        }
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    private boolean isSet(SDODataObject dataObject, Property property, SDOChangeSummary cs) {
        if (cs != null) {
            return cs.wasSet(dataObject, property);
        }
        return dataObject.isSetInternal(property);
    }

    private Object getValue(SDODataObject dataObject, Property property, SDOChangeSummary cs) {
        if (cs != null) {
            Object returnValue = cs.getPropertyInternal(dataObject, property);
            if (property.isMany() && cs.getOriginalElements().containsKey(returnValue)) {
                return cs.getOriginalElements().get(returnValue);
            }
            return returnValue;
        }
        return dataObject.get(property);
    }
}

