/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class MultiplyNode
extends BinaryOperatorNode {
    public void validate(ParseTreeContext context) {
        super.validate(context);
        if (this.left != null && this.right != null) {
            TypeHelper typeHelper = context.getTypeHelper();
            this.setType(typeHelper.extendedBinaryNumericPromotion(this.left.getType(), this.right.getType()));
        }
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = ExpressionMath.multiply(whereClause, this.getRight().generateExpression(context));
        return whereClause;
    }

    public boolean isMultiplyNode() {
        return true;
    }
}

