/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSetting;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SDOMarshalListener
implements XMLMarshalListener {
    private Object marshalledObject;
    private SDOTypeHelper typeHelper;
    private XMLMarshaller xmlMarshaller;

    public SDOMarshalListener(XMLMarshaller aMarshaller, SDOTypeHelper aTypeHelper) {
        this.xmlMarshaller = aMarshaller;
        this.typeHelper = aTypeHelper;
    }

    public void afterMarshal(Object obj) {
    }

    public void beforeMarshal(Object obj) {
        if (obj instanceof SDOChangeSummary) {
            SDOChangeSummary changeSummary = (SDOChangeSummary)obj;
            List createdSet = changeSummary.getCreated();
            ArrayList<String> xpaths = new ArrayList<String>(createdSet.size());
            if (createdSet != null && createdSet.size() > 0) {
                Iterator anIterator = createdSet.iterator();
                SDODataObject nextCreatedDO = null;
                while (anIterator.hasNext()) {
                    nextCreatedDO = (SDODataObject)anIterator.next();
                    xpaths.add("#/" + this.getPathFromAncestor(nextCreatedDO, (SDODataObject)this.marshalledObject, changeSummary));
                }
            }
            changeSummary.setCreatedXPaths(xpaths);
            String xpathMarshalledObjToCS = this.getPathFromAncestor((SDODataObject)changeSummary.getRootObject(), (SDODataObject)this.marshalledObject, changeSummary);
            String xpathChangeSumProp = this.getXPathForProperty(((SDOType)changeSummary.getRootObject().getType()).getChangeSummaryProperty());
            String xpathToCS = "#";
            if (xpathMarshalledObjToCS != null && !xpathMarshalledObjToCS.equals("")) {
                xpathToCS = xpathToCS + "/" + xpathMarshalledObjToCS;
            }
            xpathToCS = xpathToCS + "/" + xpathChangeSumProp + "/";
            ArrayList deletedXPaths = new ArrayList();
            Document document = XMLPlatformFactory.getInstance().getXMLPlatform().createDocument();
            Element csNode = null;
            List modifiedItems = changeSummary.getModified();
            int modifiedSize = modifiedItems.size();
            ArrayList<Element> newNodes = new ArrayList<Element>(modifiedSize);
            SDODataObject nextModifiedDO = null;
            for (int i = 0; i < modifiedSize; ++i) {
                nextModifiedDO = (SDODataObject)modifiedItems.get(i);
                String sdoPrefix = this.typeHelper.getPrefix("commonj.sdo");
                String uri = this.getURI(nextModifiedDO);
                String qualifiedName = this.getQualifiedName(nextModifiedDO);
                String sdoRefPrefix = "#/";
                csNode = uri == null ? document.createElement(qualifiedName) : document.createElementNS(uri, qualifiedName);
                csNode.setAttributeNS("commonj.sdo", sdoPrefix + ":" + "ref", sdoRefPrefix + this.getPathFromAncestor(nextModifiedDO, (SDODataObject)this.marshalledObject, changeSummary));
                Vector namespaces = nextModifiedDO.getType().getXmlDescriptor().getNonNullNamespaceResolver().getNamespaces();
                for (int j = 0; j < namespaces.size(); ++j) {
                    Namespace next = (Namespace)namespaces.get(j);
                    if (!this.declareNamespace(next.getNamespaceURI(), next.getPrefix(), changeSummary.getRootObject())) continue;
                    csNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + next.getPrefix(), next.getNamespaceURI());
                }
                List nextDOSettings = changeSummary.getOldValues(nextModifiedDO);
                DOMRecord row = new DOMRecord(csNode);
                DatabaseSession session = ((SDOXMLHelper)this.typeHelper.getHelperContext().getXMLHelper()).getXmlContext().getSession(0);
                row.setSession((AbstractSession)session);
                SDOSetting nextSetting = null;
                for (int j = 0; j < nextDOSettings.size(); ++j) {
                    nextSetting = (SDOSetting)nextDOSettings.get(j);
                    if (!nextSetting.isSet()) continue;
                    if (!nextSetting.getProperty().getType().isDataType()) {
                        if (nextSetting.getProperty().isMany()) {
                            List values = (List)nextSetting.getValue();
                            for (int k = 0; k < values.size(); ++k) {
                                this.doMarshal((SDOProperty)nextSetting.getProperty(), (DataObject)values.get(k), changeSummary, csNode, nextModifiedDO, deletedXPaths, xpathToCS, sdoPrefix);
                            }
                            continue;
                        }
                        this.doMarshal((SDOProperty)nextSetting.getProperty(), (DataObject)nextSetting.getValue(), changeSummary, csNode, nextModifiedDO, deletedXPaths, xpathToCS, sdoPrefix);
                        continue;
                    }
                    Object value = nextSetting.getValue();
                    if (value == null) {
                        this.marshalNilAttribute((SDOProperty)nextSetting.getProperty(), row);
                        continue;
                    }
                    String xPath = this.getXPathForProperty((SDOProperty)nextSetting.getProperty());
                    XMLField field = new XMLField(xPath);
                    field.setNamespaceResolver(this.typeHelper.getNamespaceResolver());
                    row.put((DatabaseField)field, value);
                }
                List unsetPropNames = changeSummary.getUnsetProps(nextModifiedDO);
                if (!unsetPropNames.isEmpty()) {
                    XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.typeHelper.getHelperContext().getXMLHelper()).getXmlConversionManager();
                    String unsetPropsString = (String)xmlConversionManager.convertObject((Object)unsetPropNames, String.class);
                    csNode.setAttributeNS("commonj.sdo", sdoPrefix + ":" + "unset", unsetPropsString);
                }
                newNodes.add(csNode);
            }
            changeSummary.setDeletedXPaths(deletedXPaths);
            changeSummary.setModifiedDoms(newNodes);
        }
    }

    private void doMarshal(SDOProperty prop, DataObject value, SDOChangeSummary cs, Element csNode, SDODataObject modifiedObject, List deletedXPaths, String xpathToCS, String sdoPrefix) {
        if (value == null) {
            DOMRecord row = new DOMRecord(csNode);
            DatabaseSession session = ((SDOXMLHelper)this.typeHelper.getHelperContext().getXMLHelper()).getXmlContext().getSession(0);
            row.setSession((AbstractSession)session);
            this.marshalNilAttribute(prop, row);
            return;
        }
        boolean isDeleted = false;
        Object original = cs.getReverseDeletedMap().get(value);
        if (original != null && cs.isDeleted((DataObject)original)) {
            isDeleted = true;
        }
        String qualifiedName = this.getXPathForProperty(prop);
        String uri = null;
        uri = prop.isOpenContent() ? prop.getUri() : prop.getContainingType().getURI();
        if (isDeleted) {
            String pathToNode = this.getPathFromAncestor((SDODataObject)original, modifiedObject, cs);
            String containerPath = null;
            containerPath = this.getQualifiedName(modifiedObject);
            deletedXPaths.add(xpathToCS + containerPath + "/" + pathToNode);
            XMLRoot xmlroot = new XMLRoot();
            xmlroot.setObject((Object)value);
            xmlroot.setNamespaceURI(uri);
            xmlroot.setLocalName(qualifiedName);
            this.xmlMarshaller.marshal((Object)xmlroot, (Node)csNode);
        } else {
            Element modifiedElement = null;
            modifiedElement = uri == null ? csNode.getOwnerDocument().createElement(qualifiedName) : csNode.getOwnerDocument().createElementNS(uri, qualifiedName);
            csNode.appendChild(modifiedElement);
            modifiedElement.setAttributeNS("commonj.sdo", sdoPrefix + ":" + "ref", "#/" + this.getPathFromAncestor((SDODataObject)original, (SDODataObject)this.marshalledObject, cs));
            if (((SDODataObject)original).getContainmentProperty() != null && ((SDODataObject)original).getContainmentProperty().getType().isDataObjectType()) {
                String schemaContext = ((SDOType)value.getType()).getXmlDescriptor().getSchemaReference().getSchemaContext();
                QName schemaContextQName = ((SDOType)value.getType()).getXmlDescriptor().getSchemaReference().getSchemaContextAsQName(((SDOType)value.getType()).getXmlDescriptor().getNonNullNamespaceResolver());
                if (schemaContext != null) {
                    String typeValue = schemaContext.substring(1, schemaContext.length());
                    String schemaInstancePrefix = ((SDOType)value.getType()).getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                    String schemaContextUri = schemaContextQName.getNamespaceURI();
                    String schemaContextPrefix = ((SDOType)value.getType()).getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespaceURI(schemaContextUri);
                    if (schemaContextPrefix != null) {
                        modifiedElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + schemaContextPrefix, schemaContextQName.getNamespaceURI());
                    }
                    modifiedElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", schemaInstancePrefix + ":" + "type", typeValue);
                }
            }
        }
    }

    private String getURI(SDODataObject currentObject) {
        String uri = null;
        uri = currentObject.getContainmentProperty() == null ? currentObject.getType().getURI() : this.getUriForProperty(currentObject);
        return uri;
    }

    private String getQualifiedName(SDODataObject currentObject) {
        String qualifiedName = null;
        qualifiedName = currentObject.getContainmentProperty() == null ? currentObject.getType().getXmlDescriptor().getDefaultRootElement() : this.getXPathForProperty(currentObject.getContainmentProperty());
        return qualifiedName;
    }

    public void setMarshalledObject(Object marshalledObject) {
        this.marshalledObject = marshalledObject;
    }

    public Object getMarshalledObject() {
        return this.marshalledObject;
    }

    private boolean declareNamespace(String uri, String prefix, DataObject theDataObject) {
        while (theDataObject != null) {
            NamespaceResolver nr = ((SDOType)theDataObject.getType()).getXmlDescriptor().getNonNullNamespaceResolver();
            String resolvedPrefix = nr.resolveNamespaceURI(uri);
            if (resolvedPrefix != null && !resolvedPrefix.equals("") && resolvedPrefix.equals(prefix)) {
                return false;
            }
            theDataObject = theDataObject.getContainer();
        }
        return true;
    }

    private String getUriForProperty(SDODataObject currentObject) {
        SDOProperty prop = currentObject.getContainmentProperty();
        if (prop.getXmlMapping() != null) {
            return ((XMLField)prop.getXmlMapping().getField()).getXPathFragment().getNamespaceURI();
        }
        return prop.getUri();
    }

    private String getXPathForProperty(SDOProperty prop) {
        return this.getXPathForProperty(prop, false);
    }

    private String getXPathForProperty(SDOProperty prop, boolean removeText) {
        String prefix;
        String uri;
        if (prop.getXmlMapping() != null) {
            String xpath = prop.getXmlMapping().getField().getName();
            if (removeText && xpath.endsWith("/text()")) {
                xpath = xpath.substring(0, xpath.length() - 7);
            }
            return xpath;
        }
        String name = prop.getName();
        if (prop.isOpenContent() && (uri = prop.getUri()) != null && (prefix = this.typeHelper.getNamespaceResolver().resolveNamespaceURI(uri)) != null && !prefix.equals("")) {
            return prefix + ":" + name;
        }
        return name;
    }

    private String getPathFromAncestorPrivate(SDOChangeSummary aChangeSummary, String currentPath, SDODataObject targetDO, SDODataObject currentObject, String aSeparator) {
        SDOProperty parentContainmentProperty;
        if (currentObject == null || targetDO == null || aChangeSummary == null) {
            return currentPath;
        }
        if (currentObject == targetDO) {
            return currentPath;
        }
        DataObject parent = null;
        if (null == currentObject.getContainer()) {
            parent = aChangeSummary.getOldContainer(currentObject);
            parentContainmentProperty = (SDOProperty)aChangeSummary.getOldContainmentProperty(currentObject);
            if (null == parent || null == parentContainmentProperty) {
                return SDOConstants.SDO_XPATH_INVALID_PATH;
            }
        } else {
            parent = currentObject.getContainer();
            parentContainmentProperty = currentObject.getContainmentProperty();
        }
        String parentContainmentPropertyXPath = this.getXPathForProperty(parentContainmentProperty);
        if (parentContainmentProperty.isMany()) {
            ChangeSummary.Setting anOldSetting;
            int index = ((SDODataObject)parent).getList(parentContainmentProperty).indexOf(currentObject);
            if (index < 0 && (anOldSetting = aChangeSummary.getOldValue(parent, parentContainmentProperty)) != null) {
                List aDeletedParent = (List)anOldSetting.getValue();
                index = aDeletedParent.indexOf(aChangeSummary.getDeepCopies().get(currentObject));
            }
            currentPath = parentContainmentPropertyXPath + "[" + (1 + index) + "]" + aSeparator + currentPath;
        } else {
            currentPath = parentContainmentPropertyXPath + aSeparator + currentPath;
        }
        return this.getPathFromAncestorPrivate(aChangeSummary, currentPath, targetDO, (SDODataObject)parent, "/");
    }

    public String getPathFromAncestor(SDODataObject sourceDO, SDODataObject targetDO, SDOChangeSummary cs) {
        if (sourceDO == targetDO) {
            return "";
        }
        return this.getPathFromAncestorPrivate(cs, "", targetDO, sourceDO, "");
    }

    private void marshalNilAttribute(SDOProperty property, DOMRecord row) {
        String xsiPrefix = this.typeHelper.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null || xsiPrefix.equals("")) {
            xsiPrefix = this.typeHelper.getNamespaceResolver().generatePrefix("xsi");
            this.typeHelper.getNamespaceResolver().put(xsiPrefix, "http://www.w3.org/2001/XMLSchema-instance");
        }
        String xPath = this.getXPathForProperty(property, true);
        xPath = xPath + "/@" + xsiPrefix + ":nil";
        XMLField field = new XMLField(xPath);
        field.setNamespaceResolver(this.typeHelper.getNamespaceResolver());
        row.put((DatabaseField)field, (Object)"true");
    }
}

