/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XSDHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.AttributeMimeTypePolicy;
import org.eclipse.persistence.sdo.helper.InstanceClassConverter;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOFragmentMappingAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOMethodAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOProperty
implements Property,
Serializable {
    private String propertyName;
    private SDOType type;
    private Type containingType;
    private boolean isContainment;
    private boolean hasMany;
    private boolean readOnly;
    private List aliasNames;
    private Object defaultValue;
    private boolean isDefaultSet;
    private int indexInType = -1;
    private int indexInDeclaredProperties = -1;
    private Property opposite;
    private boolean xsd;
    private String xsdLocalName;
    private boolean global;
    private boolean namespaceQualified;
    private transient DatabaseMapping xmlMapping;
    private Map propertyValues;
    private boolean nullable;
    private QName xsdType;
    private boolean valueProperty;
    private List appInfoElements;
    private Map appInfoMap;
    private boolean nameCollision;
    private String uri;
    private boolean isSubstitutable;
    private Collection<SDOProperty> substitutableElements;
    private boolean finalized;
    private static boolean isActivationAvailable = false;
    private HelperContext aHelperContext;

    public SDOProperty(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public SDOProperty(HelperContext aContext, String aName) {
        this(aContext);
        this.setName(aName);
    }

    public SDOProperty(HelperContext aContext, String aName, SDOType aType) {
        this(aContext, aName);
        this.setType(aType);
    }

    public SDOProperty(HelperContext aContext, String aUri, String aName, SDOType aType) {
        this(aContext, aName, aType);
        this.setUri(aUri);
    }

    public String getName() {
        return this.propertyName;
    }

    public SDOType getType() {
        return this.type;
    }

    public boolean isMany() {
        return this.hasMany;
    }

    public boolean isOpenContent() {
        int idx = this.getIndexInType();
        return idx == -1;
    }

    public boolean isContainment() {
        return this.isContainment;
    }

    public Type getContainingType() {
        return this.containingType;
    }

    public Object getDefault() {
        if (null == this.defaultValue) {
            return this.type.getPseudoDefault();
        }
        return this.defaultValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Property getOpposite() {
        return this.opposite;
    }

    public List getAliasNames() {
        if (this.aliasNames == null) {
            this.aliasNames = new ArrayList();
        }
        return this.aliasNames;
    }

    public void setName(String name) {
        this.propertyName = name;
    }

    public void setType(Type type) {
        this.type = (SDOType)type;
    }

    public void setContainment(boolean containment) {
        this.isContainment = containment;
    }

    public void setMany(boolean many) {
        this.hasMany = many;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setAliasNames(List names) {
        this.aliasNames = names;
    }

    public void setContainingType(Type type) {
        this.containingType = type;
    }

    public void setDefault(Object aDefaultValue) {
        this.defaultValue = aDefaultValue;
        this.isDefaultSet = true;
    }

    public void setOpposite(Property property) {
        this.opposite = property;
    }

    public void setXsd(boolean xsd) {
        this.xsd = xsd;
    }

    public boolean isXsd() {
        return this.xsd;
    }

    public void setXsdLocalName(String xsdLocalName) {
        this.xsdLocalName = xsdLocalName;
    }

    public String getXsdLocalName() {
        return this.xsdLocalName;
    }

    public void setNamespaceQualified(boolean namespaceQualified) {
        this.namespaceQualified = namespaceQualified;
    }

    public boolean isNamespaceQualified() {
        return this.namespaceQualified;
    }

    public void setXmlMapping(DatabaseMapping xmlMapping) {
        this.xmlMapping = xmlMapping;
    }

    public DatabaseMapping getXmlMapping() {
        return this.xmlMapping;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isGlobal() {
        return this.global;
    }

    private void setIsSetNillablePolicyOnMapping(XMLNillableMapping aMapping, Object propertyName) {
        AbstractNullPolicy aNullPolicy = this.setIsSetPolicyOnMapping(aMapping, propertyName);
        aNullPolicy.setNullRepresentedByEmptyNode(false);
        aNullPolicy.setNullRepresentedByXsiNil(true);
        aNullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
    }

    private void setIsSetOptionalPolicyOnMapping(XMLNillableMapping aMapping, Object propertyName) {
        AbstractNullPolicy aNullPolicy = this.setIsSetPolicyOnMapping(aMapping, propertyName);
        aNullPolicy.setNullRepresentedByEmptyNode(false);
        aNullPolicy.setNullRepresentedByXsiNil(false);
        aNullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.EMPTY_NODE);
    }

    private AbstractNullPolicy setIsSetPolicyOnMapping(XMLNillableMapping aMapping, Object propertyName) {
        IsSetNullPolicy aNullPolicy = new IsSetNullPolicy();
        aNullPolicy.setIsSetMethodName("isSet");
        aNullPolicy.setIsSetParameterTypes(new Class[]{ClassConstants.STRING});
        aNullPolicy.setIsSetParameters(new Object[]{propertyName});
        aMapping.setNullPolicy((AbstractNullPolicy)aNullPolicy);
        return aNullPolicy;
    }

    public void buildMapping(String mappingUri) {
        this.buildMapping(mappingUri, -1);
    }

    public void buildMapping(String mappingUri, int indexToAdd) {
        if (this.getContainingType().isDataType()) {
            return;
        }
        if (this.getType().isChangeSummaryType()) {
            this.buildChangeSummaryMapping();
            this.addMappingToOwner(false, indexToAdd);
        } else if (this.isNameCollision()) {
            this.xmlMapping = new XMLAnyCollectionMapping();
            this.xmlMapping.setAttributeName(this.getName());
            this.addMappingToOwner(true, indexToAdd);
        } else {
            boolean sdoMethodAccessor = true;
            if (!this.getType().isDataType()) {
                if (this.getType().isDataObjectType()) {
                    this.getType().setImplClassName("org.eclipse.persistence.sdo.SDODataObject");
                    if (this.getXsdType() != null && !this.getXsdType().equals(SDOConstants.ANY_TYPE_QNAME)) {
                        this.xmlMapping = this.isMany() ? this.buildXMLCompositeCollectionMapping(mappingUri) : this.buildXMLCompositeObjectMapping(mappingUri);
                    } else {
                        sdoMethodAccessor = false;
                        this.xmlMapping = this.isMany() ? this.buildXMLFragmentCollectionMapping(mappingUri) : this.buildXMLFragmentMapping(mappingUri);
                    }
                } else {
                    if (!this.getType().isFinalized()) {
                        this.getType().getNonFinalizedReferencingProps().add(this);
                        this.getType().getNonFinalizedMappingURIs().add(mappingUri);
                        return;
                    }
                    this.xmlMapping = this.isSubstitutable() ? (this.isMany() ? this.buildXMLChoiceCollectionMapping(mappingUri) : this.buildXMLChoiceObjectMapping(mappingUri)) : (this.isMany() ? (this.isContainment() ? this.buildXMLCompositeCollectionMapping(mappingUri) : this.buildXMLCollectionReferenceMapping(mappingUri)) : (this.isContainment() ? this.buildXMLCompositeObjectMapping(mappingUri) : this.buildXMLObjectReferenceMapping(mappingUri)));
                }
            } else if (this.isMany()) {
                MimeTypePolicy mimeTypePolicy = this.getMimeTypePolicy();
                this.xmlMapping = isActivationAvailable && !this.aHelperContext.getXSDHelper().isAttribute((Property)this) && (mimeTypePolicy != null || this.getType().getInstanceClass() != null && this.getType().getInstanceClass().getName().equals("javax.activation.DataHandler") || this.getXsdType() != null && this.getXsdType().equals(XMLConstants.BASE_64_BINARY_QNAME)) ? this.buildXMLBinaryDataCollectionMapping(mappingUri, mimeTypePolicy) : (this.isSubstitutable() ? this.buildXMLChoiceCollectionMapping(mappingUri) : this.buildXMLCompositeDirectCollectionMapping(mappingUri));
            } else {
                MimeTypePolicy mimeTypePolicy = this.getMimeTypePolicy();
                this.xmlMapping = isActivationAvailable && !this.aHelperContext.getXSDHelper().isAttribute((Property)this) && (mimeTypePolicy != null || this.getType().getInstanceClass() != null && this.getType().getInstanceClass().getName().equals("javax.activation.DataHandler") || this.getXsdType() != null && this.getXsdType().equals(XMLConstants.BASE_64_BINARY_QNAME)) ? this.buildXMLBinaryDataMapping(mappingUri, mimeTypePolicy) : (this.isSubstitutable() ? this.buildXMLChoiceObjectMapping(mappingUri) : this.buildXMLDirectMapping(mappingUri));
            }
            this.addMappingToOwner(sdoMethodAccessor, indexToAdd);
        }
    }

    public void buildChangeSummaryMapping() {
        XMLCompositeObjectMapping aCMapping = new XMLCompositeObjectMapping();
        aCMapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(this.getContainingType().getURI(), false);
        aCMapping.setXPath(xpath);
        aCMapping.setGetMethodName("getChangeSummary");
        aCMapping.setSetMethodName("_setChangeSummary");
        aCMapping.setReferenceClass(SDOChangeSummary.class);
        if (this.nullable) {
            this.setIsSetNillablePolicyOnMapping((XMLNillableMapping)aCMapping, this.propertyName);
        } else {
            this.setIsSetOptionalPolicyOnMapping((XMLNillableMapping)aCMapping, this.propertyName);
        }
        this.setXmlMapping((DatabaseMapping)aCMapping);
    }

    private void addMappingToOwner(boolean sdoMethodAttributeAccessor, int indexToAdd) {
        if (this.xmlMapping != null) {
            if (sdoMethodAttributeAccessor) {
                SDOMethodAttributeAccessor accessor = null;
                if (this.getType().isDataType()) {
                    Class theClass = this.getType().getInstanceClass();
                    accessor = new SDOMethodAttributeAccessor(this, theClass);
                } else {
                    accessor = new SDOMethodAttributeAccessor(this);
                }
                this.xmlMapping.setAttributeAccessor((AttributeAccessor)accessor);
            }
            if (this.getContainingType() != null && !this.getContainingType().isDataType()) {
                XMLDescriptor containingDescriptor = ((SDOType)this.getContainingType()).getXmlDescriptor();
                this.xmlMapping.setDescriptor((ClassDescriptor)containingDescriptor);
                XMLMapping mapping = (XMLMapping)((SDOType)this.getContainingType()).getXmlDescriptor().getMappingForAttributeName(this.getName());
                if (mapping != null) {
                    ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().remove(mapping);
                }
                if (indexToAdd > -1 && indexToAdd < ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().size()) {
                    ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().add(indexToAdd, this.xmlMapping);
                } else {
                    ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().add(this.xmlMapping);
                }
            }
        }
    }

    private DatabaseMapping buildXMLBinaryDataMapping(String mappingUri, MimeTypePolicy mimeTypePolicy) {
        XMLBinaryDataMapping mapping = new XMLBinaryDataMapping();
        mapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(mappingUri, false);
        mapping.setMimeTypePolicy(mimeTypePolicy);
        mapping.setXPath(xpath);
        if (this.getXsdType() != null) {
            ((XMLField)mapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter converter = new InstanceClassConverter();
            converter.setCustomClass(this.getType().getInstanceClass());
            mapping.setConverter((Converter)converter);
        }
        return mapping;
    }

    private DatabaseMapping buildXMLBinaryDataCollectionMapping(String mappingUri, MimeTypePolicy mimeTypePolicy) {
        XMLBinaryDataCollectionMapping mapping = new XMLBinaryDataCollectionMapping();
        mapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(mappingUri, false);
        if (!this.getType().getInstanceClassName().equals("javax.activation.DataHandler")) {
            mapping.setAttributeElementClass(this.getType().getInstanceClass());
        }
        mapping.setMimeTypePolicy(mimeTypePolicy);
        mapping.setXPath(xpath);
        if (this.getXsdType() != null) {
            ((XMLField)mapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter converter = new InstanceClassConverter();
            converter.setCustomClass(this.getType().getInstanceClass());
            mapping.setValueConverter((Converter)converter);
        }
        return mapping;
    }

    private DatabaseMapping buildXMLDirectMapping(String mappingUri) {
        XMLDirectMapping mapping = new XMLDirectMapping();
        mapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(mappingUri, true);
        mapping.setXPath(xpath);
        if (this.getXsdType() != null) {
            ((XMLField)mapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.getType().getInstanceClass() != null && this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter converter = new InstanceClassConverter();
            converter.setCustomClass(this.getType().getInstanceClass());
            mapping.setConverter((Converter)converter);
        }
        if (this.nullable) {
            this.setIsSetNillablePolicyOnMapping((XMLNillableMapping)mapping, this.propertyName);
        } else {
            this.setIsSetOptionalPolicyOnMapping((XMLNillableMapping)mapping, this.propertyName);
        }
        return mapping;
    }

    private DatabaseMapping buildXMLCompositeDirectCollectionMapping(String mappingUri) {
        XMLCompositeDirectCollectionMapping mapping = new XMLCompositeDirectCollectionMapping();
        mapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(mappingUri, true);
        mapping.setXPath(xpath);
        mapping.setAttributeElementClass(this.getType().getInstanceClass());
        if (this.getXsdType() != null) {
            ((XMLField)mapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.getType().getInstanceClass() != null && this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter converter = new InstanceClassConverter();
            converter.setCustomClass(this.getType().getInstanceClass());
            mapping.setValueConverter((Converter)converter);
        }
        return mapping;
    }

    private DatabaseMapping buildXMLCompositeCollectionMapping(String mappingUri) {
        XMLCompositeCollectionMapping mapping = new XMLCompositeCollectionMapping();
        mapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(mappingUri, false);
        mapping.setXPath(xpath);
        if (!this.getType().isDataObjectType()) {
            QName schemaContext = this.getType().getXmlDescriptor().getSchemaReference().getSchemaContextAsQName(this.getType().getXmlDescriptor().getNamespaceResolver());
            ((XMLField)mapping.getField()).setLeafElementType(schemaContext);
            mapping.setReferenceClassName(this.getType().getImplClassName());
            mapping.setReferenceClass(this.getType().getImplClass());
        } else if (this.getXsdType() != null) {
            ((XMLField)mapping.getField()).setLeafElementType(this.getXsdType());
        }
        mapping.useCollectionClass(ListWrapper.class);
        return mapping;
    }

    private DatabaseMapping buildXMLCompositeObjectMapping(String mappingUri) {
        XMLCompositeObjectMapping mapping = new XMLCompositeObjectMapping();
        mapping.setAttributeName(this.getName());
        String xpath = this.getQualifiedXPath(mappingUri, false);
        mapping.setXPath(xpath);
        if (!this.getType().isDataObjectType()) {
            QName schemaContext = this.getType().getXmlDescriptor().getSchemaReference().getSchemaContextAsQName(this.getType().getXmlDescriptor().getNamespaceResolver());
            ((XMLField)mapping.getField()).setLeafElementType(schemaContext);
            mapping.setReferenceClassName(this.getType().getImplClassName());
            mapping.setReferenceClass(this.getType().getImplClass());
        } else if (this.getXsdType() != null) {
            ((XMLField)mapping.getField()).setLeafElementType(this.getXsdType());
        }
        if (this.nullable) {
            this.setIsSetNillablePolicyOnMapping((XMLNillableMapping)mapping, this.propertyName);
        } else {
            this.setIsSetOptionalPolicyOnMapping((XMLNillableMapping)mapping, this.propertyName);
        }
        return mapping;
    }

    private DatabaseMapping buildXMLObjectReferenceMapping(String mappingUri) {
        XMLObjectReferenceMapping mapping = new XMLObjectReferenceMapping();
        mapping.setAttributeName(this.getName());
        if (this.getType().isDataObjectType()) {
            this.getType().setImplClassName("org.eclipse.persistence.sdo.SDODataObject");
        }
        mapping.setReferenceClassName(this.getType().getImplClassName());
        mapping.setReferenceClass(this.getType().getImplClass());
        String sourcexpath = this.getQualifiedXPath(this.getContainingType().getURI(), true);
        SDOProperty targetIDProp = this.getIDProp(this.getType());
        if (targetIDProp == null) {
            throw SDOException.noTargetIdSpecified((String)this.getType().getURI(), (String)this.getType().getName());
        }
        String targetxpath = targetIDProp.getQualifiedXPath(this.getType().getURI(), true);
        mapping.addSourceToTargetKeyFieldAssociation(sourcexpath, targetxpath);
        return mapping;
    }

    private DatabaseMapping buildXMLChoiceObjectMapping(String mappingUri) {
        XMLChoiceObjectMapping mapping = new XMLChoiceObjectMapping();
        mapping.setAttributeName(this.getName());
        String xPath = this.getQualifiedXPath(mappingUri, this.getType().isDataType());
        mapping.addChoiceElement(xPath, this.getType().getImplClass());
        for (SDOProperty nextProp : this.getSubstitutableElements()) {
            xPath = nextProp.getQualifiedXPath(mappingUri, nextProp.getType().isDataType(), (SDOType)this.getContainingType());
            mapping.addChoiceElement(xPath, nextProp.getType().getImplClass());
        }
        return mapping;
    }

    private DatabaseMapping buildXMLChoiceCollectionMapping(String mappingUri) {
        XMLChoiceCollectionMapping mapping = new XMLChoiceCollectionMapping();
        mapping.setAttributeName(this.getName());
        mapping.useCollectionClass(ListWrapper.class);
        String xPath = this.getQualifiedXPath(mappingUri, this.getType().isDataType());
        mapping.addChoiceElement(xPath, this.getType().getImplClass());
        for (SDOProperty nextProp : this.getSubstitutableElements()) {
            xPath = nextProp.getQualifiedXPath(mappingUri, nextProp.getType().isDataType(), (SDOType)this.getContainingType());
            mapping.addChoiceElement(xPath, nextProp.getType().getImplClass());
        }
        return mapping;
    }

    private SDOProperty getIDProp(Type aType) {
        return (SDOProperty)aType.getProperty((String)aType.get((Property)SDOConstants.ID_PROPERTY));
    }

    private DatabaseMapping buildXMLCollectionReferenceMapping(String mappingUri) {
        XMLCollectionReferenceMapping mapping = new XMLCollectionReferenceMapping();
        mapping.setAttributeName(this.getName());
        if (this.getType().isDataObjectType()) {
            this.getType().setImplClassName("org.eclipse.persistence.sdo.SDODataObject");
        }
        mapping.setReferenceClassName(this.getType().getImplClassName());
        mapping.setReferenceClass(this.getType().getImplClass());
        mapping.setUsesSingleNode(true);
        mapping.useCollectionClass(ArrayList.class);
        String sourcexpath = this.getQualifiedXPath(this.getContainingType().getURI(), true);
        SDOProperty targetIDProp = this.getIDProp(this.getType());
        if (targetIDProp == null) {
            throw SDOException.noTargetIdSpecified((String)this.getType().getURI(), (String)this.getType().getName());
        }
        String targetxpath = targetIDProp.getQualifiedXPath(this.getType().getURI(), true);
        mapping.addSourceToTargetKeyFieldAssociation(sourcexpath, targetxpath);
        return mapping;
    }

    private boolean shouldAddInstanceClassConverter() {
        Object value = this.getType().get(SDOConstants.JAVA_CLASS_PROPERTY);
        if (this.getType().isDataType() && value != null) {
            Class instanceClass = this.getType().getInstanceClass();
            String instanceClassName = this.getType().getInstanceClassName();
            return (instanceClassName == null || !instanceClassName.equals("javax.activation.DataHandler")) && instanceClass != ClassConstants.ABYTE && instanceClass != ClassConstants.APBYTE && instanceClass != ClassConstants.BYTE && instanceClass != ClassConstants.PBYTE && instanceClass != ClassConstants.CHAR && instanceClass != ClassConstants.PCHAR && instanceClass != ClassConstants.DOUBLE && instanceClass != ClassConstants.PDOUBLE && instanceClass != ClassConstants.FLOAT && instanceClass != ClassConstants.PFLOAT && instanceClass != ClassConstants.LONG && instanceClass != ClassConstants.PLONG && instanceClass != ClassConstants.SHORT && instanceClass != ClassConstants.PSHORT && instanceClass != ClassConstants.INTEGER && instanceClass != ClassConstants.PINT && instanceClass != ClassConstants.BIGDECIMAL && instanceClass != ClassConstants.BIGINTEGER && instanceClass != ClassConstants.STRING && instanceClass != ClassConstants.UTILDATE && instanceClass != ClassConstants.CALENDAR && instanceClass != ClassConstants.TIME && instanceClass != ClassConstants.SQLDATE && instanceClass != ClassConstants.TIMESTAMP;
        }
        return false;
    }

    public String getXPath() {
        String xpath = this.getXsdLocalName();
        if (xpath == null) {
            xpath = this.getName();
        }
        return xpath;
    }

    public String getQualifiedXPath(String uri, boolean simple) {
        SDOType containingType = (SDOType)this.getContainingType();
        return this.getQualifiedXPath(uri, simple, containingType);
    }

    private String getQualifiedXPath(String uri, boolean simple, SDOType containingType) {
        if (this.valueProperty) {
            return "text()";
        }
        String xpath = this.getXPath();
        String prefix = null;
        if (this.isNamespaceQualified()) {
            prefix = containingType.getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespaceURI(uri);
        }
        if (this.aHelperContext.getXSDHelper().isAttribute((Property)this)) {
            if (prefix != null) {
                xpath = prefix + ":" + xpath;
            }
            xpath = "@" + xpath;
        } else {
            if (prefix != null) {
                xpath = prefix + ":" + xpath;
            }
            if (simple) {
                xpath = xpath + "/text()";
            }
        }
        return xpath;
    }

    public Object get(Property property) {
        return this.getPropertyValues().get(property);
    }

    public List getInstanceProperties() {
        return new ArrayList(this.getPropertyValues().keySet());
    }

    public void setPropertyValues(Map properties) {
        this.propertyValues = properties;
    }

    public Map getPropertyValues() {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap();
        }
        return this.propertyValues;
    }

    public void setInstanceProperty(Property property, Object value) {
        this.getPropertyValues().put(property, value);
        if ("commonj.sdo/xml".equals(((SDOProperty)property).getUri()) && "dataType".equals(property.getName()) && value instanceof Type) {
            this.setType((Type)value);
        }
        if ("org.eclipse.persistence.sdo".equals(((SDOProperty)property).getUri()) && "xmlSchemaType".equals(property.getName()) && value instanceof Type) {
            Type schemaType = (Type)value;
            QName schemaTypeQName = new QName(schemaType.getURI(), schemaType.getName());
            this.setXsdType(schemaTypeQName);
        }
    }

    public void setIndexInType(int indexInType) {
        this.indexInType = indexInType;
    }

    public int getIndexInType() {
        if (this.indexInType == -1 && this.getContainingType() != null) {
            this.indexInType = this.getContainingType().getProperties().indexOf(this);
        }
        return this.indexInType;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setXsdType(QName xsdType) {
        this.xsdType = xsdType;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    public MimeTypePolicy getMimeTypePolicy() {
        String mimeType = (String)this.get(SDOConstants.MIME_TYPE_PROPERTY);
        if (mimeType != null) {
            return new FixedMimeTypePolicy(mimeType);
        }
        mimeType = (String)this.get(SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        if (mimeType != null) {
            return new AttributeMimeTypePolicy(mimeType);
        }
        return null;
    }

    public void setIndexInDeclaredProperties(int indexInDeclaredProperties) {
        this.indexInDeclaredProperties = indexInDeclaredProperties;
    }

    public int getIndexInDeclaredProperties() {
        if (this.indexInDeclaredProperties == -1 && this.getContainingType() != null) {
            this.indexInDeclaredProperties = this.getContainingType().getDeclaredProperties().indexOf(this);
        }
        return this.indexInDeclaredProperties;
    }

    public void setValueProperty(boolean valueProperty) {
        this.valueProperty = valueProperty;
    }

    public boolean isValueProperty() {
        return this.valueProperty;
    }

    public void setAppInfoElements(List appInfoElements) {
        this.appInfoElements = appInfoElements;
    }

    public List getAppInfoElements() {
        return this.appInfoElements;
    }

    public Map getAppInfoMap() {
        if (this.appInfoMap == null) {
            this.appInfoMap = ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).buildAppInfoMap(this.appInfoElements);
        }
        return this.appInfoMap;
    }

    public void setNameCollision(boolean nameCollision) {
        this.nameCollision = nameCollision;
    }

    public boolean isNameCollision() {
        return this.nameCollision;
    }

    public boolean isDefaultSet() {
        return this.isDefaultSet;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public XMLFragmentMapping buildXMLFragmentMapping(String uri) {
        XMLFragmentMapping mapping = new XMLFragmentMapping();
        mapping.setAttributeName(this.getName());
        mapping.setXPath(this.getQualifiedXPath(uri, false));
        mapping.setAttributeAccessor((AttributeAccessor)new SDOFragmentMappingAttributeAccessor(this, this.aHelperContext));
        return mapping;
    }

    public XMLFragmentCollectionMapping buildXMLFragmentCollectionMapping(String mappingUri) {
        XMLFragmentCollectionMapping mapping = new XMLFragmentCollectionMapping();
        mapping.setAttributeName(this.getName());
        mapping.setXPath(this.getQualifiedXPath(mappingUri, false));
        mapping.setAttributeAccessor((AttributeAccessor)new SDOFragmentMappingAttributeAccessor(this, this.aHelperContext));
        return mapping;
    }

    public boolean isSubstitutable() {
        return this.isSubstitutable;
    }

    public void setSubstitutable(boolean substitutable) {
        this.isSubstitutable = substitutable;
    }

    public Collection<SDOProperty> getSubstitutableElements() {
        return this.substitutableElements;
    }

    public void setSubstitutableElements(Collection<SDOProperty> elements) {
        this.substitutableElements = elements;
    }

    public void setFinalized(boolean isFinalized) {
        this.finalized = isFinalized;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.getName() ? 0 : this.getName().hashCode());
        hash = 31 * hash + (null == this.getUri() ? 0 : this.getUri().hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        SDOProperty prop;
        if (obj == null) {
            return false;
        }
        try {
            prop = (SDOProperty)obj;
        }
        catch (ClassCastException ccx) {
            return false;
        }
        if (prop.getType() == null ? this.getType() != null : this.getType() == null || !this.getType().equals(prop.getType())) {
            return false;
        }
        if (prop.getName() == null ? this.getName() != null : this.getName() == null || !this.getName().equals(prop.getName())) {
            return false;
        }
        if (prop.getUri() == null ? this.getUri() != null : this.getUri() == null || !this.getUri().equals(prop.getUri())) {
            return false;
        }
        XSDHelper helper = this.aHelperContext.getXSDHelper();
        return !(helper.isAttribute((Property)this) ? helper.isElement((Property)prop) : helper.isAttribute((Property)prop));
    }

    static {
        try {
            PrivilegedAccessHelper.getClassForName((String)"javax.activation.DataHandler");
            isActivationAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

