/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.AttributeGroup;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Group;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.internal.oxm.schema.model.Union;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.eclipse.persistence.sdo.helper.SchemaResolverWrapper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;
import org.eclipse.persistence.sdo.types.SDOWrapperType;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOTypesGenerator {
    private Project schemaProject;
    private Schema rootSchema;
    private HashMap processedComplexTypes = new HashMap();
    private HashMap processedSimpleTypes = new HashMap();
    private HashMap processedElements = new HashMap();
    private HashMap processedAttributes = new HashMap();
    private Map itemNameToSDOName = new HashMap();
    private boolean processImports;
    private boolean returnAllTypes;
    private java.util.List namespaceResolvers = new ArrayList();
    private boolean inRestriction;
    private HelperContext aHelperContext;
    private Map<QName, Type> generatedTypes;
    private Map<QName, Property> generatedGlobalElements;
    private Map<QName, Property> generatedGlobalAttributes;
    private String packageName;
    private java.util.List<NonContainmentReference> nonContainmentReferences;
    private Map<Type, java.util.List<GlobalRef>> globalRefs;
    private boolean isImportProcessor;

    public SDOTypesGenerator(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public java.util.List<Type> define(Source xsdSource, SchemaResolver schemaResolver) {
        return this.define(xsdSource, schemaResolver, false, true);
    }

    public java.util.List<Type> define(Source xsdSource, SchemaResolver schemaResolver, boolean includeAllTypes, boolean processImports) {
        Schema schema = this.getSchema(xsdSource, schemaResolver);
        return this.define(schema, includeAllTypes, processImports);
    }

    public java.util.List<Type> define(Schema schema, boolean includeAllTypes, boolean processImports) {
        ArrayList<Type> returnList = new ArrayList<Type>();
        this.setReturnAllTypes(includeAllTypes);
        this.setProcessImports(processImports);
        this.processSchema(schema);
        returnList.addAll(this.getGeneratedTypes().values());
        if (!this.isImportProcessor()) {
            SDOProperty nextSDOProperty;
            ArrayList<Type> descriptorsToAdd = new ArrayList<Type>(this.getGeneratedTypes().values());
            for (SDOType sDOType : this.getGeneratedTypes().values()) {
                if (!sDOType.isFinalized()) {
                    throw SDOException.typeReferencedButNotDefined((String)sDOType.getURI(), (String)sDOType.getName());
                }
                for (SDOProperty prop : sDOType.getProperties()) {
                    if (!prop.getType().isDataType() || !prop.isContainment()) continue;
                    prop.setContainment(false);
                }
            }
            for (SDOProperty sDOProperty : this.getGeneratedGlobalElements().values()) {
                if (sDOProperty.isFinalized()) continue;
                throw SDOException.referencedPropertyNotFound((String)sDOProperty.getUri(), (String)sDOProperty.getName());
            }
            for (SDOProperty sDOProperty : this.getGeneratedGlobalAttributes().values()) {
                if (sDOProperty.isFinalized()) continue;
                throw SDOException.referencedPropertyNotFound((String)sDOProperty.getUri(), (String)sDOProperty.getName());
            }
            for (SDOType sDOType : this.getGeneratedTypes().values()) {
                ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addType(sDOType);
                if (!sDOType.isDataType() && sDOType.getBaseTypes().size() == 0 && sDOType.getSubTypes().size() > 0) {
                    sDOType.setupInheritance(null);
                    continue;
                }
                if (sDOType.isDataType() || sDOType.getBaseTypes().size() <= 0 || this.getGeneratedTypes().values().contains(sDOType.getBaseTypes().get(0))) continue;
                SDOType baseType = (SDOType)sDOType.getBaseTypes().get(0);
                while (baseType != null) {
                    descriptorsToAdd.add(baseType);
                    if (baseType.getBaseTypes().size() == 0) {
                        descriptorsToAdd.add(baseType);
                        baseType.setupInheritance(null);
                        baseType = null;
                        continue;
                    }
                    baseType = (SDOType)baseType.getBaseTypes().get(0);
                }
            }
            ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(descriptorsToAdd);
            for (QName nextQName : this.getGeneratedGlobalElements().keySet()) {
                nextSDOProperty = (SDOProperty)this.getGeneratedGlobalElements().get(nextQName);
                ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(nextQName, nextSDOProperty, true);
            }
            for (QName nextQName : this.getGeneratedGlobalAttributes().keySet()) {
                nextSDOProperty = (SDOProperty)this.getGeneratedGlobalAttributes().get(nextQName);
                ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(nextQName, nextSDOProperty, false);
            }
            for (java.util.List<GlobalRef> nextList : this.getGlobalRefs().values()) {
                if (nextList.size() <= 0) continue;
                GlobalRef ref = nextList.get(0);
                throw SDOException.referencedPropertyNotFound((String)((SDOProperty)ref.getProperty()).getUri(), (String)ref.getProperty().getName());
            }
        }
        return returnList;
    }

    private void processSchema(Schema parsedSchema) {
        this.rootSchema = parsedSchema;
        this.initialize();
        this.namespaceResolvers.add(this.rootSchema.getNamespaceResolver());
        this.processIncludes(this.rootSchema.getIncludes());
        this.processImports(this.rootSchema.getImports());
        this.processGlobalAttributes(this.rootSchema);
        this.processGlobalElements(this.rootSchema);
        this.processGlobalSimpleTypes(this.rootSchema);
        this.processGlobalComplexTypes(this.rootSchema);
        this.postProcessing();
    }

    private void processImports(java.util.List imports) {
        if (imports == null || imports.size() == 0 || !this.isProcessImports()) {
            return;
        }
        for (Import nextImport : imports) {
            try {
                this.processImportIncludeInternal((Include)nextImport);
            }
            catch (Exception e) {
                throw SDOException.errorProcessingImport((String)nextImport.getSchemaLocation(), (String)nextImport.getNamespace(), (Exception)e);
            }
        }
    }

    private void processIncludes(java.util.List includes) {
        if (includes == null || includes.size() == 0 || !this.isProcessImports()) {
            return;
        }
        for (Include nextInclude : includes) {
            try {
                this.processImportIncludeInternal(nextInclude);
            }
            catch (Exception e) {
                throw SDOException.errorProcessingInclude((String)nextInclude.getSchemaLocation(), (Exception)e);
            }
        }
    }

    private void processImportIncludeInternal(Include theImportOrInclude) throws Exception {
        if (theImportOrInclude.getSchema() != null) {
            SDOTypesGenerator generator = new SDOTypesGenerator(this.aHelperContext);
            generator.setGeneratedTypes(this.getGeneratedTypes());
            generator.setIsImportProcessor(true);
            java.util.List<Type> importedTypes = generator.define(theImportOrInclude.getSchema(), this.isReturnAllTypes(), this.isProcessImports());
            this.processedComplexTypes.putAll(generator.processedComplexTypes);
            this.processedSimpleTypes.putAll(generator.processedSimpleTypes);
            this.processedElements.putAll(generator.processedElements);
            this.processedAttributes.putAll(generator.processedAttributes);
            if (null != importedTypes) {
                int size = importedTypes.size();
                for (int i = 0; i < size; ++i) {
                    Type nextType = importedTypes.get(i);
                    String name = nextType.getName();
                    QName qname = new QName(nextType.getURI(), name);
                    this.getGeneratedTypes().put(qname, nextType);
                }
            }
            for (QName nextKey : generator.getGeneratedGlobalElements().keySet()) {
                this.getGeneratedGlobalElements().put(nextKey, generator.getGeneratedGlobalElements().get(nextKey));
            }
            for (QName nextKey : generator.getGeneratedGlobalAttributes().keySet()) {
                this.getGeneratedGlobalAttributes().put(nextKey, generator.getGeneratedGlobalAttributes().get(nextKey));
            }
            for (Type nextKey : generator.getGlobalRefs().keySet()) {
                this.getGlobalRefs().put(nextKey, generator.getGlobalRefs().get(nextKey));
            }
        }
    }

    private boolean typesExists(String targetNamespace, String sdoTypeName) {
        boolean alreadyProcessed = false;
        if (targetNamespace != null && (targetNamespace.equals("commonj.sdo/java") || targetNamespace.equals("commonj.sdo") || targetNamespace.equals("commonj.sdo/xml"))) {
            alreadyProcessed = true;
        } else {
            QName qname = new QName(targetNamespace, sdoTypeName);
            Object processed = this.processedComplexTypes.get(qname);
            if (processed != null) {
                alreadyProcessed = true;
            }
        }
        if (!alreadyProcessed) {
            QName qname;
            SDOType lookup = (SDOType)this.aHelperContext.getTypeHelper().getType(targetNamespace, sdoTypeName);
            if (lookup != null && lookup.isFinalized()) {
                if (this.isReturnAllTypes()) {
                    qname = new QName(targetNamespace, sdoTypeName);
                    this.getGeneratedTypes().put(qname, lookup);
                }
                return true;
            }
            if (lookup == null) {
                qname = new QName(targetNamespace, sdoTypeName);
                SDOType processed = (SDOType)this.getGeneratedTypes().get(qname);
                if (processed != null && processed.isFinalized()) {
                    alreadyProcessed = true;
                }
            }
        }
        return alreadyProcessed;
    }

    private void processGlobalComplexTypes(Schema schema) {
        Collection complexTypes = schema.getTopLevelComplexTypes().values();
        if (complexTypes == null) {
            return;
        }
        for (ComplexType complexType : complexTypes) {
            this.processGlobalComplexType(schema.getTargetNamespace(), schema.getDefaultNamespace(), complexType);
        }
    }

    private void processGlobalComplexType(String targetNamespace, String defaultNamespace, ComplexType complexType) {
        QName qname = new QName(targetNamespace, complexType.getName());
        Object processed = this.processedComplexTypes.get(qname);
        if (processed == null) {
            this.processComplexType(targetNamespace, defaultNamespace, complexType.getName(), complexType);
            this.processedComplexTypes.put(qname, complexType);
        }
    }

    private void processComplexType(String targetNamespace, String defaultNamespace, String name, ComplexType complexType) {
        if (complexType == null) {
            return;
        }
        boolean addedNR = this.addNextNamespaceResolver(complexType.getAttributesMap());
        boolean newType = this.startComplexType(targetNamespace, defaultNamespace, name, complexType);
        if (newType) {
            if (complexType.getComplexContent() != null) {
                this.processComplexContent(targetNamespace, defaultNamespace, complexType.getComplexContent());
                this.finishComplexType(targetNamespace, defaultNamespace, name);
            } else if (complexType.getSimpleContent() != null) {
                this.processSimpleContent(targetNamespace, defaultNamespace, complexType.getSimpleContent());
                this.finishComplexType(targetNamespace, defaultNamespace, name);
            } else {
                if (complexType.getChoice() != null) {
                    this.processChoice(targetNamespace, defaultNamespace, name, complexType.getChoice(), false);
                } else if (complexType.getSequence() != null) {
                    this.processSequence(targetNamespace, defaultNamespace, name, complexType.getSequence(), false);
                } else if (complexType.getAll() != null) {
                    this.processAll(targetNamespace, defaultNamespace, name, complexType.getAll(), false);
                }
                this.processOrderedAttributes(targetNamespace, defaultNamespace, name, complexType.getOrderedAttributes());
                this.finishComplexType(targetNamespace, defaultNamespace, name);
            }
        }
        if (addedNR) {
            this.namespaceResolvers.remove(this.namespaceResolvers.size() - 1);
        }
    }

    private boolean startComplexType(String targetNamespace, String defaultNamespace, String name, ComplexType complexType) {
        boolean alreadyExists;
        String nameValue = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME);
        String originalName = name;
        if (nameValue != null) {
            this.itemNameToSDOName.put(name, nameValue);
            originalName = name;
            name = nameValue;
        }
        if (!(alreadyExists = this.typesExists(targetNamespace, name))) {
            this.startNewComplexType(targetNamespace, name, originalName, complexType);
            return true;
        }
        return false;
    }

    private void startNewComplexType(String targetNamespace, String sdoTypeName, String xsdLocalName, ComplexType complexType) {
        java.util.List documentation;
        Annotation annotation;
        String sequencedValue;
        SDOType currentType = this.createSDOTypeForName(targetNamespace, sdoTypeName, xsdLocalName);
        if (complexType.isMixed()) {
            currentType.setSequenced(true);
        }
        if (complexType.getAnyAttribute() != null) {
            currentType.setOpen(true);
        }
        currentType.setAbstract(complexType.isAbstractValue());
        currentType.setDataType(false);
        String value = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_ALIASNAME_QNAME);
        if (value != null) {
            XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            java.util.List names = (java.util.List)xmlConversionManager.convertObject((Object)value, java.util.List.class);
            currentType.setAliasNames(names);
        }
        if ((sequencedValue = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_SEQUENCE_QNAME)) != null) {
            Boolean sequencedBoolean = new Boolean(sequencedValue);
            currentType.setSequenced(sequencedBoolean);
        }
        if ((annotation = complexType.getAnnotation()) != null && (documentation = annotation.getDocumentation()) != null && documentation.size() > 0) {
            currentType.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, documentation);
        }
        currentType.preInitialize(this.packageName, this.namespaceResolvers);
        if (complexType.getAnnotation() != null) {
            currentType.setAppInfoElements(complexType.getAnnotation().getAppInfo());
        }
    }

    private void finishComplexType(String targetNamespace, String defaultNamespace, String name) {
        SDOType currentType = this.getSDOTypeForName(targetNamespace, defaultNamespace, false, name);
        currentType.postInitialize();
    }

    private void processOrderedAttributes(String targetNamespace, String defaultNamespace, String name, java.util.List orderedAttributes) {
        for (int i = 0; i < orderedAttributes.size(); ++i) {
            Object next = orderedAttributes.get(i);
            if (next instanceof Attribute) {
                this.processAttribute(targetNamespace, defaultNamespace, name, (Attribute)next, false);
                continue;
            }
            if (!(next instanceof AttributeGroup)) continue;
            this.processAttributeGroup(targetNamespace, defaultNamespace, name, (AttributeGroup)next);
        }
    }

    private void processGlobalAttributes(Schema schema) {
        Collection attributes = schema.getTopLevelAttributes().values();
        if (attributes == null) {
            return;
        }
        for (Attribute nextAttribute : attributes) {
            this.processGlobalAttribute(schema.getTargetNamespace(), schema.getDefaultNamespace(), nextAttribute);
        }
    }

    private void processGlobalAttribute(String targetNamespace, String defaultNamespace, Attribute attribute) {
        if (attribute.getName() != null) {
            QName qname = new QName(targetNamespace, attribute.getName());
            Object processed = this.processedAttributes.get(qname);
            if (processed == null) {
                this.processAttribute(targetNamespace, defaultNamespace, null, attribute, true);
                this.processedAttributes.put(qname, attribute);
            }
        } else {
            this.processAttribute(targetNamespace, defaultNamespace, null, attribute, true);
        }
    }

    private void processGroup(String targetNamespace, String defaultNamespace, String ownerName, TypeDefParticle typeDefParticle, Group group, boolean isMany) {
        String groupName;
        if (!isMany && this.maxOccursGreaterThanOne(group.getMaxOccurs())) {
            isMany = true;
        }
        if ((groupName = group.getRef()) != null) {
            int idx = groupName.indexOf(":");
            String prefix = null;
            String localName = null;
            String uri = null;
            if (idx > -1) {
                localName = groupName.substring(idx + 1, groupName.length());
                prefix = groupName.substring(0, idx);
                uri = this.getURIForPrefix(prefix);
            } else {
                localName = groupName;
                uri = targetNamespace;
            }
            Group globalGroup = this.rootSchema.getGroup(uri, localName);
            if (globalGroup != null) {
                if (globalGroup.getChoice() != null) {
                    globalGroup.getChoice().setMaxOccurs(group.getMaxOccurs());
                    this.processChoice(targetNamespace, defaultNamespace, ownerName, globalGroup.getChoice(), isMany);
                } else if (globalGroup.getSequence() != null) {
                    globalGroup.getSequence().setMaxOccurs(group.getMaxOccurs());
                    this.processSequence(targetNamespace, defaultNamespace, ownerName, globalGroup.getSequence(), isMany);
                } else if (globalGroup.getAll() != null) {
                    globalGroup.getAll().setMaxOccurs(group.getMaxOccurs());
                    this.processAll(targetNamespace, defaultNamespace, ownerName, globalGroup.getAll(), isMany);
                }
            }
        }
    }

    private void processAttribute(String targetNamespace, String defaultNamespace, String ownerName, Attribute attribute, boolean isGlobal) {
        SimpleType simpleType = attribute.getSimpleType();
        if (simpleType != null) {
            this.processSimpleType(targetNamespace, defaultNamespace, attribute.getName(), simpleType);
            this.processSimpleAttribute(targetNamespace, defaultNamespace, ownerName, attribute, isGlobal, this.rootSchema.isAttributeFormDefault());
        } else {
            this.processSimpleAttribute(targetNamespace, defaultNamespace, ownerName, attribute, isGlobal, this.rootSchema.isAttributeFormDefault());
        }
    }

    private void processAttributeGroup(String targetNamespace, String defaultNamespace, String ownerName, AttributeGroup attributeGroup) {
        String attributeGroupName = attributeGroup.getRef();
        if (attributeGroupName != null) {
            int idx = attributeGroupName.indexOf(":");
            String prefix = null;
            String localName = null;
            String uri = null;
            if (idx > -1) {
                localName = attributeGroupName.substring(idx + 1, attributeGroupName.length());
                prefix = attributeGroupName.substring(0, idx);
                uri = this.getURIForPrefix(prefix);
            } else {
                localName = attributeGroupName;
                uri = targetNamespace;
            }
            AttributeGroup globalAttributeGroup = this.rootSchema.getAttributeGroup(uri, localName);
            if (globalAttributeGroup != null) {
                int size = globalAttributeGroup.getAttributes().size();
                if (globalAttributeGroup.getAnyAttribute() != null) {
                    this.processAnyAttribute(targetNamespace, defaultNamespace, ownerName);
                }
                for (int j = 0; j < size; ++j) {
                    this.processAttribute(targetNamespace, defaultNamespace, ownerName, (Attribute)globalAttributeGroup.getAttributes().get(j), false);
                }
            }
        }
    }

    private void processAttributes(String targetNamespace, String defaultNamespace, String ownerName, java.util.List attributes) {
        if (attributes == null) {
            return;
        }
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute nextAttribute = (Attribute)attributes.get(i);
            this.processAttribute(targetNamespace, defaultNamespace, ownerName, nextAttribute, false);
        }
    }

    private void processGlobalSimpleTypes(Schema schema) {
        Collection simpleTypes = schema.getTopLevelSimpleTypes().values();
        if (simpleTypes == null) {
            return;
        }
        for (SimpleType simpleType : simpleTypes) {
            this.processGlobalSimpleType(schema.getTargetNamespace(), schema.getDefaultNamespace(), simpleType);
        }
    }

    private void processGlobalSimpleType(String targetNamespace, String defaultNamespace, SimpleType simpleType) {
        QName qname = new QName(targetNamespace, simpleType.getName());
        Object processed = this.processedSimpleTypes.get(qname);
        if (processed == null) {
            this.processSimpleType(targetNamespace, defaultNamespace, simpleType.getName(), simpleType);
            this.processedSimpleTypes.put(qname, simpleType);
        }
    }

    private boolean startSimpleType(String targetNamespace, String defaultNamespace, String name, String xsdLocalName, SimpleType simpleType) {
        boolean alreadyExists = this.typesExists(targetNamespace, name);
        if (!alreadyExists) {
            this.startNewSimpleType(targetNamespace, name, xsdLocalName, simpleType);
            return true;
        }
        return false;
    }

    private void startNewSimpleType(String targetNamespace, String sdoTypeName, String xsdLocalName, SimpleType simpleType) {
        SDOType currentType = this.createSDOTypeForName(targetNamespace, sdoTypeName, xsdLocalName);
        currentType.setDataType(true);
        SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        QName baseTypeQName = null;
        if (simpleType.getRestriction() != null) {
            String baseType = simpleType.getRestriction().getBaseType();
            int colonIndex = baseType.indexOf(":");
            if (colonIndex != -1) {
                baseType = baseType.substring(colonIndex + 1, baseType.length());
            }
            baseTypeQName = new QName("http://www.w3.org/2001/XMLSchema", baseType);
            SDOType baseSDOType = typeHelper.getSDOTypeFromXSDType(baseTypeQName);
            currentType.addBaseType(baseSDOType);
            currentType.setInstanceClass(baseSDOType.getInstanceClass());
        }
        SDOWrapperType wrapperType = new SDOWrapperType((Type)currentType, sdoTypeName, typeHelper, baseTypeQName);
        typeHelper.getWrappersHashMap().put(currentType.getQName(), wrapperType);
        typeHelper.getTypesHashMap().put(wrapperType.getQName(), wrapperType);
        typeHelper.getInterfacesToSDOTypeHashMap().put(wrapperType.getXmlDescriptor().getInterfacePolicy().getParentInterfaces().firstElement(), wrapperType);
        ArrayList<SDOWrapperType> list = new ArrayList<SDOWrapperType>(1);
        list.add(wrapperType);
        ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(list);
        if (simpleType.getAnnotation() != null) {
            currentType.setAppInfoElements(simpleType.getAnnotation().getAppInfo());
        }
    }

    private void processSimpleType(String targetNamespace, String defaultNamespace, String sdoTypeName, SimpleType simpleType) {
        boolean newType;
        String name;
        if (simpleType == null) {
            return;
        }
        boolean addedNR = this.addNextNamespaceResolver(simpleType.getAttributesMap());
        String originalName = name = sdoTypeName;
        String nameValue = (String)simpleType.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME);
        if (nameValue != null) {
            this.itemNameToSDOName.put(sdoTypeName, nameValue);
            name = nameValue;
        }
        if (newType = this.startSimpleType(targetNamespace, defaultNamespace, name, originalName, simpleType)) {
            Union union;
            List list;
            Restriction restriction = simpleType.getRestriction();
            if (restriction != null) {
                this.processRestriction(targetNamespace, defaultNamespace, sdoTypeName, restriction);
            }
            if ((list = simpleType.getList()) != null) {
                this.processList(targetNamespace, defaultNamespace, sdoTypeName, list);
            }
            if ((union = simpleType.getUnion()) != null) {
                this.processUnion(targetNamespace, defaultNamespace, sdoTypeName, union);
            }
            this.finishSimpleType(targetNamespace, defaultNamespace, sdoTypeName, simpleType);
        }
        if (addedNR) {
            this.namespaceResolvers.remove(this.namespaceResolvers.size() - 1);
        }
    }

    private void finishSimpleType(String targetNamespace, String defaultNamespace, String sdoTypeName, SimpleType simpleType) {
        String extendedInstanceClassValue;
        String instanceClassValue;
        SDOType currentType = this.getSDOTypeForName(targetNamespace, defaultNamespace, false, sdoTypeName);
        String value = (String)simpleType.getAttributesMap().get(SDOConstants.SDOXML_ALIASNAME_QNAME);
        if (value != null) {
            XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            java.util.List names = (java.util.List)xmlConversionManager.convertObject((Object)value, java.util.List.class);
            currentType.setAliasNames(names);
        }
        if ((instanceClassValue = (String)simpleType.getAttributesMap().get(SDOConstants.SDOJAVA_INSTANCECLASS_QNAME)) != null) {
            currentType.setInstanceProperty(SDOConstants.JAVA_CLASS_PROPERTY, instanceClassValue);
            currentType.setBaseTypes(null);
        }
        if ((extendedInstanceClassValue = (String)simpleType.getAttributesMap().get(SDOConstants.SDOJAVA_EXTENDEDINSTANCECLASS_QNAME)) != null) {
            currentType.setInstanceClassName(extendedInstanceClassValue);
        }
        currentType.postInitialize();
    }

    private void processChoice(String targetNamespace, String defaultNamespace, String ownerName, Choice choice, boolean isMany) {
        if (choice != null) {
            this.processTypeDef(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)choice);
            java.util.List orderedItems = choice.getOrderedElements();
            for (int i = 0; i < orderedItems.size(); ++i) {
                Object next = orderedItems.get(i);
                if (!isMany && this.maxOccursGreaterThanOne(choice.getMaxOccurs())) {
                    isMany = true;
                }
                if (next instanceof Choice) {
                    this.processChoice(targetNamespace, defaultNamespace, ownerName, (Choice)next, isMany);
                    continue;
                }
                if (next instanceof Sequence) {
                    this.processSequence(targetNamespace, defaultNamespace, ownerName, (Sequence)next, isMany);
                    continue;
                }
                if (next instanceof Any) {
                    this.processAny(targetNamespace, defaultNamespace, (Any)next, ownerName, (TypeDefParticle)choice);
                    continue;
                }
                if (next instanceof Element) {
                    this.processElement(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)choice, (Element)next, false, isMany);
                    continue;
                }
                if (!(next instanceof Group)) continue;
                this.processGroup(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)choice, (Group)next, isMany);
            }
        }
    }

    private void processSequence(String targetNamespace, String defaultNamespace, String ownerName, Sequence sequence, boolean isMany) {
        if (sequence != null) {
            this.processTypeDef(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)sequence);
            java.util.List orderedItems = sequence.getOrderedElements();
            for (int i = 0; i < orderedItems.size(); ++i) {
                Object next = orderedItems.get(i);
                if (!isMany && this.maxOccursGreaterThanOne(sequence.getMaxOccurs())) {
                    isMany = true;
                }
                if (next instanceof Choice) {
                    this.processChoice(targetNamespace, defaultNamespace, ownerName, (Choice)next, isMany);
                    continue;
                }
                if (next instanceof Sequence) {
                    this.processSequence(targetNamespace, defaultNamespace, ownerName, (Sequence)next, isMany);
                    continue;
                }
                if (next instanceof Any) {
                    this.processAny(targetNamespace, defaultNamespace, (Any)next, ownerName, (TypeDefParticle)sequence);
                    continue;
                }
                if (next instanceof Element) {
                    this.processElement(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)sequence, (Element)next, false, isMany);
                    continue;
                }
                if (!(next instanceof Group)) continue;
                this.processGroup(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)sequence, (Group)next, isMany);
            }
        }
    }

    private void processAll(String targetNamespace, String defaultNamespace, String ownerName, All all, boolean isMany) {
        if (all != null) {
            this.processTypeDef(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)all);
            if (!isMany && this.maxOccursGreaterThanOne(all.getMaxOccurs())) {
                isMany = true;
            }
            java.util.List elements = all.getElements();
            for (int i = 0; i < elements.size(); ++i) {
                Object next = elements.get(i);
                if (!(next instanceof Element)) continue;
                this.processElement(targetNamespace, defaultNamespace, ownerName, (TypeDefParticle)all, (Element)next, false, isMany);
            }
        }
    }

    private void processComplexContent(String targetNamespace, String defaultNamespace, ComplexContent complexContent) {
        if (complexContent != null) {
            if (complexContent.getExtension() != null) {
                this.processExtension(targetNamespace, defaultNamespace, complexContent.getOwnerName(), complexContent.getExtension(), false);
            } else if (complexContent.getRestriction() != null) {
                this.processRestriction(targetNamespace, defaultNamespace, complexContent.getOwnerName(), complexContent.getRestriction());
            }
        }
    }

    private void processSimpleContent(String targetNamespace, String defaultNamespace, SimpleContent simpleContent) {
        if (simpleContent != null) {
            if (simpleContent.getExtension() != null) {
                this.processExtension(targetNamespace, defaultNamespace, simpleContent.getOwnerName(), simpleContent.getExtension(), true);
            } else if (simpleContent.getRestriction() != null) {
                this.processRestriction(targetNamespace, defaultNamespace, simpleContent.getOwnerName(), simpleContent.getRestriction());
            }
        }
    }

    private void processExtension(String targetNamespace, String defaultNamespace, String ownerName, Extension extension, boolean simpleContent) {
        if (extension != null) {
            String qualifiedType = extension.getBaseType();
            this.processBaseType(targetNamespace, defaultNamespace, extension.getOwnerName(), qualifiedType, simpleContent);
            if (extension.getChoice() != null) {
                this.processChoice(targetNamespace, defaultNamespace, ownerName, extension.getChoice(), false);
            } else if (extension.getSequence() != null) {
                this.processSequence(targetNamespace, defaultNamespace, ownerName, extension.getSequence(), false);
            } else if (extension.getAll() != null) {
                // empty if block
            }
            this.processOrderedAttributes(targetNamespace, defaultNamespace, ownerName, extension.getOrderedAttributes());
        }
    }

    private void processRestriction(String targetNamespace, String defaultNamespace, String ownerName, Restriction restriction) {
        if (restriction != null) {
            String qualifiedType = restriction.getBaseType();
            this.processBaseType(targetNamespace, defaultNamespace, ownerName, qualifiedType, false);
            boolean alreadyIn = this.inRestriction;
            if (!alreadyIn) {
                this.inRestriction = true;
            }
            if (restriction.getChoice() != null) {
                this.processChoice(targetNamespace, defaultNamespace, ownerName, restriction.getChoice(), false);
            } else if (restriction.getSequence() != null) {
                this.processSequence(targetNamespace, defaultNamespace, ownerName, restriction.getSequence(), false);
            } else if (restriction.getAll() != null) {
                // empty if block
            }
            this.processAttributes(targetNamespace, defaultNamespace, ownerName, restriction.getAttributes());
            if (!alreadyIn) {
                this.inRestriction = false;
            }
        }
    }

    private void processUnion(String targetNamespace, String defaultNamespace, String sdoTypeName, Union union) {
        if (union != null) {
            java.util.List allMemberTypes = union.getAllMemberTypes();
            SDOType type = this.getSDOTypeForName(targetNamespace, defaultNamespace, sdoTypeName);
            String firstInstanceClassName = null;
            for (int i = 0; i < allMemberTypes.size(); ++i) {
                String nextMemberType = (String)allMemberTypes.get(i);
                SDOType typeForMemberType = this.getTypeForName(targetNamespace, defaultNamespace, nextMemberType);
                if (i == 0) {
                    firstInstanceClassName = typeForMemberType.getInstanceClassName();
                    if (firstInstanceClassName != null) continue;
                    break;
                }
                String nextClassName = typeForMemberType.getInstanceClassName();
                if (firstInstanceClassName.equals(nextClassName)) continue;
                type.setInstanceClass(Object.class);
                return;
            }
            if (firstInstanceClassName != null) {
                type.setInstanceClassName(firstInstanceClassName);
            } else {
                type.setInstanceClass(Object.class);
            }
        }
    }

    private boolean addNextNamespaceResolver(Map attributesMap) {
        NamespaceResolver nr = new NamespaceResolver();
        for (QName key : attributesMap.keySet()) {
            if (!key.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            String value = (String)attributesMap.get(key);
            String prefix = key.getLocalPart();
            int index = prefix.indexOf(58);
            if (index > -1) {
                prefix = prefix.substring(index + 1, prefix.length());
            }
            nr.put(prefix, value);
        }
        if (nr.getPrefixes().hasMoreElements()) {
            this.namespaceResolvers.add(nr);
            return true;
        }
        return false;
    }

    private void processList(String targetNamespace, String defaultNamespace, String sdoTypeName, List list) {
        if (list != null) {
            SDOType type = this.getSDOTypeForName(targetNamespace, defaultNamespace, sdoTypeName);
            type.setXsdList(true);
        }
    }

    private void processBaseType(String targetNamespace, String defaultNamespace, String ownerName, String qualifiedName, boolean simpleContentExtension) {
        if (qualifiedName == null) {
            return;
        }
        SDOType baseType = this.getSDOTypeForName(targetNamespace, defaultNamespace, qualifiedName);
        if (simpleContentExtension) {
            SDOType ownerType = this.getTypeForName(targetNamespace, defaultNamespace, ownerName);
            if (ownerType != null) {
                SDOProperty prop = new SDOProperty(this.aHelperContext);
                prop.setName("value");
                prop.setType(baseType);
                prop.setValueProperty(true);
                prop.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
                ownerType.addDeclaredProperty(prop);
                prop.buildMapping(null, -1);
                prop.setFinalized(true);
            }
            return;
        }
        ArrayList<SDOType> baseTypes = new ArrayList<SDOType>();
        baseTypes.add(baseType);
        if (ownerName != null) {
            SDOType owner = this.getTypeForName(targetNamespace, defaultNamespace, ownerName);
            if (owner.isDataType()) {
                QName baseQName;
                owner.setInstanceClassName(baseType.getInstanceClassName());
                if (baseType.getInstanceClass() != null) {
                    owner.setInstanceClass(baseType.getInstanceClass());
                }
                if ((baseQName = this.getQNameForString(defaultNamespace, qualifiedName)).equals(XMLConstants.BASE_64_BINARY_QNAME) || baseQName.equals(XMLConstants.HEX_BINARY_QNAME) || baseQName.equals(XMLConstants.DATE_QNAME) || baseQName.equals(XMLConstants.TIME_QNAME) || baseQName.equals(XMLConstants.DATE_TIME_QNAME)) {
                    owner.setXsdType(baseQName);
                }
            }
            if (!owner.getBaseTypes().contains(baseType)) {
                owner.addBaseType(baseType);
            }
        }
    }

    private void processTypeDef(String targetNamespace, String defaultNamespace, String owner, TypeDefParticle typeDefParticle) {
        SDOType currentType = this.getTypeForName(targetNamespace, defaultNamespace, owner);
        if (this.maxOccursGreaterThanOne(typeDefParticle.getMaxOccurs()) && !currentType.isSequenced() && this.shouldBeSequenced(typeDefParticle)) {
            currentType.setSequenced(true);
        }
    }

    private boolean shouldBeSequenced(TypeDefParticle typeDefParticle) {
        block4: {
            block3: {
                java.util.List elements = typeDefParticle.getElements();
                if (elements != null && elements.size() > 1) {
                    return true;
                }
                if (!(typeDefParticle instanceof Sequence)) break block3;
                java.util.List allItems = ((Sequence)typeDefParticle).getOrderedElements();
                for (int i = 0; i < allItems.size(); ++i) {
                    boolean sequenced;
                    Object nextItem = allItems.get(i);
                    if (!(nextItem instanceof TypeDefParticle) || !(sequenced = this.shouldBeSequenced((TypeDefParticle)nextItem))) continue;
                    return true;
                }
                break block4;
            }
            if (!(typeDefParticle instanceof Choice)) break block4;
            java.util.List allItems = ((Choice)typeDefParticle).getOrderedElements();
            for (int i = 0; i < allItems.size(); ++i) {
                boolean sequenced;
                Object nextItem = allItems.get(i);
                if (!(nextItem instanceof TypeDefParticle) || !(sequenced = this.shouldBeSequenced((TypeDefParticle)nextItem))) continue;
                return true;
            }
        }
        return false;
    }

    private void processAny(String targetNamespace, String defaultNamespace, Any any, String owner, TypeDefParticle typeDefParticle) {
        if (any == null) {
            return;
        }
        SDOType currentType = this.getTypeForName(targetNamespace, defaultNamespace, owner);
        if (typeDefParticle instanceof Choice && ((Choice)typeDefParticle).hasAny()) {
            currentType.setOpen(true);
        } else if (typeDefParticle instanceof Sequence && ((Sequence)typeDefParticle).hasAny()) {
            currentType.setOpen(true);
        }
        if (this.maxOccursGreaterThanOne(any.getMaxOccurs())) {
            currentType.setSequenced(true);
        }
    }

    private void processGlobalElements(Schema schema) {
        Collection elements = schema.getTopLevelElements().values();
        if (elements == null) {
            return;
        }
        for (Element nextElement : elements) {
            this.processGlobalElement(schema.getTargetNamespace(), schema.getDefaultNamespace(), nextElement);
        }
        this.processSubstitutionGroups(elements, schema.getTargetNamespace(), schema.getDefaultNamespace());
    }

    private void processGlobalElement(String targetNamespace, String defaultNamespace, Element element) {
        if (element.getName() != null) {
            QName qname = new QName(targetNamespace, element.getName());
            Object processed = this.processedElements.get(qname);
            if (processed == null) {
                this.processElement(targetNamespace, defaultNamespace, null, null, element, true, false);
                this.processedElements.put(qname, element);
            }
        } else {
            this.processElement(targetNamespace, defaultNamespace, null, null, element, true, false);
        }
    }

    private void processElement(String targetNamespace, String defaultNamespace, String ownerName, TypeDefParticle typeDefParticle, Element element, boolean isGlobal, boolean isMany) {
        boolean addedNR = this.addNextNamespaceResolver(element.getAttributesMap());
        ComplexType complexType = element.getComplexType();
        boolean qualified = true;
        if (!isGlobal) {
            qualified = this.rootSchema.isElementFormDefault();
        }
        if (!isMany && this.maxOccursGreaterThanOne(element.getMaxOccurs())) {
            isMany = true;
        }
        if (complexType != null) {
            this.processComplexType(targetNamespace, defaultNamespace, element.getName(), complexType);
            this.processSimpleElement(targetNamespace, defaultNamespace, ownerName, typeDefParticle, element, qualified, isGlobal, isMany);
        } else if (element.getSimpleType() != null) {
            this.processSimpleType(targetNamespace, defaultNamespace, element.getName(), element.getSimpleType());
            this.processSimpleElement(targetNamespace, defaultNamespace, ownerName, typeDefParticle, element, qualified, isGlobal, isMany);
        } else {
            this.processSimpleElement(targetNamespace, defaultNamespace, ownerName, typeDefParticle, element, qualified, isGlobal, isMany);
        }
        if (addedNR) {
            this.namespaceResolvers.remove(this.namespaceResolvers.size() - 1);
        }
    }

    private void processSimpleElement(String targetNamespace, String defaultNamespace, String ownerName, TypeDefParticle typeDefParticle, Element element, boolean isQualified, boolean isGlobal, boolean isMany) {
        SDOProperty lookedUpProp;
        if (element == null) {
            return;
        }
        String manyValue = (String)element.getAttributesMap().get(SDOConstants.SDOXML_MANY_QNAME);
        if (manyValue != null) {
            Boolean manyBoolean = new Boolean(manyValue);
            isMany = manyBoolean;
        }
        SDOProperty p = null;
        SDOType owningType = null;
        String typeName = null;
        SDOType sdoPropertyType = null;
        String mappingUri = null;
        if (typeDefParticle != null) {
            owningType = this.getTypeForName(targetNamespace, defaultNamespace, ownerName);
            mappingUri = owningType.getURI();
        }
        if (element.getRef() != null) {
            String ref = element.getRef();
            String localName = null;
            String uri = null;
            int index = ref.indexOf(58);
            if (index != -1) {
                String prefix = ref.substring(0, index);
                localName = ref.substring(index + 1, ref.length());
                uri = this.getURIForPrefix(prefix);
            } else {
                localName = ref;
                uri = defaultNamespace;
            }
            SDOProperty lookedUp = owningType.getProperty(localName);
            if (lookedUp != null) {
                if (this.inRestriction) {
                    return;
                }
                this.updateCollisionProperty(owningType, lookedUp);
            } else {
                java.util.List doc;
                SDOProperty theProp = new SDOProperty(this.aHelperContext);
                theProp.setName(localName);
                theProp.setGlobal(false);
                theProp.setContainment(true);
                theProp.setXsd(true);
                theProp.setMany(isMany);
                theProp.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
                if (element.getAnnotation() != null && (doc = element.getAnnotation().getDocumentation()) != null) {
                    theProp.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, doc);
                }
                owningType.addDeclaredProperty(theProp);
                GlobalRef globalRef = new GlobalRef();
                globalRef.setProperty(theProp);
                globalRef.setIsElement(true);
                globalRef.setOwningType(owningType);
                globalRef.setUri(uri);
                globalRef.setLocalName(localName);
                this.addGlobalRef(globalRef);
            }
            return;
        }
        if (isGlobal && (lookedUpProp = this.getExistingGlobalProperty(targetNamespace, element.getName(), true)) != null && lookedUpProp.isFinalized()) {
            return;
        }
        p = this.createNewProperty(targetNamespace, element.getName(), isQualified, isGlobal, true, element.isNillable(), element.getAnnotation());
        if (element.getAnnotation() != null) {
            p.setAppInfoElements(element.getAnnotation().getAppInfo());
        }
        if (element.getType() != null) {
            String mimeTypePropName;
            String mimeType;
            typeName = element.getType();
            p.setName(element.getName());
            QName qname = this.getQNameForString(defaultNamespace, typeName);
            if (isGlobal && qname.getNamespaceURI().equals(targetNamespace)) {
                this.processGlobalItem(targetNamespace, defaultNamespace, qname.getLocalPart());
            }
            if (qname.equals(XMLConstants.BASE_64_BINARY_QNAME) || qname.equals(XMLConstants.HEX_BINARY_QNAME) || qname.equals(XMLConstants.DATE_QNAME) || qname.equals(XMLConstants.TIME_QNAME) || qname.equals(XMLConstants.DATE_TIME_QNAME)) {
                p.setXsdType(qname);
            }
            if ((mimeType = (String)element.getAttributesMap().get(SDOConstants.XML_MIME_TYPE_QNAME)) != null) {
                p.setInstanceProperty(SDOConstants.MIME_TYPE_PROPERTY, mimeType);
            }
            if ((mimeTypePropName = (String)element.getAttributesMap().get(SDOConstants.XML_MIME_TYPE_PROPERTY_QNAME)) != null) {
                p.setInstanceProperty(SDOConstants.MIME_TYPE_PROPERTY_PROPERTY, mimeTypePropName);
            }
            sdoPropertyType = this.getSDOTypeForName(targetNamespace, defaultNamespace, typeName);
            if (p.getXsdType() == null && sdoPropertyType.getXsdType() != null) {
                p.setXsdType(sdoPropertyType.getXsdType());
            }
            if (sdoPropertyType.isDataType()) {
                p.setContainment(false);
            }
        } else if (element.getComplexType() != null) {
            sdoPropertyType = this.getTypeForName(targetNamespace, defaultNamespace, element.getComplexType().getNameOrOwnerName());
            typeName = element.getName();
            p.setName(element.getComplexType().getNameOrOwnerName());
        } else if (element.getSimpleType() != null) {
            typeName = element.getName();
            sdoPropertyType = this.getTypeForName(targetNamespace, defaultNamespace, element.getName());
            p.setName(element.getName());
            if (sdoPropertyType.isDataType()) {
                p.setContainment(false);
            }
        } else {
            p.setName(element.getName());
            sdoPropertyType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(SDOConstants.ANY_TYPE_QNAME);
        }
        sdoPropertyType = this.processSimpleComponentAnnotations(owningType, (SimpleComponent)element, p, targetNamespace, defaultNamespace, sdoPropertyType);
        p.setType(sdoPropertyType);
        this.setDefaultValue(p, (SimpleComponent)element);
        p.setMany(isMany);
        if (p.getType().isChangeSummaryType()) {
            p.setReadOnly(true);
        }
        if (typeDefParticle != null) {
            this.updateOwnerAndBuildMapping(owningType, p, defaultNamespace, targetNamespace, (SimpleComponent)element, typeName, mappingUri);
        }
        if (isGlobal) {
            this.addRootElementToDescriptor(p, targetNamespace, element.getName());
        }
        p.setFinalized(true);
    }

    private SDOProperty processRef(GlobalRef globalRef) {
        boolean isElement = globalRef.isElement();
        SDOProperty p = null;
        SDOProperty refProp = this.getExistingGlobalProperty(globalRef.getUri(), globalRef.getLocalName(), isElement);
        if (refProp != null && refProp.isFinalized()) {
            p = (SDOProperty)globalRef.getProperty();
            p.setValueProperty(refProp.isValueProperty());
            p.setNullable(refProp.isNullable());
            p.setName(refProp.getName());
            p.setXsdLocalName(refProp.getXsdLocalName());
            p.setNamespaceQualified(refProp.isNamespaceQualified());
            p.setAliasNames(refProp.getAliasNames());
            p.setDefault(refProp.getDefault());
            p.setSubstitutable(refProp.isSubstitutable());
            p.setSubstitutableElements(refProp.getSubstitutableElements());
            if (p.getType() == null) {
                p.setType(refProp.getType());
                if (refProp.getType().isDataType()) {
                    p.setContainment(false);
                }
            }
            p.setOpposite(refProp.getOpposite());
            p.setReadOnly(refProp.isReadOnly());
            p.setXsd(refProp.isXsd());
            p.setAppInfoElements(refProp.getAppInfoElements());
            int index = ((SDOProperty)globalRef.getProperty()).getIndexInDeclaredProperties();
            p.buildMapping(globalRef.getUri(), index);
            p.setFinalized(true);
        } else if (this.isImportProcessor) {
            p = new SDOProperty(this.aHelperContext);
            p.setGlobal(true);
            p.setUri(globalRef.getUri());
            p.setName(globalRef.getLocalName());
            QName qname = new QName(globalRef.getUri(), globalRef.getLocalName());
            if (isElement) {
                p.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
                this.getGeneratedGlobalElements().put(qname, p);
            } else {
                this.getGeneratedGlobalAttributes().put(qname, p);
            }
        } else {
            throw SDOException.referencedPropertyNotFound((String)globalRef.getUri(), (String)globalRef.getLocalName());
        }
        return p;
    }

    private void updateCollisionProperty(SDOType owningType, SDOProperty p) {
        owningType.setSequenced(true);
        SDOType baseType = owningType;
        while (baseType.getBaseTypes() != null && baseType.getBaseTypes().size() > 0) {
            baseType = (Type)baseType.getBaseTypes().get(0);
            baseType.setSequenced(true);
        }
        p.setNameCollision(true);
        p.setType(SDOConstants.SDO_OBJECT);
        p.setContainment(true);
        p.setMany(true);
        p.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
    }

    private SDOProperty createNewProperty(String targetNamespace, String xsdLocalName, boolean isQualified, boolean isGlobal, boolean isElement, boolean isNillable, Annotation annotation) {
        java.util.List documentation;
        SDOProperty p = null;
        if (isGlobal) {
            p = this.getExistingGlobalProperty(targetNamespace, xsdLocalName, isElement);
        }
        if (p == null) {
            p = new SDOProperty(this.aHelperContext);
        }
        p.setGlobal(isGlobal);
        p.setXsd(true);
        p.setNullable(isNillable);
        if (isElement) {
            p.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
        }
        p.setXsdLocalName(xsdLocalName);
        p.setNamespaceQualified(isQualified);
        p.setContainment(true);
        if (isGlobal) {
            QName qname = new QName(targetNamespace, xsdLocalName);
            if (isElement) {
                this.getGeneratedGlobalElements().put(qname, p);
            } else {
                this.getGeneratedGlobalAttributes().put(qname, p);
            }
        }
        if (annotation != null && (documentation = annotation.getDocumentation()) != null && documentation.size() > 0) {
            p.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, documentation);
        }
        return p;
    }

    private void addRootElementToDescriptor(SDOProperty p, String targetNamespace, String xsdName) {
        if (!p.getType().isDataType()) {
            NamespaceResolver nr = p.getType().getXmlDescriptor().getNamespaceResolver();
            String prefix = null;
            if (nr != null) {
                prefix = nr.resolveNamespaceURI(targetNamespace);
            }
            if (prefix == null || prefix.equals("")) {
                p.getType().getXmlDescriptor().addRootElement(xsdName);
            } else {
                p.getType().getXmlDescriptor().addRootElement(prefix + ":" + xsdName);
            }
        } else {
            SDOTypeHelper typeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
            SDOWrapperType wrapperType = (SDOWrapperType)typeHelper.getWrappersHashMap().get(p.getType().getQName());
            XMLDescriptor d = wrapperType.getXmlDescriptor(p.getXsdType());
            if (wrapperType != null) {
                d.addRootElement(xsdName);
                QName descriptorQname = new QName(targetNamespace, xsdName);
                ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().addDescriptorByQName(descriptorQname, d);
            }
        }
    }

    private void updateOwnerAndBuildMapping(SDOType owningType, SDOProperty p, String defaultNamespace, String targetNamespace, SimpleComponent simpleComponent, String typeName, String mappingUri) {
        boolean buildMapping = true;
        SDOProperty lookedUp = owningType.getProperty(p.getName());
        if (lookedUp != null) {
            p = lookedUp;
            if (this.inRestriction) {
                return;
            }
            this.updateCollisionProperty(owningType, p);
        } else {
            owningType.addDeclaredProperty(p);
        }
        QName xsdType = this.getQNameForString(defaultNamespace, typeName);
        if (xsdType != null && xsdType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            if (xsdType.getLocalPart().equals("ID")) {
                owningType.setInstanceProperty(SDOConstants.ID_PROPERTY, p.getName());
            } else if (xsdType.getLocalPart().equals("IDREF")) {
                p.setContainment(false);
                String propertyTypeValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_PROPERTYTYPE_QNAME);
                if (propertyTypeValue != null) {
                    buildMapping = false;
                }
            } else if (xsdType.getLocalPart().equals("IDREFS")) {
                p.setContainment(false);
                p.setMany(true);
                String propertyTypeValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_PROPERTYTYPE_QNAME);
                if (propertyTypeValue != null) {
                    buildMapping = false;
                }
            }
        }
        if (buildMapping) {
            p.buildMapping(mappingUri);
        }
    }

    private void setDefaultValue(SDOProperty p, SimpleComponent sc) {
        if (sc.getFixed() != null) {
            Object convertedValue = this.convertDefaultValue(p.getType(), sc.getFixed());
            p.setDefault(convertedValue);
        } else if (sc.getDefaultValue() != null) {
            Object convertedValue = this.convertDefaultValue(p.getType(), sc.getDefaultValue());
            p.setDefault(convertedValue);
        }
    }

    private Object convertDefaultValue(Type type, String stringValue) {
        Class javaClass;
        if (type != null && (javaClass = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getJavaWrapperTypeForSDOType(type)) != null) {
            Object objectValue = ((SDODataHelper)this.aHelperContext.getDataHelper()).convertFromStringValue(stringValue, javaClass);
            return objectValue;
        }
        return stringValue;
    }

    private void processSimpleAttribute(String targetNamespace, String defaultNamespace, String ownerName, Attribute attribute, boolean isGlobal, boolean isQualified) {
        SDOProperty lookedUpProp;
        if (attribute == null) {
            return;
        }
        SDOProperty p = null;
        SDOType owningType = null;
        String typeName = null;
        SDOType sdoPropertyType = null;
        String mappingUri = null;
        if (ownerName != null) {
            owningType = this.getTypeForName(targetNamespace, defaultNamespace, ownerName);
            mappingUri = owningType.getURI();
        }
        if (attribute.getRef() != null) {
            String ref = attribute.getRef();
            String localName = null;
            String uri = null;
            int index = ref.indexOf(58);
            if (index != -1) {
                String prefix = ref.substring(0, index);
                localName = ref.substring(index + 1, ref.length());
                uri = this.getURIForPrefix(prefix);
            } else {
                localName = ref;
                uri = defaultNamespace;
            }
            SDOProperty lookedUp = owningType.getProperty(localName);
            if (lookedUp != null) {
                if (this.inRestriction) {
                    return;
                }
                this.updateCollisionProperty(owningType, lookedUp);
            } else {
                java.util.List doc;
                SDOProperty theProp = new SDOProperty(this.aHelperContext);
                theProp.setName(localName);
                theProp.setGlobal(false);
                theProp.setContainment(false);
                theProp.setXsd(true);
                theProp.setMany(false);
                if (attribute.getAnnotation() != null && (doc = attribute.getAnnotation().getDocumentation()) != null) {
                    theProp.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, doc);
                }
                theProp.setFinalized(true);
                GlobalRef globalRef = new GlobalRef();
                globalRef.setProperty(theProp);
                owningType.addDeclaredProperty(theProp);
                globalRef.setIsElement(false);
                globalRef.setOwningType(owningType);
                globalRef.setUri(uri);
                globalRef.setLocalName(localName);
                this.addGlobalRef(globalRef);
            }
            return;
        }
        if (isGlobal && (lookedUpProp = this.getExistingGlobalProperty(targetNamespace, attribute.getName(), false)) != null && lookedUpProp.isFinalized()) {
            return;
        }
        p = this.createNewProperty(targetNamespace, attribute.getName(), isQualified, isGlobal, false, false, attribute.getAnnotation());
        if (attribute.getAnnotation() != null) {
            p.setAppInfoElements(attribute.getAnnotation().getAppInfo());
        }
        if ((typeName = attribute.getType()) != null) {
            p.setName(attribute.getName());
            QName qname = this.getQNameForString(defaultNamespace, typeName);
            if (isGlobal) {
                this.processGlobalItem(targetNamespace, defaultNamespace, typeName);
            }
            if (qname.equals(XMLConstants.BASE_64_BINARY_QNAME) || qname.equals(XMLConstants.HEX_BINARY_QNAME) || qname.equals(XMLConstants.DATE_QNAME) || qname.equals(XMLConstants.TIME_QNAME) || qname.equals(XMLConstants.DATE_TIME_QNAME)) {
                p.setXsdType(qname);
            }
            sdoPropertyType = this.getSDOTypeForName(targetNamespace, defaultNamespace, typeName);
            if (p.getXsdType() == null && sdoPropertyType.getXsdType() != null) {
                p.setXsdType(sdoPropertyType.getXsdType());
            }
        } else if (attribute.getSimpleType() != null) {
            p.setName(attribute.getName());
            sdoPropertyType = this.getSDOTypeForName(targetNamespace, defaultNamespace, attribute.getName());
            typeName = attribute.getName();
        } else {
            p.setName(attribute.getName());
            sdoPropertyType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(SDOConstants.ANY_TYPE_QNAME);
        }
        sdoPropertyType = this.processSimpleComponentAnnotations(owningType, (SimpleComponent)attribute, p, targetNamespace, defaultNamespace, sdoPropertyType);
        p.setType(sdoPropertyType);
        p.setContainment(false);
        this.setDefaultValue(p, (SimpleComponent)attribute);
        if (p.getType().isChangeSummaryType()) {
            p.setReadOnly(true);
        }
        if (owningType != null) {
            this.updateOwnerAndBuildMapping(owningType, p, defaultNamespace, targetNamespace, (SimpleComponent)attribute, typeName, mappingUri);
        }
        p.setFinalized(true);
    }

    private SDOType processSimpleComponentAnnotations(SDOType owningType, SimpleComponent simpleComponent, SDOProperty p, String targetNamespace, String defaultNamespace, SDOType sdoPropertyType) {
        String propertyTypeValue;
        QName propertyName;
        String nameValue;
        String stringValue;
        String dataTypeValue;
        String readOnlyValue;
        String aliasNamesValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_ALIASNAME_QNAME);
        if (aliasNamesValue != null) {
            XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            java.util.List names = (java.util.List)xmlConversionManager.convertObject((Object)aliasNamesValue, java.util.List.class);
            p.setAliasNames(names);
        }
        if ((readOnlyValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_READONLY_QNAME)) != null) {
            Boolean readOnlyBoolean = new Boolean(readOnlyValue);
            p.setReadOnly(readOnlyBoolean);
        }
        if ((dataTypeValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_DATATYPE_QNAME)) != null) {
            SDOType sdoType;
            QName xsdQName = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType(sdoPropertyType);
            if (xsdQName == null && !sdoPropertyType.isDataType()) {
                xsdQName = new QName(sdoPropertyType.getURI(), sdoPropertyType.getName());
            }
            p.setXsdType(xsdQName);
            sdoPropertyType = sdoType = this.getSDOTypeForName(targetNamespace, defaultNamespace, dataTypeValue);
            Property xmlDataTypeProperty = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "dataType");
            p.setInstanceProperty(xmlDataTypeProperty, sdoType);
        }
        if ((stringValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_STRING_QNAME)) != null) {
            QName xsdTypeQName = this.getQNameForString(defaultNamespace, simpleComponent.getType());
            p.setXsdType(xsdTypeQName);
            sdoPropertyType = SDOConstants.SDO_STRING;
        }
        if ((nameValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME)) != null) {
            p.setName(nameValue);
            if (p.isGlobal() && targetNamespace != null) {
                propertyName = new QName(targetNamespace, nameValue);
                ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getOpenContentProperties().put(propertyName, p);
            }
        } else if (p.isGlobal() && targetNamespace != null) {
            propertyName = new QName(targetNamespace, p.getName());
            ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getOpenContentProperties().put(propertyName, p);
        }
        if ((propertyTypeValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_PROPERTYTYPE_QNAME)) != null) {
            String uri = targetNamespace;
            int colonIndex = propertyTypeValue.indexOf(58);
            if (colonIndex > -1) {
                String prefix = propertyTypeValue.substring(0, colonIndex);
                uri = this.getURIForPrefix(prefix);
            }
            NonContainmentReference nonContainmentReference = new NonContainmentReference();
            nonContainmentReference.setPropertyTypeName(propertyTypeValue);
            nonContainmentReference.setPropertyTypeURI(uri);
            nonContainmentReference.setOwningType(owningType);
            nonContainmentReference.setOwningProp(p);
            String oppositePropValue = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_OPPOSITEPROPERTY_QNAME);
            nonContainmentReference.setOppositePropName(oppositePropValue);
            this.getNonContainmentReferences().add(nonContainmentReference);
        }
        return sdoPropertyType;
    }

    private void postProcessing() {
        int size = this.getNonContainmentReferences().size();
        for (int i = 0; i < size; ++i) {
            SDOProperty owningProp;
            NonContainmentReference nonContainmentReference = this.getNonContainmentReferences().get(i);
            SDOType owningType = nonContainmentReference.getOwningType();
            if (owningType == null) continue;
            String propertyTypeName = nonContainmentReference.getPropertyTypeName();
            String propertyTypeUri = nonContainmentReference.getPropertyTypeURI();
            SDOType oppositeType = this.getSDOTypeForName(propertyTypeUri, propertyTypeUri, propertyTypeName);
            if (oppositeType == null || (owningProp = nonContainmentReference.getOwningProp()) == null) continue;
            if (oppositeType.isDataType()) {
                throw SDOException.propertyTypeAnnotationTargetCannotBeDataTypeTrue((String)oppositeType.getName(), (String)owningProp.getName());
            }
            owningProp.setType(oppositeType);
            owningProp.setContainment(false);
            owningProp.buildMapping(owningProp.getType().getURI());
            String oppositePropName = nonContainmentReference.getOppositePropName();
            if (oppositePropName == null) continue;
            SDOProperty prop = oppositeType.getProperty(oppositePropName);
            owningProp.setOpposite(prop);
            prop.setOpposite(owningProp);
        }
        for (Type nextKey : this.getGlobalRefs().keySet()) {
            int i;
            java.util.List<GlobalRef> value = this.getGlobalRefs().get(nextKey);
            ArrayList<GlobalRef> refsToRemove = new ArrayList<GlobalRef>();
            if (value != null) {
                for (i = 0; i < value.size(); ++i) {
                    GlobalRef nextGlobalRef = value.get(i);
                    SDOProperty p = this.processRef(nextGlobalRef);
                    if (!p.isFinalized()) continue;
                    refsToRemove.add(nextGlobalRef);
                }
            }
            for (i = 0; i < refsToRemove.size(); ++i) {
                value.remove(refsToRemove.get(i));
            }
        }
    }

    private void addGlobalRef(GlobalRef ref) {
        java.util.List<GlobalRef> refs = this.getGlobalRefs().get(ref.getOwningType());
        if (null == refs) {
            refs = new ArrayList<GlobalRef>();
            refs.add(ref);
            this.getGlobalRefs().put(ref.getOwningType(), refs);
        } else {
            refs.add(ref);
        }
    }

    private void initialize() {
        if (null == this.packageName) {
            String packageValue = (String)this.rootSchema.getAttributesMap().get(SDOConstants.SDOJAVA_PACKAGE_QNAME);
            this.packageName = null != packageValue ? packageValue : (null == this.rootSchema.getTargetNamespace() || this.rootSchema.getTargetNamespace().equals("") ? "noNamespace" : SDOUtil.getPackageNameFromURI(this.rootSchema.getTargetNamespace()));
            this.packageName = this.packageName + ".";
        }
    }

    private SDOType createSDOTypeForName(String targetNamespace, String name, String xsdLocalName) {
        SDOType returnType = null;
        int index = name.indexOf(58);
        if (index != -1) {
            String prefix = name.substring(0, index);
            String localName = name.substring(index + 1, name.length());
            String theURI = this.getURIForPrefix(prefix);
            returnType = this.getOrCreateType(theURI, localName, xsdLocalName);
        } else {
            returnType = this.getOrCreateType(targetNamespace, name, xsdLocalName);
        }
        if (returnType != null) {
            QName qname = new QName(returnType.getURI(), name);
            this.getGeneratedTypes().put(qname, returnType);
        }
        return returnType;
    }

    private SDOType getSDOTypeForName(String targetNamespace, String defaultNamespace, String name) {
        return this.getSDOTypeForName(targetNamespace, defaultNamespace, true, name);
    }

    private SDOType getSDOTypeForName(String targetNamespace, String defaultNamespace, boolean checkDefaultNamespace, String name) {
        int index = name.indexOf(58);
        if (index != -1) {
            String prefix = name.substring(0, index);
            String localName = name.substring(index + 1, name.length());
            String theURI = this.getURIForPrefix(prefix);
            QName qname = new QName(theURI, localName);
            SDOType sdoType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(qname);
            if (null == sdoType && null == (sdoType = this.getExisitingType(theURI, localName))) {
                sdoType = this.findSdoType(targetNamespace, defaultNamespace, name, localName, theURI);
            }
            if (null == sdoType && !(sdoType = this.getOrCreateType(theURI, localName, localName)).isFinalized()) {
                this.getGeneratedTypes().put(new QName(sdoType.getURI(), sdoType.getName()), sdoType);
            }
            return sdoType;
        }
        String sdoName = (String)this.itemNameToSDOName.get(name);
        if (sdoName != null) {
            name = sdoName;
        }
        SDOType sdoType = null;
        if (checkDefaultNamespace && defaultNamespace != null) {
            QName qname = new QName(defaultNamespace, name);
            sdoType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(qname);
        }
        if (null == sdoType) {
            sdoType = this.getExisitingType(targetNamespace, name);
            if (null == sdoType) {
                return this.findSdoType(targetNamespace, defaultNamespace, name, name, targetNamespace);
            }
            return this.getOrCreateType(targetNamespace, name, name);
        }
        return sdoType;
    }

    private SDOType getOrCreateType(String uri, String typeName, String xsdLocalName) {
        SDOTypeHelper sdoTypeHelper;
        SDOType returnType;
        String lookupName = typeName;
        int index = lookupName.indexOf(58);
        if (index != -1) {
            lookupName = lookupName.substring(index + 1, lookupName.length());
        }
        if ((returnType = (SDOType)(sdoTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(uri, lookupName)) == null) {
            QName qname = new QName(uri, lookupName);
            returnType = (SDOType)this.getGeneratedTypes().get(qname);
            if (returnType == null) {
                returnType = new SDOType(uri, lookupName, sdoTypeHelper);
                returnType.setXsd(true);
                returnType.setXsdLocalName(xsdLocalName);
            }
        }
        return returnType;
    }

    private SDOProperty getExistingGlobalProperty(String uri, String localName, boolean isElement) {
        SDOProperty prop = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(uri, localName, isElement);
        if (prop == null) {
            QName qName = new QName(uri, localName);
            prop = isElement ? (SDOProperty)this.getGeneratedGlobalElements().get(qName) : (SDOProperty)this.getGeneratedGlobalAttributes().get(qName);
        }
        return prop;
    }

    private SDOType getExisitingType(String uri, String localName) {
        SDOType type = (SDOType)((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(uri, localName);
        if (type == null) {
            QName qName = new QName(uri, localName);
            type = (SDOType)this.getGeneratedTypes().get(qName);
        }
        return type;
    }

    private SDOType findSdoType(String targetNamespace, String defaultNamespace, String qualifiedName, String localName, String theURI) {
        SDOType type = this.getExisitingType(theURI, localName);
        if (null == type) {
            this.processGlobalItem(targetNamespace, defaultNamespace, qualifiedName);
            String sdoName = (String)this.itemNameToSDOName.get(localName);
            if (sdoName != null) {
                localName = sdoName;
            }
            type = this.getExisitingType(theURI, localName);
        }
        if (null == type && !(type = this.getOrCreateType(theURI, localName, localName)).isFinalized()) {
            this.getGeneratedTypes().put(new QName(type.getURI(), type.getName()), type);
        }
        return type;
    }

    public void setGeneratedTypes(Map<QName, Type> generatedTypes) {
        this.generatedTypes = generatedTypes;
    }

    public Map<QName, Type> getGeneratedTypes() {
        if (null == this.generatedTypes) {
            this.generatedTypes = new HashMap<QName, Type>();
        }
        return this.generatedTypes;
    }

    public Map<QName, Property> getGeneratedGlobalElements() {
        if (null == this.generatedGlobalElements) {
            this.generatedGlobalElements = new HashMap<QName, Property>();
        }
        return this.generatedGlobalElements;
    }

    public Map<QName, Property> getGeneratedGlobalAttributes() {
        if (null == this.generatedGlobalAttributes) {
            this.generatedGlobalAttributes = new HashMap<QName, Property>();
        }
        return this.generatedGlobalAttributes;
    }

    private void processSubstitutionGroups(Collection elements, String targetNamespace, String defaultNamespace) {
        for (Element nextElement : elements) {
            if (nextElement.getSubstitutionGroup() == null) continue;
            String substitutionGroup = nextElement.getSubstitutionGroup();
            String localName = null;
            String uri = null;
            int index = substitutionGroup.indexOf(58);
            if (index != -1) {
                String prefix = substitutionGroup.substring(0, index);
                localName = substitutionGroup.substring(index + 1, substitutionGroup.length());
                uri = this.getURIForPrefix(prefix);
            } else {
                localName = substitutionGroup;
                uri = defaultNamespace;
            }
            SDOProperty rootProp = this.getExistingGlobalProperty(uri, localName, true);
            SDOProperty thisProperty = this.getExistingGlobalProperty(targetNamespace, nextElement.getName(), true);
            if (rootProp == null || thisProperty == null) continue;
            if (rootProp.getSubstitutableElements() == null) {
                rootProp.setSubstitutableElements(new ArrayList<SDOProperty>());
                rootProp.setSubstitutable(true);
            }
            rootProp.getSubstitutableElements().add(thisProperty);
        }
    }

    private void processAnyAttribute(String targetNamespace, String defaultNamespace, String ownerName) {
        SDOType owningType = this.getTypeForName(targetNamespace, defaultNamespace, ownerName);
        owningType.setOpen(true);
    }

    private SDOType getTypeForName(String targetNamespace, String defaultNamespace, String typeName) {
        Type value = this.getGeneratedTypes().get(typeName);
        if (value != null) {
            return (SDOType)value;
        }
        String sdoName = (String)this.itemNameToSDOName.get(typeName);
        if (sdoName != null) {
            return this.getTypeForName(targetNamespace, defaultNamespace, sdoName);
        }
        return this.getSDOTypeForName(targetNamespace, defaultNamespace, false, typeName);
    }

    private QName getQNameForString(String defaultNamespace, String name) {
        if (null == name) {
            return null;
        }
        int index = name.indexOf(58);
        if (index != -1) {
            String prefix = name.substring(0, index);
            String localName = name.substring(index + 1, name.length());
            String theURI = this.getURIForPrefix(prefix);
            QName qname = new QName(theURI, localName);
            return qname;
        }
        QName qname = new QName(defaultNamespace, name);
        return qname;
    }

    private void processGlobalItem(String targetNamespace, String defaultNamespace, String qualifiedName) {
        if (this.rootSchema == null) {
            return;
        }
        String localName = null;
        int index = qualifiedName.indexOf(58);
        localName = index != -1 ? qualifiedName.substring(index + 1, qualifiedName.length()) : qualifiedName;
        SimpleType simpleType = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(localName);
        if (simpleType == null) {
            ComplexType complexType = (ComplexType)this.rootSchema.getTopLevelComplexTypes().get(localName);
            if (complexType == null) {
                Element element = (Element)this.rootSchema.getTopLevelElements().get(localName);
                if (element == null) {
                    Attribute attribute = (Attribute)this.rootSchema.getTopLevelAttributes().get(localName);
                    if (attribute != null) {
                        this.processGlobalAttribute(targetNamespace, defaultNamespace, attribute);
                    }
                } else {
                    this.processGlobalElement(targetNamespace, defaultNamespace, element);
                }
            } else {
                this.processGlobalComplexType(targetNamespace, defaultNamespace, complexType);
            }
        } else {
            this.processGlobalSimpleType(targetNamespace, defaultNamespace, simpleType);
        }
    }

    public Schema getSchema(Source xsdSource, SchemaResolver schemaResolver) {
        return this.getSchema(xsdSource, new SchemaResolverWrapper(schemaResolver));
    }

    public Schema getSchema(Source xsdSource, SchemaResolverWrapper schemaResolverWrapper) {
        try {
            XMLContext context = new XMLContext(this.getSchemaProject());
            XMLUnmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEntityResolver((EntityResolver)schemaResolverWrapper.getSchemaResolver());
            Schema schema = (Schema)unmarshaller.unmarshal(xsdSource);
            java.util.List imports = schema.getImports();
            for (Import nextImport : imports) {
                Source referencedSchema = this.getReferencedSchema(xsdSource, nextImport.getNamespace(), nextImport.getSchemaLocation(), schemaResolverWrapper);
                if (referencedSchema == null) continue;
                Schema importedSchema = this.getSchema(referencedSchema, schemaResolverWrapper);
                nextImport.setSchema(importedSchema);
            }
            java.util.List includes = schema.getIncludes();
            for (Include nextInclude : includes) {
                Source referencedSchema = this.getReferencedSchema(xsdSource, schema.getTargetNamespace(), nextInclude.getSchemaLocation(), schemaResolverWrapper);
                if (referencedSchema == null) continue;
                Schema includedSchema = this.getSchema(referencedSchema, schemaResolverWrapper);
                nextInclude.setSchema(includedSchema);
            }
            return schema;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Source getReferencedSchema(Source xsdSource, String namespace, String schemaLocation, SchemaResolverWrapper schemaResolverWrapper) {
        if (namespace.equals("commonj.sdo/java") || namespace.equals("commonj.sdo") || namespace.equals("commonj.sdo/xml")) {
            return null;
        }
        return schemaResolverWrapper.resolveSchema(xsdSource, namespace, schemaLocation);
    }

    public Project getSchemaProject() {
        if (this.schemaProject == null) {
            this.schemaProject = new SchemaModelProject();
        }
        return this.schemaProject;
    }

    public Schema getRootSchema() {
        return this.rootSchema;
    }

    public void setProcessImports(boolean processImports) {
        this.processImports = processImports;
    }

    public boolean isProcessImports() {
        return this.processImports;
    }

    public void setReturnAllTypes(boolean returnAllTypes) {
        this.returnAllTypes = returnAllTypes;
    }

    public boolean isReturnAllTypes() {
        return this.returnAllTypes;
    }

    private boolean maxOccursGreaterThanOne(String maxOccurs) {
        if (maxOccurs == null) {
            return false;
        }
        if (maxOccurs.equalsIgnoreCase("unbounded")) {
            return true;
        }
        return !maxOccurs.equals("1");
    }

    private String getURIForPrefix(String prefix) {
        NamespaceResolver next;
        String uri = null;
        for (int i = this.namespaceResolvers.size() - 1; i >= 0 && ((uri = (next = (NamespaceResolver)this.namespaceResolvers.get(i)).resolveNamespacePrefix(prefix)) == null || uri.equals("")); --i) {
        }
        if (null == uri) {
            throw SDOException.prefixUsedButNotDefined((String)prefix);
        }
        return uri;
    }

    private java.util.List<NonContainmentReference> getNonContainmentReferences() {
        if (null == this.nonContainmentReferences) {
            this.nonContainmentReferences = new ArrayList<NonContainmentReference>();
        }
        return this.nonContainmentReferences;
    }

    private Map<Type, java.util.List<GlobalRef>> getGlobalRefs() {
        if (null == this.globalRefs) {
            this.globalRefs = new HashMap<Type, java.util.List<GlobalRef>>();
        }
        return this.globalRefs;
    }

    public boolean isImportProcessor() {
        return this.isImportProcessor;
    }

    public void setIsImportProcessor(boolean isImport) {
        this.isImportProcessor = isImport;
    }

    public class GlobalRef {
        private SDOType owningType;
        private boolean isElement;
        private String uri;
        private String localName;
        private Property property;

        public void setOwningType(SDOType owningType) {
            this.owningType = owningType;
        }

        public SDOType getOwningType() {
            return this.owningType;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String theUri) {
            this.uri = theUri;
        }

        public Property getProperty() {
            return this.property;
        }

        public void setProperty(Property theProperty) {
            this.property = theProperty;
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String theLocalName) {
            this.localName = theLocalName;
        }

        public boolean isElement() {
            return this.isElement;
        }

        public void setIsElement(boolean isElem) {
            this.isElement = isElem;
        }
    }

    public class NonContainmentReference {
        private SDOType owningType;
        private SDOProperty owningProp;
        private String propertyTypeName;
        private String propertyTypeURI;
        private String oppositePropName;

        public void setOwningType(SDOType owningType) {
            this.owningType = owningType;
        }

        public SDOType getOwningType() {
            return this.owningType;
        }

        public void setOwningProp(SDOProperty owningProp) {
            this.owningProp = owningProp;
        }

        public SDOProperty getOwningProp() {
            return this.owningProp;
        }

        public void setPropertyTypeName(String propertyTypeName) {
            this.propertyTypeName = propertyTypeName;
        }

        public String getPropertyTypeName() {
            return this.propertyTypeName;
        }

        public void setPropertyTypeURI(String propertyTypeURI) {
            this.propertyTypeURI = propertyTypeURI;
        }

        public String getPropertyTypeURI() {
            return this.propertyTypeURI;
        }

        public void setOppositePropName(String oppositePropName) {
            this.oppositePropName = oppositePropName;
        }

        public String getOppositePropName() {
            return this.oppositePropName;
        }
    }
}

