/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOExternalizableDelegator;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.XPathEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDODataObject
implements DataObject,
SequencedObject {
    private SDOType type;
    private DataObject container;
    private ValueStore currentValueStore;
    private List openContentProperties;
    private List openContentPropertiesAttributes;
    private Map openContentAliasNames;
    private String containmentPropertyName;
    private ChangeSummary changeSummary;
    private List instanceProperties;
    private String sdoRef;
    private Sequence sequence;
    private DataGraph dataGraph;
    private HelperContext aHelperContext;
    private static Class pluggableClass;

    public SDODataObject() {
        try {
            this._setCurrentValueStore((ValueStore)pluggableClass.newInstance());
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(ie.getMessage());
        }
    }

    public void _setHelperContext(HelperContext aContext) {
        this.aHelperContext = aContext;
        if (this.getChangeSummary() != null) {
            ((SDOChangeSummary)this.getChangeSummary()).setHelperContext(this.aHelperContext);
        }
    }

    public Object get(String path) {
        return XPathEngine.getInstance().get(path, this);
    }

    public void set(String path, Object value) throws ClassCastException, UnsupportedOperationException, IllegalArgumentException {
        XPathEngine.getInstance().set(path, value, this, false);
    }

    public boolean isSet(String path) {
        return XPathEngine.getInstance().isSet(path, (DataObject)this);
    }

    public void unset(String path) {
        XPathEngine.getInstance().unset(path, this);
    }

    public boolean getBoolean(String path) throws ClassCastException {
        Boolean value = (Boolean)XPathEngine.getInstance().convertObjectToValueByPath(path, Boolean.class, this);
        if (value == null) {
            return false;
        }
        return value;
    }

    public byte getByte(String path) {
        Byte value = (Byte)XPathEngine.getInstance().convertObjectToValueByPath(path, Byte.class, this);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public char getChar(String path) {
        Character value = (Character)XPathEngine.getInstance().convertObjectToValueByPath(path, Character.class, this);
        if (value == null) {
            return '\u0000';
        }
        return value.charValue();
    }

    public double getDouble(String path) {
        Double value = (Double)XPathEngine.getInstance().convertObjectToValueByPath(path, Double.class, this);
        if (value == null) {
            return 0.0;
        }
        return value;
    }

    public float getFloat(String path) {
        Float value = (Float)XPathEngine.getInstance().convertObjectToValueByPath(path, Float.class, this);
        if (value == null) {
            return 0.0f;
        }
        return value.floatValue();
    }

    public int getInt(String path) {
        Integer value = (Integer)XPathEngine.getInstance().convertObjectToValueByPath(path, Integer.class, this);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public long getLong(String path) {
        Long value = (Long)XPathEngine.getInstance().convertObjectToValueByPath(path, Long.class, this);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    public short getShort(String path) {
        Short value = (Short)XPathEngine.getInstance().convertObjectToValueByPath(path, Short.class, this);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public byte[] getBytes(String path) {
        byte[] value = (byte[])XPathEngine.getInstance().convertObjectToValueByPath(path, byte[].class, this);
        return value;
    }

    public BigDecimal getBigDecimal(String path) {
        BigDecimal value = (BigDecimal)XPathEngine.getInstance().convertObjectToValueByPath(path, BigDecimal.class, this);
        return value;
    }

    public BigInteger getBigInteger(String path) {
        BigInteger value = (BigInteger)XPathEngine.getInstance().convertObjectToValueByPath(path, BigInteger.class, this);
        return value;
    }

    public DataObject getDataObject(String path) throws ClassCastException {
        return (DataObject)this.get(path);
    }

    public Date getDate(String path) {
        Date value = (Date)XPathEngine.getInstance().convertObjectToValueByPath(path, Date.class, this);
        return value;
    }

    public String getString(String path) {
        String value = (String)XPathEngine.getInstance().convertObjectToValueByPath(path, String.class, this);
        return value;
    }

    public List getList(String path) {
        return (List)XPathEngine.getInstance().convertObjectToValueByPath(path, List.class, this);
    }

    public void setBoolean(String path, boolean value) {
        this.convertValueAndSet(path, (Object)new Boolean(value));
    }

    public void setByte(String path, byte value) {
        this.convertValueAndSet(path, (Object)new Byte(value));
    }

    public void setChar(String path, char value) {
        this.convertValueAndSet(path, (Object)new Character(value));
    }

    public void setDouble(String path, double value) {
        this.convertValueAndSet(path, (Object)new Double(value));
    }

    public void setFloat(String path, float value) {
        this.convertValueAndSet(path, (Object)new Float(value));
    }

    public void setInt(String path, int value) {
        this.convertValueAndSet(path, (Object)new Integer(value));
    }

    public void setLong(String path, long value) {
        this.convertValueAndSet(path, (Object)new Long(value));
    }

    public void setShort(String path, short value) {
        this.convertValueAndSet(path, (Object)new Short(value));
    }

    public void setBytes(String path, byte[] value) {
        this.convertValueAndSet(path, (Object)value);
    }

    public void setBigDecimal(String path, BigDecimal value) {
        this.convertValueAndSet(path, (Object)value);
    }

    public void setBigInteger(String path, BigInteger value) {
        this.convertValueAndSet(path, (Object)value);
    }

    public void setDataObject(String path, DataObject value) {
        this.set(path, (Object)value);
    }

    public void setDate(String path, Date value) {
        this.convertValueAndSet(path, (Object)value);
    }

    public void setString(String path, String value) {
        this.convertValueAndSet(path, (Object)value);
    }

    public void setList(String path, List value) {
        this.convertValueAndSet(path, (Object)value);
    }

    public Object get(int propertyIndex) throws IllegalArgumentException {
        SDOProperty p = this.getInstanceProperty(propertyIndex);
        return this.get(p);
    }

    public void set(int propertyIndex, Object value) {
        try {
            SDOProperty p = this.getInstanceProperty(propertyIndex);
            this.set(p, value);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("PropertyIndex invalid.");
        }
    }

    public boolean isSet(int propertyIndex) {
        SDOProperty p = this.getInstanceProperty(propertyIndex);
        return this.isSet(p);
    }

    public void unset(int propertyIndex) {
        SDOProperty p = this.getInstanceProperty(propertyIndex);
        this.unset(p);
    }

    public boolean getBoolean(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBoolean(property);
    }

    public byte getByte(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getByte(property);
    }

    public char getChar(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getChar(property);
    }

    public double getDouble(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getDouble(property);
    }

    public float getFloat(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getFloat(property);
    }

    public int getInt(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getInt(property);
    }

    public long getLong(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getLong(property);
    }

    public short getShort(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getShort(property);
    }

    public byte[] getBytes(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBytes(property);
    }

    public BigDecimal getBigDecimal(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBigDecimal(property);
    }

    public BigInteger getBigInteger(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getBigInteger(property);
    }

    public DataObject getDataObject(int propertyIndex) {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getDataObject(property);
    }

    public Date getDate(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getDate(property);
    }

    public String getString(int propertyIndex) throws IllegalArgumentException, ClassCastException {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getString(property);
    }

    public List getList(int propertyIndex) {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        return this.getList(property);
    }

    public Sequence getSequence(String path) {
        Object anObject = this.get(path);
        if (null == anObject || !(anObject instanceof DataObject)) {
            throw SDOException.sequenceNotFoundForPath((String)path);
        }
        return ((DataObject)anObject).getSequence();
    }

    public Sequence getSequence(int propertyIndex) {
        SDOProperty aProperty = this.getInstanceProperty(propertyIndex);
        return this.getSequencePrivate(aProperty);
    }

    public Sequence getSequence(Property property) {
        return this.getSequencePrivate(property);
    }

    private Sequence getSequencePrivate(Property aProperty) {
        if (aProperty != null && aProperty.getType().isSequenced() && this.isSet(aProperty) && !aProperty.getType().isDataType() && !aProperty.isMany()) {
            return ((DataObject)this.get(aProperty)).getSequence();
        }
        throw SDOException.sequenceNotSupportedForProperty((String)aProperty.getName());
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setBoolean(int propertyIndex, boolean value) {
        this.convertValueAndSet(propertyIndex, (Object)new Boolean(value));
    }

    public void setByte(int propertyIndex, byte value) {
        this.convertValueAndSet(propertyIndex, (Object)new Byte(value));
    }

    public void setChar(int propertyIndex, char value) {
        this.convertValueAndSet(propertyIndex, (Object)new Character(value));
    }

    public void setDouble(int propertyIndex, double value) {
        this.convertValueAndSet(propertyIndex, (Object)new Double(value));
    }

    public void setFloat(int propertyIndex, float value) {
        this.convertValueAndSet(propertyIndex, (Object)new Float(value));
    }

    public void setInt(int propertyIndex, int value) {
        this.convertValueAndSet(propertyIndex, (Object)new Integer(value));
    }

    public void setLong(int propertyIndex, long value) {
        this.convertValueAndSet(propertyIndex, (Object)new Long(value));
    }

    public void setShort(int propertyIndex, short value) {
        this.convertValueAndSet(propertyIndex, (Object)new Short(value));
    }

    public void setBytes(int propertyIndex, byte[] value) {
        this.convertValueAndSet(propertyIndex, (Object)value);
    }

    public void setBigDecimal(int propertyIndex, BigDecimal value) {
        this.convertValueAndSet(propertyIndex, (Object)value);
    }

    public void setBigInteger(int propertyIndex, BigInteger value) {
        this.convertValueAndSet(propertyIndex, (Object)value);
    }

    public void setDataObject(int propertyIndex, DataObject value) {
        this.set(propertyIndex, (Object)value);
    }

    public void setDate(int propertyIndex, Date value) {
        this.convertValueAndSet(propertyIndex, (Object)value);
    }

    public void setString(int propertyIndex, String value) {
        this.convertValueAndSet(propertyIndex, (Object)value);
    }

    public void setList(int propertyIndex, List value) {
        this.convertValueAndSet(propertyIndex, (Object)value);
    }

    public Object get(Property property) throws IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (null != this.type && !this.type.isOpen() && property.isOpenContent()) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (property.isMany()) {
            return this.getList(property);
        }
        if (this.isSet(property)) {
            return this.getPropertyInternal(property);
        }
        return property.getDefault();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Property defineOpenContentProperty(String name, Object value) throws UnsupportedOperationException, IllegalArgumentException {
        DataObject propertyDO = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        propertyDO.set("name", (Object)name);
        Type sdotype = null;
        boolean isMany = false;
        boolean isContainment = false;
        Class<?> valueClass = value.getClass();
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            if (((Collection)value).size() <= 0) return null;
            Object firstObject = ((Collection)value).iterator().next();
            if (firstObject == null) return null;
            valueClass = firstObject.getClass();
            if (firstObject instanceof DataObject) {
                if (((DataObject)firstObject).getContainer() == null) {
                    isContainment = true;
                }
                sdotype = ((DataObject)firstObject).getType();
            } else {
                sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
            }
            isMany = true;
        } else if (value instanceof DataObject) {
            if (((DataObject)value).getContainer() == null) {
                isContainment = true;
            }
            sdotype = ((DataObject)value).getType();
        } else {
            Property xmlElementProperty = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "xmlElement");
            propertyDO.set(xmlElementProperty, (Object)Boolean.TRUE);
            sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
        }
        propertyDO.set("type", (Object)sdotype);
        propertyDO.set("many", (Object)isMany);
        propertyDO.set("containment", (Object)isContainment);
        return this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propertyDO);
    }

    public Property defineOpenContentProperty(String name, Object value, Type sdotype) throws UnsupportedOperationException, IllegalArgumentException {
        if (sdotype == null) {
            return this.defineOpenContentProperty(name, value);
        }
        DataObject propertyDO = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        propertyDO.set("name", (Object)name);
        boolean isMany = false;
        boolean isContainment = false;
        Class<?> valueClass = value.getClass();
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Object firstObject;
            if (((Collection)value).size() > 0 && (firstObject = ((Collection)value).iterator().next()) != null) {
                valueClass = firstObject.getClass();
                if (firstObject instanceof DataObject) {
                    if (((DataObject)firstObject).getContainer() == null) {
                        isContainment = true;
                    }
                    sdotype = ((DataObject)firstObject).getType();
                } else {
                    sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
                }
            }
            isMany = true;
        } else if (value instanceof DataObject) {
            if (((DataObject)value).getContainer() == null) {
                isContainment = true;
            }
            sdotype = ((DataObject)value).getType();
        } else {
            sdotype = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(valueClass);
        }
        propertyDO.set("type", (Object)sdotype);
        propertyDO.set("many", (Object)isMany);
        propertyDO.set("containment", (Object)isContainment);
        return this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propertyDO);
    }

    public void set(Property property, Object value) throws UnsupportedOperationException, IllegalArgumentException {
        this.set((SDOProperty)property, value, true);
    }

    public void setInternal(SDOProperty property, Object value, boolean updateSequence) throws UnsupportedOperationException, IllegalArgumentException {
        if (null == this.getType()) {
            throw new UnsupportedOperationException("Type is null");
        }
        if (property.isOpenContent() && !this.getType().isOpen()) {
            throw new IllegalArgumentException("DataObject " + this + " is not Open for property " + property.getName());
        }
        Object oldValue = this.get(property);
        boolean wasSet = this.isSet(property);
        if (wasSet && oldValue == value) {
            return;
        }
        this._setModified(true);
        if (property.isMany()) {
            if (null == value) {
                value = new ListWrapper(this, property);
            }
            if (!(value instanceof Collection)) {
                throw new IllegalArgumentException("Properties with isMany = true can only be set on list values.");
            }
            List listValue = (List)value;
            if (property.isContainment() || this.isContainedByDataGraph(property)) {
                int size = listValue.size();
                for (int i = 0; i < size; ++i) {
                    Object next = listValue.get(i);
                    if (!(next instanceof SDODataObject) || !this.parentContains(next)) continue;
                    throw new IllegalArgumentException("Circular reference.");
                }
            }
            listValue = (List)oldValue;
            ((ListWrapper)listValue).clear(updateSequence);
            ((ListWrapper)listValue).addAll((Collection)value, updateSequence);
        } else {
            if (property.isContainment() || this.isContainedByDataGraph(property)) {
                if (value instanceof SDODataObject && this.parentContains(value)) {
                    throw new IllegalArgumentException("Circular reference.");
                }
                this.detach(property, oldValue);
                if (value != null && value instanceof DataObject) {
                    this.updateContainment((Property)property, (DataObject)value);
                }
            }
            this.setPropertyInternal(property, value, updateSequence);
        }
        if (this.getType().isOpen() && property.isOpenContent()) {
            this.addOpenContentProperty(property);
        }
    }

    public void set(SDOProperty property, Object value, boolean updateSequence) throws UnsupportedOperationException, IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException("Illegal Argument.");
        }
        if (property.isReadOnly()) {
            throw new UnsupportedOperationException("Property is Readonly." + property.getName() + "  " + this.getType().getName());
        }
        this.setInternal(property, value, updateSequence);
    }

    public boolean isSet(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"isSet");
        }
        if (property.isMany()) {
            List value = this.getList(property);
            return !value.isEmpty();
        }
        return this.isSetInternal(property);
    }

    public void unset(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"unset");
        }
        this.unset(property, false);
    }

    private void unset(Property property, boolean fromDelete) {
        this.unset(property, fromDelete, true);
    }

    public void unset(Property property, boolean fromDelete, boolean updateSequence) {
        Object oldValue;
        boolean wasSet;
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"unset");
        }
        if (property.isReadOnly()) {
            // empty if block
        }
        if (wasSet = this.isSet(property)) {
            if (!fromDelete) {
                this._setModified(true);
            }
        } else {
            return;
        }
        if ((property.isContainment() || this.isContainedByDataGraph(property)) && (oldValue = this.get(property)) != null) {
            if (property.isMany()) {
                int size = ((List)oldValue).size();
                for (int itemIndex = 0; itemIndex < size; ++itemIndex) {
                    SDODataObject manyItem = (SDODataObject)((List)oldValue).get(itemIndex);
                    if (manyItem == null) continue;
                    manyItem.detachOrDelete(fromDelete);
                }
            } else {
                ((SDODataObject)oldValue).detachOrDelete(fromDelete);
            }
        }
        if (wasSet) {
            this.unsetInternal(property, updateSequence);
        }
    }

    public boolean getBoolean(Property property) throws IllegalArgumentException, ClassCastException {
        Boolean propertyBooleanValue = (Boolean)this.convertObjectToValue(property, Boolean.class);
        if (propertyBooleanValue == null) {
            return false;
        }
        return propertyBooleanValue;
    }

    public byte getByte(Property property) throws IllegalArgumentException, ClassCastException {
        Byte propertyByteValue = (Byte)this.convertObjectToValue(property, Byte.class);
        if (propertyByteValue == null) {
            return 0;
        }
        return propertyByteValue;
    }

    public char getChar(Property property) throws IllegalArgumentException {
        Character propertyCharValue = (Character)this.convertObjectToValue(property, Character.class);
        if (propertyCharValue == null) {
            return '\u0000';
        }
        return propertyCharValue.charValue();
    }

    public double getDouble(Property property) throws IllegalArgumentException {
        Double propertyDoubleValue = (Double)this.convertObjectToValue(property, Double.class);
        if (propertyDoubleValue == null) {
            return 0.0;
        }
        return propertyDoubleValue;
    }

    public float getFloat(Property property) throws IllegalArgumentException {
        Float propertyFloatValue = (Float)this.convertObjectToValue(property, Float.class);
        if (propertyFloatValue == null) {
            return 0.0f;
        }
        return propertyFloatValue.floatValue();
    }

    public int getInt(Property property) throws IllegalArgumentException {
        Integer propertyIntegerValue = (Integer)this.convertObjectToValue(property, Integer.class);
        if (propertyIntegerValue == null) {
            return 0;
        }
        return propertyIntegerValue;
    }

    public long getLong(Property property) throws IllegalArgumentException {
        Long propertyLongValue = (Long)this.convertObjectToValue(property, Long.class);
        if (propertyLongValue == null) {
            return 0L;
        }
        return propertyLongValue;
    }

    public short getShort(Property property) throws IllegalArgumentException {
        Short propertyShortValue = (Short)this.convertObjectToValue(property, Short.class);
        if (propertyShortValue == null) {
            return 0;
        }
        return propertyShortValue;
    }

    public byte[] getBytes(Property property) throws IllegalArgumentException {
        byte[] propertyByteValue = (byte[])this.convertObjectToValue(property, byte[].class);
        return propertyByteValue;
    }

    public BigDecimal getBigDecimal(Property property) throws IllegalArgumentException {
        BigDecimal propertyDecimalValue = (BigDecimal)this.convertObjectToValue(property, BigDecimal.class);
        return propertyDecimalValue;
    }

    public BigInteger getBigInteger(Property property) throws IllegalArgumentException {
        BigInteger propertyBigIntegerValue = (BigInteger)this.convertObjectToValue(property, BigInteger.class);
        return propertyBigIntegerValue;
    }

    public DataObject getDataObject(Property property) throws IllegalArgumentException, ClassCastException {
        return (DataObject)this.get(property);
    }

    public Date getDate(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"getDate");
        }
        if (property.getType().equals(SDOConstants.SDO_STRING)) {
            DataHelper dHelper = this.aHelperContext.getDataHelper();
            String dateString = (String)this.get(property);
            return dHelper.toDate(dateString);
        }
        Date propertyDateValue = (Date)this.convertObjectToValue(property, Date.class);
        return propertyDateValue;
    }

    public String getString(Property property) {
        String propertyStringValue = (String)this.convertObjectToValue(property, String.class);
        return propertyStringValue;
    }

    public List getList(Property property) {
        if (null == property) {
            throw SDOException.cannotPerformOperationOnNullArgument((String)"getList");
        }
        if (this.type != null && !this.type.isOpen() && property.isOpenContent()) {
            throw new IllegalArgumentException("Argument not Supported.");
        }
        if (!property.isMany()) {
            throw new ClassCastException("can not call getList for a property that has isMany false.");
        }
        Object value = this.getPropertyInternal(property);
        if (value != null && value instanceof List) {
            return (List)value;
        }
        ListWrapper theList = new ListWrapper(this, property);
        if (this.getType().isOpen() && property.isOpenContent()) {
            this.addOpenContentProperty(property);
        }
        this.setPropertyInternal((SDOProperty)property, theList, false);
        return theList;
    }

    public void setBoolean(Property property, boolean value) {
        this.convertValueAndSet(property, (Object)new Boolean(value));
    }

    public void setByte(Property property, byte value) {
        this.convertValueAndSet(property, (Object)new Byte(value));
    }

    public void setChar(Property property, char value) {
        this.convertValueAndSet(property, (Object)new Character(value));
    }

    public void setDouble(Property property, double value) {
        this.convertValueAndSet(property, (Object)new Double(value));
    }

    public void setFloat(Property property, float value) {
        this.convertValueAndSet(property, (Object)new Float(value));
    }

    public void setInt(Property property, int value) {
        this.convertValueAndSet(property, (Object)new Integer(value));
    }

    public void setLong(Property property, long value) {
        this.convertValueAndSet(property, (Object)new Long(value));
    }

    public void setShort(Property property, short value) {
        this.convertValueAndSet(property, (Object)new Short(value));
    }

    public void setBytes(Property property, byte[] value) {
        this.convertValueAndSet(property, (Object)value);
    }

    public void setBigDecimal(Property property, BigDecimal value) {
        this.convertValueAndSet(property, (Object)value);
    }

    public void setBigInteger(Property property, BigInteger value) {
        this.convertValueAndSet(property, (Object)value);
    }

    public void setDataObject(Property property, DataObject value) {
        this.set(property, (Object)value);
    }

    public void setDate(Property property, Date value) {
        this.convertValueAndSet(property, (Object)value);
    }

    public void setString(Property property, String value) {
        this.convertValueAndSet(property, (Object)value);
    }

    public void setList(Property property, List value) {
        this.convertValueAndSet(property, (Object)value);
    }

    public DataObject createDataObject(String propertyName) {
        SDOProperty aProperty = this.getInstanceProperty(propertyName);
        return this.createDataObject(aProperty);
    }

    public DataObject createDataObject(int propertyIndex) {
        SDOProperty aProperty = this.getInstanceProperty(propertyIndex);
        return this.createDataObject(aProperty);
    }

    public DataObject createDataObject(Property aProperty) {
        Type aType;
        if (aProperty.isContainment() && (aType = aProperty.getType()) != null) {
            return this.createDataObject(aProperty, aType);
        }
        return null;
    }

    public DataObject createDataObject(String propertyName, String namespaceURI, String typeName) {
        SDOProperty aProperty = this.getInstanceProperty(propertyName);
        Type aType = this.aHelperContext.getTypeHelper().getType(namespaceURI, typeName);
        return this.createDataObject(aProperty, aType);
    }

    public DataObject createDataObject(int propertyIndex, String namespaceURI, String typeName) {
        SDOProperty aProperty = this.getInstanceProperty(propertyIndex);
        Type aType = this.aHelperContext.getTypeHelper().getType(namespaceURI, typeName);
        return this.createDataObject(aProperty, aType);
    }

    public DataObject createDataObject(Property property, Type aType) {
        DataObject created = this.aHelperContext.getDataFactory().create(aType);
        if (property.isMany()) {
            ((ListWrapper)this.getList(property)).add(created, false);
        } else {
            this.set(property, (Object)created);
        }
        this._setModified(true);
        ((SDODataObject)created)._setCreated(true);
        return created;
    }

    private void detach(Property property, Object oldValue) {
        if (property.isMany()) {
            int size = ((List)oldValue).size();
            for (int i = 0; i < size; ++i) {
                Object nextValue = ((List)oldValue).get(i);
                if (nextValue == null || !(nextValue instanceof SDODataObject)) continue;
                ((SDODataObject)nextValue).detachOrDelete(false);
            }
        } else if (oldValue != null && oldValue instanceof SDODataObject) {
            ((SDODataObject)oldValue).detachOrDelete(false);
        }
    }

    public void detachOrDelete(boolean fromDelete) {
        boolean isCSRoot;
        if (null == this.getContainer() && !fromDelete) {
            return;
        }
        boolean bl = isCSRoot = null != this.getChangeSummary() && this.getChangeSummary().getRootObject() == this;
        if (!fromDelete && isCSRoot) {
            return;
        }
        this.detachDeleteRecursivePrivate(fromDelete, !isCSRoot, true);
    }

    private void detachDeleteRecursivePrivate(boolean fromDelete, boolean clearCS, boolean isRootOfRecursiveLoop) {
        boolean subTreeRootHasCStoClear = clearCS;
        if (null == this.getContainer()) {
            clearCS = false;
        }
        if ((isRootOfRecursiveLoop || fromDelete) && null != this.getContainer()) {
            ((SDODataObject)this.getContainer())._setModified(true);
            this._setContainer(null);
            this._setContainmentPropertyName(null);
        }
        this._setDeleted(true);
        DataGraph previousDataGraph = this.getDataGraph();
        this.setDataGraph(null);
        List instancePropertiesList = this.getInstanceProperties();
        int psize = instancePropertiesList.size();
        for (int i = 0; i < psize; ++i) {
            SDOProperty nextProperty = (SDOProperty)instancePropertiesList.get(i);
            Object oldValue = this.get(nextProperty);
            if (nextProperty.getType().isChangeSummaryType()) continue;
            if (nextProperty.isContainment() || this.isContainedByDataGraph(previousDataGraph, nextProperty)) {
                if (nextProperty.isMany()) {
                    int lsize = ((List)oldValue).size();
                    for (int j = 0; j < lsize; ++j) {
                        Object manyItem = ((List)oldValue).get(j);
                        this.detachDeleteRecursivePrivateHelper((SDODataObject)manyItem, fromDelete, clearCS);
                    }
                } else {
                    this.detachDeleteRecursivePrivateHelper((SDODataObject)oldValue, fromDelete, clearCS);
                }
            }
            if (!fromDelete || nextProperty.isReadOnly()) continue;
            this.unset(nextProperty, fromDelete);
        }
        if (clearCS || subTreeRootHasCStoClear) {
            this._setChangeSummary(null);
        }
    }

    private void detachDeleteRecursivePrivateHelper(SDODataObject aDataObject, boolean fromDelete, boolean clearCS) {
        if (aDataObject != null) {
            ChangeSummary containerCS;
            boolean isCSRoot;
            boolean bl = isCSRoot = aDataObject.getChangeSummary() != null && aDataObject.getChangeSummary().getRootObject() == aDataObject;
            if (isCSRoot) {
                clearCS = false;
            } else if (aDataObject.getContainer() != null && (containerCS = aDataObject.getContainer().getChangeSummary()) == null) {
                clearCS = true;
            }
            aDataObject.detachDeleteRecursivePrivate(fromDelete, clearCS, false);
        }
    }

    public void detach() {
        this.detachWithSequenceUpdate();
    }

    private void detachWithSequenceUpdate() {
        this.detach(false, true);
    }

    private void deleteWithSequenceUpdate() {
        this.detach(true, true);
    }

    private void detach(boolean fromDelete, boolean updateSequence) {
        SDOProperty containmentProperty = this.getContainmentProperty();
        if (containmentProperty == null || containmentProperty.isReadOnly()) {
            // empty if block
        }
        if (containmentProperty != null) {
            if (this.getContainmentProperty().isMany()) {
                List oldList = this.getContainer().getList((Property)containmentProperty);
                ((ListWrapper)oldList).remove(this, fromDelete, updateSequence);
            } else {
                ((SDODataObject)this.getContainer()).unset(containmentProperty, fromDelete, updateSequence);
            }
        } else {
            this._setDeleted(true);
            this.detachOrDelete(fromDelete);
        }
    }

    public void delete() {
        this.deleteWithSequenceUpdate();
    }

    public DataObject getContainer() {
        return this.container;
    }

    public SDOProperty getContainmentProperty() {
        if (this.container != null && this.containmentPropertyName != null) {
            return (SDOProperty)this.container.getInstanceProperty(this.containmentPropertyName);
        }
        return null;
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    public void setDataGraph(DataGraph dataGraph) {
        this.dataGraph = dataGraph;
    }

    public SDOType getType() {
        return this.type;
    }

    public List getInstanceProperties() {
        if (null == this.instanceProperties) {
            this.instanceProperties = new ArrayList();
        }
        return this.instanceProperties;
    }

    public Property getProperty(String propertyName) {
        return this.getInstanceProperty(propertyName);
    }

    public SDOProperty getInstanceProperty(String propertyName) {
        if (this.getType() == null) {
            throw new UnsupportedOperationException("Type is null");
        }
        SDOProperty property = this.getType().getProperty(propertyName);
        if (null == property && null == (property = (SDOProperty)this._getOpenContentAliasNamesMap().get(propertyName))) {
            SDOProperty nextProp;
            int i;
            for (i = 0; i < this._getOpenContentProperties().size(); ++i) {
                nextProp = (SDOProperty)this._getOpenContentProperties().get(i);
                if (!nextProp.getName().equals(propertyName)) continue;
                return nextProp;
            }
            if (null == property) {
                for (i = 0; i < this._getOpenContentPropertiesAttributes().size(); ++i) {
                    nextProp = (SDOProperty)this._getOpenContentPropertiesAttributes().get(i);
                    if (!nextProp.getName().equals(propertyName)) continue;
                    return nextProp;
                }
            }
        }
        return property;
    }

    SDOProperty getInstanceProperty(String propertyName, Object value) {
        SDOProperty sdoProperty = this.getInstanceProperty(propertyName);
        if (null == sdoProperty) {
            sdoProperty = (SDOProperty)this.defineOpenContentProperty(propertyName, value);
        }
        return sdoProperty;
    }

    public SDOProperty getInstanceProperty(int propertyIndex) throws IllegalArgumentException {
        try {
            SDOProperty property = this.getInstancePropertiesArray()[propertyIndex];
            return property;
        }
        catch (IndexOutOfBoundsException e) {
            throw SDOException.propertyNotFoundAtIndex((Exception)e, (int)propertyIndex);
        }
    }

    public DataObject getRootObject() {
        if (this.getContainer() != null) {
            return this.getContainer().getRootObject();
        }
        return this;
    }

    public ChangeSummary getChangeSummary() {
        return this.changeSummary;
    }

    public void _setCreated(boolean created) {
        if (this.changeSummary != null) {
            ((SDOChangeSummary)this.changeSummary).setCreated(this, created);
        }
    }

    public void _setModified(boolean modified) {
        if (this.changeSummary != null && this.isLogging()) {
            this.updateChangeSummaryWithOriginalValues();
        }
    }

    private void _setDeleted(boolean deleted) {
        boolean wasDeleted;
        if (this.changeSummary != null && (wasDeleted = ((SDOChangeSummary)this.changeSummary).setDeleted(this, deleted)) && this.isLogging()) {
            this.updateChangeSummaryWithOriginalValues();
        }
    }

    private void setChangeSummaryNonRecursive(ChangeSummary csm) {
        SDOProperty changeSummaryProperty;
        this.changeSummary = csm;
        if (this.getType() != null && (changeSummaryProperty = this.getType().getChangeSummaryProperty()) != null) {
            this.setChangeSummaryProperty(changeSummaryProperty, csm);
        }
    }

    public void _setChangeSummary(ChangeSummary aChangeSummary) {
        this.updateChangeSummaryAndDataGraph(aChangeSummary, this.getDataGraph());
    }

    private void updateChangeSummaryAndDataGraph(ChangeSummary aChangeSummary, DataGraph aDataGraph) {
        Iterator iterProperties = this.getInstanceProperties().iterator();
        this.setDataGraph(aDataGraph);
        while (iterProperties.hasNext()) {
            Property property = (Property)iterProperties.next();
            if (!property.isContainment() && !this.isContainedByDataGraph(property)) continue;
            Object object = this.get(property);
            if (object instanceof SDODataObject) {
                ((SDODataObject)object).updateChangeSummaryAndDataGraph(aChangeSummary, aDataGraph);
            }
            if (!(object instanceof ListWrapper)) continue;
            for (Object listContainedObject : (ListWrapper)object) {
                if (!(listContainedObject instanceof SDODataObject)) continue;
                ((SDODataObject)listContainedObject).updateChangeSummaryAndDataGraph(aChangeSummary, aDataGraph);
            }
        }
        this.setChangeSummaryNonRecursive(aChangeSummary);
    }

    private void updateDataGraph(DataGraph aDataGraph) {
        Iterator iterProperties = this.getInstanceProperties().iterator();
        this.setDataGraph(aDataGraph);
        while (iterProperties.hasNext()) {
            Property property = (Property)iterProperties.next();
            if (!property.isContainment() && !this.isContainedByDataGraph(property)) continue;
            Object object = this.get(property);
            if (object instanceof SDODataObject) {
                ((SDODataObject)object).updateDataGraph(aDataGraph);
            }
            if (!(object instanceof ListWrapper)) continue;
            for (Object listContainedObject : (ListWrapper)object) {
                if (!(listContainedObject instanceof SDODataObject)) continue;
                ((SDODataObject)listContainedObject).updateDataGraph(aDataGraph);
            }
        }
    }

    private void setChangeSummaryProperty(SDOProperty property, ChangeSummary value) {
        if (property.isOpenContent()) {
            throw new IllegalArgumentException("ChangeSummary can not be on an open content property.");
        }
        if (property.isMany()) {
            throw new IllegalArgumentException("ChangeSummary can not be on a property with many set to true.");
        }
        if (this.isLogging()) {
            this._setModified(true);
        }
        this.setPropertyInternal(property, value, true);
    }

    public void undoChanges(boolean isCSRoot, ChangeSummary cs, SDODataObject origContainer, String origContainmentPropName) {
        if (null == cs) {
            return;
        }
        if (((SDOChangeSummary)cs).isDirty(this)) {
            if (!isCSRoot) {
                if (null == this.changeSummary) {
                    this.changeSummary = cs;
                }
                if (null == this.container) {
                    this._setContainer(origContainer);
                }
                if (null == this.containmentPropertyName) {
                    this._setContainmentPropertyName(origContainmentPropName);
                }
            }
            this._setCurrentValueStore((ValueStore)((SDOChangeSummary)cs).getOriginalValueStores().get(this));
            ((SDOChangeSummary)cs).getOriginalValueStores().remove(this);
        }
        if (this.getType().isSequenced() && ((SDOChangeSummary)cs).isDirty((SDOSequence)this.sequence)) {
            Sequence currentSequence = this.sequence;
            Sequence originalSequence = (Sequence)((SDOChangeSummary)cs).getOriginalSequences().get(this);
            if (null == originalSequence && null != currentSequence) {
                throw SDOException.oldSequenceNotFound();
            }
            this.sequence = originalSequence;
            ((SDOChangeSummary)cs).getOldSequences().remove(this);
            ((SDOChangeSummary)cs).getOriginalSequences().remove(this);
        }
        List oldUnsetOCList = ((SDOChangeSummary)cs).getUnsetOCProperties(this);
        int size = oldUnsetOCList.size();
        for (int i = 0; i < size; ++i) {
            this.addOpenContentProperty((Property)oldUnsetOCList.get(0));
        }
        for (SDOProperty property : this.getInstanceProperties()) {
            Object value;
            if (property.getType().isChangeSummaryType() || null == (value = this.get(property)) && null != this.getChangeSummary()) continue;
            if (property.isMany()) {
                if (null == value) continue;
                ((ListWrapper)value).undoChanges((SDOChangeSummary)this.getChangeSummary());
                if (property.getType().isDataType()) continue;
                for (Object valueMany : (List)value) {
                    if (null == valueMany) continue;
                    ((SDODataObject)valueMany).undoChanges(false, this.changeSummary, this, property.getName());
                }
                continue;
            }
            if (property.getType().isDataType() || null == value) continue;
            ((SDODataObject)value).undoChanges(false, this.changeSummary, this, property.getName());
        }
    }

    private void updateChangeSummaryWithOriginalValues() {
        if (this.isLogging() && !((SDOChangeSummary)this.getChangeSummary()).isDirty(this)) {
            ((SDOChangeSummary)this.getChangeSummary()).getOriginalValueStores().put(this, this._getCurrentValueStore());
            this.currentValueStore = this._getCurrentValueStore().copy();
            if (this.getType().isSequenced()) {
                SDOSequence copySequence = ((SDOSequence)this.getSequence()).copy();
                ((SDOChangeSummary)this.getChangeSummary()).getOriginalSequences().put(this, copySequence);
            }
        }
    }

    public void resetChanges() {
        if (this.container != null && this.containmentPropertyName != null && this.changeSummary != null) {
            ((SDOChangeSummary)this.changeSummary).setOldContainer(this, this.container);
            ((SDOChangeSummary)this.changeSummary).setOldContainmentProperty(this, this.container.getInstanceProperty(this.containmentPropertyName));
        }
        for (SDOProperty property : this.getInstanceProperties()) {
            Object value = this.get(property);
            if ((property.isContainment() || this.isContainedByDataGraph(property)) && !property.isMany() && value != null && !property.getType().isChangeSummaryType()) {
                ((SDODataObject)value).resetChanges();
                continue;
            }
            if (!property.isMany() || null == value) continue;
            for (Object valueMany : (ListWrapper)value) {
                if (!property.isContainment() && !this.isContainedByDataGraph(property) || valueMany == null || property.getType().isChangeSummaryType()) continue;
                ((SDODataObject)valueMany).resetChanges();
            }
        }
    }

    public void _setType(Type aType) {
        this.type = (SDOType)aType;
        if (this.getInstanceProperties().isEmpty()) {
            if (this.type != null) {
                this.getInstanceProperties().addAll(this.type.getProperties());
            }
            this.getInstanceProperties().addAll(this._getOpenContentProperties());
        }
        if (this.type != null) {
            SDOProperty csmProperty;
            this._getCurrentValueStore().initialize(this);
            if (this.type.isSequenced()) {
                this.sequence = new SDOSequence(this);
            }
            if ((csmProperty = this.type.getChangeSummaryProperty()) != null) {
                SDOChangeSummary aChangeSummary = new SDOChangeSummary(this, this.aHelperContext);
                aChangeSummary.endLogging();
                this._setChangeSummary(aChangeSummary);
            }
        }
    }

    public void _setCurrentValueStore(ValueStore aValueStore) {
        this.currentValueStore = aValueStore;
    }

    public ValueStore _getCurrentValueStore() {
        return this.currentValueStore;
    }

    public void _setContainer(DataObject aContainer) {
        this.container = aContainer;
    }

    public Map _getOpenContentPropertiesAttributesMap() {
        HashMap<QName, Object> openContentPropertiesAttrs = new HashMap<QName, Object>();
        int size = this._getOpenContentPropertiesAttributes().size();
        for (int i = 0; i < size; ++i) {
            Property next = (Property)this._getOpenContentPropertiesAttributes().get(i);
            QName qname = new QName(((SDOProperty)next).getUri(), next.getName());
            openContentPropertiesAttrs.put(qname, this.get(next));
        }
        return openContentPropertiesAttrs;
    }

    public void _setOpenContentPropertiesAttributesMap(Map openAttributeProperties) {
        for (QName nextKey : openAttributeProperties.keySet()) {
            if (nextKey.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || nextKey.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && nextKey.getLocalPart().equals("type")) continue;
            Object value = openAttributeProperties.get(nextKey);
            SDOProperty prop = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(nextKey.getNamespaceURI(), nextKey.getLocalPart(), false);
            if (prop == null) {
                DataObject propDo = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
                propDo.set("name", (Object)nextKey.getLocalPart());
                propDo.set("type", (Object)SDOConstants.SDO_STRING);
                propDo.set("many", (Object)false);
                prop = (SDOProperty)this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propDo);
                prop.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.FALSE);
                prop.setUri(nextKey.getNamespaceURI());
                this.set(prop, value);
                continue;
            }
            this.set(prop, value);
        }
    }

    public void _setOpenContentPropertiesWithXMLRoots(List openContentPropertiesWithXMLRoots) {
        int size = openContentPropertiesWithXMLRoots.size();
        for (int i = 0; i < size; ++i) {
            Object next = openContentPropertiesWithXMLRoots.get(i);
            String propertyName = null;
            String propertyUri = null;
            Object value = null;
            Type theType = null;
            if (next instanceof XMLRoot) {
                XMLRoot nextXMLRoot = (XMLRoot)next;
                value = nextXMLRoot.getObject();
                propertyName = nextXMLRoot.getLocalName();
                propertyUri = nextXMLRoot.getNamespaceURI();
                theType = value instanceof DataObject ? ((DataObject)value).getType() : ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(value.getClass());
            } else if (next instanceof DataObject) {
                value = next;
                String qualifiedName = ((SDOType)((DataObject)next).getType()).getXmlDescriptor().getDefaultRootElement();
                int colonIndex = qualifiedName.indexOf(":");
                if (colonIndex > -1) {
                    String prefix = qualifiedName.substring(0, colonIndex);
                    if (prefix != null && !prefix.equals("")) {
                        propertyUri = ((SDOType)((DataObject)next).getType()).getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespacePrefix(prefix);
                    }
                    propertyName = qualifiedName.substring(colonIndex + 1, qualifiedName.length());
                } else {
                    propertyName = qualifiedName;
                }
                theType = ((DataObject)next).getType();
            } else {
                theType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getTypeForSimpleJavaType(value.getClass());
            }
            if (propertyName == null) continue;
            SDOProperty prop = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(propertyUri, propertyName, true);
            if (prop == null) {
                prop = this.getInstanceProperty(propertyName);
                if (prop != null) {
                    if (prop.getUri() == null && propertyUri != null) {
                        prop = this.createNewProperty(propertyName, propertyUri, theType);
                    } else if (prop.getUri() != null) {
                        if (propertyUri == null) {
                            prop = this.createNewProperty(propertyName, propertyUri, theType);
                        } else if (!prop.getUri().equals(propertyUri)) {
                            prop = this.createNewProperty(propertyName, propertyUri, theType);
                        }
                    }
                } else {
                    prop = this.createNewProperty(propertyName, propertyUri, theType);
                }
            }
            if (prop.isMany()) {
                ((ListWrapper)this.getList(prop)).add(value, false);
                continue;
            }
            this.set(prop, value, false);
        }
    }

    private SDOProperty createNewProperty(String propertyName, String propertyUri, Type theType) {
        DataObject propDo = this.aHelperContext.getDataFactory().create("commonj.sdo", "Property");
        propDo.set("name", (Object)propertyName);
        propDo.set("type", (Object)theType);
        propDo.set("many", (Object)true);
        SDOProperty prop = (SDOProperty)this.aHelperContext.getTypeHelper().defineOpenContentProperty(null, propDo);
        prop.setUri(propertyUri);
        return prop;
    }

    public List _getOpenContentPropertiesWithXMLRoots() {
        ArrayList<XMLRoot> returnList = new ArrayList<XMLRoot>();
        int size = this.openContentProperties.size();
        for (int i = 0; i < size; ++i) {
            Property next = (Property)this.openContentProperties.get(i);
            XMLRoot root = new XMLRoot();
            String localName = ((SDOProperty)next).getXPath();
            if (next.getType() != null) {
                String uri;
                if (!next.getType().isDataType()) {
                    uri = ((SDOProperty)next).getUri();
                    root.setNamespaceURI(uri);
                } else {
                    uri = ((SDOProperty)next).getUri();
                    root.setNamespaceURI(uri);
                }
            }
            root.setLocalName(localName);
            Object value = this.get(next);
            if (next.isMany()) {
                int sizel = ((List)value).size();
                for (int j = 0; j < sizel; ++j) {
                    XMLRoot nextRoot = new XMLRoot();
                    nextRoot.setNamespaceURI(root.getNamespaceURI());
                    nextRoot.setLocalName(root.getLocalName());
                    Object nextItem = ((List)value).get(j);
                    if (next.getType() != null && ((SDOType)next.getType()).getXmlDescriptor() == null) {
                        nextItem = XMLConversionManager.getDefaultXMLManager().convertObject(nextItem, String.class);
                    }
                    nextRoot.setObject(nextItem);
                    returnList.add(nextRoot);
                }
                continue;
            }
            if (next.getType() != null && ((SDOType)next.getType()).getXmlDescriptor() == null) {
                value = XMLConversionManager.getDefaultXMLManager().convertObject(value, String.class);
            }
            root.setObject(value);
            returnList.add(root);
        }
        return returnList;
    }

    public List _getOpenContentProperties() {
        if (this.openContentProperties == null) {
            this.openContentProperties = new ArrayList();
        }
        return this.openContentProperties;
    }

    private Map<String, Property> _getOpenContentAliasNamesMap() {
        if (this.openContentAliasNames == null) {
            this.openContentAliasNames = new HashMap();
        }
        return this.openContentAliasNames;
    }

    private void convertValueAndSet(Property property, Object originalValue) {
        Object convertedValue = this.aHelperContext.getDataHelper().convert(property, originalValue);
        this.set(property, convertedValue);
    }

    private void convertValueAndSet(int propertyIndex, Object originalValue) {
        SDOProperty property = this.getInstanceProperty(propertyIndex);
        Object convertedValue = this.aHelperContext.getDataHelper().convert((Property)property, originalValue);
        this.set(property, convertedValue);
    }

    private void convertValueAndSet(String path, Object originalValue) {
        XPathEngine.getInstance().set(path, originalValue, this, true);
    }

    public Object convertObjectToValue(Property property, Class cls) throws ClassCastException, IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationOnNullArgument((String)"convertObjectToValue"));
        }
        Object obj = this.get(property);
        try {
            return ((SDODataHelper)this.aHelperContext.getDataHelper()).convertValueToClass(property, obj, cls);
        }
        catch (Exception e) {
            throw new ClassCastException("An error occurred during converison or an unsupported conversion was attempted.");
        }
    }

    public Object convertObjectToValue(Property property, int position, Class cls) throws ClassCastException, IllegalArgumentException {
        if (null == property) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationOnNullArgument((String)"convertObjectToValue"));
        }
        if (cls == ClassConstants.List_Class && !property.isMany()) {
            throw new ClassCastException("can not call getList for a property that has isMany false.");
        }
        Object obj = position == -1 ? this.get(property) : this.getList(property).get(position);
        try {
            return ((SDODataHelper)this.aHelperContext.getDataHelper()).convertValueToClass(property, obj, cls);
        }
        catch (Exception e) {
            throw new ClassCastException("An error occurred during conversion or an unsupported conversion was attempted.");
        }
    }

    public void _setContainmentPropertyName(String aContainmentPropertyName) {
        this.containmentPropertyName = aContainmentPropertyName;
    }

    public String _getContainmentPropertyName() {
        return this.containmentPropertyName;
    }

    public boolean parentContains(Object value) {
        if (value == null || !(value instanceof DataObject)) {
            return false;
        }
        if (this.getContainer() != null && this.getContainmentProperty() != null) {
            if (value.equals(this.getContainer())) {
                return true;
            }
            return ((SDODataObject)this.getContainer()).parentContains(value);
        }
        return false;
    }

    private boolean isContainedByDataGraph(Property aProperty) {
        return this.isContainedByDataGraph(this.getDataGraph(), aProperty);
    }

    private boolean isContainedByDataGraph(DataGraph aDataGraph, Property aProperty) {
        return null != aDataGraph && null != aProperty.getType() && !aProperty.getType().isDataType();
    }

    public void updateContainment(Property property, Collection values, boolean updateSequence) {
        if (property.isContainment() || this.isContainedByDataGraph(property)) {
            Object[] valuesArray = values.toArray();
            for (int i = 0; i < valuesArray.length; ++i) {
                Object next = valuesArray[i];
                if (!(next instanceof DataObject)) continue;
                this.updateContainment(property, (DataObject)next, updateSequence);
            }
        }
    }

    public void updateContainment(Property property, Collection values) {
        this.updateContainment(property, values, true);
    }

    public void updateContainment(Property property, DataObject value, boolean updateSequence) {
        if (property.isContainment() || this.isContainedByDataGraph(property)) {
            SDODataObject aDataObject = (SDODataObject)value;
            boolean wasInNewCS = this.getChangeSummary() != null && aDataObject.getChangeSummary() != null && this.getChangeSummary().equals(aDataObject.getChangeSummary());
            aDataObject.detach(false, updateSequence);
            boolean isDeleted = false;
            if (this.getChangeSummary() != null) {
                isDeleted = this.getChangeSummary().isDeleted((DataObject)aDataObject);
            }
            if (this.getChangeSummary() != null && aDataObject.getType() != null && aDataObject.getType().getChangeSummaryProperty() == null) {
                aDataObject.updateChangeSummaryAndDataGraph(this.getChangeSummary(), this.getDataGraph());
            } else if (aDataObject.getDataGraph() != this.getDataGraph()) {
                aDataObject.updateDataGraph(this.getDataGraph());
            }
            aDataObject._setContainer(this);
            aDataObject._setContainmentPropertyName(property.getName());
            if (!wasInNewCS && this.getChangeSummary() != null && !this.getChangeSummary().isDeleted(value)) {
                aDataObject._setCreated(true);
            }
            if (this.getChangeSummary() != null && this.getChangeSummary().isDeleted(value)) {
                aDataObject._setDeleted(false);
            }
            this._setModified(true);
            if (isDeleted) {
                ValueStore originalParentVS;
                DataObject oldParentDO;
                Map originalValueStores = ((SDOChangeSummary)this.getChangeSummary()).getOriginalValueStores();
                ValueStore originalVS = (ValueStore)originalValueStores.get(aDataObject);
                if (originalVS.equals(aDataObject._getCurrentValueStore())) {
                    originalValueStores.remove(aDataObject);
                }
                if ((oldParentDO = this.getChangeSummary().getOldContainer((DataObject)aDataObject)) == this && (originalParentVS = (ValueStore)originalValueStores.get(oldParentDO)).equals(this._getCurrentValueStore())) {
                    Map originalElements = ((SDOChangeSummary)this.getChangeSummary()).getOriginalElements();
                    List oldParentProps = oldParentDO.getInstanceProperties();
                    for (int i = 0; i < oldParentProps.size(); ++i) {
                        Object prop = originalParentVS.getDeclaredProperty(i);
                        Object oldList = originalElements.get(prop);
                        if (oldList == null) continue;
                        List oldElements = (List)oldList;
                        List currentElements = ((ListWrapper)prop).getCurrentElements();
                        if (oldElements.size() != currentElements.size()) {
                            return;
                        }
                        Iterator elementIt = currentElements.iterator();
                        Iterator oldelementIt = oldElements.iterator();
                        while (elementIt.hasNext()) {
                            if (elementIt.next() == oldelementIt.next()) continue;
                            return;
                        }
                    }
                    originalValueStores.remove(oldParentDO);
                }
            }
        }
    }

    public void updateContainment(Property property, DataObject value) {
        this.updateContainment(property, value, true);
    }

    private boolean isLogging() {
        return this.changeSummary != null && this.changeSummary.isLogging();
    }

    public Object writeReplace() {
        return new SDOExternalizableDelegator(this, this.aHelperContext);
    }

    private String getPathPrivate(String currentPath, SDODataObject targetObject, String aSeparator) {
        SDODataObject aParent = (SDODataObject)targetObject.getContainer();
        if (aParent == null) {
            return currentPath;
        }
        String aContainmentPropertyName = targetObject._getContainmentPropertyName();
        SDOProperty aChild = aParent.getInstanceProperty(aContainmentPropertyName);
        if (aChild.isMany()) {
            int index = aParent.getList(aChild).indexOf(targetObject);
            return this.getPathPrivate(aContainmentPropertyName + "[" + (1 + index) + "]" + aSeparator + currentPath, aParent, "/");
        }
        return this.getPathPrivate(aContainmentPropertyName + aSeparator + currentPath, aParent, "/");
    }

    public String _getPath() {
        if (this.getContainer() == null) {
            return "/";
        }
        return this.getPathPrivate("", this, "");
    }

    private SDOProperty[] getInstancePropertiesArray() {
        int i;
        if (this.openContentProperties == null || this.openContentProperties.isEmpty()) {
            return this.getType().getPropertiesArray();
        }
        SDOProperty[] props = this.getType().getPropertiesArray();
        SDOProperty[] ret = new SDOProperty[this.openContentProperties.size() + props.length];
        for (i = 0; i < props.length; ++i) {
            ret[i] = props[i];
        }
        for (i = props.length; i < ret.length; ++i) {
            ret[i] = (SDOProperty)this.openContentProperties.get(i - props.length);
        }
        return ret;
    }

    public Object getPropertyInternal(Property property) {
        int index = ((SDOProperty)property).getIndexInType();
        if (index == -1) {
            return this._getCurrentValueStore().getOpenContentProperty(property);
        }
        return this._getCurrentValueStore().getDeclaredProperty(index);
    }

    public void setPropertyInternal(SDOProperty property, Object value, boolean updateSequence) {
        int index;
        if (this.type.isSequenced() && updateSequence && !property.getType().isChangeSummaryType() && !this.aHelperContext.getXSDHelper().isAttribute((Property)property)) {
            if (property.isMany()) {
                ((SDOSequence)this.sequence).addSettingWithoutModifyingDataObject(property, value);
            } else if (this.isSet(property)) {
                ((SDOSequence)this.sequence).updateSettingWithoutModifyingDataObject(property, this.get(property), value);
            } else {
                ((SDOSequence)this.sequence).addSettingWithoutModifyingDataObject(property, value);
            }
        }
        if ((index = property.getIndexInType()) == -1) {
            this._getCurrentValueStore().setOpenContentProperty(property, value);
        } else {
            this._getCurrentValueStore().setDeclaredProperty(index, value);
        }
    }

    public void addOpenContentProperty(Property property) {
        List theList = null;
        theList = this.aHelperContext.getXSDHelper().isAttribute(property) ? this._getOpenContentPropertiesAttributes() : this._getOpenContentProperties();
        if (!theList.contains(property)) {
            if (this.isLogging()) {
                ((SDOChangeSummary)this.getChangeSummary()).removeUnsetOCProperty(this, property);
            }
            theList.add(property);
            this.getInstanceProperties().add(property);
            int size = property.getAliasNames().size();
            for (int i = 0; i < size; ++i) {
                this._getOpenContentAliasNamesMap().put((String)property.getAliasNames().get(i), property);
            }
        }
    }

    public void removeOpenContentProperty(Property property) {
        if (this.isLogging()) {
            ((SDOChangeSummary)this.getChangeSummary()).setUnsetOCProperty(this, property);
        }
        this._getOpenContentProperties().remove(property);
        this._getOpenContentPropertiesAttributes().remove(property);
        this.getInstanceProperties().remove(property);
        int size = property.getAliasNames().size();
        for (int i = 0; i < size; ++i) {
            this._getOpenContentAliasNamesMap().remove(property.getAliasNames().get(i));
        }
    }

    public boolean isSetInternal(Property property) {
        int index = ((SDOProperty)property).getIndexInType();
        if (index == -1) {
            return this._getCurrentValueStore().isSetOpenContentProperty(property);
        }
        return this._getCurrentValueStore().isSetDeclaredProperty(index);
    }

    private void unsetInternal(Property property, boolean updateSequence) {
        if (property.isMany()) {
            this.getList(property).clear();
            if (property.isOpenContent()) {
                this.removeOpenContentProperty(property);
            } else {
                this._getCurrentValueStore().unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
            }
        } else if (property.isOpenContent()) {
            this._getCurrentValueStore().unsetOpenContentProperty(property);
            this.removeOpenContentProperty(property);
        } else {
            this._getCurrentValueStore().unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
        }
        if (this.type.isSequenced() && this.sequence != null && updateSequence && this.aHelperContext.getXSDHelper().isElement(property)) {
            ((SDOSequence)this.sequence).removeSettingWithoutModifyingDataObject(property);
        }
    }

    public String _getSdoRef() {
        return this.sdoRef;
    }

    public void _setOpenContentPropertiesAttributes(List openContentPropertiesAttributes) {
        this.openContentPropertiesAttributes = openContentPropertiesAttributes;
    }

    public List _getOpenContentPropertiesAttributes() {
        if (this.openContentPropertiesAttributes == null) {
            this.openContentPropertiesAttributes = new ArrayList();
        }
        return this.openContentPropertiesAttributes;
    }

    public List<Setting> getSettings() {
        if (null != this.sequence) {
            return ((SDOSequence)this.sequence).getSettings();
        }
        return null;
    }

    public void _setSdoRef(String newRef) {
        this.sdoRef = newRef;
    }

    static {
        block6: {
            try {
                String pluggableClassName = System.getProperty("valuestore.impl.class", "org.eclipse.persistence.sdo.DefaultValueStore");
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        pluggableClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(pluggableClassName));
                        break block6;
                    }
                    catch (PrivilegedActionException ex) {
                        if (ex.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)ex.getCause();
                        }
                        throw (RuntimeException)ex.getCause();
                    }
                }
                pluggableClass = PrivilegedAccessHelper.getClassForName((String)pluggableClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException(cnfe.getMessage());
            }
        }
    }
}

