/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.delegates.AbstractHelperDelegator;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sessions.Project;

public class SDOTypeHelperDelegator
extends AbstractHelperDelegator
implements SDOTypeHelper {
    private Map sdoTypeHelperDelegates;

    public SDOTypeHelperDelegator() {
        this.sdoTypeHelperDelegates = new WeakHashMap();
    }

    public SDOTypeHelperDelegator(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.sdoTypeHelperDelegates = new WeakHashMap();
    }

    @Override
    public Class getJavaWrapperTypeForSDOType(Type sdoType) {
        return this.getSDOTypeHelperDelegate().getJavaWrapperTypeForSDOType(sdoType);
    }

    public Type getType(String uri, String typeName) {
        return this.getSDOTypeHelperDelegate().getType(uri, typeName);
    }

    @Override
    public Type getTypeForSimpleJavaType(Class implClass) {
        return this.getSDOTypeHelperDelegate().getTypeForSimpleJavaType(implClass);
    }

    @Override
    public void addType(SDOType newType) {
        this.getSDOTypeHelperDelegate().addType(newType);
    }

    public Type getType(Class interfaceClass) {
        return this.getSDOTypeHelperDelegate().getType(interfaceClass);
    }

    public Type define(DataObject dataObject) {
        return this.getSDOTypeHelperDelegate().define(dataObject);
    }

    public List define(List types) {
        return this.getSDOTypeHelperDelegate().define(types);
    }

    @Override
    public QName getXSDTypeFromSDOType(Type aType) {
        return this.getSDOTypeHelperDelegate().getXSDTypeFromSDOType(aType);
    }

    @Override
    public SDOType getSDOTypeFromXSDType(QName aName) {
        return this.getSDOTypeHelperDelegate().getSDOTypeFromXSDType(aName);
    }

    @Override
    public void setTypesHashMap(Map typesHashMap) {
        this.getSDOTypeHelperDelegate().setTypesHashMap(typesHashMap);
    }

    @Override
    public Map getTypesHashMap() {
        return this.getSDOTypeHelperDelegate().getTypesHashMap();
    }

    @Override
    public Map getWrappersHashMap() {
        return this.getSDOTypeHelperDelegate().getWrappersHashMap();
    }

    @Override
    public void setWrappersHashMap(Map aMap) {
        this.getSDOTypeHelperDelegate().setWrappersHashMap(aMap);
    }

    @Override
    public void reset() {
        this.getSDOTypeHelperDelegate().reset();
    }

    public Property defineOpenContentProperty(String uri, DataObject property) {
        return this.getSDOTypeHelperDelegate().defineOpenContentProperty(uri, property);
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        return this.getSDOTypeHelperDelegate().getOpenContentProperty(uri, propertyName);
    }

    private SDOTypeHelperDelegate getSDOTypeHelperDelegate() {
        ClassLoader contextClassLoader = this.getContextClassLoader();
        SDOTypeHelperDelegate sdoTypeHelperDelegate = (SDOTypeHelperDelegate)this.sdoTypeHelperDelegates.get(contextClassLoader);
        if (null == sdoTypeHelperDelegate) {
            sdoTypeHelperDelegate = new SDOTypeHelperDelegate(this.getHelperContext());
            this.sdoTypeHelperDelegates.put(contextClassLoader, sdoTypeHelperDelegate);
            AbstractSessionLog.getLog().log(1, "{0} creating new {1} keyed on classLoader: {2}", new Object[]{this.getClass().getName(), sdoTypeHelperDelegate, contextClassLoader.toString()}, false);
        }
        return sdoTypeHelperDelegate;
    }

    @Override
    public String addNamespace(String prefix, String uri) {
        return this.getSDOTypeHelperDelegate().addNamespace(prefix, uri);
    }

    @Override
    public String getPrefix(String uri) {
        return this.getSDOTypeHelperDelegate().getPrefix(uri);
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.getSDOTypeHelperDelegate().getNamespaceResolver();
    }

    @Override
    public Map getOpenContentProperties() {
        return this.getSDOTypeHelperDelegate().getOpenContentProperties();
    }

    @Override
    public void addWrappersToProject(Project toplinkProject) {
        this.getSDOTypeHelperDelegate().addWrappersToProject(toplinkProject);
    }

    @Override
    public Map getInterfacesToSDOTypeHashMap() {
        return this.getSDOTypeHelperDelegate().getInterfacesToSDOTypeHashMap();
    }
}

