/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public abstract class AbstractHelperDelegator {
    protected HelperContext aHelperContext;
    private static String OC4J_CLASSLOADER_NAME = "oracle";
    private static String WLS_CLASSLOADER_NAME = "weblogic";
    private MBeanServer wlsMBeanServer = null;
    private ObjectName wlsThreadPoolRuntime = null;
    private static final String WLS_ENV_CONTEXT_LOOKUP = "java:comp/env/jmx/runtime";
    private static final String WLS_CONTEXT_LOOKUP = "java:comp/jmx/runtime";
    private static final String WLS_SERVICE_KEY = "com.bea:Name=RuntimeService,Type=weblogic.management.mbeanservers.runtime.RuntimeServiceMBean";
    private static final String WLS_SERVER_RUNTIME = "ServerRuntime";
    private static final String WLS_THREADPOOL_RUNTIME = "ThreadPoolRuntime";
    private static final String WLS_EXECUTE_THREAD_GET_METHOD_NAME = "getExecuteThread";
    private static final String WLS_APPLICATION_NAME_GET_METHOD_NAME = "getApplicationName";
    private static final Class[] PARAMETER_TYPES = new Class[0];

    protected Object getDelegateMapKey() {
        Object executeThread;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String classLoaderName = classLoader.getClass().getName();
        Object delegateKey = classLoader;
        if (classLoaderName.startsWith(OC4J_CLASSLOADER_NAME)) {
            if (classLoader.getParent() != null && (classLoader.toString().indexOf(".web.") != -1 || classLoader.toString().indexOf(".wrappers") != -1)) {
                classLoader = classLoader.getParent();
            }
            delegateKey = classLoader;
        } else if (classLoaderName.contains(WLS_CLASSLOADER_NAME) && (executeThread = this.getExecuteThread()) != null) {
            try {
                Method getMethod = PrivilegedAccessHelper.getPublicMethod(executeThread.getClass(), (String)WLS_APPLICATION_NAME_GET_METHOD_NAME, (Class[])PARAMETER_TYPES, (boolean)false);
                delegateKey = PrivilegedAccessHelper.invokeMethod((Method)getMethod, (Object)executeThread);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return delegateKey;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    private Object getExecuteThread() {
        if (this.wlsMBeanServer == null) {
            InitialContext weblogicContext = null;
            try {
                weblogicContext = new InitialContext();
                try {
                    this.wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_ENV_CONTEXT_LOOKUP);
                }
                catch (NamingException e) {
                    try {
                        this.wlsMBeanServer = (MBeanServer)weblogicContext.lookup(WLS_CONTEXT_LOOKUP);
                    }
                    catch (NamingException namingException) {}
                }
            }
            catch (NamingException nex) {
                // empty catch block
            }
        }
        if (this.wlsMBeanServer != null) {
            if (this.wlsThreadPoolRuntime == null) {
                try {
                    ObjectName service = new ObjectName(WLS_SERVICE_KEY);
                    ObjectName serverRuntime = (ObjectName)this.wlsMBeanServer.getAttribute(service, WLS_SERVER_RUNTIME);
                    this.wlsThreadPoolRuntime = (ObjectName)this.wlsMBeanServer.getAttribute(serverRuntime, WLS_THREADPOOL_RUNTIME);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if (this.wlsThreadPoolRuntime != null) {
                try {
                    return this.wlsMBeanServer.invoke(this.wlsThreadPoolRuntime, WLS_EXECUTE_THREAD_GET_METHOD_NAME, new Object[]{Thread.currentThread().getName()}, new String[]{String.class.getName()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

